/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: param.c,v 1.3 87/05/14 17:46:45 davidb Exp $ */

/* 
	@(#)param.c	1.1 8/16/85

	Filename:	param.c

	Compiler:	Lattice C

	Target Machine:	IBM PC

	Description:	processing parameters for INIT utility

	Create Date:	021585 (clc)

	Edit History:


*/


#include	"def.h"
#include	"comn.h"
#include	"comm.h"
#include	"imsg.h"
#include	"bd.h"
#include	"mem.h"
#include	<ctype.h>

#define	DFLT	0xffff
#define	NUMBUF	8
#define DFLTSIZ 80
#define	INTTYP	3

/* local variables */
UBYTE2	numpcb = DFLT;
UBYTE2	nummbx = DFLT;
UBYTE2	numasl = DFLT;
UBYTE2	hnumbuf = NUMBUF;
UBYTE2	hinttyp = INTTYP;
UBYTE2	enumbuf = NUMBUF;
UBYTE2	einttyp = INTTYP;
UBYTE2	movadd = DFLT;
UBYTE2	rgbufsiz = DFLTSIZ;

UBYTE2	sndseg;
UBYTE2	rcvseg;
UBYTE2	sndhdr;
UBYTE2	rcvhdr;

extern	UBYTE2	debug;
extern	UBYTE2	icedebug;
extern	UBYTE2	verbose;
extern	UBYTE	filnam[];
/*
extern	char *xmemdev
*/



/* skip SPACE and '=' */
ADDRESS	skip(cchar)
ADDRESS cchar;
{
for (;;) {
          if ((*cchar == ' ') || (*cchar == '=')) cchar++;
          else break;
}
return(cchar);
}


/* get parameters for ring buffer number and interrupt type */
get_qpar(ss,bufnum,inttyp)
UBYTE2	*bufnum,*inttyp;
ADDRESS	ss;
{
UBYTE2	*par;
ss++;
if (*ss=='b')	get_dec(ss,bufnum);	
if (*ss=='i')	get_dec(ss,inttyp);	
}



/* get a parameter in decimal from the given string */
get_dec(ss,num)
UBYTE2	*num;
ADDRESS	ss;
{
ss++;
ss = skip(ss);
sscanf(ss,"%d",num);				
} /* end of get_dec */



/* get a parameter in hex from the given string */
get_hex(ss,num)
UBYTE2	*num;
ADDRESS	ss;
{
ss++;
ss = skip(ss);
sscanf(ss,"%x",num);				
} /* end of get_hex */



prse(s)
ADDRESS s;
{
	ADDRESS	ss;
	UBYTE2	hexnum;

	ss = s;
	while (*ss != '\0') {
		if (isupper(*ss)) *ss = tolower(*ss);
		ss++;
	}
	switch	(*s)	{
	case 'd':
		debug = TRUE;
	case 'v':
		verbose = TRUE;
		break;
	case 'i':
		s++;
		switch (*s) {
		case 'c':
			icedebug = TRUE;
			break;
		}
		break;
	case 'f':
		s++;
		s = skip(s);
		strcpy(filnam,s);
		break;
	case 'p':
		get_dec(s,&numpcb);
		break;
	case 'a':
		get_dec(s,&numasl);
		break;
	case 's':
		get_dec(s,&rgbufsiz);
		break;
	case 'm':
		s++;
		if (*s=='v')	{
			get_hex(s,&movadd);
		} else	{
			get_dec(s,&nummbx);
		}
		break;
	case 'h':
		get_qpar(s,&hnumbuf,&hinttyp);
		break;
	case 'e':
		get_qpar(s,&enumbuf,&einttyp);
		break;
	default:
		printf("\nillegal option %c\n",*s);
		exit(1);		
	}

} /* end of parse */


debparam()
{
if (debug==TRUE)	{
	printf("\n\npcb=%d, asl=%d, mbx=%d, movaddr=%xH",
		numpcb,numasl,nummbx,movadd);
	printf("\nh-e buf=%d, int=%d;  e-h buf=%d, int=%d;  buf siz=%d",
		hnumbuf,hinttyp,enumbuf,einttyp,rgbufsiz);
}
}



UBYTE2	alloc_ring(lopar,hipar,ringseg,ringhdr,numbuf,commaddr,bufsts)
UBYTE2	*lopar,*hipar,*ringseg,*ringhdr,numbuf,commaddr;
UBYTE	bufsts;
{
UBYTE2	numpar;
UBYTE2	i,hstring;
UBYTE2	ringbeg;
hmshdr	tempbuf;
SEGOFF	ptr;
ADDRESS loc;

*ringseg = *hipar & 0xf000;	/* segment base at 64k boundary */

numpar = INTSIZ + numbuf*rgbufsiz; /* # of bytes for ring buffers */
if ((numpar & 0xf)!=0)	numpar = (numpar + 0x10) & 0xfff0;
numpar >>= 4;			/* convert to paragraphs */

if ( (*hipar+1-numpar) < *lopar) {
	printf("\nring buffers take up too much space!");
	printf("\njob aborted!");
	exit(1); 
}

hstring = *ringseg;		/* queue base from host view */
loc = (ADDRESS) (*hipar << 4) + 0xf;	/* last byte of the mem available */
ringbeg = (UBYTE2) loc-numbuf*rgbufsiz+1;
				/* allocate for host to exos ring bufs */
*ringhdr = ringbeg - INTSIZ;	/* header ptr to ring */
poke(hstring,*ringhdr,&ringbeg,INTSIZ);	/* point to 1st buffer */
tempbuf.hmsrsr = 0;
tempbuf.hmssta = bufsts;	/* buffer status */
tempbuf.hmslen = rgbufsiz - hbufsiz;
loc = (ADDRESS) ringbeg;	/* save 1st buf addr */
for (i=0; i<numbuf; i++) {
	tempbuf.nxthms = (phmsg) ( (UBYTE2) loc + rgbufsiz );
				/* next buf location */
	if (i==numbuf-1) tempbuf.nxthms = (phmsg) ringbeg; /* circular */
	poke(hstring,loc,&tempbuf,hbufsiz);
	loc += rgbufsiz;
} /* end of circular ring */
ptr.off = ringbeg;
ptr.seg = hstring;
poke(HCOMSEG,commaddr,&ptr,SGOFSIZ);
*hipar -= numpar;	/* update available paragraph # */
} /* alloc_ring */



/* set ring buffers below the high paragraph available */
set_ring()
{
UBYTE2	hipara;
UBYTE2	lopara;

peek(HCOMSEG,HIMAP,&hipara,INTSIZ);/* get high paragraph of mem available */
peek(HCOMSEG,BNK2LO,&lopara,INTSIZ);
 
alloc_ring(&lopara,&hipara,&sndseg,&sndhdr,hnumbuf,SNDPTR,0);
alloc_ring(&lopara,&hipara,&rcvseg,&rcvhdr,enumbuf,RCVPTR,ownbit+donbit);

poke(HCOMSEG,HIMAP,&hipara,INTSIZ);/* update high memory available */

} /* end of seg_ring */



/* prepare parameters in init msg */
init_par(iniptr)
pimsg	iniptr;
{
iniptr->datadr = movadd;
iniptr->datseg = DFLT;
if (movadd != DFLT) iniptr->datseg = 0;
iniptr->nmpcb = numpcb & 0xff;
iniptr->nmmbx = nummbx & 0xff;
iniptr->nmasl = numasl & 0xff;
iniptr->h2nqseg[0] = 0;
iniptr->h2nqseg[1] = sndseg;
iniptr->h2nqhdr = sndhdr;
iniptr->h2nityp = hinttyp;
iniptr->n2hqseg[0] = 0;
iniptr->n2hqseg[1] = rcvseg;
iniptr->n2hqhdr = rcvhdr;
#ifdef notdef
iniptr->n2hityp = 4;
iniptr->n2hival = VECTOR;
#else	/* notdef */
iniptr->n2hityp = einttyp;
#endif	/* notdef */

/* Fill in byte order patterns; 
 * the NX205 executive will determine whether
 * byte ordering is required.
 */
iniptr->tst_map.tstdata.byte1[0] = 0x01;
iniptr->tst_map.tstdata.byte1[1] = 0x03;
iniptr->tst_map.tstdata.byte1[2] = 0x07;
iniptr->tst_map.tstdata.byte1[3] = 0x0f;
iniptr->tst_map.tstdata.byte2[0] = 0x0103;
iniptr->tst_map.tstdata.byte2[1] = 0x070f;
iniptr->tst_map.tstdata.byte4 = 0x0103070f;
} /* init_par */


