/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: load.c,v 1.2 87/04/24 13:58:35 davidb Exp $ */
/*

	@(#)load.c	1.1 8/16/85

	File Name:	load.c

	Compiler:	Lattice C

	Target Machine:	IBM PC

	Description:	load an intel object file on to the 
			EXOS 205 board

	Date Created:	032785 (clc)

	Edit History:	

	051085		1	Removed SEGDIF in poke call to support
				window (clc)
	062485		2	Adapted to xenix environment
*/

#include "def.h"
#include "comn.h"
#include "comm.h"
#ifdef LATICE
#include "\lattice\stdio.h"
#include "\lattice\fcntl.h"
#else	/* LATICE */
#include <stdio.h>
#include <fcntl.h>
#endif	/* LATICE */


/* intel object format file record defintions */

#define PEDATA	0x84	/* physical emunerated date record type */
#define	PIDATA	0x86	/* physical iterated data record type */

typedef	struct	{
	
	UBYTE	rectype;
	UBYTE	recleng[2];
	UBYTE	recfram[2];
	UBYTE	recoffs;

} rechdr, *phdr;

struct {
	char	hi;
	char	lo;
};

#define typlen	3
#define	hdrsiz	6

#define CRCLEN 1	/* 1-byte checksum included in record len */

#define	RBUFSIZ 0x4000

/* return code for READ call */

#define ENDFILE 0	/* end of file in raw mode */
#define	RDERR	-1	/* read error */

/* configuration information */

UBYTE2 bc;
UBYTE2 arrndx;
UBYTE2 numbyt;
UBYTE2 reclen;
UBYTE2 recfrm;
UBYTE2 recoff;
UBYTE2 rectyp;
UBYTE2 recsum;
UBYTE2 skiplen;
phdr hdrptr;	

BYTE2	fp;
UBYTE	rdbuf[RBUFSIZ + 0x1000];
UBYTE	*extbuf = &rdbuf[RBUFSIZ];
UBYTE	pibuf[0x4000];
UBYTE2	rlev;
UBYTE2	deb = 0;
UBYTE	*bytptr;

extern verbose;
extern debug;


sumbyt(num)
UBYTE2 num;
{
UBYTE2 i,j;
UBYTE *ptr;
if (deb==1) {
	printf("\nrectyp= %x, reclen=%x, recsum=%04x",rectyp,reclen,recsum);
	printf("\nsumming %x bytes",num);
}
ptr = bytptr;
for (i=0; i<num; i++) {
	j = (UBYTE2) (*ptr++);
	if (deb==1) printf(" %2x",j);
	recsum += j;
}
if (deb==1) printf("\nnew recsum=%04x",recsum);
}



UBYTE2 rdbyte()
{
UBYTE2	bytval;

bytval = (UBYTE2) (*bytptr++);
recsum += bytval;
return(bytval);
}


UBYTE2 rdword()
{
UBYTE2	*wdval;

wdval = (UBYTE2 *) bytptr;
sumbyt(2);
bytptr += 2;
return(*wdval);
}


prdeb()
{
printf ("rectyp= %02x, reclen= %04x, recfrm= %04x\n",
		rectyp,reclen,recfrm);
}


/* store a byte into array */
stbyte(val)
UBYTE val;
{
	pibuf[arrndx++] = val & 255;
	numbyt++;
}



/* store physical iterated data */
stpid()
{
UBYTE2 repcnt;
UBYTE2 blkcnt;
UBYTE2 bytcnt;
UBYTE2 begndx;
UBYTE2 endndx;
UBYTE2 copndx;
UBYTE2 valu;

	rlev++;				/* level of recursion */
	repcnt = rdword();		/* read repeat count */
	blkcnt = rdword();		/* read block count */
	reclen -= 4;
	if (deb==1) {
		printf("\n%2d. repcnt=%04x  blkcnt=%04x ",rlev,repcnt,blkcnt);
	}
	begndx = arrndx;
	if (blkcnt == 0) {
		bytcnt = rdbyte();
		reclen--; 
		if (deb==1) {
			printf(" bytcnt=%02xH ",bytcnt);
		}
		for ( ; bytcnt>0; bytcnt--){
			valu = rdbyte();
			reclen--;
			if (deb==1) {
				printf(" valu=%02x",valu);
			}
			stbyte(valu);
		}
	} else {
		for ( ; blkcnt>0; blkcnt--) stpid();
	}
	endndx = arrndx;
	for (repcnt--; repcnt > 0; repcnt--) {
		for (copndx=begndx; copndx<endndx; copndx++) {
			stbyte(pibuf[copndx]);
		}
	}
} /* end of stpid */



UBYTE2 load(filnam)
UCHAR *filnam;
{

	fp = open(filnam,O_RDONLY);
	if (fp == -1) {
		perror(filnam);
		return(FAIL);
	} else {
		prcfile();
		close(fp);
		return(SUC);
	}
}



prcfile()
{
UBYTE2	numbyt;

for (;;) {
	numbyt = bulkrd(rdbuf,RBUFSIZ);
	if (numbyt==0) break;
	prcbuf(numbyt);
	if (numbyt < RBUFSIZ) break;
}
}



bulkrd(buf,len)
UBYTE2 len;
UBYTE *buf;
{
BYTE2	status;

	status = read(fp,buf,len);	
	switch (status) {
	case	RDERR:
		printf("\nerror occurred when reading the file!");
		exit(1);
	case	ENDFILE:
		return(0);
	default:
		return(status);
	}
}


prcbuf(siz)
BYTE2	siz;
{
UBYTE2	extrd = 0,i;
UBYTE	*ptr;

bytptr = rdbuf;

for (;;) {	/* begin process loop */

if (deb==1) printf("\nloop: siz=%x",siz);
	if( siz != 0 && extrd !=0 ) {
		printf( "buffer overflow\n" );
		exit( 1 );
	}
	recsum = 0;
	extrd = 0;
	if (siz==0) break;
	if (siz<typlen) {
		extrd = typlen-siz;
		bulkrd(extbuf,extrd);
		siz += extrd;
	}
	hdrptr = (phdr) bytptr;
	rectyp = 0xff & hdrptr->rectype;
	reclen = ( hdrptr->recleng[1] << 8 ) | ( 0xff & hdrptr->recleng[0] );
	siz -= typlen;
	sumbyt(typlen);
	bytptr += typlen;
	
	if (siz<reclen) {
		if (verbose)    /* deb==1 */
		  printf("\nreading %x bytes into extbuf...",reclen-siz);
		bulkrd(&(extbuf[extrd]),reclen-siz);
		siz = reclen;
	}

	if ((rectyp==PEDATA) || (rectyp==PIDATA)) {

		recfrm = ( hdrptr->recfram[1] << 8 ) |
			( 0xff & hdrptr->recfram[0] );
		recoff = hdrptr->recoffs;
		sumbyt(hdrsiz-typlen);
		siz -= (hdrsiz-typlen);
		bytptr = ((UBYTE *) hdrptr) + hdrsiz;
		reclen -= (hdrsiz-typlen);

	  if (deb == 1) {
	    printf("\n>> new rectype=%x   reclen=%x",rectyp,reclen);
	    printf("\n   recfrm=%x  recoff=%x\n",recfrm,recoff);
	  }
	}

	sumbyt(reclen);
	recsum  = recsum & 255;
	if (recsum != 0) {
		printf("record check sum failed recsum = %x \n\n", recsum);
		exit(1);
	} else {
		if( deb == 1 )
			printf( "CHECKSUM OK\n" );
	}

	skiplen = reclen;
	
	if (rectyp==PEDATA)
		poke(recfrm,recoff,bytptr,reclen-CRCLEN);	/* [1] */

	if (rectyp==PIDATA) {

		numbyt = 0;	/* initialize # of bytes in a rec */
		arrndx = 0;	/* store from the beginning */
		rlev = 0;
		while (reclen > CRCLEN) stpid();
		bytptr++;
		poke(recfrm,recoff,pibuf,numbyt);	/* [1] */
	} else {
		bytptr += reclen;
	}

	siz -= skiplen;
}	
} /* end of prcbuf */	


