/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: config.c,v 1.2 87/04/24 13:54:36 davidb Exp $ */
/* 
	@(#)config.c	1.1 8/16/85

	Filename:	config.c

	Compiler:	Lattice C

	Target Machine:	IBM PC

	Description:	Configures the 205 board

	Create Date:	021985 (clc)

	Edit History:
	
	051085		1	Removed SEGDIF in peek/poke calls to use
				window (clc)

	062185		2	Adapted to xenix environment
*/

#include	"def.h"
#include	"imsg.h"
#include	"comn.h"
#include	"comm.h"
#include	"err.h"
#include	"bd.h"
#include	<sys/exos205.h>

extern	UBYTE2	debug,verbose,icedebug;
extern	UBYTE2	ctlcopy;
extern	UBYTE2	rgbufsiz;

UBYTE2	iniseg;
pimsg	iniptr;
UBYTE2	timeout = 0x7fff;



set_init_msg()				/* prepare init msg */
{
	imsg	ini;				/* local version of config msg */
	UBYTE2	para,i;
	ADDRESS	addr;

	peek(HCOMSEG,BNK2LO,&para,INTSIZ);	/* use low available mem */
	para += (imsglen >> 4);			/* allocate mem for init msg */
	poke(HCOMSEG,BNK2LO,&para,INTSIZ);	/* reserve it */

	addr = (ADDRESS)&ini;
	for (i=0; i<imsglen; i++) {
		*addr = 0;			/* zero out buffer */
		addr++;
	}
	ini.msgversn = 1;			/* msg version */
	ini.nstatus = 0xff;			/* non-ready status */
	ini.nmd = hstboot;			/* host boot mode */
	ini.nmhst = 1;				/* 1 host */
	init_par(&ini);

	iniseg = para & 0xf000;		/* map into host space */
	iniptr = (pimsg)(para << 4);
	poke(iniseg,iniptr,&ini,imsglen);/* copy config msg to exos memory [1]*/
}



/* write init msg ptr to 9fff0 */
pass_init_ptr()
{
	SEGOFF	ptr;
	ptr.off = (short)iniptr;
	ptr.seg = iniseg;
#ifdef DEBUGPK
	printf( "configuration message at %x:%x\n", ptr.seg, ptr.off );
#endif	/* DEBUGPK */
	poke(HCOMSEG,ADRVCT,&ptr,SGOFSIZ);
	/*
 * save pointer to configuration message for download program
 */
	poke((int)((CONFMSGADR >> 4) & 0xf000L),
	    (int)(CONFMSGADR & 0xffff),&ptr,SGOFSIZ);
}



/* wait for configuration reply from exos */
wait_rpl()
{
	UBYTE	reply;
	UBYTE2	i;

	sleep( 1 );
	for (i=0; i!=timeout; i++) {
		peek(iniseg,&(iniptr->nstatus),&reply,1);	/* [1] */
		if ((reply & 0xff)!=0xff) 	break;
	}

	if (debug==TRUE) printf("\ngot configuration reply at loop # %d\n",i);

	if (reply != 0) {
		printf("\nEXOS 205 configuration error");
		err_report(reply);
		printf("!\n");
		return(FAIL);
	} else	{
		return(SUC);
	}
} /* wait_rpl */




/* wait for exos ready */
wait_rdy()
{
	struct	status {
		UBYTE	sts;
		UBYTE	err;
	} exosts;
	UBYTE2	i;

	sleep( 1 );
#ifdef DEBUGPK
printf("starting to peek, sizeof stat = %d\n", sizeof(struct status));
#endif	/* DEBUGPK */
	for (i=0; i<timeout; i++) {
		peek(HCOMSEG,EXSTAT,&exosts.sts,sizeof(struct status));
		if (exosts.sts==EXRDY) break;
	}
#ifdef DEBUGPK
printf("peeked, got %x\n", exosts.sts==EXRDY);
#endif	/* DEBUGPK */

	if (exosts.sts==EXRDY) {
		if (debug==TRUE) printf("\nEXOS ready at loop # %d",i);
		return(SUC);
	} else {
		if (exosts.err!=0) {
			printf("\nThe EXOS 205 failed self test");
			err_report(exosts.err);
			printf(" failed!\n");
		} else {
			printf("\nEXOS not up! Get an expert!\n");
		}
		return(FAIL);
	}
} /* wait_rdy */




err_report(err)
UBYTE	err;
{
	printf(" --\nERROR %02x:  ",err);
	switch	(err)	{
	case CTRFAL:
		printf("on-chip timer test");
		break;
	case INTFAL:
		printf("on-chip interrupt controller test");
		break;
	case SCBFAL:
		printf("communication with the network processor");
		break;
	case CBFAL:
		printf("command execution of the network processor");
		break;
	case BADMVA:
		printf("invalid movable block address");
		break;
	case BADPCB:
		printf("invalid number of processes");
		break;
	case BADMBX:
		printf("invalid number of mailboxes");
		break;
	case BADASL:
		printf("invalid number of address slots");
		break;
	case HSQFAL:
		printf("invalid host message queue parameter");
		break;
	case OBJFAL:
		printf("insufficient memory for movable data block");
		break;
	case DFLERR:
		printf("completion field unchanged");
		break;
	default:
		printf("unexpected error code %02x",err);
		break;

	}
}




dspl_vrsn()
{
	imsg	ini;
	UBYTE2	drvrblk[8];

	peek(iniseg,iniptr,&ini,imsglen);	/* copy msg to local mem [1] */

	printf("\nEXOS 20%01x Version: software=%c.%c  hardware rev=%c.%c\n\n",
	    (ini.reservd[1] & 0xf),ini.nvers[0],ini.nvers[1],
	    ini.nvers[2],ini.nvers[3]);

	if ((debug==FALSE) && (icedebug==FALSE)) return(0);

	poke(HCOMSEG,CTLCOP,&ctlcopy,INTSIZ);
	poke(HCOMSEG,MBUFSIZ,&rgbufsiz,INTSIZ);

	if ( (icedebug==TRUE) || (verbose==TRUE) ) {
		peek(HCOMSEG,DRVBLK,drvrblk,16);
		printf("Memory available on the board: paragraphs %04x - %04x",
		    drvrblk[1],drvrblk[2]);
		printf("\nPC-to-EXOS queue header:  %04x:%04x (board's view)",
		    drvrblk[4],drvrblk[3]);
		printf("\nEXOS-to-PC queue header:  %04x:%04x (board's view)",
		    drvrblk[6],drvrblk[5]);
		printf("\nmessage buffer size: %04xH\n",drvrblk[7]);
		return(0);
	}

	printf("Msg Version: %04x     Mode: %02x,   Options: %02x %02x %02x\n",
	    ini.msgversn,ini.nmd,ini.bytopt,ini.adropt,ini.clkopt);

	printf("Reserved: %02x %02x\n",ini.reservd[0],
	    ini.reservd[2]);
	printf("Segnum: %02x\n",ini.segnum);
	printf("Mem Map: %04x:%04x-%04x:%04x   %04x:%04x-%04x:%04x\n",
	    ini.tst_map.mapmem0[1],ini.tst_map.mapmem0[0],
	    ini.tst_map.mapmem0[3],ini.tst_map.mapmem0[2],
	    ini.tst_map.mapmem0[5],ini.tst_map.mapmem0[4],
	    ini.mapmem1[1],ini.mapmem1[0]);

	printf("Data Area: %04x:%04x\n",ini.datseg,ini.datadr);

	if (ini.nmd == ctlrmod) {
		printf("Num xmt buf: %02x,  Num rcv buf: %02x\n",
		    ini.nmpcb,ini.nmmbx);
	} else {
		printf("Num process: %02x,  Num mailbox: %02x\n",
		    ini.nmpcb,ini.nmmbx);
	}

	printf("Num adrslot: %02x,  Num Hosts: %02x\n",ini.nmasl,ini.nmhst);

	printf("Host-Exos que: addr=%04x:%04x, typ=%02x\n",
	    ini.h2nqseg[1],ini.h2nqhdr,ini.h2nityp);

	printf("Exos-Host que: addr=%04x:%04x, typ=%02x\n",
	    ini.n2hqseg[1],ini.n2hqhdr,ini.n2hityp);

	return(0);
}

