3  Syntax10.Scn.Fnt  u Z  ParcElems Alloc     
 +6      ևԒҝШϳ;        StampElems Alloc 25 May 94      8  FoldElems New  K    8   "    8   K    8       8   G    8       8   C    8   y    8      8      Syntax10b.Scn.Fnt          8      8               8      8   +    8      8   .    8      8   )    8   +   8   +    8       8   )    8   i   8               8   :   8               8   }   8   .    8      8   )   Syntax10i.Scn.Fnt  *        8   q   8   .    8      8               8              8               8   Z   8   :    %  MODULE CLTool; (* sg 26 Oct 92/ *) (* formatting: Write.Set tabs * 50~ *)
	IMPORT CLGAs, Oberon, Texts, Files;

VAR
	W : Texts.Writer;


PROCEDURE Str (s : ARRAY OF CHAR);	
BEGIN
	Texts.WriteString (W, s); Texts.Append (Oberon.Log, W.buf)
END Str;

PROCEDURE Int (i, w : LONGINT);	
BEGIN
	Texts.WriteInt (W, i, w); Texts.Append (Oberon.Log, W.buf)
END Int;

PROCEDURE Char (ch : CHAR);	
BEGIN
	Texts.Write (W, ch); Texts.Append (Oberon.Log, W.buf)
END Char;

PROCEDURE Ln;	
BEGIN
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END Ln;

PROCEDURE Setup(VAR S: Texts.Scanner);	(* Set up S on parameter list *)	
VAR Sel: Texts.Text; beg, end, time: LONGINT;	
BEGIN
	Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
	IF (S.class = Texts.Char) & (S.line = 0) & (S.c = "^") THEN
		Oberon.GetSelection(Sel, beg, end, time);
		IF time >= 0 THEN Texts.OpenScanner(S, Sel, beg); Texts.Scan(S) END
	END
END Setup;

(****

PROCEDURE Read*;	
VAR i, val : INTEGER; ch : CHAR; S : Texts.Scanner; offset : SHORTINT;
BEGIN
	Setup (S); IF S.class = Texts.Int THEN offset := SHORT (SHORT (S.i MOD 4)) ELSE offset := 0 END;
	CLLoader.Get (ch, offset);
	val := ORD (ch);
	Char ("("); Int (val, 0); Str (")   ");
	i := 128;
	REPEAT
		IF val >= i THEN Char ("1"); val := val - i ELSE Char ("0") END;
		i := i DIV 2
	UNTIL i = 0;
	Ln
END Read;

PROCEDURE Write*;	
VAR S : Texts.Scanner; value : LONGINT; offset : SHORTINT;
BEGIN
	Setup(S); IF S.class = Texts.Int THEN value := S.i MOD 256; Texts.Scan (S) END;
	IF S.class = Texts.Int THEN offset := SHORT (SHORT (S.i MOD 4)) ELSE offset := 0 END;
	CLLoader.Put (CHR (value), offset)
END Write;

PROCEDURE DefaultLabels (ga : CLGAs.GA);	
VAR u, v : INTEGER; s1, s2 : ARRAY CLGAs.LabelLen OF CHAR; l : CLGAs.Label;

	PROCEDURE Delete (s : ARRAY OF CHAR);
	BEGIN
		l := CLGAs.This (ga, s); IF l # NIL THEN CLGAs.Delete (ga, l.u, l.v, l.sig, s) END
	END Delete;

	PROCEDURE Insert (s : ARRAY OF CHAR; u, v : INTEGER);
	BEGIN
		CLGAs.Insert (ga, s, u, v, CLGAs.AOut, l);
	END Insert;

BEGIN
	v := 0; s1[0] := "D"; s1[2] := 0X; s2[0] := "d"; s2[2] := 0X; (* insert default labels *)
	WHILE v < 8 DO
		s1[1] := CHR (ORD ("0") + v); s2[1] := s1[1];
		Delete (s1); Insert (s1, -1, v);
		Delete (s2); Insert (s2, CLGAs.Dim, v);
		INC (v)
	END;
	Delete ("CW"); Delete ("SEL"); Delete ("WR"); Delete ("RD"); Delete ("A2");
	Delete ("A3"); Delete ("INT"); Delete ("CS"); Delete ("WE"); Delete ("OE");
	Insert ("CW", -1, 14); Insert ("SEL", -1, 13); Insert ("WR", -1, 12); Insert ("RD", -1, 11); Insert ("A2", -1, 10);
	Insert ("A3", -1, 9); Insert ("INT", -1, 8); Insert ("CS", CLGAs.Dim, 13); Insert ("WE", CLGAs.Dim, 12);
	Insert ("OE", CLGAs.Dim, 11);
	u := 0; s1[0] := "a"; s1[3] := 0X;
	WHILE u < 15 DO
		IF u >= 10 THEN s1[1] := "1"; s1[2] := CHR (ORD ("0") + u - 10) ELSE s1[1] := CHR (ORD ("0") + u) END;
		Delete (s1); Insert (s1, 14 - u, CLGAs.Dim);
		INC(u)
	END;
END DefaultLabels;

PROCEDURE DefaultRepeaters (ga : CLGAs.GA);	
VAR u, v : INTEGER;
BEGIN
	u := 0;
	WHILE u < CLGAs.Dim DO
		v := 0;
		WHILE v < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
			IF ga.vr[u, v].w = CLGAs.None THEN ga.vr[u, v].w := 0 END;
			IF ga.vr[u, v].e = CLGAs.None THEN ga.vr[u, v].e := 0 END;
			IF ga.hr[v, u].n = CLGAs.None THEN ga.hr[v, u].n := 0 END;
			IF ga.hr[v, u].s = CLGAs.None THEN ga.hr[v, u].s := 0 END;
			INC (v)
		END;
		INC (u)
	END;
END DefaultRepeaters;

PROCEDURE DefaultPads (ga : CLGAs.GA);	
VAR u : INTEGER;
BEGIN
	u := 0;
	WHILE u < CLGAs.Dim DIV 2 DO
		ga.p[CLGAs.North, u].selector := CLGAs.TSOn; ga.p[CLGAs.North, u].flags := CLGAs.Pullup; (* RAM address lines enabled *)
		ga.p[CLGAs.South, u].selector := CLGAs.TSOff; ga.p[CLGAs.South, u].flags := CLGAs.Pullup;
		ga.p[CLGAs.West, u].selector := CLGAs.TSOff; ga.p[CLGAs.West, u].flags := CLGAs.Pullup;
		ga.p[CLGAs.East, u].selector := CLGAs.TSOff; ga.p[CLGAs.East, u].flags := CLGAs.Pullup;
		INC (u)
	END;
	ga.p[CLGAs.North, 7].selector := CLGAs.TSOff; ga.p[CLGAs.South, 8].selector := CLGAs.TSOff;
	ga.p[CLGAs.West, 7].selector := CLGAs.TSOff; ga.p[CLGAs.East, 8].selector := CLGAs.TSOff;
	ga.p[CLGAs.East, 12].selector := CLGAs.TSOn; ga.p[CLGAs.East, 13].selector := CLGAs.TSOn; (* OE, WE enabled (+1 because of shifting) *)
END DefaultPads;

PROCEDURE DefaultClocks (ga : CLGAs.GA);	
VAR u : INTEGER;
BEGIN
	u := 0;
	WHILE u < CLGAs.Dim DO
		ga.res[u] := CLGAs.ClkGlobal; ga.clk[u] := CLGAs.ClkOne;
		INC (u)
	END;
END DefaultClocks;

PROCEDURE LDirections (ga : CLGAs.GA);	
VAR u, v : INTEGER; temp : SHORTINT;
BEGIN
	u := 0;
	WHILE u < CLGAs.Dim DO
		v := 0;
		WHILE v < CLGAs.Dim DO
			IF (ga.c[u, v].weL IN {CLGAs.North, CLGAs.South}) OR (ga.c[u, v].nsL IN {CLGAs.West, CLGAs.East}) THEN
				temp := ga.c[u, v].weL; ga.c[u, v].weL := ga.c[u, v].nsL; ga.c[u, v].nsL := temp
			END;
			INC (v)
		END;
		INC (u)
	END;
END LDirections;

PROCEDURE Init*;	
VAR S: Texts.Scanner; ga : CLGAs.GA; len : LONGINT;
BEGIN
	Setup(S); NEW (ga);
	WHILE S.class = Texts.Name DO
		Str ("init pads, clocks, and resets in "); Str (S.s);
		CLGAs.Open (ga, S.s);
		DefaultPads (ga);
		DefaultClocks (ga);
		CLGAs.Store (ga, S.s, len);
		Int (len, 7); Ln;
		Texts.Scan (S)
	END
END Init;

PROCEDURE Update*;	
VAR S: Texts.Scanner; ga : CLGAs.GA; len : LONGINT;
BEGIN
	Setup(S); NEW (ga);
	WHILE S.class = Texts.Name DO
		Str ("updating "); Str (S.s);
		CLGAs.Open (ga, S.s);
		Str (" default labels"); DefaultLabels (ga);
		Str (" repeaters"); DefaultRepeaters (ga);
		Str (" l busses"); LDirections (ga);
		CLGAs.Store (ga, S.s, len);
		Int (len, 7); Ln;
		Texts.Scan (S)
	END
END Update;

PROCEDURE DefaultRepeaters (ga : CLGAs.GA);	
VAR u, v : INTEGER;
BEGIN
	u := 0;
	WHILE u < CLGAs.Dim DO
		v := 0;
		WHILE v < (CLGAs.Dim DIV CLGAs.Sector) - 1 DO
			IF ga.vr[u, v].w = CLGAs.None THEN ga.vr[u, v].w := 0 END;
			IF ga.vr[u, v].e = CLGAs.None THEN ga.vr[u, v].e := 0 END;
			IF ga.hr[v, u].n = CLGAs.None THEN ga.hr[v, u].n := 0 END;
			IF ga.hr[v, u].s = CLGAs.None THEN ga.hr[v, u].s := 0 END;
			INC (v)
		END;
		INC (u)
	END;
END DefaultRepeaters;

PROCEDURE ChangeLabels (ga : CLGAs.GA);	(* change some signals to low polarity *) 	
	VAR str: ARRAY CLGAs.LabelLen OF CHAR;

	PROCEDURE Change (s : ARRAY OF CHAR);
		VAR l: CLGAs.Label; u, v, i: INTEGER; sig: SHORTINT;
	BEGIN
		l := CLGAs.This (ga, s);
		IF l # NIL THEN
			u := l.u; v := l.v; sig := l.sig;
			CLGAs.Delete (ga, u, v, sig, s);
			i := 0;  WHILE s[i] # 0X DO INC(i) END;
			s[i] := "'"; s[i+1] := 0X;
			CLGAs.Insert(ga, s, u, v, sig, l)
		END
	END Change;

BEGIN
	str := "CW"; Change(str); str := "SEL"; Change(str); str := "WR"; Change(str); str := "RD"; Change(str);
	str := "INT"; Change(str); str := "CS"; Change(str); str := "WE"; Change(str); str := "OE"; Change(str)
END ChangeLabels;

PROCEDURE ChangeLabelConsts (ga : CLGAs.GA);
CONST
	OldAOut = 14; OldBOut = 15; OldLOut = 16;
	OldLBusN = 19; OldLBusS = 20; OldLBusW = 21; OldLBusE = 22;
	OldEBusN = 23; OldEBusS = 24; OldEBusW = 25; OldEBusE = 26;
VAR
	l : CLGAs.Label;
BEGIN
	l := ga.first;
	WHILE l # NIL DO
		CASE l.sig OF
			OldAOut	:	l.sig := CLGAs.AOut;
		|	OldBOut	:	l.sig := CLGAs.BOut;
		|	OldLOut		:	l.sig := CLGAs.LOut;
		|	OldLBusN	:	l.sig := CLGAs.LBusN;
		|	OldLBusE	:	l.sig := CLGAs.LBusE;
		|	OldLBusS	:	l.sig := CLGAs.LBusS;
		|	OldLBusW	:	l.sig := CLGAs.LBusW;
		|	OldEBusN	:	l.sig := CLGAs.EBusN;
		|	OldEBusE	:	l.sig := CLGAs.EBusE;
		|	OldEBusS	:	l.sig := CLGAs.EBusS;
		|	OldEBusW	:	l.sig := CLGAs.EBusW;
		ELSE (* ignore *)
		END;
		l := l.next
	END;
END ChangeLabelConsts;

PROCEDURE Update*;	
	VAR
		S: Texts.Scanner; ga: CLGAs.GA; from, to: Files.File; From, To: Files.Rider; len: LONGINT; res: INTEGER; ch: CHAR;
		buf: POINTER TO ARRAY 30000 OF CHAR;
BEGIN
	NEW(buf); Setup(S);
	WHILE S.class = Texts.Name DO
		from := Files.Old(S.s); to := Files.New("tmp");
		IF (from # NIL) & (to # NIL) THEN
			Str("updating "); Str(S.s); Ln;
			Files.Set(From, from, 0); Files.Read(From, ch);
			IF ch # 0C1X THEN
				Files.Set(From, from, 0); Files.Set(To, to, 0); Files.Write(To, 0C1X);
				len := Files.Length(from);
				Files.ReadBytes(From, buf^, len); Files.WriteBytes(To, buf^, len);
				IF Files.Length(to) # len+1 THEN Str("incorrect length"); Ln
				ELSE
					Files.Register(to); Files.Rename("tmp", S.s, res);
					IF res > 1 THEN Str("renaming not done"); Ln
					ELSE
						NEW(ga); CLGAs.Open(ga, S.s, res);
						IF res = 0 THEN
							Str(" changing labels"); ChangeLabels(ga); Ln;
							Str(" changing label constants"); ChangeLabelConsts(ga); Ln;
							Str(" changing default repeaters"); DefaultRepeaters(ga);	(*<< for NW 14 May 93 *) 
							CLGAs.Store(ga, S.s, len); Int(len, 7); Ln
						END
					END
				END
			ELSE Str("update done already!"); Ln
			END
		END;
		Texts.Scan(S)
	END
END Update;

*****)

PROCEDURE Update*;	
	VAR s: Texts.Scanner; ga: CLGAs.GA; len, totFrom, totTo: LONGINT; res: INTEGER;
BEGIN
	Setup(s); totFrom := 0; totTo := 0;
	Str("CLTool.Update"); Ln;
	WHILE s.class = Texts.Name DO
		NEW(ga); CLGAs.Open(ga, s.s, res);
		IF res = 0 THEN
			len := Files.Length(Files.Old(s.s)); INC(totFrom, len);
			Str("storing "); Str(s.s); Char(" "); Int(len, 0); Str(" -> ");
			CLGAs.Store(ga, s.s, len); Int(len, 0); Ln; INC(totTo, len);
		END;
		Texts.Scan(s)
	END;
	Str("Total from "); Int(totFrom, 0); Str(" to "); Int(totTo, 0); Str(" = ");
	Int(ENTIER(100*(totTo/totFrom)+0.5), 0); Char("%"); Ln
END Update;

BEGIN Texts.OpenWriter(W)
END CLTool.


CLTool.Update ^
