  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt         StampElems Alloc 20 Jun 94      r    8  FoldElems New      8   #    8   _    8   9    8   T   8   _    8      8   _    8   `    8      8   f    8   M    8      8   B    8   \   8   /    8       8   0    8      8   1    8   '   8   1    8   )   8   4    8       8   1    8       8   3    8       8   6    8      8   0    8       8   0    8   .    8   )      MODULE CLLola;	(* sg ,  *)

IMPORT Texts, Oberon, LSD;

VAR topScope : LSD.Variable; W : Texts.Writer;

PROCEDURE err0 (op : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, op); Texts.WriteString (W, " with undefined argument");
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END err0;

PROCEDURE err (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s); Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END err;


PROCEDURE Match* (var1, var2 : LSD.Variable) : BOOLEAN;
BEGIN
	WHILE (var1 # NIL) & (var2 # NIL) DO
		IF var1.name # var2.name THEN var2 := NIL
		ELSIF (var1.y # NIL) & (var2.y # NIL) THEN var1 := var1.y(LSD.Variable); var2 := var2.y(LSD.Variable)
		ELSIF (var1.y = NIL) & (var2.y = NIL) THEN var1 := NIL; var2 := NIL;
		ELSE var1 := NIL
		END
	END;
	RETURN (var1 = var2) (* = NIL *)
END Match;

PROCEDURE Insert (scope : LSD.Variable; name : ARRAY OF CHAR; type : SHORTINT) : LSD.Variable;
VAR var, prev : LSD.Variable;
BEGIN
	var := scope.dsc; prev := NIL;
	WHILE (var # NIL) & (var.name < name) DO prev := var; var := var.next END;
	IF (var = NIL) OR (var.name # name) THEN
		NEW (var); var.x := NIL; var.dsc := NIL; var.fct := type; COPY (name, var.name);
		IF scope # topScope THEN var.y := scope ELSE var.y := NIL END;
		IF prev = NIL THEN var.next := scope.dsc; scope.dsc := var
		ELSE var.next := prev.next; prev.next := var
		END
	END;
	RETURN var
END Insert;

PROCEDURE Enter* (scope : LSD.Variable; name : ARRAY OF CHAR; type : SHORTINT) : LSD.Variable;
VAR i : SHORTINT; var : LSD.Variable;

	PROCEDURE Enter2 (scope : LSD.Variable) : LSD.Variable;
	VAR name1 : LSD.Name; i0, type1 : SHORTINT; newScope : LSD.Variable;
	BEGIN
		i0 := i;
		WHILE (name[i] # 0X) & (name[i] # ".") & (i - i0 < LSD.NameLen - 1) DO name1[i - i0] := name[i]; INC (i) END;
		name1[i - i0] := 0X;
		IF name[i] = 0X THEN RETURN Insert (scope, name1, type)
		ELSE
			INC (i);
			IF (name[i] >= "0") & (name[i] <= "9") THEN type1 := LSD.Array ELSE type1 := LSD.Record END;
			newScope := Insert (scope, name1, type1);
			RETURN Enter2 (newScope)
		END
	END Enter2;

BEGIN
	topScope := scope;
	i := 0;
	var :=  Enter2 (scope);
	topScope := NIL;
	RETURN var
END Enter;

PROCEDURE This* (scope : LSD.Variable; name : ARRAY OF CHAR) : LSD.Variable;
VAR i, i0 : SHORTINT; name1 : LSD.Name; var : LSD.Variable;
BEGIN
	IF scope # NIL THEN
		i := -1;
		REPEAT
			INC (i); i0 := i;
			WHILE (name[i] # 0X) & (name[i] # ".") & (i - i0 < LSD.NameLen - 1) DO name1[i - i0] := name[i]; INC (i) END;
			name1[i - i0] := 0X;
			var := scope.dsc;
			WHILE (var # NIL) & (var.name # name1) DO var := var.next END;
			scope := var;
		UNTIL (var = NIL) OR (name[i] = 0X);
		IF (var # NIL) & ~(var.fct IN {LSD.Bit, LSD.TS, LSD.OC}) THEN var := NIL END
	ELSE var := NIL
	END;
	RETURN var
END This;

PROCEDURE Lookup* (var : LSD.Variable; VAR name : ARRAY OF CHAR);
VAR i : SHORTINT;

	PROCEDURE Append (var : LSD.Variable);
	VAR i0 : SHORTINT;
	BEGIN
		IF var.y # NIL THEN Append (var.y (LSD.Variable)); name[i] := "."; INC (i) END;
		i0 := i;
		WHILE (var.name[i - i0] # 0X) & (i < LEN (name)) DO name[i] := var.name[i - i0]; INC (i) END;
	END Append;

BEGIN
	i := 0;
	Append (var);
	name[i] := 0X;
END Lookup;


PROCEDURE Not* (x : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF x = NIL THEN err0 ("NOT"); z := LSD.zero
	ELSIF x = LSD.one THEN RETURN LSD.zero
	ELSIF x = LSD.zero THEN RETURN LSD.one
	ELSIF x.fct = LSD.not THEN z := x.y
	ELSE z := LSD.New (LSD.not, NIL, x)
	END;
	RETURN z
END Not;

PROCEDURE Or* (x, y : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF  (x = NIL) OR  (y = NIL) THEN err0 ("OR"); z := LSD.zero
	ELSIF (x = LSD.one) OR (y = LSD.one) THEN RETURN LSD.one
	ELSIF x = LSD.zero THEN RETURN y
	ELSIF y = LSD.zero THEN RETURN x
	ELSE z := LSD.New (LSD.or, x, y)
	END;
	RETURN z
END Or;

PROCEDURE Xor* (x, y : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF  (x = NIL) OR  (y = NIL) THEN err0 ("XOR"); z := LSD.zero
	ELSIF x = LSD.one THEN RETURN Not (y)
	ELSIF x = LSD.zero THEN RETURN y
	ELSIF y = LSD.one THEN RETURN Not (x)
	ELSIF y = LSD.zero THEN RETURN x
	ELSE z := LSD.New (LSD.xor, x, y)
	END;
	RETURN z
END Xor;

PROCEDURE And* (x, y : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF  (x = NIL) OR  (y = NIL) THEN err0 ("AND"); z := LSD.zero
	ELSIF x = LSD.zero THEN RETURN LSD.zero
	ELSIF x = LSD.one THEN RETURN y
	ELSIF y = LSD.zero THEN RETURN LSD.zero
	ELSIF y = LSD.one THEN RETURN x
	ELSE z := LSD.New (LSD.and, x, y)
	END;
	RETURN z
END And;

PROCEDURE Mux* (s, x, y : LSD.Signal) : LSD.Signal;
VAR z, w : LSD.Signal;
BEGIN
	IF  (s = NIL) OR  (x = NIL) OR  (y = NIL) THEN err0 ("MUX"); z := LSD.zero
	ELSE z := LSD.New (LSD.mux, s, LSD.New (LSD.mux1, x, y))
	END;
	RETURN z
END Mux;

PROCEDURE Reg* (e, d : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF  (d = NIL) OR  (e = NIL) THEN err0 ("REG"); z := LSD.zero
	ELSE z := LSD.New (LSD.reg, e, d)
	END;
	RETURN z
END Reg;

PROCEDURE Latch* (e, d : LSD.Signal) : LSD.Signal;
VAR z : LSD.Signal;
BEGIN
	IF  (d = NIL) OR  (e = NIL) THEN err0 ("LATCH"); z := LSD.zero
	ELSE z := LSD.New (LSD.lch, e, d)
	END;
	RETURN z
END Latch;

PROCEDURE Assign* (v : LSD.Variable; x : LSD.Signal);
BEGIN
	IF v = NIL THEN err ("variable undefined")
	ELSIF x = NIL THEN Texts.WriteString (W, v.name); err (" expression undefined")
	ELSIF v.fct = LSD.Bit THEN
		IF v.x = NIL THEN v.x := x;
		ELSE Texts.WriteString (W, v.name); err (" mult def. ")
		END
	ELSIF v.fct = LSD.TS THEN
		IF x.fct = LSD.ts THEN v.x := LSD.New (LSD.tsc, x, v.x)
		ELSE Texts.WriteString (W, v.name); err (" assignment without TS-gate")
		END
	ELSIF v.fct = LSD.OC THEN
		v.x := LSD.New (LSD.occ, x, v.x)
	END
END Assign;

PROCEDURE TS* (e, x : LSD.Signal) : LSD.Signal;
VAR t : LSD.Signal;
BEGIN
	IF  (e = NIL) OR  (x = NIL) THEN err0 ("TS"); t := LSD.zero
	ELSE t := LSD.New (LSD.ts, e, x)
	END;
	RETURN t
END TS;

PROCEDURE SR* (s, r : LSD.Signal) : LSD.Signal;
BEGIN
	RETURN LSD.New (LSD.sr, s, r)
END SR;


BEGIN Texts.OpenWriter (W)
END CLLola.
