/******************************************************************************
*PRINTER.C - Parallel Printer Turbo Driver			Version 1.0
*******************************************************************************
* Version   Date   Who          Description
* ======= ======== ============ ===============================================
*  1.01   18FEB88  Mike Bailey  Forget doing mapphys() on ROS data area to
*                               do presence test for adapters...must do HW I/O
*                               because phys. mem. will probably be overwritten
*				by driver-install time.
*	  30.09.87 R.K.		Checks unit 0 = Port 3XX or 278
*         02.08.87 R.K		Disable interupt from prn_flush to prn_uninit
*				because problems in batch program.
*
* V1.00	  23.07.87 Rolf Koeppel Interrupt-driven printer driver.
*		   GWK TSS3	3.5 times faster than old polling driver
*				Parallel process works fast now.
*				For 2 Units, because there are only 2 hardware 
*				interrupts.
*				Unit 0 = Interrupt 0x6f,Port 378 or 3BC,
*				Unit 1 = Interrupt 0x6d,Port 278.
*******************************************************************************
*
*	What I assume:
*	1) That there will be no more that 4 units. Tables affected are
*	   PRN_BASEPORT and PRN_RTN, which are set up for
*	   this limit.
*	2) That the baseports at 0000:0408 through 0000:040F are valid
*	   and set up by the boot ROM.
*       3) Forget #2...the ports are in RAM when FlexOS is first entered by
*          the boot loader, but that RAM has most likely been given away
*          at driver-install time...Mike Bailey, 18 FEB 88. 
*
******************************************************************************/

#include "portab.h"
#include "sysbuild.h"
#include "io.h"
#include "system.h"

#if METAWARE 
#define PRINTER
#include "protos.h"
#endif

#define DEBUG  0		/* Non zero output to com1: */

/************************************************************************
*	The next three defines are the relative offset of each printer
*	register from its base value (as described in PRN_BASEPORT,
*	below).
*************************************************************************/

#define	P_DATA	0		/* Offset of the DATA latch register	*/
#define	P_STAT	1		/* Offset of the STATUS register	*/
#define	P_COMM	2		/* Offset of the COMMAND register	*/

#define	NBRUNIT	2		/* Maximum of two printers.		*/
#define	FLAGVAL	0x0A		/* sync at unit level,16-bit reads	*/

#define	YES	1		/* Writing is allowed			*/
#define	NO	0		/* Writing isn't allowed		*/

#define	INITDLY	16384		/* Length of the Init Delay		*/

#define	READY	-1		/* Returned from PRN_STATUS if ready	*/
#define	UNREADY	0		/* Returned from PRN_STATUS if not ready*/

/************************************************************************
*	Printer Status Bits
*************************************************************************/

#define	PRN_TO	0x01		/* Time out error			*/
#define	PRN_IO	0x08		/* I/O error				*/
#define	PRN_SEL	0x10		/* Printer Selected			*/
#define	PRN_OOP	0x20		/* Out Of Paper				*/
#define	PRN_ACK	0x40		/* Strobe Acknowledge			*/
#define	PRN_NBY	0x80		/* Not Busy				*/ 

#define	PRN_ERR	(PRN_OOP)	/* Any of these is an error.		*/

/************************************************************************
*	Printer Command Bits
*************************************************************************/

#define	PRN_STROBE	0x01	/* Set STROBE line high			*/
#define	PRN_INIT	0x04	/* Set INIT* line high			*/
#define	PRN_SELECT 	0x08	/* Select printer			*/
#define PRN_INT		0x10	/* Interupt enable */

/************************************************************************
*	External Definitions
*************************************************************************/
#if DEBUG
EXTERN VOID debug_init(),xregs(),confmt();
/*GLOBAL WORD prn_portget();  1.01*/
#endif


EXTERN  LONG	pollevent();

#define	mwait(a) supif(F_WAIT,a)
#define	aret(a) supif(F_RETURN,a)

EXTERN WORD inp(), outp();
EXTERN VOID prnstrob();			/* ASM Routine */

EXTERN WORD setvec();
EXTERN VOID s_ds_prn();			/* ASM Routine */
EXTERN supif();

/************************************************************************
*	Locally defined routines. The first four rows are normal
*	driver routines. The fifth contains the status routines.
*************************************************************************/

LONG	prn_init(), prn_uninit(), prn_subdrv(), prn_select(), prn_flush();
LONG	prn_read(), prn_write(), prn_get(), prn_set(), prn_special();
/*WORD    prn_portget();   1.01*/
VOID	prn_presence();  /*1.01*/
int	do_port();	 /*1.01*/	

WORD	prn_st0(), prn_st1(), prn_status();
VOID	getset_prn();

WORD	prn0_intrp(), prn1_intrp();
ASR	prn_asr();

/************************************************************************
*	The Printer Driver Driver Header.
*
*	This must be the first data structure defined, so that the loader
*	knows where to find it.
*************************************************************************/

GLOBAL DH prn_dh = 
{
	0,			/* Number of units allocated.		*/
	NBRUNIT,		/* Maximum number of units.		*/
	FLAGVAL,		/* Synchronize at Unit level.		*/
	prn_init,		/* Initialize the printer.		*/
	prn_subdrv,		/************** Not Needed **************/
	prn_uninit,		/* Un-initializes the printer.		*/
	prn_select,		/* Selects the printer for use.		*/
	prn_flush,		/* Flush the printer.			*/
	prn_read,		/************** Not Needed **************/
	prn_write,		/* Writes data to the printer.		*/
	prn_get,		/* gets prn_table[u]			*/
	prn_set,		/* sets prn_table[u]			*/
	prn_special,		/**** Unimplemented **** not needed *****/
	0L,0L,0L,0L,0L		/* resevered				*/
} ;

/************************************************************************
*	prn_table
*
*	defines and sets up the default values for each printer unit
*	change this table to your values (if known)
*************************************************************************/
#define PTE	struct	prnTableStruct
PTE
{	LONG	PT_STATUS;
	BYTE	PT_MODE;
	BYTE	PT_PAPERTYP;
	WORD	PT_WIDTH;
	BYTE	PT_LEGMODE;
	BYTE	PT_SINGPAG;
	BYTE	PT_LPI;
	BYTE	PT_LENGTH;
	BYTE	PT_NAME[16];
};

PTE	prn_table[NBRUNIT] = {
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Interupt printer" },
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Interupt printer" },
 };

			/* a place to store the user's parmeter block when */
			/* we return control and possible overwrite	   */
	DPBLK	prn_wpb[NBRUNIT] = {0,0};

	WORD	abflg[NBRUNIT] = {0,0,} ;

	LONG	zaehler[NBRUNIT] = { 0L,0L};	 /*lached character counter*/ 

	LONG 	curpd_prn[NBRUNIT];		/*process discriptor save */

	LONG	prn_buffer[NBRUNIT] = {0L,0L} ;	     /*will be SALLOCED later in s_write*/
	LONG 	prn_s_buffer[NBRUNIT] = {0L,0L};     /*for sfree */
	LONG	prn_dp_bufsiz[NBRUNIT] = {0L,0L};
	BYTE	intrp_ok[NBRUNIT] = {0,0};	     /*for spurious interrupts*/
	WORD	port[NBRUNIT+1] = {0,0,0};	/* 1.01 port start address */
						/* 3 because we look for 3 */
						/* in prn_presence */
#if DEBUG
	struct SREGS
	{
		WORD xcs;
		WORD xds;
		WORD xes;
		WORD xss;
		WORD xip;
		WORD xax;
		WORD xbx;
		WORD xcx;
		WORD xdx;
		WORD xsi;
		WORD xdi;
		WORD xsp;
	} sregs;


#endif


/************************************************************************
*	PRN_BASEPORT
*
*	An array of the base ports of each printer unit. I don't know
*	what the exact values are...
*************************************************************************/
/* 1.01
struct {
    LONG pfill, pstart, plength;
    } prn_physpb		= { 0L, 0x408L, 8L };
*/
/************************************************************************
*	PRN_RTN
*
*	A list of all the status routines, one for each unit. This is
*	necessary because POLLEVENT doesn't let the status routine have
*	any arguments, hence this method of determining the unit number.
*************************************************************************/

WORD (*prn_rtn[NBRUNIT])() = { prn_st0, prn_st1 };

/************************************************************************
*	PRN_FLAGS
*
*	A list of event flags for each unit.
*************************************************************************/

LONG prn_flags[NBRUNIT] = { 0L, 0L };

/************************************************************************
*	PRN_PORTGET ... no longer used 1.01
*
*	Get the I/O address of the specified printer port.
*************************************************************************/
/*
WORD prn_portget(unitno)
int unitno;
{
    static WORD *tval, getinit=0;

    if(!getinit){
1.01 */
	/***** Check for error return from mapphys() *****/
/*
	if ( ( tval = (WORD *)mapphys(&prn_physpb,1) ) == NULLPTR )
		return(0);
	getinit = 1;
	}
    return(*(tval + unitno));
}
1.01 */

/*************************************************************************
*        prn_presence()   1.01
*
*        Fills out the global "port[]" array with base I/O address for the
*        IBM-compatible parallel adapters it finds...up to NBRUNIT
*
**************************************************************************/

void prn_presence()
  {
  static int initted = 0;	/* only need to do this for 1st unit */

  if (initted == 0)
    {
    if (do_port(0,0) == 0)	/* 3BC to unit 0 */ 
      do_port(1,0);		/* then 378 to unit 0 */
    do_port(2,1);		/* always 278 to unit 1 */
    initted = 1;
    }
  }    


/*************************************************************************
*        do_port()   1.01
*
*        Fills out the global "port[]" array with base I/O address for the
*        IBM-compatible parallel adapter it finds.  First parm == HW port
*        number, 2nd = FlexOS unit number to assign.  Presence check is
*        done like IBM ROS.
*
**************************************************************************/

int do_port(i,j)
  int i,j;				/* HW to check, unit to fill in */
  {
  static WORD base_addrs[3] = {0x3BC, 0x378, 0x278};

  outp(base_addrs[i],0xaa);
  if (inp(base_addrs[i]) == 0xaa)
    {
    port[j] = base_addrs[i];
    return(1);
    }
  return(0);
  }          

/************************************************************************
*	PRN_INIT
*
*	Initialize the specified unit number
*************************************************************************/

LONG prn_init( unitno )
WORD unitno;
{
    WORD i;
    LONG rc;

    prn_presence();			/* set up port[] array     1.01 */

    /* Get flag for future use.	*/
    if( (rc = flagget()) == NULLPTR ) return(ED_PRN | E_EMASK);
    prn_flags[unitno] = rc;
					/* Get some memory for asrwait */

    /***** Check for error from prn_portget (caused by mapphys()) *****/
    /* 1.01                                                    */
    /* 1.01 if ( ( port[unitno] = prn_portget(unitno) ) == 0 ) */
    /* 1.01	return( ED_PRN + E_MEMORY );                   */

    if ( port[unitno] == 0)		/* 1.01 */
/*    return(ED_PRN + E_HARDWARE);	   1.01 */
      return (ED_PRN + E_MEMORY);       /* 1.01 */   

    outp( port[unitno]+P_COMM, PRN_SELECT + PRN_INT );	/* Assert INIT*	*/
    for( i = INITDLY; --i; );		/* Wait for printer to catch on	*/
					/* ints, no auto lf, INIT* hi*/
    outp( port[unitno]+P_COMM, PRN_SELECT+PRN_INIT+PRN_INT );

    if (unitno ==0) 
	{
	  if(port[0] == 0x278)
	     setvec(prn1_intrp,0x6DL);		
	  else
	     setvec(prn0_intrp,0x6FL);
	}

    if (unitno ==1)
       {
	 if((port[1] & 0x300) == 0x300)
	    return(ED_PRN + E_INIT);
	 else
	    setvec(prn1_intrp,0x6DL);
	}

    prn_table[unitno].PT_STATUS = 0L;

#if DEBUG
    debug_init();
    xregs(&sregs);
    confmt("CS Reg.  : %x\t\tOff prn_portget: %x\n",sregs.xcs,sregs.xip);
    confmt("DS Reg.  : %x\t\tBX Reg.	  : %x \n",sregs.xds,sregs.xbx);
    confmt("ES Reg.  : %x\t\tSI Reg.	  : %x \n",sregs.xes,sregs.xsi);
    confmt("SS Reg.  : %x\t\tSP Reg.      : %x \n",sregs.xss,sregs.xsp);
    confmt("AX Reg.  : %x\t\tCX Reg.      : %x \n",sregs.xax,sregs.xcx);
    confmt("DX Reg.  : %x\t\tDI Reg.      : %x \n",sregs.xdx,sregs.xdi);
#endif

    return((LONG)DVR_PRN);		/* Return code.			*/
}

/************************************************************************
*	PRN_UNINIT
*
*	Uninitialize the current unit number... disable reading and
*	writing.
*************************************************************************/

LONG prn_uninit( unitno )
WORD unitno;
{
    if(flagrel(prn_flags[unitno]) < 0) return(ED_PRN | E_CONFLICT);

    if (unitno ==0)
      {
	if(port[0] == 0x278)
	  {
    	   outp( 0x21 , inp(0x21) | 0x20 ); /*disable interupt mask register */ 
           setvec(prn1_intrp,0x0L);
	  }
	else
	  {
	   outp( 0x21 , inp(0x21) | 0x80 ); /*disable interupt mask register */
           setvec(prn0_intrp,0x0L);
	  }
      }

    if (unitno ==1)
      {
	outp( 0x21 , inp(0x21) | 0x20 ); /*disable interupt mask register */ 
        setvec(prn1_intrp,0x0L);
      }
    return(E_SUCCESS);
}

/************************************************************************
*	PRN_SELECT
*
*	Enable printing on the selected unit.
************************************************************************/

LONG prn_select( pb )
DPBLK *pb;
{

	BYTE unitno;

	unitno = pb->dp_unitno;

/* 1.01   if ( ( port[unitno] = prn_portget(unitno) ) == 0 ) */
/* 1.01	    return( ED_PRN + E_MEMORY );		     */

        if (port[unitno] == 0)			/* 1.01 */
/*	  return(ED_PRN + E_HARDWARE);		   1.01 */
          return(ED_PRN + E_MEMORY);            /* 1.01 */

	if (unitno ==0)
	   {
	     if(port[0] == 0x278)
	       outp( 0x21,inp(0x21) & ~0x20); /*enable IRQ 5 */
	     else
	       outp( 0x21 , inp(0x21) & ~0x80 ); /*enable IRQ 7 interupt mask register */
	   }
	if (unitno ==1) outp( 0x21 , inp(0x21) & ~0x20 );

    return(E_SUCCESS);
}

/************************************************************************
*	PRN_FLUSH
*
*	Flush the current unit number. Currently has no meaning for
*	a printer.
*************************************************************************/

LONG prn_flush( pb )
DPBLK *pb;
{
	BYTE unitno;

	if (!(pb->dp_flags))  {
	    abflg[pb->dp_unitno] = 1 ;
        }

	unitno = pb->dp_unitno;

							/*copy makes shared open */
							/*and calls flush -> clear intrp.*/
 
   if(prn_wpb[unitno].dp_pdaddr == pb->dp_pdaddr)	/*for shared open*/
    {
         prn_wpb[unitno].dp_bufsiz = 0L;		/*for ^C Abruch */

         if(prn_s_buffer[unitno])
          {
	    if(sfree(prn_s_buffer[unitno]) < 0L)
		return(ED_PRN + E_MEMORY);
	    prn_dp_bufsiz[unitno] = prn_s_buffer[unitno] = 0L;
	
	  }
     } 
    return(E_SUCCESS);
}

/************************************************************************
*	PRN_READ
*
*	Again, no meaning for a printer.
************************************************************************/

LONG prn_read( pb )
DPBLK *pb;
{
    return(ED_PRN | E_IMPLEMENT);
}

/***********************************************************************
*	PRN_WRITE
*
*	Sets up an ASR function to do the write to the printer.
*	needs to make local copy of parmeter block.
*	And returns the event mask to the Resource Manager
************************************************************************/

LONG prn_write( pb )
DPBLK *pb;
{
	BYTE 	*prnbuf,*d,*s;
	WORD	unitno,size;
	LONG	emask,emask1,prn_poll,buff_size;

 	unitno = pb->dp_unitno;		/* The unit number.		*/

	if (prn_dp_bufsiz[unitno] < pb->dp_bufsiz)
	 {
	  if (prn_dp_bufsiz[unitno])
	   {
	     if (sfree(prn_s_buffer[unitno]) < 0)
		return(ED_PRN + E_MEMORY);
	   }  

          if ( ( prn_s_buffer[unitno] = salloc(pb->dp_bufsiz) ) == NULLPTR )
		return( ED_PRN + E_MEMORY);
		prn_dp_bufsiz[unitno] = pb->dp_bufsiz;
	}
    prn_buffer[unitno] = prn_s_buffer[unitno];	

    if((emask=flagevent(prn_flags[unitno],pb->dp_swi)) > 0L)
     {
/*	size = sizeof(DPBLK) / 2 ;   */		/* make it words */
/*	d = (WORD *) &prn_wpb[unitno]; */
/*	s = (WORD *) pb;		*/
/*	while (size--) *d++ = *s++ ;	*/

	size = sizeof(DPBLK) ;   		
	d = (BYTE *) &prn_wpb[unitno]; 
	s = (BYTE *) pb;		
	_move(s,d,size);		/*save pb */

	curpd_prn[unitno] = (LONG)*prn_dh.dh_curpd;	/*save current processdiscriptor for interuptrou.*/
        prnbuf = prn_wpb[unitno].dp_buffer;		/* And wherever they are.	*/
    
        if (prn_wpb[unitno].dp_flags & DPF_UADDR)
	   {
	   mapu( prn_wpb[unitno].dp_pdaddr );
           prnbuf = (BYTE *) SADDR(prnbuf);
	   }

/*	buff_size = prn_wpb[unitno].dp_bufsiz/2;
 	d = (WORD *) prn_buffer[unitno];
	s = (WORD *) prnbuf;
	while (buff_size2--) *d++ = *s++ ;
*/

	if((buff_size = prn_wpb[unitno].dp_bufsiz) != 0)
 	 {
	  d = (BYTE *) prn_buffer[unitno];
	  s = (BYTE *) prnbuf;

	  *d++ = *s++ ;
	  buff_size -=1;			/*rep movsb only for CX=FFFF=64k-1*/
 	  _move(s,d,buff_size);			/*save character */

	  if(prn_status(unitno) == UNREADY)	/*for busy and paper out */
	    {
  	        prn_poll = (LONG)prn_rtn[unitno];
	        emask1 = pollevent(prn_poll,0L);
                supif(F_WAIT,emask1);	/*wait till printer ready */
 	        supif(F_RETURN,emask1);

   	    }
	  
          intrp_ok[unitno] = TRUE;			/*for spurious interrupts*/
        }
       zaehler[unitno]=0L;				/*set latched character counter to 0 */

       doasr(prn_asr,unitno,0L,201);			/*give first character*/

       if( prn_wpb[unitno].dp_flags & DPF_UADDR) unmapu();

     }
    return(emask);
}


/***********************************************************************
*	Interuptservice routine for UNIT 0 
************************************************************************/

WORD prn0_intrp()
{
        outp(0x20,0x20); 		/*non-specific EOI */
	s_ds_prn();			/*set DS Register to prn_dh*/
        if(intrp_ok[0])			/*for spurious interrupts*/
	  doasr(prn_asr,0,0L,201);  
	return(FALSE);			/*no dispatch ,LINK86 30% faster than dispatch */
}


/***********************************************************************
*	Interuptservice routine for UNIT 1 
************************************************************************/

WORD prn1_intrp()
{
        outp(0x20,0x20); 		/*non-specific EOI */
	s_ds_prn();			/*set DS Register to prn_dh*/
	if(port[0]==0x278)
	  {
           if(intrp_ok[0])			/*for spurious interrupts*/
	   doasr(prn_asr,0,0L,201);  
	  }
	else
	  {
           if(intrp_ok[1])			/*for spurious interrupts*/
	   doasr(prn_asr,1,0L,201);  
	  }
	return(FALSE);			/*make no dispatch for ASR */

}


/***********************************************************************
*	ASR Routine , called from Interuptservice routine 
************************************************************************/

ASR prn_asr(unitno)

BYTE unitno;
{
	s_ds_prn();

        if (abflg[unitno])
         {
	   abflg[unitno] = 0 ;
           flagset(prn_flags[unitno],curpd_prn[unitno],zaehler[unitno]);
           intrp_ok[unitno] = FALSE; 			/*for spurious interrupts*/
           return(0) ;
         }

       
	if (zaehler[unitno] < prn_wpb[unitno].dp_bufsiz )
	 {
	   outp(port[unitno]+P_DATA,*((BYTE *)prn_buffer[unitno]++));	/*latch the character */
	   zaehler[unitno]++;
	   prnstrob(port[unitno]+P_COMM);	/*give Strobe to printer via steuer port */
	   return(0);
        }
	 flagset(prn_flags[unitno],curpd_prn[unitno],zaehler[unitno]); 	/*give EMASK for next s_write free*/
  	 flagclr(prn_flags[unitno]);
         intrp_ok[unitno] = FALSE; 			/*for spurious interrupts*/
      	 return(0);
}
/************************************************************************
*	PRN_STATUS
*
*	Return the status of the printer -- -1 if ready, else 0
*************************************************************************/

WORD prn_st0()
{
    return(prn_status(0));
}

WORD prn_st1()
{
    return(prn_status(1));
}

WORD prn_status(unitno)
WORD unitno;
{

    switch(inp(port[unitno]+P_STAT) & 0xA8 ) 
	{
	case (PRN_NBY + PRN_IO):	/*no busy ,no error,no paper end*/
		return(READY);
	default:
		return(UNREADY);
	}
}
/************************************************************************
*	PRN_GET
*	PRN_SET
*
*	The driver GET and SET functions ... awaiting definition of the
*	table.
*************************************************************************/

LONG prn_get( pb ) 
DPBLK *pb ;
{
	BYTE	*buff;

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset_prn(&prn_table[pb->dp_unitno],buff,(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();
	return(E_SUCCESS);
}

LONG prn_set( pb ) 
DPBLK *pb ;
{
	BYTE	*buff;

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset_prn(buff,&prn_table[pb->dp_unitno],(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();
	return(E_SUCCESS);
}

/************************************************************************
*	PRN_SPECIAL
*
*	Again, a function that doesn't apply (yet, at least) to the
*	printer drivers.
*************************************************************************/

LONG prn_special( pb )
DPBLK *pb ;
{
    return(ED_PRN | E_IMPLEMENT) ;
}

/************************************************************************
*	PRN_SUBDRV
*
*	The printer driver does not need a sub driver
*************************************************************************/

LONG prn_subdrv( pb )
DPBLK *pb ;
{
    return(ED_PRN | E_UNWANTED) ;
}

/************************************************************************
*	GETSET
*
*	Common routine for PRN_GET() and PRN_SET() code
*	copies sz words from source pointer to destination pointer
*	checking against field size.
*************************************************************************/
/*
*
*	here's a little macro for checking if this field is now beyond
*	the size of get/set requested.  Done by macro so source code line
*	length remains exceptable
*/

#define	ckspace(s,p,n)	((s) -= sizeof((p))) >= sizeof((n))

VOID	getset_prn(sp,dp,sz)
REG PTE	 *sp,*dp;
REG WORD sz;
{
	BYTE	i;

 if( sz >= sizeof(dp->PT_STATUS))
 {
  dp->PT_STATUS = sp->PT_STATUS;
  if( ckspace(sz,dp->PT_STATUS,dp->PT_MODE) )
  {
  dp->PT_MODE = sp->PT_MODE;
   if( ckspace(sz,dp->PT_MODE,dp->PT_PAPERTYP) )
   {
   dp->PT_PAPERTYP = sp->PT_PAPERTYP;
   if( ckspace(sz,dp->PT_PAPERTYP,dp->PT_WIDTH) )
    {
    dp->PT_WIDTH = sp->PT_WIDTH;
    if( ckspace(sz,dp->PT_WIDTH,dp->PT_LEGMODE) )
     {
     dp->PT_LEGMODE = sp->PT_LEGMODE;
     if( ckspace(sz,dp->PT_LEGMODE,dp->PT_SINGPAG) )
      {
      dp->PT_SINGPAG = sp->PT_SINGPAG;
      if( ckspace(sz,dp->PT_SINGPAG,dp->PT_LPI) )
       {
       dp->PT_LPI = sp->PT_LPI;
       if( ckspace(sz,dp->PT_LPI,dp->PT_LENGTH) )
        {
        dp->PT_LENGTH = sp->PT_LENGTH;
        if( ckspace(sz,dp->PT_LENGTH,dp->PT_NAME) )
         {
	 for (i=0 ; i < sizeof(dp->PT_NAME) ; i++)
         	dp->PT_NAME[i] = sp->PT_NAME[i];
         }
        }
       }
      }
     }
    }
   }
  }
 }
}
