/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.4.02     IIFDDMA.C                                *
 *                      Machine dependent dma functions.         *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85  reb    rewritten/added to system        *
 *    1.1       6/17/85  reb    removed dkpanic call             *
 *    1.2	6/13/86  mei	High C port.			 *
 *    1.3       1/27/87  KPB    added OUTPW INPW for 386         *
 *    1.4       4/4/86   KPB    Added par to dm_dma for 386      *
 *    1.4.01	05/29/87 AM	Fixed contig memory stuff for 386*
 *    1.4.02	05/29/87 AM	Changed bad pgbount to pgbound	 *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */


#if IAPX386
EXTERN	LONG	contig();
#endif
/***********************************************************************
*                             DMA routines
*
***********************************************************************/

/***********************************************************************
*  dm_dmamax -
*       machine dependent routine which determines if the number of
*       bytes requested can be handled by the dma.
*/

#define K64     0x00010000
#define MASK64K 0xffff0000


LONG    dm_dmamax( buffer , nb ,VaUserAddr)
UBYTE   *buffer ;       /*  start of buffer     */
LONG    nb ;            /*  number of bytes     */
LONG    **VaUserAddr;    /* Va contig user buffer addr */

{

        PHYSADDR        sta, pgbound ;  /*  start addr, page boundary addr */

#if IAPX386
LONG  HoldContigSize;


HoldContigSize = contig(buffer,nb,VaUserAddr);
#else
*VaUserAddr = (LONG*)PADDR(buffer);
#endif



#if (MACHINE == XMACHINE)
        sta = (LONG) *VaUserAddr;                 /*  convert to phys             */
        pgbound = (sta + K64) & MASK64K ;
        if(  (sta + nb) < pgbound )
#if IAPX386
           return((nb < HoldContigSize) ? nb : HoldContigSize);
        else
           return(((pgbound - sta) < HoldContigSize) ? (pgbound - sta)
                                   : HoldContigSize);
#else
                return( nb ) ;
        else
                return( pgbound - sta ) ;
#endif
#endif
#if (MACHINE == COMPUPRO)
/* no max for the compupro's 24 bit dma capability      */
                return( nb ) ;
#endif

}




/*********************************************************************
*  dm_DmaOutput -
*       Outputs controls codes to the dma
*
*/

/*
 *  of a twenty bit address...
 */

#define LOW8(x)         ( (BYTE) ( x & 0x0000ff ) )
#define MID8(x)         ( (BYTE) ((x & 0x00ff00) >> 8) )
#define HI4(x)          ( (BYTE) ((x & 0xff0000) >> 16) )


VOID    dm_DmaOutput( i )
IORB    *i ;
{
        BYTE    mode ;
        LONG    buffer ;
        WORD    count ;

        switch( i->io_op )
        {
                case DKSEEK:            /*  seek                */
                case DKRECAL:           /*  recal               */
                        return ;

                case DKREAD:            /*  read                */
                        mode = DMM_READ ;
                        break ;

                case DKFMT:             /*  format              */
                case DKFMTLST:          /*  list type format    */  
                case DKWRITE:           /*  write               */
                        mode = DMM_WRITE ;
                        break ;
        /* (reb) put in the verify mode */
                case DKVFY:
                        mode = DMM_VFY ;
                        break ;
                default:
                        break ;
        }


#if (MACHINE == XMACHINE)       /* (gam) the 20 bit dma stuff */
        OUTPW( DMCBPF , (BYTE) -1 ) ;            /*  clear byte ptr flip/flop    */
        OUTPW( DMMODE , mode ) ;                 /*  read or write mode          */

        buffer = (LONG) i->io_dmaddr ;          /*  buffer address              */
        OUTPW( DMC2ADDR , LOW8(buffer) ) ;       /*  let's get physical, */
        OUTPW( DMC2ADDR , MID8(buffer) ) ;       /*  physical, yea....   */
        OUTPW( DMPAGEFDC , HI4(buffer) ) ;

        count = i->io_dmcount -1 ;              /*  nbr of bytes                */
        OUTPW( DMC2COUNT , LOW8(count) ) ;
        OUTPW( DMC2COUNT , MID8(count) ) ;

        OUTPW( DMBMASK , DMB_FDCMASK ) ;         /*  binary channel mask         */
#endif

#if (MACHINE == COMPUPRO)
        buffer = (LONG) i->io_dmaddr ;
        OUTPW(DMAPORT, (BYTE)((buffer & 0xFF0000L) >> 16));
        OUTPW(DMAPORT, (BYTE)((buffer & 0x00FF00L) >>  8));
        OUTPW(DMAPORT, (BYTE)((buffer & 0x0000FFL)      ));
#endif

        return ;
}
