/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.1        CPMDBS.H                                 *
 *                      Media Descriptor Blocks Compupro Floppy. *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       3/27/85 gam     added header, intro.c            *
 *    1.1       6/12/85 reb     rewritten/added to system        *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */


/******************************************************************************
*  MDBs -
*       these values are copied to the file system's mdb buffer when we determine
*       what kind of media/drive combo is present.  the table is determined by
*       the FAT ID byte.

(gam) 
16 nov - slight change in the defination of the MDB structure
(see dk.h) , the size of the data structure is the same, a word struct
was "chopped" into two byte fields to allow passing the fat id byte
with the MDB "sent" back to the DISK RESOURCE MGR

*/

MDB     mdb_fc =
{
        /*
         *  MDB for type   0xfc   disk
         */
/* (gam) 7 nov - "corrected to support ?        */
        1024,           /*  sector size                                 */
        01,             /*  firstsec                                    */
        8*77*1,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        1,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfc,           /*  md byte                                     */
        1,              /*  nfrecs                                      */
        96,             /*  dirsize                                     */
        1,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for type   0xfd   disk
         */
/* 7 jan (gam) not sure about this mdb info - I think its incorrect */
MDB     mdb_fe =
{
        128,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        26*77*1,        /*  nsectors                                    */
        26,             /*  sectors per track                           */
        4,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfe,           /*  md byte                                     */
        4,              /*  nfrecs                                      */
        112,            /*  dirsize                                     */
        2,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for type   0xfd   disk
         */

MDB     mdb_fd =
{
        1024,           /*  sector size                                 */
        01,             /*  firstsec                                    */
        8*77*2,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        1,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfd,           /*  md byte                                     */
        2,              /*  nfrecs                                      */
        192,            /*  dirsize                                     */
        2,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for type   0xff   disk
         */

MDB     mdb_ff =
{
        128,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        26*77*1,        /*  nsectors                                    */
        26,             /*  sectors per track                           */
        4,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xff,           /*  md byte                                     */
        6,              /*  nfrecs                                      */
        68,             /*  dirsize                                     */
        1,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

/* (gam) 16 nov - adding support for raw/cpm media determination        */


        /*
         *  MDB for unformatted disks
         */

MDB     mdb_unformatted = 
{
        128,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        26*77*1,        /*  nsectors                                    */
        9,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        2,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for double sided cpm disks
         */

MDB     mdb_2sidedcpm = 
{
        128,            /*  sector size                                 */
        00,             /*  firstsec                                    */
        26*77*2,        /*  nsectors                                    */
        9,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        2,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for single sided cpm disks
         */

MDB     mdb_1sidedcpm = 
{
        128,            /*  sector size                                 */
        00,             /*  firstsec                                    */
        26*77*1,        /*  nsectors                                    */
        9,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        1,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

/***************************************************************************
*  mdbtry -
*       ptrs to mdbs to try to read disk with    
*/
GLOBAL  MDB     *mdbarray[] = { &mdb_ff , &mdb_fd, &mdb_fc, &mdb_fe } ;

