/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        ATMDBS.H                                 *
 *                      Media Descriptor Blocks for AT Floppy.   *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/26/85 reb     added dpb's for copy cpm         *
 *    1.2	6/17/86 mei	DPB def deleted via '#if 0' for  *
 *				High C..is this struct ever used?*
 *===============================================================*
 *  INCLUDES:                                                    */


/******************************************************************************
*  MDBs -
*                               for ibm at
*       these values are copied to the file systems mdb buffer when we determine
*       what kind of media/drive combo is present.  the table is determined by
*       the FAT ID byte.
*/


MDB     mdb_fc =
{
        /*
         *  MDB for type   0xfc   disk
         */

        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        9*40*1,         /*  nsectors                                    */
        9,              /*  sectors per track                           */
        1,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfc,           /*  md byte                                     */
        2,              /*  nfrecs                                      */
        64,             /*  dirsize                                     */
        1,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  system size                 M0002           */
} ;

        /*
         *  MDB for type   0xfd   disk
         */

MDB     mdb_fd =
{
        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        9*40*2,         /*  nsectors                                    */
        9,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfd,           /*  md byte                                     */
        2,              /*  nfrecs                                      */
        112,            /*  dirsize                                     */
        2,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  system size                 M0002           */
} ;

        /*
         *  MDB for type   0xfe   disk
         */

MDB     mdb_fe =
{
        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        8*40*1,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        1,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xfe,           /*  md byte                                     */
        1,              /*  nfrecs                                      */
        64,             /*  dirsize                                     */
        1,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  system size                 M0002           */
} ;

        /*
         *  MDB for type   0xff   disk
         */

MDB     mdb_ff =
{
        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        8*40*2,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xff,           /*  md byte                                     */
        1,              /*  nfrecs                                      */
        112,            /*  dirsize                                     */
        2,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  system size                 M0002           */
} ;

        /*
         *  MDB for type   0xf9 (1.2 M)   disk
         */

MDB     mdb_f9 =
{
        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        15*80*2,        /*  nsectors                                    */
        15,             /*  sectors per track                           */
        1,              /*  secblk                                      */
        2,              /*  nfats                                       */
        0xf9,           /*  md byte                                     */
        7,              /*  nfrecs                                      */
        224,            /*  dirsize                                     */
        2,              /*  nheads                                      */
        1,              /*  format                                      */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  system size                 M0002           */
} ;

        /*
         *  MDB for unformatted disks
         */

MDB     mdb_unformatted = 
{
        512,            /*  sector size                                 */
        01,             /*  firstsec                                    */
        9*40*2,         /*  nsectors                                    */
        9,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        2,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for double sided cpm disks
         */

MDB     mdb_2sidedcpm = 
{
        512,            /*  sector size                                 */
        00,             /*  firstsec                                    */
        8*40*2,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        2,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

        /*
         *  MDB for single sided cpm disks
         */

MDB     mdb_1sidedcpm = 
{
        512,            /*  sector size                                 */
        00,             /*  firstsec                                    */
        8*40*1,         /*  nsectors                                    */
        8,              /*  sectors per track                           */
        2,              /*  secblk                                      */
        0,              /*  nfats                                       */
        0,              /*  md byte                                     */
        0,              /*  nfrecs                                      */
        0,              /*  dirsize                                     */
        1,              /*  nheads                                      */
        0,              /*  format ** raw/cpm **                        */
        0L,             /*  number of hidden sectors  * M000A *         */
        0               /*  sys size                                    */
} ;

/***************************************************************************
*  mdbtry -
*       ptrs to mdbs to try to read disk with    
*/
GLOBAL  MDB     *mdbarray[] = { &mdb_fd , &mdb_fd, &mdb_f9 } ;

/***************************************************************************
*  xval -
*       store data rate value here for future use
*/
GLOBAL  BYTE    xval[FDMAXUNITS] ;


/***************************************************************************
*  xvaltry -
*       array of data rate values to try to read the disk with
*/
GLOBAL  BYTE    xvalarray[] = { H360 , DD360 , H12 } ;

/* DPBS :  IBM PC/AT 5 1/4" STANDARD,DEFAULT */

GLOBAL  UWORD onesdpb[] = {8,0x0703,0,155,63,0x00c0,16,1};
GLOBAL  UWORD twosdpb[] = {8,0x0f04,1,157,63,0x0080,16,1};

#if 0
 
 DPB                      		/*  disk parameter table */
 {
         UWORD   spt;            /*  sectors per track            */
         UBYTE   bsh;            /*  block shift factor           */
         UBYTE   blm;            /*  block mask                   */
         UBYTE   exm;            /*  extent mask                  */
         UBYTE   dpbdum;         /*  dummy byte for fill          */
         UWORD   dsm;            /*  max disk size in blocks      */
         UWORD   drm;            /*  max directory entries        */
         UWORD   dir_al;         /*  initial allocation for dir   */
         UWORD   cks;            /*  number dir sectors to checksum */
         UWORD   trk_off;        /*  track offset                 */
};

#endif

