/************************************************************************
 * ipdrv.h - Serial PORT Driver	HEADER file 
 *******************************************************************************
 * Copyright (c) 1987 Digital Research Inc.  All rights reserved.   {non-prop} *
 * The Software Code contained in this listing is copyrighted and may be used  *
 * and copied only under terms of the Digital Research Inc. End User License   *
 * Agreement.  This code may be used only by the registered user, and may not  *
 * be resold or transfered without the consent of Digital Research Inc.        *
 * Unauthorized reproduction, transfer, or use of this material may be a       *
 * criminal offense under Federal and/or State law.			       *
 *		U.S. GOVERNMENT RESTRICTED RIGHTS			       *
 * This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
 * or disclosure by the Government is subject to restrictions as set forth in  *
 * FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable        *
 * provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
 * (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
 * is Digital Research Inc. / 60 Garden Court / BOX DRI / Monterey, CA 93940.  *
 *******************************************************************************
 * Revision History:
 * Date   Author SPR #	Comments
 * 871218 mdf		added defines and copyright header
 ************************************************************************/

/************************************************************************
 * File: ipdrv.h
 *
 * Description: Serial PORT Driver HEADER file (Version 2.1)
 ************************************************************************/

/*----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   3/26/85 11:20 DR-K	shortened port_tbl to spec		*
 *   1.02   4/26/85 17:51 DR-K	define PTM_PARITY mask			*
 *   1.03   6/12/85 14:24 DR-K	delete DH and DPB use IO.H instead	*
 *   2.0    3/14/86 13:54 RFW   added CDSELECT struct for port driver   * 
 *   2.1    9/18/86 09:20 RFW	Defined PTx_TYPE,PTx_BAUD, PTx_MODE and *
 *				PTx_CTRL for setting the default values *
 *				of the PORT_TBL structure for each port.*
 *======================================================================*/

/************************************************************************/
/* NOTE: Change these values in order to Modify the default PORT TABLE  */
/* values. PTx_TYPE is set to a value from the Port Type Defines found  */
/* below. PTx_BAUD baud rate index for Port 0 and Port 1 is set by 	*/
/* indexing into BD Baud Rate Values defined below; such as define 	*/
/* PT0_BAUD to  PTB_1200 (7) is for 1200 baud. 				*/
/*									*/
/* The PTx_MODEs are set to a combination of the Port Mode Defines found*/
/* below. PTx_CTRL is set to a combination of the Port Control Defines  */
/* also found below.							*/
/************************************************************************/

/* Port 0 PORT_TBL default defines */
#define PT0_TYPE   PTT_SERIAL	/* Set the default TYPE of port for port 0 */
#define PT0_BAUD   PTB_9600	/* Set the default baud rate for port 0 */ 
				/* Set default MODE for port 0 */
#define PT0_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH 
				/* Set default PORT CONTROL for port 0*/
#define PT0_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS

/* Port 1 PORT_TBL default defines */
#define PT1_TYPE   PTT_SERIAL	/* Set the default TYPE of port for port 1 */
#define PT1_BAUD   PTB_9600	/* Set the default baud rate for port 1 */ 
				/* Set the default MODE for port 1 */
#define PT1_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH
				/* Set the default PORT CONTROL for port 1 */
#define PT1_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS

/**************************************************************************/

#define	ERROR		LONG	/* type of error code returns	*/
#define EMASK		LONG

#define E_IllUnitno	-1020

/****************************************************************/
/*  PORT Driver  dependent type definitions 			*/
/****************************************************************/


/************************************************************************
 *
 *  PORT_TBL structure 				(port Get/Set structure)
 *
 ************************************************************************/

#define	PORT_TBL	struct PortInfoTable
PORT_TBL
{
	WORD	pt_type ;		/*  type of port - see below	*/
	WORD	pt_state ;		/*  not used			*/
	BYTE	pt_baud ;		/*  see BD defines below	*/
	BYTE	pt_mode ;		/*  serial mode of operation	*/
	BYTE	pt_control ;
	BYTE	pt_1fill ;
} ;

/* port type field defines */

#define	PTT_UNDEFINED	0x00	/*  not used				*/
#define	PTT_SERIAL	0x01	/*  standard serial i/o device		*/
#define	PTT_CHAR	0x02	/*  character i/o dev			*/
#define	PTT_PARALLEL	0x04	/*  standard parallel port i/o device	*/


/* port state field defines */

#define PTS_RTS		0	/* ready to send character		*/
#define PTS_CHREC	1	/* character has been received		*/
#define PTS_DSRCH	2	/* change in DSR or CD			*/
#define PTS_PARERR	3	/* parity error				*/
#define PTS_OVRERR	4	/* overrun error			*/
#define PTS_FRMERR	5	/* framing error			*/
#define PTS_CD		6	/* character present			*/
#define PTS_DSR		7	/* DSR					*/ 


/* port baud rate field defines */

#define PTB_50		0	/* PTB_x, x = baud rate			*/
#define PTB_75		1
#define PTB_110		2
#define PTB_134_5	3	/* 134.5				*/
#define PTB_150		4
#define PTB_300		5
#define PTB_600		6
#define PTB_1200	7
#define PTB_1800	8
#define PTB_2000	9
#define PTB_2400	10
#define PTB_3600	11
#define PTB_4800	12
#define PTB_7200	13
#define PTB_9600	14
#define PTB_19200	15

/* port mode field defines */

#define	PTM_LENGTH		0x03		/* length sub-field	*/
#define		PTM_L5		0x00
#define		PTM_L6		0x01
#define		PTM_L7		0x02
#define		PTM_L8		0x03

#define	PTM_STOP		0x0c		/* stop bits sub-field	*/
#define		PTM_XSTOP	0x00		/* no stop bits		*/
#define		PTM_1STOP	0x04		/* 1 stop bit		*/
#define		PTM_12STOP	0x08		/* 1.5 stop bits	*/
#define		PTM_2STOP	0x0c		/* 2 stop bits		*/

#define PTM_PARITY	        0x30		/* parity sub-field	*/
#define		PTM_NOPAR	0x00		/* no parity		*/
#define 	PTM_ODDPAR	0x10		/* odd parity		*/
#define		PTM_PEVEN	0x20		/* even parity		*/

#define 	PTM_PENAB	0x10		/* old definition	*/

/* port control defines */

#define	PTC_DTR			0x01	/* rw: data term ready	   */
#define	PTC_RTS			0x02	/* rw: req to send	   */
#define	PTC_TXENAB	    	0x04	/* rw: 1 = enable transmit */
#define	PTC_RXENAB		0x08	/* rw: 1 = enable receive  */
#define	PTC_XONXOFF		0x10	/* rw: 1 = enable ^s^q log */
#define	PTC_DSR			0x20	/* r:  1 = data set ready  */
#define	PTC_DCD			0x40	/* r:  1 = dcd active	   */


/*  BD - Baud Rate values */

#define		BDINVALID	0x0000		/* index of baudtab[] */
#define		BD50		0x0900		/* 0 */    
#define		BD75		0x0600		/* 1 */
#define		BD110		0x0417		/* 2 */
#define		BD134		0x0359		/* 3 */
#define		BD150		0x0300		/* 4 */
#define		BD300		0x0180		/* 5 */
#define		BD600		0x00C0		/* 6 */
#define		BD1200		0x0060		/* 7 */
#define		BD1800		0x0040		/* 8 */
#define		BD2000		0x003A		/* 9 */
#define		BD2400		0x0030		/* 10 */
#define		BD3600		0x0020		/* 11 */
#define		BD4800		0x0018		/* 12 */
#define		BD7200		0x0010		/* 13 */
#define		BD9600		0x000C		/* 14 */
#define		BD19200		0x0006		/* 15 */


#define	CDSELECT   struct	SelectConDrvStruct
CDSELECT
{
	BYTE	unitno;		/* unit number 			*/
	BYTE	cdse_two;	/* unused			*/
	WORD	cdse_three;	/* unused			*/
	LONG	kbd_pin;	/* address of KEYBOARD ASR	*/
	LONG	m_pin;		/* address of MOUSE ASR		*/
	LONG	mbut_pin;	/* address of BUTTON ASR	*/
	LONG	PConId;		/* Physical Console Id		*/
};
