### FlexOS 286 System Makefile
### High C version
########################################################################
##                                                                    ##
##    Execute this Makefile from the directory where all FlexOS       ##
##    system source and object modules are located.                   ##
##                                                                    ##
##    This make file will create a "new" FLEXOS.SYS file everytime    ##
##    time it's executed.  Enter the command:                         ##
##                                                                    ##
##         MAKE -F FLEX286.MAK                                        ##
##                                                                    ##
########################################################################

########################################################################
##                                                                    ##
##    Compile time definitions.                                       ##
##                                                                    ##
########################################################################
HCPRO 	=  -pro system.pro -def

########################################################################
##                                                                    ##
##    Set the Code segments.                                          ##
##                                                                    ##
########################################################################
MKKERN 	=  $HCPRO kern
MKLOADER=  $HCPRO loader
MKPRM 	=  $HCPRO prm
MKCRM 	=  $HCPRO crm
MKCONF 	=  $HCPRO conf
MKMRM 	=  $HCPRO mrm
MKFS 	=  $HCPRO drm
MKFLOP 	=  $HCPRO floppy
MKGMAN	=  $HCPRO gman
MKSYS 	=  $HCPRO sys
MKPDRV 	=  $HCPRO pdrv
MKYDK	=  $HCPRO hdisk
MKFE	=  $HCPRO fe
MKOTHER =  $HCPRO other

########################################################################
##                                                                    ##
##    The following pseudo dependency (system) ensures this .MAK file ##
##    will always create the FlexOS 286 system image.                 ##
##                                                                    ##
########################################################################
system :	bootload.sys \
		disp286.obj config.obj aconfat.obj clock.obj clockat.obj

########################################################################
##                                                                    ##
##  .MAK files distributed with the System Builder's Kit              ##
##                                                                    ##
########################################################################
 make -f cnfglib.mak
 make -f hd.mak
 make -f sdrv.mak
 make -f rnetdrv.mak
 make -f mdrv.mak
 make -f ramdsk.mak
 make -f printint.mak

########################################################################
##                                                                    ##
##  .MAK files distributed with Machine Readable Source.              ##
##                                                                    ##
########################################################################
 +-if exist kernel.mak make -f kernel.mak
 +-if exist miscrm.mak make -f miscrm.mak
 +-if exist piperm.mak make -f piperm.mak
 +-if exist conrm.mak  make -f conrm.mak
 +-if exist diskrm.mak make -f diskrm.mak
 +-if exist giflib.mak make -f giflib.mak
 +-if exist aelib286.mak make -f aelib286.mak

########################################################################
##                                                                    ##
##  FlexOS system LINK and FIX step.                                  ##
##                                                                    ##
########################################################################
 link debug286[i]
 link boot286[i]
 fix bootprot.tmp flexos.sys
########################################################################
##                                                                    ##
##    End of pseudo dependency SYSTEM                                 ##
##                                                                    ##
########################################################################


#######################
# System loader....   #
#######################
bootload.sys :	bootload.obj
 link bootload.tmp = bootload.obj[data[max[0],origin[0]]
 fix bootload.tmp bootload.sys /r

bootload.obj :	sysbuild.equ bootload.a86
 rasm86 bootload $$pzsz286

#######################
# LINKED in OBJs..... #
#######################
disp286.obj :	sysbuild.equ struct.equ segs.equ system.equ \
		panic.equ \
		disp286.a86
 rasm86 disp286 $$pzszlo286

config.obj :	portab.h sysbuild.h system.h sup.h \
		dh.h flags.h struct.h baspag.h \
		panic.h protos.h \
		imc286.h config.h \
		config.c
 hc config $MKCONF

aconfat.obj :	sysbuild.equ struct.equ segs.equ panic.equ \
		aconfat.a86
 rasm86 aconfat $$pzsz286

clock.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h protos.h \
		clock.c
 hc clock $MKKERN

clockat.obj :	sysbuild.equ struct.equ system.equ \
		clockat.a86
 rasm86 clockat $$pzsz286

