/******************************************************************************
* CONSOLE.H - Data structures and definitions for Console Resource Manager
*******************************************************************************
* Copyright (c) 1987,1988 Digital Research Inc. All rights reserved.
* The Software Code contained in this listing is proprietary to Digital
* Research Inc., Monterey, California, and is covered by U.S. and other
* copyright protection. Unauthorized copying, adaption, distribution, use or
* display is prohibited and may be subject to civil and criminal penalties.
* Disclosure to others is prohibited. For the terms and conditions of software
* code use, refer to the appropriate Digital Research License Agreement.
*		U.S. GOVERNMENT RESTRICTED RIGHTS
* This software product is provided with RESTRICTED RIGHTS.  Use, duplication
* or disclosure by the Government is subject to restrictions as set forth in
* FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable
* provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)
* (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer
* is Digital Research Inc. / 60 Garden Court / BOX DRI / Monterey, CA 93940.
*******************************************************************************
* Revision History:
* Date   Author SPR #	Comments
*-----------------------------------------------------------------------------
* 880127 DR-K		Add new header and cleanup code
* 870507 KJ		added 4 words CT_crows, CT_ccols,
*			CT_charwidth, CT_cahrheight to CTE struc
*			and to PCONSOLE stuc and DRGET struc
* 861003 RFW		Added to the Mouse table mt_mkst,
*			mt_reser and mt_butt.
* 860604 mei		High C port: added #define PD. Console.h
*			now MUST precede vcb.h and struct.h.
* 860325 RFW		Added flag DRG_IGRAF
* 860320 RFW		defined MFORM structure
* 851101 RFW		define CDSPEC4 structure for special 4
* 851028 DR-K		define PCT_BITMAP as pc lookalike memory
* 850911 DR-K		undo 1.2  DISPON defined as okdisp()
* 850910 DR-K		define CP_VCORDER as 0x0800 for
*			copy calls to reorder VCs
* 850511 jor		Redefined DISPON macro, making it
*			call sdispon() directly.
* 850415 jor		Defined CURSMOV flag for Copy PB.
* 850326 jor		Original
*======================================================================*/

#define	EMASK	LONG
#define	ERROR	LONG

#define CNAMSIZ		10	/* byte length of pcon device name	*/
#define	OUTTIMER	100L	/* Millisecond Timeout for output	*/
#define BKTIMER		500L	/* Millesecond Timeout for B000 update	*/
#define BKCNT		10	/* Number of Timers before ending PCMODE*/
#define MMSKLEN		16	/* mouse mask data length 		*/
#define READ		1	/* iomode value indicating read echo    */
#define WRITE		2

#define NODISP indisp++;
#define DISPON okdisp();

/********************/
/*  SYSTEM TABLES   */
/********************/		

#define CONSOLE		struct con_table_struct 
#define	MOUSE		struct mouse_table_struct
#define PCONSOLE	struct pcon_table_struct
#define	VCONSOLE	struct vcon_table_struct

/********************/
/* LOCAL STRUCTURES */
/********************/

#define BUTTON		struct  button_struct
#define SQUARE		struct  square_struct	/* not really square, ... */
#define VSQUARE		struct  vsquare_struct
#define ALTBYT		struct  alterbytestruct
#define CFILNAM 	struct 	cfilnamstruct
#define	MFORM		struct  mouseformstruct

#define PD 	struct _pd

CONSOLE    		/* CONSOLE (screen and keyboard) system table	*/

{
	WORD	ct_kcnt;	/* count of keys in keyboard buffer	*/
	WORD	ct_smode;	/* screen mode				*/
	WORD	ct_kmode;	/* keyboard mode flags			*/
	WORD	ct_currow;	/* current cursor row position		*/
	WORD	ct_curcol;	/* current cursor column position	*/
	WORD	ct_nrows;	/* height in rows of virtual screen	*/
	WORD	ct_ncols;	/* width in columns of virtual screen	*/
	BYTE	ct_vcnum;	/* virtual console number		*/
	BYTE	ct_type;	/* type of console			*/
	BYTE	ct_name[CNAMSIZ]; /* physical console name		*/
};

MOUSE				/* MOUSE system table		*/

{
	WORD	mt_row;		/* current row position of mouse	*/
	WORD	mt_col;		/* current column position of mouse	*/
	BYTE    mt_mkst;	/* cntrl,alt,right + shift key states	*/
	BYTE	mt_reser;	/* currently unused so its reserved	*/
	WORD	mt_butt;	/* current mouse button state infor	*/
	WORD	mt_pixrow;	/* pixel rows/inch			*/
	WORD	mt_pixcol;	/* pixel cols/inch			*/
	WORD	mt_click;	/* click interval			*/
	BYTE	mt_height;	/* height of mouse form			*/
	BYTE	mt_width;	/* width of mouse form			*/
	WORD	mt_hotrow;	/* hot row of mouse form		*/
	WORD	mt_hotcol;	/* hot column of mouse form		*/
	WORD	mt_mask[MMSKLEN]; /* mouse mask plane/rect		*/
	WORD	mt_data[MMSKLEN]; /* mouse data plane/rect		*/
};
	/* PCONSOLE TABLE TYPE FLAGS */

#define	PCT_GRAF	0X0001		/* console type = graphic	*/
#define	PCT_NNKEY	0X0002		/* no numeric keypad		*/
#define	PCT_MOUSE	0X0004		/* mouse support		*/
#define	PCT_COLOR	0X0008		/* color screen			*/
#define	PCT_BITMAP 	0x0010		/* is a bit mapped memory video	*/

	/* PCONSOLE TABLE PLANE TYPE FLAGS	*/

#define	PCP_CHAR	0X01		/* character plane supported	*/
#define	PCP_ATTR	0X02		/* attribute plane supported	*/
#define	PCP_EXT		0X04		/* extension plane supported	*/


PCONSOLE		/* PCONSOLE system table 	*/

{
	BYTE	pc_name[CNAMSIZ]; /* console device name	*/
	BYTE	pc_nvc;		/* number of virtual consoles on this pcon */
	BYTE	pc_cid;		/* physical console id		*/
	WORD	pc_rows;	/* number of rows		*/
	WORD	pc_cols;	/* number of columns		*/
	WORD	pc_crows;	/* number of character rows	*/
	WORD	pc_ccols;	/* number of character columns	*/
	BYTE	pc_flags;	/* type of console		*/
	BYTE	pc_planes;	/* supported planes bit map	*/
	BYTE	pc_attrp;	/* supported attribute plane bits 	*/
	BYTE	pc_extp;	/* supported extension plane bits	*/
	WORD	pc_country;	/* country code			*/
	BYTE	pc_nfkeys;	/* number of function keys	*/
	BYTE	pc_butt;	/* number of mouse buttons 	*/
	LONG	pc_serial;	/* serial number of mouse	*/
	UWORD	pc_murow;	/* mouse mikeys per row		*/
	UWORD	pc_mucol;	/* mouse mikeys per col		*/
	UWORD	pc_charheight;	/* character cell height in dots*/
	UWORD	pc_charwidth;	/* character cell width in dots */
};


	/* 	VIRTUAL CONSOLE MODE FLAGS	*/

#define VTM_FREEZE	0X0001	/* freeze border during changes		*/
#define	VTM_AUTOOK	0X0002	/* allow auto view change		*/
#define	VTM_EDGECUR	0X0004	/* keep cursor on edge on auto view change */
#define	VTM_OUTAUTO	0X0008	/* auto view change on output		*/

	/* 	VIRTUAL CONSOLE TYPE FLAGS	*/

#define	VTT_GRAF	0X0001	/* graphic type console			*/


VCONSOLE		/* VIRTUAL CONSOLE system table		*/

{
	LONG	vc_key;		/* key field for lookup			*/
	WORD	vc_mode;	/* mode of virtual console		*/
	BYTE	vc_vcnum;	/* number of virtual console		*/
	BYTE	vc_type;	/* type of virtual console		*/
	WORD	vc_vrow;	/* origin of view within window of vscreen */
	WORD	vc_vcol;	/*  in rows and columns			*/
	WORD	vc_nrow;	/* window height in rows		*/
	WORD	vc_ncol;	/* window width in columns		*/
/* 10 */
	WORD	vc_posrow;	/* row position of window on parent vc	*/
	WORD	vc_poscol;	/* col. position of window on parent vc	*/
	WORD	vc_rows;	/* height of virtual console in rows	*/
	WORD	vc_cols;	/* width of virtual console in columns	*/
	BYTE	vc_top;		/* height of top border in characters	*/
	BYTE	vc_bot;		/* height of bottom border in characters */
	BYTE	vc_left;	/* width of left border in characters	*/
	BYTE	vc_right;	/* width of right border in characters	*/
};



MFORM
{				/* mouse form default is a arrow RFW */
	WORD 	mmask[MMSKLEN];
	WORD	mform[MMSKLEN];
};



/************************************************************************/
/*	DRIVER RETURN DATA STRUCTURES					*/
/************************************************************************/

#define DRGET		struct  drvrgetstruct

/* FLAGS for driver GET flags byte */

#define	DRG_GRAF	0x01	/* graphic pcon			*/
#define DRG_NOKP	0x02	/* no numerical keypad		*/
#define DRG_MOUSE	0x04	/* mouse support		*/
#define	DRG_COLOR	0x08	/* color console		*/
#define DRG_IGRAF	0x20	/* 0=not in graphics mode 1=in  */
				/* graphics mode		*/
DRGET
{
        UWORD   dg_rows         ;/* number of pixel rows                */
        UWORD   dg_cols         ;/* number of pixel columns             */
        UWORD   dg_crows        ;/* number of character rows            */
        UWORD   dg_ccols        ;/* number of character columns         */
	UBYTE	dg_flags;	/* type of console			*/
	UBYTE	dg_planes;	/* supported planes bit map		*/
	UBYTE	dg_attrp;	/* supported attribute plane bits 	*/
	UBYTE	dg_extp;	/* supported extension plane bits	*/
	UWORD 	dg_country;	/* country code				*/
	UBYTE	dg_nfkeys;	/* number of function keys		*/
	UBYTE	dg_butt;	/* number of mouse buttons 		*/
	LONG	dg_serial;	/* serial number of mouse		*/
	UWORD	dg_mrow;	/* mouse row units per inch		*/
	UWORD	dg_mcol;	/* mouse col units per inch		*/
	UWORD	dg_charheight;  /* character cell heigh in dots		*/
 	UWORD	dg_charwidth;	/* character cell width in dots		*/
	UWORD	(*dg_cto16) (); /* address of 8/16-bit char. conv. rtn	*/
	BYTE	(*dg_cto8) ();	/* address of 16/8 bit char. conv. rtn	*/
 
/*	Note: dg_flags, planes, attrp and extp bit fields are mapped ident- */
/*      ically to those in the PCONSOLE table				    */
};

/************************************************************************
*	DRIVER ENTRY POINT PARAMETER BLOCK STRUCTURES			*
*************************************************************************/

#define CDSELECT	struct 	condrvselstruct
#define	CDFLUSH		struct  condrvflustruct
#define	CDSPEC0		struct  spec0struct
#define	CDSPEC1		struct  spec1struct
#define CDSPEC3		struct	spec3struct
#define CDSPEC4		struct  spec4struct
#define CDGET		struct  cdrvgetstruct
#define CDSET		struct	cdrvsetstruct

CDSELECT
{
	BYTE	cdse_unit;	/* unit number 			*/
	BYTE	cdse_two;	/* unused			*/
	WORD	cdse_three;	/* unused			*/
	LONG	cdse_kbd;	/* address of KEYBOARD ASR	*/
	LONG	cdse_mouse;	/* address of MOUSE ASR		*/
	LONG	cdse_but;	/* address of BUTTON ASR	*/
	LONG	cdse_pconid;	/* DLE Address			*/
};

CDFLUSH
{
	BYTE	cdf_unit;	/* unit number			*/
	BYTE	cdf_nothing;	/* unused			*/
};

/*  Console Driver Special Function flags */

#define CDS_GRAF	0x0001	/* vcon(or border) to be created is 	*/
				/* bit mapped				*/

CDSPEC0
{
	BYTE	cds0_unit;	/* unit number			*/
	BYTE	cds0_subf;	/* subfunction # - 0 = create, 1 = delete  */
	WORD	cds0_flags;	/* flags - bit 0 : 1 = bit map, 0 = char.  */
	WORD	cds0_nrows;	/* # of rows in VFRAME		*/
	WORD	cds0_ncols;	/* # of cols in VFRAME		*/
};

CDSPEC1
{
	BYTE	cds1_unit;	/* unit number			*/
	BYTE	cds1_subf;	/* subfunction # - 0 = create, 1 = delete  */
	WORD	cds1_three;	/* unused			*/
	LONG	cds1_vcid;	/* id of vcon to be deleted 	*/
};

#define V2PCFRAME	2
#define PC2VFRAME	3

CDSPEC3
{
	BYTE	cds3_unit;	/* unit number			*/
	BYTE	cds3_subf;	/* function & - 2=V2PCFRAME, 3=PC2VFRAME */
	UWORD	cds3_flags;
	LONG	cds3_vcid;	/* Id of vcon to convert	*/
};

CDSPEC4
{
	BYTE 	cds4_unit;	/* unit number */
	BYTE	cds4_subf;	/* function 4 change virtual console and 
				   screen mode */
	UWORD   cds4_flags;	/* Graphic Color and FULLTOP */
	UWORD	cds4_rows;	/* # of rows */
	UWORD	cds4_cols;	/* # of cols */
	LONG	cds4_vcid;	/* ID of the vcblk to convert */ 
        WORD    cds4_mode ;
};

CDGET
{
	UBYTE	cdg_unit;	/* unit number		*/
	UBYTE	cdg_two;	/* unused		*/
	UWORD	cdg_flags;	
	LONG	cdg_four;	/* unused		*/
	PD	*cdg_pd;	/* address of process descriptor of process
				 * owning BUFFER	*/
	BYTE	*cdg_buffer;	/* address of table-formatted buffer	*/
	LONG	cdg_bufsize;	/* buffer size in bytes	*/
};

CDSET
{
	UBYTE	cds_unit;	/* unit number		*/
	UBYTE	cds_two;	/* unused		*/
	UWORD	cds_flags;	
	LONG	cds_four;	/* unused		*/
	PD	*cds_pd;	/* address of process descriptor of process
				 * owning BUFFER	*/
	BYTE	*cds_buffer;	/* address of table-formatted buffer	*/
	LONG	cds_bufsize;	/* buffer size in bytes	*/
};

#define	CDCOPALT	struct _cdcopalt
#define	CDWRITE		struct _cdwrite

	/* DRIVER COPY/ALTER FLAGS */ 

#define CURSMOV	0x1000		/* flag marking copy call as a call to move */
				/*   move cursor, nothing more		    */
#define CP_VCORDER 0X0800	/* flag marking this copy call as a call to */
				/*   re-order which is top virtual console  */
CDCOPALT
{
	BYTE	cdc_unit;	/* unit number			*/
	BYTE	cdc_opt;	/* options			*/
	UWORD	cdc_flags;	/* you guessed it		*/
	UWORD	cdc_crow;	/* current cursor row for this vframe */ 
	UWORD	cdc_ccol;	/* current cursor column for this vframe */
	LONG	cdc_pd;		/* pd address of process owning UFRAME	*/
	LONG	cdc_dfram;	/* address of destination frame	*/
	LONG	cdc_drect;	/* address of destination rectangle	*/
	LONG	cdc_sfram;	/* address of source frame	*/
	LONG	cdc_srect;	/* address of source rect       */
};
 
			

	/* CONSOLE DRIVER WRITE FLAGS */

#define CW_PWRITE 	0x4000	/* This VC is Full Screen on Top */
#define CW_UPDIRT 	0x2000	/* This is dirty rectangle update */
#define CW_TOPVF 	0x0080	/* VFRAME in question is on top  */

CDWRITE
{
	BYTE	cdw_unit;	/* unit number			*/
	BYTE	cdw_two;	/* unused			*/
	UWORD	cdw_flags;
	LONG	cdw_vcid;	/* vcon id # - 0 if PFRAME	*/
	LONG	cdw_pd;		/* ptr to PD of process owning BUFFER */
	LONG	cdw_buffer;	/* ptr to character buffer	*/
	LONG	cdw_bufsiz;	/* buffer size in bytes		*/
	UWORD	cdw_row;	/* row position for start of write */
	UWORD	cdw_col;	/* column position for start of write	*/
	LONG	cdw_dirty;	/* ptr to structure containing new cursor
				 * position and info on Dirty region	*/
};


#define CTE     struct  conTablestruct
CTE
{
        UWORD   CT_rows         ;/* number of pixel rows                */
        UWORD   CT_cols         ;/* number of pixel columns             */
        UWORD   CT_crows        ;/* number of character rows            */
        UWORD   CT_ccols        ;/* number of character columns         */
        BYTE    CT_flags        ;/* flags                               */
        BYTE    CT_planes       ;/* planes being supported              */
        BYTE    CT_attrp        ;/* attribute plane bits supported      */
        BYTE    CT_extp         ;/* extension plane bits supported      */
        UWORD   CT_country      ;/* country code number                 */
        BYTE    CT_nfkys        ;/* number of function keys             */
        BYTE    CT_buttons      ;/* number of mouse buttons             */
        LONG    CT_serial       ;/* serial number of the mouse          */
        UWORD   CT_murow        ;/* mouse row units per inch            */
        UWORD   CT_mucol        ;/* mouse column units per inch         */
	UWORD	CT_charheight   ;/* character cell heigh in dots        */
 	UWORD	CT_charwidth	;/* character cell width in pixel	*/
        UWORD   (*CT_conv8)()	;/* ptr to 8 to 16 char convert routine */
        UWORD   (*CT_conv16)()	;/* ptr to 16 to 8 char convert routine */
        LONG    CT_pcframe      ;/* ptr to PC char map if available     */
} ;

/******************************************************************************
* End of FILENAME.C
******************************************************************************/
