/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/
/*===============================================================*
 *   Version 1.3        SYS.C	                      		 *
 *                      Main shell for system transfer utility   *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *	1.4   08/27/87  ldt	Jumpbuff fix on error detection. *
 *      1.3   08/04/87  ldt	Prototyped.                      *
 *	1.2    5/09/86	DR-K	modified for MetaWare compiler	 *
 *	1.1   08/06/85	jsr	Added CRLF, DOSERR and 68K stuff.*
 *	1.0   03/22/85  jsr	                                 *
 *                                                               *
 *===============================================================*/
/*****************************************************************/
/* INCLUDES :  	   						 */
/*****************************************************************/
#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"berror.h"
#include	"libproto.h"
/*****************************************************************/
/* DEFINES : 	   						 */
/*****************************************************************/
#define	XFERROFF	1		     /* xfersys() errors */
#define	SDERROFF	27		      /* setdev() errors */
/*****************************************************************/
/* EXTERNALS : 	   						 */
/*****************************************************************/
/* CCMSGS.L86							 */
EXTERN	BYTE	nullstr[], crlfmsg[], defname[];
EXTERN	BYTE	devdelim,  *nullmsg[];
EXTERN	BYTE	*cc0413[], *cc0430[], *cc0431[];
EXTERN	BYTE	cc0440[],  cc0443[],  cc0446[];
EXTERN	BYTE	cc0450[],  cc0455[],  cc0490[],  *cc0500[];
EXTERN	BYTE	*cc0810[], *cc0811[], *cc0812[], *cc0813[];
/* SYSMSGS.C */
EXTERN	BYTE	sy0000[], sy0002[];
/*****************************************************************/
/* EXTERN FUNCTIONS PROTOTYPED :				 */
/*****************************************************************/
WORD	utxfrsys ( BYTE *dd, BYTE *sd, BYTE *sf, struct _mcb *mp );
/*****************************************************************/
/* LOCAL FUNCTIONS PROTOTYPED :					 */
/*****************************************************************/
LONG	utlmain ( BYTE *rawtail );
VOID	sysinit ( BYTE *tail );
VOID	syserrhnd ( WORD uc, WORD df, LONG rcl );
/*****************************************************************/
/* GLOBALS :							 */
/*****************************************************************/
BYTE		sysldd[DEVMAX];	     /* logical dest device name */
BYTE		syslsd[DEVMAX];	   /* logical source device name */
BYTE		syssf[SPECMAX];		     /* system file spec */
MCB		sysmcb;			/* Message Control Block */
jumpbuff	sysjbf;	  /* error bailout transfer control info */
/*****************************************************************/
/* Start of Code :						 */
/*****************************************************************/
LONG	utlmain ( BYTE *rawtail )
{
    BYTE	tail[BUFSIZ];

    if( (sysmcb.retcode = utstjmp(sysjbf)) !=0)	     /* set error abort info */
    {
	uterrmsg(&sysmcb, STDERR, FATAL);
	goto bailout;
    }

    utt1(rawtail, tail);				  /* discard garbage */
    sysinit(tail);		/* parse command tail and perform main setup */

    if( (sysmcb.utilcode = utxfrsys(sysldd,syslsd,syssf,&sysmcb)) !=0)
	syserrhnd((sysmcb.utilcode+XFERROFF), sysmcb.dosfunc, sysmcb.retcode);

    sysmcb.retcode = UR_SUCCESS;

bailout:
    s_write(WRF_END, STDOUT, crlfmsg, utslen(crlfmsg), 0L);

    if(sysmcb.retcode < 0)
	sysmcb.retcode = (UR_SOURCE | UR_DOSERR);

    return(sysmcb.retcode);
}

/* sysinit() : initialize variables etc, and parse command tail */
VOID	sysinit ( BYTE *tail )
{
    BYTE	*ptr;
    DEFINE	ldef;

							   /* set up the MCB */
    utintmcb(&sysmcb,sy0000,nullstr,nullstr,nullstr,nullstr);
					    /* get "default:" logical device */
    if((sysmcb.retcode =
      utgtdf(defname, &ldef, GDLITR, &sysmcb)) < 1)
	    syserrhnd(UTER01, sysmcb.dosfunc, sysmcb.retcode);

    ptr = (BYTE *)(ldef.def_prefix + utslen(ldef.def_prefix));
    while((ptr > ldef.def_prefix) && (*ptr != devdelim))
	--ptr;
    *++ptr = NULL;

					  /* parse the DEST device from tail */
    ptr = utstdv(tail, sysldd, ldef.def_prefix, MANDATORY, &sysmcb);
    if(sysmcb.utilcode)
	syserrhnd((sysmcb.utilcode + SDERROFF), 0, (UR_SOURCE | UR_PARM));
			       /* parse the SOURCE device from tail (if any) */
    ptr = utstdv(utskpwht(ptr), syslsd, ldef.def_prefix, OPTIONAL, &sysmcb);
    if(sysmcb.utilcode)
	syserrhnd((sysmcb.utilcode + SDERROFF), 0, (UR_SOURCE | UR_PARM));
					       /* set up the SOURCE filespec */
    syssf[0] = NULL;
    if(*ptr)
	strcat(syssf, ptr);			       /* use any given name */
}

/* syserrhnd() : fatal error handler (message formation) */
VOID	syserrhnd ( WORD uc, WORD df, LONG rcl )
{
    REG	WORD	code;

    switch(uc)
    {
	case UTER10:
	case UTER11:
	case UTER12:
	case UTER16:
	case UTER17:
	case UTER18:
	case UTER19:
	case UTER22:
	case UTER28:
	case UTER29:
	    code = UE_DEVONLY;
	    break;

	default:
	    code = UE_DEVFIL;
	    break;
    }

    sysmcb.pptr[PARM8] = cc0500[HLVL3];

    switch(df)
    {
	case 0:
	    switch(uc)
	    {
		case UTER04:			     /* sysfile format error */
		    utstmcb(&sysmcb, cc0810, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case UTER07:
		    utstmcb(&sysmcb, cc0413, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case UTER09:
		    sysmcb.pptr[PARM6] = cc0443;
		    sysmcb.pptr[PARM7] = cc0455;
		    sysmcb.pptr[PARM5] = cc0430[HLVL3];
		    utstmcb(&sysmcb, cc0430, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case UTER12:
		    sysmcb.pptr[PARM5] = cc0811[HLVL3];
		    utstmcb(&sysmcb, cc0811, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case UTER21:
		    sysmcb.pptr[PARM6] = cc0490;
		    sysmcb.pptr[PARM5] = cc0812[HLVL3];
		    utstmcb(&sysmcb, cc0812, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case UTER22:
		    sysmcb.pptr[PARM5] = cc0813[HLVL3];
		    utstmcb(&sysmcb, cc0813, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case UTER28:
		    sysmcb.pptr[PARM6] = cc0440;
		    sysmcb.pptr[PARM7] = cc0450;
		    sysmcb.pptr[PARM5] = cc0430[HLVL3];
		    utstmcb(&sysmcb, cc0430, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case UTER29:
		    sysmcb.pptr[PARM6] = cc0446;
		    sysmcb.pptr[PARM7] = sy0002;
		    sysmcb.pptr[PARM5] = cc0431[HLVL3];
		    utstmcb(&sysmcb, cc0431, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		default:
		    utstmcb(&sysmcb, nullmsg, uc, df, (UR_SOURCE|UR_INTERNAL));
		    break;

	    }
	    break;

	case S_GET:
	case S_LOOKUP:
	    utegtlk(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_SET:
	    uteset(&sysmcb);
	    break;

	case S_OPEN:
	case S_CREATE:
	    utecrop(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_READ:
	case S_WRITE:
	    uterw(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_MALLOC:
	    utemaloc(&sysmcb);
	    break;

	case S_MFREE:
	    utemfree(&sysmcb);
	    break;

	default:
	    utstmcb(&sysmcb, nullmsg, uc, df, (UR_SOURCE | UR_INTERNAL));
	    break;
    }
    utfarjmp(sysjbf, (WORD)rcl);
}
/* */
