/*#######################################################################
#									#
#				NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/

/*#######################################################################
#									#
#  Filename:  PIGLOBAL.H						#
#									#
#   Purpose:  Contains "GLOBAL" defines used throughout the Primitive	#
#	      library.							#
#									#
#  Routines:  None							#
#									#
#  Maintenance Log:							#
#									#
#  Ver	Date	  Who  SPR/APR	Change/Comments				#
#  ---	--------  ---  -------	--------------------------------------	#
#  1.0	10/06/87  DS	 N/A	Created.				#
#  1.1	10/30/87  All	 N/A	program-specific def's.			#
#  1.2	11/04/87  WeD	 N/A	More define changes.			#
#  1.3	11/05/87  WeD	 N/A	Fixed PREAD_ONLY/PLOGICAL_LOCK mixup.	#
#  1.4	11/11/87  WeD	 N/A	Fixed BIT16 mis-definition		#
#  1.5	11/13/87  WeD	 N/A	Integrated new CHKDSK definitions.	#
#  1.6	11/13/87  WeD	 N/A	Fixed SIGNATURE definition.		#
#  1.7	11/14/87  WeD	 N/A	Added picode03 defines.			#
#  1.8	11/23/87  WeD	 N/A	Added picode01 & format defines.	#
#  1.9	11/30/87  WeD	 N/A	Fixed ACTIVE definition.		#
#  2.0	12/02/87  WeD	 N/A	Fixed MEG_* definitions.		#
#  2.1	02/22/88  ldt	 N/A	Added IBM_FDISK define for 'W' command  #
#                               line switch.             		#
#                                                                       #
#######################################################################*/

/*#######################################################################
#									#
#  Included Files:  None						#
#									#
#######################################################################*/

/*#######################################################################
#									#
#  Global Definitions							#
#									#
#######################################################################*/

#define PREAD_OP		    0
#define PWRITE_OP		    1

#define ENTRY_SIZE		   32

#define LEN_FILENAME		   11
#define LEN_DRIVENAME		   11

#define NUM_PARTITION_ENTRY	    4

#define PPHYSICAL_LOCK		    0
#define PLOGICAL_LOCK		    1
#define PLOGICAL_FORMAT_LOCK	    2

#define PREAD_ONLY		    0
#define PREAD_WRITE		    1

#define NUM_PART_INMBR		    4

#define CACHE			    0
#define BUFFER			    1

#define ROOTDIR			    0
#define SUBDIR			    1

#define BIT12			    1
#define BIT16			    2  /* used for MDB */
#define BIT_16			    4  /* used for MBR */
#define BIT_16L                     6  /* used for MBR 16 bit fat large size entry */

/*
    PScreenObject direction flags
*/

#define INPUT	  0
#define OUTPUT	  1

/*
    Specific FAT values.
*/

#define  MIN_FAT_VALUE	  0x0002	/* Valid FAT entries:	0x0002-0xFFEF */
#define  MAX_FAT_VALUE	  0xFFEF
#define  RESERVED_CLUSTER 0xFFF0	/* Reserved values:	0xFFF0-0xFFF6 */
#define  BAD_CLUSTER	  0xFFF7	/* Bad cluster value:	0xFFF7	      */
#define  ENDING_CLUSTER   0xFFF8	/* End of chain value:	0xFFF8-0xFFFF */

/*
    Directory Entry Types.
*/

#define  ROOT_DIRECTORY   0
#define  SUB_DIRECTORY	  1
#define  DATA_FILE	  2
#define  VOLUME_LABEL	  4

/*
    Directory Entry Attributes
*/

#define  READ_ONLY_MASK     0x0001
#define  HIDDEN_FILE_MASK   0x0002
#define  SYSTEM_FILE_MASK   0x0004
#define  VOLUME_LABEL_MASK  0x0008
#define  SUBDIRECTORY_MASK  0x0010
#define  ARCHIVE_MASK	    0x0020
#define  RESERVED6_MASK     0x0040
#define  RESERVED7_MASK     0x0080
#define  SECURITY_MASK	    0x0100
#define  NAME_CASE_MASK     0x0200

/*
   Directory Entry File Name Flags
*/

#define  UNUSED_FLAG	    0x00
#define  ALIAS_FLAG	    0x2E
#define  ERASED_FLAG	    0xE5

/*
    Error Entry Flags for PGetErrorEntry() routine.
*/

#define  LAST_ENTRY	   -1
#define  FIRST_ENTRY	    0
#define  NEW_ENTRY	    1

/*
    Error Kinds.
*/

#define  MISSING_END	    0
#define  WRONG_SIZE	    1
#define  CROSS_LINK	    2
#define  LOST_CHAIN	    3
#define  ZERO_LENGTH	    4


/* DriveLock Constants */

#define LOOKUP_FLAGS  0
#define LOOKUP_SIZE   142
#define LOOKUP_KEY    0
#define GET_MDB       11
#define FAIL	      1
#define OPEN_FLAG     0x200E
#define NEW_MDB       1
#define RAW_MEDIA     0x430b
#define FROM_DISK     0x210000L
#define DISK_DRIVER   0x20
#define OPEN_FOR_MDB  OPEN_FLAG | OPF_SHAR
#define HARD_DISK_FAT_ID  0xf8
#define DEV_INFO      0x45		/* Device information table	    */


/* GetDefaultDrive Constants */

#define LOOKUP_NOT_FOUND  0


/* ReadLogical Constants */

#define READ_LOGICAL_FLAGS	0x0001
#define READ_VERIFY_FLAGS	0x0005
#define RDF_BEG			0x0000		/* Offset rel. to beginning */


/* ReadPhysical Constants */

#define READ_PHYSICAL_FLAGS  0


/* WriteLogical Constants */

#define WRITE_LOGICAL_FLAGS  0


/* WritePhysical Constants */

#define WRITE_PHYSICAL_FLAGS  0


/* ZeroLogicalSector Constants */

#define MAX_MALLOC_SIZE  0x8000

/*
    Get/Set/Lookup table numbers.
*/

#define T_CON		  0x30
#define T_MEM		  0x03
#define T_DISKFILE	  0x20

/*
    Misc.
*/

#define  ESC		  0x1B
#define  SECTOR_ONE	     1

#define  ACTIVE		  0x80
#define  INACTIVE	    00

#define  ESCAPE_CHARACTER   27
#define  BELL_CHARACTER      7
#define  NEW_LINE	    10
#define  AT_SIGN	    64

#define  EIGHT_BIT	     8
#define  SIXTEEN_BIT	    16

#define  GET_LIT_PROCDEF	0x4002
#define  GET_LIT_SYSDEF		0x4003

#define  F_SMODE_ESC		0x0001
#define  F_SMODE_16BIT		0x0002

#define  F_KMODE_INPUT		0x002B
#define  F_KMODE_CRLF		0x0100

#define  PPROTECTION		0x0888
#define  PREAD_FLAG		0x0100


/*#######################################################################
#									#
#  FDISK-specific Definitions						#
#									#
#######################################################################*/

#define IBM_FDISK                 0       /* This switch if true enables  */
                                          /* 'W' command line option.     */
                                          
#define BUG11			  2000L
#define BUG12			  2001L
#define BUG13			  2002L
#define BADDISK			  2003L
#define BADMBR			  2004L
#define NOGAP			  2005L
#define NO32MEGPARTITION	  2006L
#define PARTALREADYACTIVE	  2007L
#define ILLEGALOPTIONDATA1	  2008L
#define ILLEGALOPTIONDATA2	  2009L
#define NOSUCHGAPEXIST		  2010L
#define NOSUCHPARTITIONEXIST	  2011L
#define NOTENOUGHMEMORY		  2012L
#define DELETEORDERERROR	  2013L
#define ILLEGALACTOPTION	  2014L
#define NOPRIMEPART		  2015L
#define BADOPTION		  2016L
#define NOEMPTYSLOTS              2017L
#define NOPARTONDISK              2018L
#define NOFOREIGNDEL              2019L

#define DONE			  0x1B
#define CREATE			     1
#define ACTIVATE		     2
#define DELETE			     3
#define DISPLAY			     4
#define NEXT                         5

#define ALL32MEG		     1
#define USERSIZE		     2
#define RANDOMSIZE		     3

#define ON			     1
#define OFF			     0

#define NONE			     0

#define HEAD_ZERO		     0
#define HEAD_THREE		     3
#define SECTOR_ZERO		     0
#define SECTOR_ONE		     1
#define CYLINDER_ZERO		     0

#define SIGNATURE		0xAA55

#define CASE0			     0
#define CASE1			     1
#define CASE2			     2
#define CASE3			     3
#define CASE4			     4

#define BEGINNING		     1
#define STARTADDR		     2
#define ENDADDR			     3
#define LAST			     4

#define GOOD_TRACK		     0
#define BAD_TRACK		     1

#define ASSIGN			     0

#define FOUR_SECTORS_PER_CLUSTER     4
#define EIGHT_SECTORS_PER_CLUSTER    8
#define SIXTEEN_SECTORS_PER_CLUSTER 16

#define MEG_1		(1L*1024*1024)
#define FIXDISK        (16L*1024*1024)
#define MEG_32	       (32L*1024*1024)
#define MEG_64         (64L*1024*1024)
#define MEG_128       (128L*1024*1024)
#define MEG_512       (512L*1024*1024)

#define DEFAULT_CLUSTER_SIZE	     0

#define SEGMENT_SIZE		0xffff

#define LOWER_BYTE		0x00FF
#define UPPER_BYTE		0xFF00
#define SIX_BITS		     6

#define DRIVE_NAME		     0
#define C_OPTION		     1
#define A_OPTION		     2
#define D_OPTION		     3
#define I_OPTION		     4
#define N_OPTION		     5
#define S_OPTION		     6
#define E_OPTION		     7
#define H_OPTION		     8
#define W_OPTION                     9

#define OSBOOT_REC_SIZE		     1 /* in sector */

#define EXTPARTITION		    05

#define NOT_FOUND		    -1

#define MAX_MBR_SLOTS		     4

#define DEBUG			     0

#define NUMBER_FATS		     2

#define NUMBER_ROOTDIR_ENTRY	   512

#define HARD_DISK		  0xF8

#define ALLMBR			     0
#define FOURMBR			     1

/*#######################################################################
#									#
#  PICODE01-specific Definitions					#
#									#
#######################################################################*/

#define OPEN_EXCLUSIVE		0x200F
#define OPEN_SHARED		0x2018

#define DISK_NONREMOVABLE	0x020
#define DISK_PARTITIONABLE	0x100


/*#######################################################################
#									#
#  PICODE02-specific Definitions					#
#									#
#######################################################################*/

#define BUG1		     1000
#define BUG2		     1001
#define BUG3		     1002
#define BUG4		     1003

#define BOOTUP			0
#define NOT_BOOTUP		1

#define BIT12MASK	   0x01ff
#define BIT16MASK	   0x00ff
#define BIT12SHIFT		9
#define BIT16SHIFT		8

#define EVEN_ODD	   0x0001

#define MAX_BYTE_INSEG	   0xffff
#define MAX_SEG_SIZE	  0x10000L

#define SHIFT1			1
#define SHIFT4			4

#define NEXTSEG		   0x7fff

#define ODD			1
#define EVEN			0

#define VALUE_MASK	   0x0fff
#define VALUE_SHIFT	   0xf000

#define UNINIT			0
#define INIT			1

#define NUM_SECTOR_INBUF	2

#define BIT12_END_OF_FILE  0x0fff
#define BIT16_END_OF_FILE  0xffff


/*#######################################################################
#									#
#  PICODE03-specific Definitions					#
#									#
#######################################################################*/

#define  STR_NORMAL		0x0000
#define  STR_DEFAULT_VALUE	0x0001
#define  STR_DIGITS_ONLY	0x0002


/*#######################################################################
#									#
#  CHKDSK-specific Definitions						#
#									#
#######################################################################*/

#define FILE_PROTECTION  0x0FFF

#define DIGEST_UNALLOCATED	0x01
#define DIGEST_REFERENCED	0x02
#define DIGEST_CROSSREFERENCED	0x04
#define DIGEST_USED		0x08
#define DIGEST_COUNTED		0x10

#define DIRCHAIN_MODE		0
#define LOSTCHAIN_MODE		DIGEST_USED
#define COUNTCHAIN_MODE		DIGEST_COUNTED
#define COUNTGAP_MODE		-1

#define FIRST_CLUSTER_ERROR	1
#define FAT_WRITE_ERROR		2
#define NEED_TO_CONVERT_DIR	3

#define COUNT_CHAINS		0
#define CREATE_FILES		1
#define FREE_CLUSTERS		2


/*#######################################################################
#									#
#  FORMAT-specific Definitions						#
#									#
#######################################################################*/

#define HARD_DISK_TYPE	 0
#define DISKETTE_TYPE	 1
#define UNFORMATTED_TYPE 2

#define OS_BOOT_REC_SIZE 1	  /* Length of OS Boot Record in sectors.*/
#define FIRST_SECTOR	 0L
#define DIR_ENTRY_LENGTH 32	  /* Number of bytes per directory entry.*/
#define BOOT_FILE_INDEX  0
#define SYS_FILE_INDEX	 1


/* Format Command Line Options */
#define OPTION_B	 1	  /* -B Copies the boot loader.*/
#define OPTION_P	 2	  /* -P Display floppy format menu.*/
#define OPTION_S	 3	  /* -S Copies the OS.*/
#define OPTION_V	 4	  /* -V Prompt for volume label.*/
#define OPTION_1	 5	  /* -1 Single-sided floppy.*/
#define OPTION_8	 6	  /* -8 Eight sector format for floppy.*/
#define OPTION_C	 7	  /* -C Defines sectors per cluster.*/
#define OPTION_R	 8	  /* -R104 (Rodger, 10-4) -- no confirmations.*/

/* Media Descriptions */
#define H12		 0
#define H360		 1
#define DD360		 2
#define FDMAXUNITS	 2
#define HYPERDRIVE(x)	( xval[x] != DD360 )


/* Special Functions */
#define SPF_INITF	0x48		/* Initialize format */
#define SPF_FMTRK	0x83		/* Format track */


/* Misc */
#define VOLUME_ATTRIBUTES  0x8		/* File attributes.*/
#define SYSTEM_ENTRY	   0L		/* Dir entry for the system file.*/
#define BOOT_ENTRY	   1L		/* Dir entry for the boot load file.*/
#define VOLUME_ENTRY	   2L		/* Dir entry to put the name.*/
#define SPACE		   0x20		/* One space or blank character.*/
#define DELETED_FILE	   0xE5		/* Specify file not in use.*/

#define MAX_P_VALUE  8

#define MAX_CLUSTER_SIZE  128

#define FILL_CHAR    0xF9
#define FMT_DENSITY  1

/*#######################################################################
#									#
#  END of program-specific Definitions					#
#									#
#######################################################################*/

/*#######################################################################
#									#
#				NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/
