/*#######################################################################
#                                                                       #
#                            NOTICE:                                    #
#                                                                       #
#    The source code contained in this listing is a proprietary trade   #
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and    #
#    is also subject to copyright protection as an unpublished work     #
#    pursuant to Section 104(a) of Title 17 of the United States Code.  #
#    Unauthorized copying, adaptation, distribution, use or display is  #
#    prohitibed by law and may be subject to civil and criminal         #
#    penalties.                                                         #
#                                                                       #
#######################################################################*/

/*#######################################################################
#                                                                       #
#  Filename:  FDSCREEN.C                                                # 
#                                                                       # 
#   Purpose:  Defines the various menu items used by the Format Utility.#
#                                                                       #
#  Routines:  None - Data Only.                                         # 
#                                                                       #  
#  Maintenance Log                                                      #
#                                                                       #
#  Version No.   Date   Initials   SPR/APR No.   Change/Comments        #
#  -----------   ----   ---------  -----------   ---------------        #
#    1.0       09/18/87    DS         N/A        Created.               # 
#    1.1        1/25/88   jmb                    Put strings in FDMSGS.C#
#                                                                       #
#######################################################################*/

/*#######################################################################
#                                                                       #
#  Included Files:                                                      #
#                                                                       #
#######################################################################*/
#include <portab.h>
#include "pistruct.h"

/*#######################################################################
#                                                                       #
#  Extern static strings, defined and allocated in FDMSGS.C             #
#                                                                       #
#######################################################################*/

extern char  YesNoChar[];	      /*YyNn*/ 
extern BYTE BannerMsg[];	      /*FLEXOS\n   Fixed Disk Setup Program..*/
extern BYTE ChosenDiskMsg[];	      /*You have chosen the physical hard...*/
extern BYTE OptionListMsg[];	      /*FDISK Options*/
extern BYTE ChooseMsg[];	      /*Choose ONE of the following:*/
extern BYTE ChoiceOneMsg[];	      /*1.  Create logical disk partition*/
extern BYTE ChoiceTwoMsg[];	      /*2.  Change active partition*/
extern BYTE ChoiceThreeMsg[];	      /*3.  Delete logical disk partition*/
extern BYTE ChoiceFourMsg[];	      /*4.  Display disk partition informa...*/
extern BYTE ChoiceFiveMsg[];	      /*5.  Select next hard disk drive*/
extern BYTE EnterChoiceMsg[];	      /*Enter Choice ( 1 - 5 ) */
extern BYTE EscapeFdiskMsg[];	      /*Press ESC key to leave FDISK*/
extern BYTE CreatePartitionMsg[];     /*Create a partition on the physical...*/
extern BYTE SelectOneMsg[];	      /*1. Partition the entire disk into...*/
extern BYTE SelectTwoMsg[];	      /*2. Create one partition at a time*/
extern BYTE WarningMsg[];	      /*WARNING:  CURRENT DISK INFORMATION...*/
extern BYTE EnterSelectionMsg[];      /*Enter Choice ( 1 - 2 ) */
extern BYTE EscapeToMainMenuMsg[];    /*Press ESC Key to return to Main Menu*/
extern BYTE CreateAllMsg[];	      /*Create all 32 megabyte partitions...*/
extern BYTE SpaceLeftMsg[];	      /*There is enough room for a total...*/
extern BYTE MakePartitionsMsg[];      /*Make the partitions (Y/N)? */
extern BYTE MakePartitionMsg[];       /*Make the partition (Y/N)? */
extern BYTE RemainingMsg[];	      /*%d cylinders are left.*/
extern BYTE EscapeToCreateMenuMsg[];  /*Press ESC Key to return to the...*/
extern BYTE CurrentPartitionsMsg[];   /*Current Partitions*/
extern BYTE HeadingMsg[];	      /*Partition Status Type Start Cyli...*/
extern BYTE UnderLineMsg[];	      /*--------- ------ ---- ------------...*/
extern BYTE ViewPartitionsMsg[];      /*Do you wish to see partitions not ...*/
extern BYTE DefaultCylinderMsg[];     /*Enter starting cylinder: %d  */
extern BYTE EnterCylinderMsg[];       /*""*/
extern BYTE DefaultSizeMsg[];	      /*Enter cylinder size:     %d  */
extern BYTE EnterSizeMsg[]; 	      /*""*/
extern BYTE MegaSizeMsg[];	      /*Size in megabytes: %5.1f  */
extern BYTE ChangePartitionMsg[];     /*Change current active partition on...*/
extern BYTE EnterNewPartitionMsg[];   /*Enter new active partition: */
extern BYTE ActivatePartitionMsg[];   /*Activate the partition (Y/N)? */
extern BYTE DeletePartitionMsg[];     /*Delete a partition on the physical...*/
extern BYTE DeleteNumberMsg[];	      /*Partition number to delete: */
extern BYTE DeleteVerifyMsg[];        /*Delete the partition (Y/N)? */
extern BYTE DisplayPartitionMsg[];    /*Display current partitions on the ...*/
extern BYTE PartitionNumMsg[];	      /* %d */
extern BYTE PartActiveMsg[];	      /*ACTIVE*/
extern BYTE PartInactiveMsg[];	      /* INACT*/
extern BYTE PartExtendedMsg[];	      /*EXTEND*/
extern BYTE DOSPartMsg[];	      /*DOS*/
extern BYTE UnknownPartMsg[];	      /*????*/
extern BYTE FlexOSPartMsg[];	      /*FLEX*/
extern BYTE DataMsg[];		      /*%4d */
extern BYTE MegDataMsg[];	      /* %5.1f */
extern BYTE No32GapMsg[];	      /*The disk does not contain 32 mega...*/
extern BYTE IllegalDataMsg[];	      /*Illegal input data - enter correct...*/
extern BYTE PartIsActiveMsg[];	      /*The active partition already exists.*/
extern BYTE PartNotExistMsg[];	      /*The partition you have chosen does...*/
extern BYTE DeleteOrderErrorMsg[];    /*MUST DELETE THE LOGICAL PARTITIONS...*/
extern BYTE NoSpaceMsg[];	      /*The disk is now fully allocated.*/
extern BYTE EscapePosMsg[];	      /**/
extern BYTE AllPartDeletedMsg[];      /*All partitions are deleted.*/
extern BYTE DiskUnPartMsg[];	      /*The disk is unpartitioned.*/
extern BYTE NoForeignPartDelMsg[];    /*Only DOS or FlexOS partition can...*/
extern BYTE IllegalPartNumMsg[];      /*Only the primary partition can be...*/
extern BYTE PrimePartNotExistMsg[];   /*The primary partition does not exist.*/
extern BYTE ReinvokeMsg[];	      /*Exit and reinvoke FDISK with the...*/
extern BYTE CylinderSizeMsg[];	      /*Total hard disk space is %d cylinders*/
extern BYTE DriverErrorMsg[];         /*Driver read or write error (Possibly a bad cylinder found) */


/*#######################################################################
#                                                                       #
#  Static variables.                                                    #
#                                                                       #
#######################################################################*/

  PDisplayObject DriverErrorObj =
       {
          { 22, 4 }, { DriverErrorMsg }
       };

  PDisplayObject CylinderSizeObj =
       {
          { 16, 4 }, {CylinderSizeMsg} 
       };

  PDisplayObject ReinvokeObj =
       {
          { 22, 4 }, { ReinvokeMsg }
       };

  PDisplayObject PrimePartNotExistObj =
       {
          { 22, 4 }, { PrimePartNotExistMsg }
       };       

  PDisplayObject IllegalPartNumObj =
       {
          { 22, 4 }, { IllegalPartNumMsg }
       };
                         
  PDisplayObject AllPartDeletedObj =
       {
          { 22, 4 }, { AllPartDeletedMsg }
       };
                       
  PDisplayObject EscapePosObj =
       {
          { 24, 1 }, { EscapePosMsg }
       };
       	  
  PDisplayObject NoSpaceObj =
       {
          { 22, 4 }, { NoSpaceMsg }
       };     
       
  PDisplayObject DeleteOrderErrorObj =
       {
          { 22, 4 }, { DeleteOrderErrorMsg }
       };

  PDisplayObject DiskUnPartObj =
       {
          { 22, 4 }, { DiskUnPartMsg }
       };

  PDisplayObject NoForeignPartDelObj =
       {
          { 22, 4 }, { NoForeignPartDelMsg }
       };

  PDisplayObject PartIsActiveObj =
       {
          { 22, 4 }, { PartIsActiveMsg }
       };
       
  PDisplayObject PartNotExistObj = 
       {
          { 22, 4 }, { PartNotExistMsg }
       };
       
  PDisplayObject No32GapObj = 
       {
          { 22, 4 }, { No32GapMsg }
       };

  PDisplayObject IllegalDataObj =
       {
          { 22, 4 }, { IllegalDataMsg }
       };

  PDisplayObject PartitionNumObj = 
       {
          { 9, 7 }, { PartitionNumMsg }
       };

  PDisplayObject DataObj = 
       {
          { 9, 35 }, { DataMsg }
       };
   
  PDisplayObject MegDataObj =
       {
          { 9, 40 }, { MegDataMsg }
       };
        
  PDisplayObject PartActiveObj =
       {
          { 9, 14 }, { PartActiveMsg }
       };

  PDisplayObject PartInactiveObj =
       {
          { 9, 14 }, { PartInactiveMsg }
       };

  PDisplayObject PartExtendedObj =
       {
          { 9, 14 }, { PartExtendedMsg }
       };

  PDisplayObject DOSPartObj =
       {
          { 9, 22 }, { DOSPartMsg }
       };

  PDisplayObject UnknownPartObj =
       {
          { 9, 21 }, { UnknownPartMsg }
       };

  PDisplayObject FlexOSPartObj =
       {
          { 9, 21 }, { FlexOSPartMsg }
       };

  PDisplayObject  BannerObj =
       {
          { 1, 4 }, { BannerMsg }
       };

  PDisplayObject  ChosenDiskObj =
       {
          { 6, 4 }, { ChosenDiskMsg }
       };

  PDisplayObject  OptionListObj =
       {
          { 8, 4 }, { OptionListMsg }
       };

  PDisplayObject  ChooseObj =
       {
          { 10, 4 }, { ChooseMsg }
       };

  PDisplayObject  ChoiceOneObj =
       {
          { 12, 4 }, { ChoiceOneMsg }
       };

  PDisplayObject  ChoiceTwoObj =
       {
          { 13, 4 }, { ChoiceTwoMsg }
       };

  PDisplayObject  ChoiceThreeObj =
       {
          { 14, 4 }, { ChoiceThreeMsg }
       };

  PDisplayObject  ChoiceFourObj =
       {
          { 15, 4 }, { ChoiceFourMsg }
       };
  PDisplayObject  ChoiceFiveObj =
       {
          { 16, 4 }, { ChoiceFiveMsg }
       };

  PDisplayObject  EnterChoiceObj =
       {
          { 19, 4 }, { EnterChoiceMsg }
       };

  PDisplayObject  EscapeFdiskObj =
       {
          { 24, 4 }, { EscapeFdiskMsg }
       };

  PDisplayObject  CreatePartitionObj =
       {
          { 7, 4 }, { CreatePartitionMsg } 
       };

  PDisplayObject  CausePartitionObj =
       {
          { 5, 13 }, { CreatePartitionMsg }
       };

  PDisplayObject  SelectOneObj =
       {
          { 12, 4 }, { SelectOneMsg }
       };

  PDisplayObject  SelectTwoObj =
       {
          { 13, 4 }, { SelectTwoMsg }
       };

  PDisplayObject  WarningObj =
       {
          { 20, 4 }, { WarningMsg }
       };

  PDisplayObject  EnterSelectionObj =
       {
          { 22, 4 }, { EnterSelectionMsg }
       };

  PDisplayObject  EscapeToMainMenuObj =
       {
          { 24, 4 }, { EscapeToMainMenuMsg }
       };

  PDisplayObject  CreateAllObj =
       {
          { 7, 4 }, { CreateAllMsg }
       };

  PDisplayObject  SpaceLeftObj =
       {
          { 9, 4 }, { SpaceLeftMsg }
       };

  PDisplayObject  MakePartitionsObj =
       {
          { 13, 4 }, { MakePartitionsMsg }
       };

  PDisplayObject  RemainingObj =
       {
          { 15, 4 }, { RemainingMsg }
       };

  PDisplayObject  EscapeToCreateMenuObj =
       {
          { 24, 4 }, { EscapeToCreateMenuMsg }
       };

  PDisplayObject  CurrentPartitionsObj =
       {
          { 6,30 }, { CurrentPartitionsMsg }
       };

   PDisplayObject  HeadingObj =
       {
          { 7, 4 }, { HeadingMsg }
       };

   PDisplayObject  UnderLineObj =
       {
          { 8, 4 }, { UnderLineMsg }
       };

  PDisplayObject  ViewPartitionsObj =
       {
          { 14, 4 }, { ViewPartitionsMsg }
       };

  PDisplayObject  DefaultCylinderObj =
       {
          { 18, 4 }, { DefaultCylinderMsg }
       };

  PDisplayObject  EnterCylinderObj =
       {
/*        { 18, sizeof( DefaultCylinderMsg ) - 1 }, { EnterCylinderMsg } */
          { 18,           30                 - 1 }, { EnterCylinderMsg }
/* If FDMSGS changes, change this. */

       };

  PDisplayObject  DefaultSizeObj =
       {
          { 19, 4 }, { DefaultSizeMsg }
       };

  PDisplayObject  EnterSizeObj =
       {
/*        { 19, sizeof( DefaultSizeMsg ) - 1 }, { EnterSizeMsg } */
          { 19,           30             - 1 }, { EnterSizeMsg }
/* If FDMSGS changes, change this. */
       };

  PDisplayObject  MegaSizeObj =
       {
          { 18, 43 }, { MegaSizeMsg }
       };

  PDisplayObject  MakePartitionObj =
       {
          { 22, 4 }, { MakePartitionMsg }
       };

  PDisplayObject  ChangePartitionObj =
       {
          { 5, 12 }, { ChangePartitionMsg }
       };

  PDisplayObject  EnterNewPartitionObj =
       {
          { 18, 4 }, { EnterNewPartitionMsg }
       };

  PDisplayObject  ActivatePartitionObj =
       {
          { 18, 4 }, { ActivatePartitionMsg }
       };

  PDisplayObject  DeletePartitionObj =
       {
          { 5, 18 }, { DeletePartitionMsg }
       };

  PDisplayObject  DeleteNumberObj =
       {
          { 18, 4 }, { DeleteNumberMsg }
       };

  PDisplayObject  DeleteVerifyObj =
       {
          { 22, 4 }, { DeleteVerifyMsg }
       };

  PDisplayObject  DisplayPartitionObj =
       {
          { 5, 14 }, { DisplayPartitionMsg }
       };

/*#######################################################################
#                                                                       #
#                            NOTICE:                                    #
#                                                                       #
#    The source code contained in this listing is a proprietary trade   #
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and    #
#    is also subject to copyright protection as an unpublished work     #
#    pursuant to Section 104(a) of Title 17 of the United States Code.  #
#    Unauthorized copying, adaptation, distribution, use or display is  #
#    prohitibed by law and may be subject to civil and criminal         #
#    penalties.                                                         #
#                                                                       #
#######################################################################*/
