/**** VDIBIND.H **********************************************************
**									**
**		VDI C Bindings Header File.				**
**									**
**   Description : Contains the X3J11 Function Prototyping option and	**
**		   the "Plain-C" option for the VDI Binding Library.    **
**									**
**		   Define "VDI_Protos" to enable the Prototypes.        **
**									**
**									**
**   Version :	1.1							**
**									**
**   Version	 Date	  Author	Comments			**
**   -------	--------  ------  ------------------------------------- **
**   1.3.01	02/25/87  Frotz   Added Prototyping switch.		**
**   1.3.00	04/19/85  JG	  Created module.			**
*************************************************************************/


#if  !defined( EXTERN )

#define EXTERN	extern

#endif




#if   defined( VDI_Protos )


/*
 *
 *	X3J11's Function Prototyping...
 *
 */


EXTERN	 WORD	 vdi( VOID );

EXTERN	 WORD	 v_opnwk(	    WORD *work_in,	/*  01	*/
				    WORD *handle,	/*  01	*/
				    WORD *work_out );	/*  01	*/
EXTERN	 WORD	 v_clswk(	    WORD handle );	/*  02	*/
EXTERN	 WORD	 v_clrwk(	    WORD handle );	/*  03	*/
EXTERN	 WORD	 v_updwk(	    WORD handle );	/*  04	*/

EXTERN	 WORD	 vq_chcells(	    WORD handle,	/* 5-01 */
				    WORD *rows, 	/* 5-01 */
				    WORD *columns );	/* 5-01 */
EXTERN	 WORD	 v_exit_cur(	    WORD handle );	/* 5-02 */
EXTERN	 WORD	 v_enter_cur(	    WORD handle );	/* 5-03 */
EXTERN	 WORD	 v_curup(	    WORD handle );	/* 5-04 */
EXTERN	 WORD	 v_curdown(	    WORD handle );	/* 5-05 */
EXTERN	 WORD	 v_curright(	    WORD handle );	/* 5-06 */
EXTERN	 WORD	 v_curleft(	    WORD handle );	/* 5-07 */
EXTERN	 WORD	 v_curhome(	    WORD handle );	/* 5-08 */
EXTERN	 WORD	 v_eeos(	    WORD handle );	/* 5-09 */
EXTERN	 WORD	 v_eeol(	    WORD handle );	/* 5-0a */
EXTERN	 WORD	 vs_curaddress(     WORD handle,	/* 5-0b */
				    WORD row,		/* 5-0b */
				    WORD column );	/* 5-0b */
EXTERN	 WORD	 v_curtext(	    WORD handle,	/* 5-0c */
				    BYTE *string );	/* 5-0c */
EXTERN	 WORD	 v_rvon(	    WORD handle );	/* 5-0d */
EXTERN	 WORD	 v_rvoff(	    WORD handle );	/* 5-0e */
EXTERN	 WORD	 vq_curaddress(     WORD handle,	/* 5-0f */
				    WORD *row,		/* 5-0f */
				    WORD *column );	/* 5-0f */
EXTERN	 WORD	 vq_tabstatus(	    WORD handle );	/* 5-10 */
EXTERN	 WORD	 v_hardcopy(	    WORD hanlde );	/* 5-11 */
EXTERN	 WORD	 v_dspcur(	    WORD handle,	/* 5-12 */
				    WORD x,		/* 5-12 */
				    WORD y );		/* 5-12 */
EXTERN	 WORD	 v_rmcur(	    WORD handle );	/* 5-13 */
EXTERN	 WORD	 v_form_adv(	    WORD handle );	/* 5-14 */
EXTERN	 WORD	 v_output_window(   WORD handle,	/* 5-15 */
				    WORD *xy ); 	/* 5-15 */
EXTERN	 WORD	 v_clear_disp_list( WORD handle );	/* 5-16 */
EXTERN	 WORD	 v_bit_image(	    WORD handle,	/* 5-17 */
				    BYTE *filename,	/* 5-17 */
				    WORD aspect,	/* 5-17 */
				    WORD x_scale,	/* 5-17 */
				    WORD y_scale,	/* 5-17 */
				    WORD h_align,	/* 5-17 */
				    WORD v_align,	/* 5-17 */
				    WORD *xy ); 	/* 5-17 */
EXTERN	 WORD	 vq_scan(	    WORD handle,	/* 5-18 */
				    WORD *g_height,	/* 5-18 */
				    WORD *g_slice,	/* 5-18 */
				    WORD *a_height,	/* 5-18 */
				    WORD *a_slice,	/* 5-18 */
				    WORD *factor );	/* 5-18 */
EXTERN	 WORD	 v_alpha_text(	    WORD handle,	/* 5-19 */
				    BYTE *string );	/* 5-19 */
EXTERN	 WORD	 vs_palette(	    WORD handle,	/* 5-3c */
				    WORD palette );	/* 5-3c */
EXTERN	 WORD	 vsp_film(	    WORD handle,	/* 5-5b */
				    WORD index, 	/* 5-5b */
				    WORD exposure );	/* 5-5b */
EXTERN	 WORD	 vqp_filmname(	    WORD handle,	/* 5-5c */
				    WORD index, 	/* 5-5c */
				    BYTE *name );	/* 5-5c */
EXTERN	 WORD	 v_meta_extents(    WORD handle,	/* 5-62 */
				    WORD min_x, 	/* 5-62 */
				    WORD min_y, 	/* 5-62 */
				    WORD max_x, 	/* 5-62 */
				    WORD max_y );	/* 5-62 */
EXTERN	 WORD	 v_write_meta(	    WORD handle,	/* 5-63 */
				    WORD num_ints,	/* 5-63 */
				    WORD *ints, 	/* 5-63 */
				    WORD num_pts,	/* 5-63 */
				    WORD *pts );	/* 5-63 */
EXTERN	 WORD	 vm_filename(	    WORD handle,	/* 5-64 */
				    BYTE *filename );	/* 5-64 */

EXTERN	 WORD	 v_pline(	    WORD handle,	/*  06	*/
				    WORD count, 	/*  06	*/
				    WORD *xy ); 	/*  06	*/
EXTERN	 WORD	 v_pmarker(	    WORD handle,	/*  07	*/
				    WORD count, 	/*  07	*/
				    WORD *xy ); 	/*  07	*/
EXTERN	 WORD	 v_gtext(	    WORD handle,	/*  08	*/
				    WORD x,		/*  08	*/
				    WORD y,		/*  08	*/
				    BYTE *string );	/*  08	*/
EXTERN	 WORD	 v_fillarea(	    WORD handle,	/*  09	*/
				    WORD count, 	/*  09	*/
				    WORD *xy ); 	/*  09	*/
EXTERN	 WORD	 v_cellarray(	    WORD handle,	/*  0a	*/
				    WORD *xy,		/*  0a	*/
				    WORD row_length,	/*  0a	*/
				    WORD el_per_row,	/*  0a	*/
				    WORD num_rows,	/*  0a	*/
				    WORD wr_mode,	/*  0a	*/
				    WORD *colors );	/*  0a	*/

EXTERN	 WORD	 v_bar( 	    WORD handle,	/* b-01 */
				    WORD *xy ); 	/* b-01 */
EXTERN	 WORD	 v_arc( 	    WORD handle,	/* b-02 */
				    WORD xc,		/* b-02 */
				    WORD yc,		/* b-02 */
				    WORD rad,		/* b-02 */
				    WORD sang,		/* b-02 */
				    WORD eang );	/* b-02 */
EXTERN	 WORD	 v_pieslice(	    WORD handle,	/* b-03 */
				    WORD xc,		/* b-03 */
				    WORD yc,		/* b-03 */
				    WORD rad,		/* b-03 */
				    WORD sang,		/* b-03 */
				    WORD eang );	/* b-03 */
EXTERN	 WORD	 v_circle(	    WORD handle,	/* b-04 */
				    WORD xc,		/* b-04 */
				    WORD yc,		/* b-04 */
				    WORD rad ); 	/* b-04 */
EXTERN	WORD v_ellipse( 	    WORD handle,	/* b-05 */
				    WORD xc,		/* b-05 */
				    WORD yc,		/* b-05 */
				    WORD xrad,		/* b-05 */
				    WORD yrad );	/* b-05 */
EXTERN	WORD v_ellarc(		    WORD handle,	/* b-06 */
				    WORD xc,		/* b-06 */
				    WORD yc,		/* b-06 */
				    WORD xrad,		/* b-06 */
				    WORD yrad,		/* b-06 */
				    WORD sang,		/* b-06 */
				    WORD eang );	/* b-06 */
EXTERN	WORD v_ellpie(		    WORD handle,	/* b-07 */
				    WORD xc,		/* b-07 */
				    WORD yc,		/* b-07 */
				    WORD xrad,		/* b-07 */
				    WORD yrad,		/* b-07 */
				    WORD sang,		/* b-07 */
				    WORD eang );	/* b-07 */
EXTERN	 WORD	 v_rbox(	    WORD handle,	/* b-08 */
				    WORD *xy ); 	/* b-08 */
EXTERN	 WORD	 v_rfbox(	    WORD handle,	/* b-09 */
				    WORD *xy ); 	/* b-09 */
EXTERN	 WORD	 v_justified(	    WORD handle,	/* b-0a */
				    WORD x,		/* b-0a */
				    WORD y,		/* b-0a */
				    BYTE *string,	/* b-0a */
				    WORD length,	/* b-0a */
				    WORD word_space,	/* b-0a */
				    WORD char_space );	/* b-0a */

EXTERN	 WORD	 vst_height(	    WORD handle,	/*  0c	*/
				    WORD height,	/*  0c	*/
				    WORD *char_width,	/*  0c	*/
				    WORD *char_height,	/*  0c	*/
				    WORD *cell_width,	/*  0c	*/
				    WORD *cell_height );/*  0c	*/
EXTERN	 WORD	 vst_rotation();			/*  0d	*/
EXTERN	 WORD	 vs_color(	    WORD handle,	/*  0e	*/
				    WORD index, 	/*  0e	*/
				    WORD *rgb );	/*  0e	*/
EXTERN	 WORD	 vsl_type(	    WORD handle,	/*  0f	*/
				    WORD style );	/*  0f	*/
EXTERN	 WORD	 vsl_width(	    WORD handle,	/*  10	*/
				    WORD width );	/*  10	*/
EXTERN	 WORD	 vsl_color(	    WORD handle,	/*  11	*/
				    WORD index );	/*  11	*/
EXTERN	 WORD	 vsm_type(	    WORD handle,	/*  12	*/
				    WORD symbol );	/*  12	*/
EXTERN	 WORD	 vsm_height(	    WORD handle,	/*  13	*/
				    WORD height );	/*  13	*/
EXTERN	 WORD	 vsm_color(	    WORD handle,	/*  14	*/
				    WORD index );	/*  14	*/
EXTERN	 WORD	 vst_font(	    WORD handle,	/*  15	*/
				    WORD font );	/*  15	*/
EXTERN	 WORD	 vst_color(	    WORD handle,	/*  16	*/
				    WORD index );	/*  16	*/
EXTERN	 WORD	 vsf_interior(	    WORD handle,	/*  17	*/
				    WORD style );	/*  17	*/
EXTERN	 WORD	 vsf_style(	    WORD handle,	/*  18	*/
				    WORD index );	/*  18	*/
EXTERN	 WORD	 vsf_color(	    WORD handle,	/*  19	*/
				    WORD index );	/*  19	*/
EXTERN	 WORD	 vq_color(	    WORD handle,	/*  1a	*/
				    WORD index, 	/*  1a	*/
				    WORD set_flag,	/*  1a	*/
				    WORD *rgb );	/*  1a	*/
EXTERN	 WORD	 vq_cellarray(	    WORD handle,	/*  1b	*/
				    WORD *xy,		/*  1b	*/
				    WORD row_len,	/*  1b	*/
				    WORD num_rows,	/*  1b	*/
				    WORD *el_used,	/*  1b	*/
				    WORD *rows_used,	/*  1b	*/
				    WORD *stat, 	/*  1b	*/
				    WORD *colors );	/*  1b	*/

EXTERN	 WORD	 vrq_locator(	    WORD handle,	/*  1c	*/
				    WORD initx, 	/*  1c	*/
				    WORD inity, 	/*  1c	*/
				    WORD *xout, 	/*  1c	*/
				    WORD *yout, 	/*  1c	*/
				    WORD *term );	/*  1c	*/
EXTERN	 WORD	 vsm_locator(	    WORD handle,	/*  1c	*/
				    WORD initx, 	/*  1c	*/
				    WORD inity, 	/*  1c	*/
				    WORD *xout, 	/*  1c	*/
				    WORD *yout, 	/*  1c	*/
				    WORD *term );	/*  1c	*/
EXTERN	 WORD	 vrq_valuator(	    WORD handle,	/*  1d	*/
				    WORD val_in,	/*  1d	*/
				    WORD *val_out,	/*  1d	*/
				    WORD *term );	/*  1d	*/
EXTERN	 WORD	 vsm_valuator(	    WORD handle,	/*  1d	*/
				    WORD val_in,	/*  1d	*/
				    WORD *val_out,	/*  1d	*/
				    WORD *term, 	/*  1d	*/
				    WORD *status );	/*  1d	*/
EXTERN	 WORD	 vrq_choice(	    WORD handle,	/*  1e	*/
				    WORD in_choice,	/*  1e	*/
				    WORD *out_choice ); /*  1e	*/
EXTERN	 WORD	 vsm_choice(	    WORD handle,	/*  1e	*/
				    WORD *choice );	/*  1e	*/
EXTERN	 WORD	 vrq_string(	    WORD handle,	/*  1f	*/
				    WORD length,	/*  1f	*/
				    WORD echo_mode,	/*  1f	*/
				    WORD *echo_xy,	/*  1f	*/
				    BYTE *string );	/*  1f	*/
EXTERN	 WORD	 vsm_string(	    WORD handle,	/*  1f	*/
				    WORD length,	/*  1f	*/
				    WORD echo_mode,	/*  1f	*/
				    WORD *echo_xy,	/*  1f	*/
				    BYTE *string );	/*  1f	*/
EXTERN	 WORD	 vswr_mode(	    WORD handle,	/*  20	*/
				    WORD mode );	/*  20	*/
EXTERN	 WORD	 vsin_mode(	    WORD handle,	/*  21	*/
				    WORD dev_type,	/*  21	*/
				    WORD mode );	/*  21	*/

EXTERN	 WORD	 vql_attributes(    WORD handle,	/*  23	*/
				    WORD *attributes ); /*  23	*/
EXTERN	 WORD	 vqm_attributes(    WORD handle,	/*  24	*/
				    WORD *attributes ); /*  24	*/
EXTERN	 WORD	 vqf_attributes(    WORD handle,	/*  25	*/
				    WORD *attributes ); /*  25	*/
EXTERN	 WORD	 vqt_attributes(    WORD handle,	/*  26	*/
				    WORD *attributes ); /*  26	*/
EXTERN	 WORD	 vst_alignment(     WORD handle,	/*  27	*/
				    WORD hor_in,	/*  27	*/
				    WORD vert_in,	/*  27	*/
				    WORD *hor_out,	/*  27	*/
				    WORD *vert_out );	/*  27	*/

EXTERN	 WORD	 v_opnvwk(	    WORD *work_in,	/*  64	*/
				    WORD *handle,	/*  64	*/
				    WORD *work_out );	/*  64	*/
EXTERN	 WORD	 v_clsvwk(	    WORD handle );	/*  65	*/
EXTERN	 WORD	 vq_extnd(	    WORD handle,	/*  66	*/
				    WORD owflag,	/*  66	*/
				    WORD *work_out );	/*  66	*/
EXTERN	 WORD	 v_contourfill(     WORD handle,	/*  67	*/
				    WORD x,		/*  67	*/
				    WORD y,		/*  67	*/
				    WORD index );	/*  67	*/

EXTERN	 WORD	 vsf_perimeter(     WORD handle,	/*  68	*/
				    WORD per_vis );	/*  68	*/
EXTERN	 WORD	 vst_background();			/*  ??	*/
EXTERN	 WORD	 vst_effects(	    WORD handle,	/*  6a	*/
				    WORD effect );	/*  6a	*/
EXTERN	 WORD	 vst_point(	    WORD handle,	/*  6b	*/
				    WORD point, 	/*  6b	*/
				    WORD *char_width,	/*  6b	*/
				    WORD *char_height,	/*  6b	*/
				    WORD *cell_width,	/*  6b	*/
				    WORD *cell_height );/*  6b	*/
EXTERN	 WORD	 vsl_ends(	    WORD handle,	/*  6c	*/
				    WORD beg_style,	/*  6c	*/
				    WORD end_style );	/*  6c	*/

EXTERN	 WORD	 vro_cpyfm(	    WORD handle,	/*  6d	*/
				    WORD wr_mode,	/*  6d	*/
				    WORD *xy,		/*  6d	*/
				    WORD *srcMFDB,	/*  6d	*/
				    WORD *desMFDB );	/*  6d	*/
EXTERN	 WORD	 vr_trnfm(	    WORD handle,	/*  6e	*/
				    WORD *srcMFDB,	/*  6e	*/
				    WORD *desMFDB );	/*  6e	*/
EXTERN	 WORD	 vsc_form(	    WORD handle,	/*  6f	*/
				    WORD *cur_form );	/*  6f	*/
EXTERN	 WORD	 vsf_udpat(	    WORD handle,	/*  70	*/
				    WORD *fill_pat,	/*  70	*/
				    WORD planes );	/*  70	*/
EXTERN	 WORD	 vsl_udsty(	    WORD handle,	/*  71	*/
				    WORD pattern );	/*  71	*/
EXTERN	 WORD	 vr_recfl(	    WORD handle,	/*  72	*/
				    WORD *xy ); 	/*  72	*/

EXTERN	 WORD	 vqin_mode(	    WORD handle,	/*  73	*/
				    WORD dev_type,	/*  73	*/
				    WORD *mode );	/*  73	*/
EXTERN	 WORD	 vqt_extent(	    WORD handle,	/*  74	*/
				    BYTE *string,	/*  74	*/
				    WORD *extent );	/*  74	*/
EXTERN	 WORD	 vqt_width(	    WORD handle,	/*  75	*/
				    BYTE character,	/*  75	*/
				    WORD *cell_width,	/*  75	*/
				    WORD *left_delta,	/*  75	*/
				    WORD *right_delta );/*  75	*/
EXTERN	 WORD	 vex_timv(	    WORD handle,	/*  76	*/
				    LONG tim_addr,	/*  76	*/
				    LONG *old_addr,	/*  76	*/
				    WORD *scale );	/*  76	*/
EXTERN	 WORD	 vst_load_fonts(    WORD handle,	/*  77	*/
				    WORD select );	/*  77	*/
EXTERN	 WORD	 vst_unload_fonts(  WORD handle,	/*  78	*/
				    WORD select );	/*  78	*/
EXTERN	 WORD	 vrt_cpyfm(	    WORD handle,	/*  79	*/
				    WORD wr_mode,	/*  79	*/
				    WORD *xy,		/*  79	*/
				    WORD *srcMFDB,	/*  79	*/
				    WORD *desMFDB,	/*  79	*/
				    WORD *index );	/*  79	*/
EXTERN	 WORD	 v_show_c(	    WORD handle,	/*  7a	*/
				    WORD reset );	/*  7a	*/
EXTERN	 WORD	 v_hide_c(	    WORD handle );	/*  7b	*/
EXTERN	 WORD	 vq_mouse(	    WORD handle,	/*  7c	*/
				    WORD *status,	/*  7c	*/
				    WORD *px,		/*  7c	*/
				    WORD *py ); 	/*  7c	*/
EXTERN	 WORD	 vex_butv(	    WORD handle,	/*  7d	*/
				    LONG usercode,	/*  7d	*/
				    LONG *savecode );	/*  7d	*/
EXTERN	 WORD	 vex_motv(	    WORD handle,	/*  7e	*/
				    LONG usercode,	/*  7e	*/
				    LONG *savecode );	/*  7e	*/
EXTERN	 WORD	 vex_curv(	    WORD handle,	/*  7f	*/
				    LONG usercode,	/*  7f	*/
				    LONG *savecode );	/*  7f	*/
EXTERN	 WORD	 vq_key_s(	    WORD handle,	/*  80	*/
				    WORD *status );	/*  80	*/
EXTERN	 WORD	 vs_clip(	    WORD handle,	/*  81	*/
				    WORD clip_flag,	/*  81	*/
				    WORD *xy ); 	/*  81	*/

EXTERN	 WORD	 vqt_name(	    WORD handle,	/*  82	*/
				    WORD element_num,	/*  82	*/
				    BYTE *name );	/*  82	*/
EXTERN	 WORD	 vqt_font_info(     WORD handle,	/*  83	*/
				    WORD *minADE,	/*  83	*/
				    WORD *maxADE,	/*  83	*/
				    WORD *distances,	/*  83	*/
				    WORD *maxwidth,	/*  83	*/
				    WORD *effects );	/*  83	*/







#else




/*
 *
 *	Plain C's extern references for the VDI Library...
 *
 */




EXTERN	 VOID	 vdiif();

EXTERN	 WORD	 v_opnwk();	      /*  1   */
EXTERN	 WORD	 v_clswk();	      /*  2   */
EXTERN	 WORD	 v_clrwk();	      /*  3   */
EXTERN	 WORD	 v_updwk();	      /*  4   */

EXTERN	 WORD	 vq_chcells();	      /* 5 1  */
EXTERN	 WORD	 v_exit_cur();	      /* 5 2  */
EXTERN	 WORD	 v_enter_cur();       /* 5 3  */
EXTERN	 WORD	 v_curup();	      /* 5 4  */
EXTERN	 WORD	 v_curdown();	      /* 5 5  */
EXTERN	 WORD	 v_curright();	      /* 5 6  */
EXTERN	 WORD	 v_curleft();	      /* 5 7  */
EXTERN	 WORD	 v_curhome();	      /* 5 8  */
EXTERN	 WORD	 v_eeos();	      /* 5 9  */
EXTERN	 WORD	 v_eeol();	      /* 5 10 */
EXTERN	 WORD	 vs_curaddress();     /* 5 11 */
EXTERN	 WORD	 v_curtext();	      /* 5 12 */
EXTERN	 WORD	 v_rvon();	      /* 5 13 */
EXTERN	 WORD	 v_rvoff();	      /* 5 14 */
EXTERN	 WORD	 vq_curaddress();     /* 5 15 */
EXTERN	 WORD	 vq_tabstatus();      /* 5 16 */
EXTERN	 WORD	 v_hardcopy();	      /* 5 17 */
EXTERN	 WORD	 v_dspcur();	      /* 5 18 */
EXTERN	 WORD	 v_rmcur();	      /* 5 19 */
EXTERN	 WORD	 v_form_adv();	      /* 5 20 */
EXTERN	 WORD	 v_output_window();   /* 5 21 */
EXTERN	 WORD	 v_clear_disp_list(); /* 5 22 */
EXTERN	 WORD	 v_bit_image();       /* 5 23 */
EXTERN	 WORD	 vq_scan();	      /* 5 24 */
EXTERN	 WORD	 v_alpha_text();      /* 5 25 */
EXTERN	 WORD	 vs_palette();	      /* 5 60 */
EXTERN	 WORD	 vsp_film();	      /* 5 91 */
EXTERN	 WORD	 vqp_filmname();      /* 5 92 */
EXTERN	 WORD	 v_meta_extents();    /* 5 98 */
EXTERN	 WORD	 v_write_meta();      /* 5 99 */
EXTERN	 WORD	 vm_filename();       /* 5 100*/

EXTERN	 WORD	 v_pline();	      /*  6   */
EXTERN	 WORD	 v_pmarker();	      /*  7   */
EXTERN	 WORD	 v_gtext();	      /*  8   */
EXTERN	 WORD	 v_fillarea();	      /*  9   */
EXTERN	 WORD	 v_cellarray();       /*  10  */

EXTERN	 WORD	 v_bar();	      /* 11  1 */
EXTERN	 WORD	 v_arc();	      /* 11  2 */
EXTERN	 WORD	 v_pieslice();	      /* 11  3 */
EXTERN	 WORD	 v_circle();	      /* 11  4 */
EXTERN	 WORD	 v_ellipse();	      /* 11  5 */
EXTERN	 WORD	 v_ellarc();	      /* 11  6 */
EXTERN	 WORD	 v_ellpie();	      /* 11  7 */
EXTERN	 WORD	 v_rbox();	      /* 11  8 */
EXTERN	 WORD	 v_rfbox();	      /* 11  9 */
EXTERN	 WORD	 v_justified();       /* 11 10 */

EXTERN	 WORD	 vst_height();	      /*  12  */
EXTERN	 WORD	 vst_rotation();      /*  13  */
EXTERN	 WORD	 vs_color();	      /*  14  */
EXTERN	 WORD	 vsl_type();	      /*  15  */
EXTERN	 WORD	 vsl_width();	      /*  16  */
EXTERN	 WORD	 vsl_color();	      /*  17  */
EXTERN	 WORD	 vsm_type();	      /*  18  */
EXTERN	 WORD	 vsm_height();	      /*  19  */
EXTERN	 WORD	 vsm_color();	      /*  20  */
EXTERN	 WORD	 vst_font();	      /*  21  */
EXTERN	 WORD	 vst_color();	      /*  22  */
EXTERN	 WORD	 vsf_interior();      /*  23  */
EXTERN	 WORD	 vsf_style();	      /*  24  */
EXTERN	 WORD	 vsf_color();	      /*  25  */
EXTERN	 WORD	 vq_color();	      /*  26  */
EXTERN	 WORD	 vq_cellarray();      /*  27  */

EXTERN	 WORD	 vrq_locator();       /*  28  */
EXTERN	 WORD	 vsm_locator();       /*  28  */
EXTERN	 WORD	 vrq_valuator();      /*  29  */
EXTERN	 WORD	 vsm_valuator();      /*  29  */
EXTERN	 WORD	 vrq_choice();	      /*  30  */
EXTERN	 WORD	 vsm_choice();	      /*  30  */
EXTERN	 WORD	 vrq_string();	      /*  31  */
EXTERN	 WORD	 vsm_string();	      /*  31  */
EXTERN	 WORD	 vswr_mode();	      /*  32  */
EXTERN	 WORD	 vsin_mode();	      /*  33  */

EXTERN	 WORD	 vql_attributes();    /*  35  */
EXTERN	 WORD	 vqm_attributes();    /*  36  */
EXTERN	 WORD	 vqf_attributes();    /*  37  */
EXTERN	 WORD	 vqt_attributes();    /*  38  */
EXTERN	 WORD	 vst_alignment();     /*  39  */

EXTERN	 WORD	 v_opnvwk();	      /* 100  */
EXTERN	 WORD	 v_clsvwk();	      /* 101  */
EXTERN	 WORD	 vq_extnd();	      /* 102  */
EXTERN	 WORD	 v_contourfill();     /* 103  */

EXTERN	 WORD	 vsf_perimeter();     /* 104  */
EXTERN	 WORD	 vst_effects();       /* 106  */
EXTERN	 WORD	 vst_point();	      /* 107  */
EXTERN	 WORD	 vsl_ends();	      /* 108  */

EXTERN	 WORD	 vro_cpyfm();	      /* 109  */
EXTERN	 WORD	 vr_trnfm();	      /* 110  */
EXTERN	 WORD	 vsc_form();	      /* 111  */
EXTERN	 WORD	 vsf_udpat();	      /* 112  */
EXTERN	 WORD	 vsl_udsty();	      /* 113  */
EXTERN	 WORD	 vr_recfl();	      /* 114  */

EXTERN	 WORD	 vqin_mode();	      /* 115  */
EXTERN	 WORD	 vqt_extent();	      /* 116  */
EXTERN	 WORD	 vqt_width();	      /* 117  */
EXTERN	 WORD	 vex_timv();	      /* 118  */
EXTERN	 WORD	 vst_load_fonts();    /* 119  */
EXTERN	 WORD	 vst_unload_fonts();  /* 120  */
EXTERN	 WORD	 vrt_cpyfm();	      /* 121  */
EXTERN	 WORD	 v_show_c();	      /* 122  */
EXTERN	 WORD	 v_hide_c();	      /* 123  */
EXTERN	 WORD	 vq_mouse();	      /* 124  */
EXTERN	 WORD	 vex_butv();	      /* 125  */
EXTERN	 WORD	 vex_motv();	      /* 126  */
EXTERN	 WORD	 vex_curv();	      /* 127  */
EXTERN	 WORD	 vq_key_s();	      /* 128  */
EXTERN	 WORD	 vs_clip();	      /* 129  */

EXTERN	 WORD	 vqt_name();	      /* 130  */
EXTERN	 WORD	 vqt_font_info();     /* 131  */



#endif
