/*===============================================================*
 *   Version 1.0        RECFMSG.C                  01/08/87      *
 *---------------------------------------------------------------*
 * VERS DATE     BY     CHANGE/COMMENTS                          *
 *---------------------------------------------------------------*
 *   v1.0 01/09/87 ldt	New.					 *
 *****************************************************************/

#include	"portab.h"

#define	CRLF		msgcrlf
#define	DCRLF		msgdcrlf 

/*  externs */
EXTERN	VOID	ffpgmname();
EXTERN	VOID	puts_out();
EXTERN	WORD	itoa();

/* globals */
GLOBAL BYTE	temp[10];
GLOBAL BYTE	*pgmname = "RECFILE :";
GLOBAL BYTE	*versno = "V1.0" ;
GLOBAL BYTE	dot = '.' ;
GLOBAL BYTE	slash = '/' ;
GLOBAL BYTE	space = ' ' ;
GLOBAL BYTE	null = '\0' ;

#ifndef	wildfield
GLOBAL BYTE	wildfield = '*' ;
#endif
#ifndef	wildchar
GLOBAL BYTE	wildchar = '?' ;
#endif
#ifndef	wildnot
GLOBAL BYTE	wildnot = '^' ;
#endif

/***  optstr - options string*/

GLOBAL	BYTE	*optstr = "hHvVtTdDfFiI" ;


/***  General Messages*/

GLOBAL BYTE *msgnull =	"" ;
GLOBAL BYTE *msgcr = 	"\r" ;
GLOBAL BYTE *msgtab =	"\t" ;
GLOBAL BYTE *msgcrlf =	"\r\n" ;
GLOBAL BYTE *msgdcrlf =	"\r\n\r\n" ;
GLOBAL BYTE *msgvers =	"Recover File Utility Version " ;
GLOBAL BYTE *msgsyserr= "System Error: " ;

/***  Messages used by ffdir module*/

GLOBAL BYTE *msg001 = 	"Search Path: " ;
GLOBAL BYTE *msg002 =	"Path Left: " ;
GLOBAL BYTE *msg003a =	"Checking Dir Entry ";
GLOBAL BYTE *msg003b =	"(dec)" ;
GLOBAL BYTE *msg004a =  "DCmpName: Comparing";
GLOBAL BYTE *msg004b =  "with";
GLOBAL BYTE *msg040 =	"File Found In Entry " ;


/***  Error Messages used by fferr module*/

GLOBAL BYTE *em0003a =	" An Unknown Option [" ;
GLOBAL BYTE *em0003b =	"] was Entered.";
GLOBAL BYTE *em0004 =	"Delete Option Requires a Destination File" ;
GLOBAL BYTE *em0005 =	"You Must Specify an Input File" ;
GLOBAL BYTE *em0006 =	"The Disk Containing " ;
GLOBAL BYTE *em0006a =	" Is of Unknown Format" ;
GLOBAL BYTE *em0007 =	"There Is NOT ENOUGH MEMORY to Run" ;
GLOBAL BYTE *em0008 =	"FILE NOT FOUND " ;
GLOBAL BYTE *em0008a =	"\tLogical File Name:\t" ;
GLOBAL BYTE *em0008b =	"\tEvaluated as:\t\t" ;
GLOBAL BYTE *em0009 =	"FlexOS Error Code " ;
GLOBAL BYTE *em0011a=	" Is a Root Directory -- " ;
GLOBAL BYTE *em0011b =	" Is a SubDirectory -- " ;
GLOBAL BYTE *em0011c =	"Can\'t Fix Sub/Directories" ;
GLOBAL BYTE *em0011d =	" Is a Volume Label -- Can't Fix Labels" ;
GLOBAL BYTE *em0011e =	" Is Read Only" ;
GLOBAL BYTE *em0011f =	" Is a Hidden File -- Can't Fix Hidden Files" ;
GLOBAL BYTE *em0011g =	" Is a System File -- Can't Fix System Files" ;
GLOBAL BYTE *em0012 =	"Getopt Returned an Unknown Index" ;
GLOBAL BYTE *em0013 =	"Get Table Returned a Value Greater Than 1" ;
GLOBAL BYTE *em0014 =	"Error returned from MFREE" ;
GLOBAL BYTE *em0015 =	"Path Table Returned Path without Device Name" ;
GLOBAL BYTE *em0016 =	"File Lookup Returns More Than One Table" ;
GLOBAL BYTE *em0017 =	"File Open Returns 0" ;
GLOBAL BYTE *em0018 =	"File Table Returns Value Greater Than 1" ;
GLOBAL BYTE *em0019 =	"Bad Return From Disk I/O Request" ;
GLOBAL BYTE *em0020 =	"Not Enough Fat Buffer Space" ;
GLOBAL BYTE *em0021 =	"No Room in Fat For New Clusters" ;
GLOBAL BYTE *em0025a =	"WRITE ERROR ON MAIN FAT" ;
GLOBAL BYTE *em0025b =	"Write Error on Auxilary Fat Number " ;
GLOBAL BYTE *em0026 = 	"Read Error on Main Fat" ;
GLOBAL BYTE *em0027 = 	"Write Error on Directory" ;
GLOBAL BYTE *em0028 =	"Read Error on SubDirectory" ;
GLOBAL BYTE *em0029 =	"No Files Were Found Matching the Path " ;
GLOBAL BYTE *em0030a =	"The file " ;
GLOBAL BYTE *em0030b =	" Was Not Fixed" ;

/***  messages used by ffinit*/

GLOBAL BYTE	*msg00b =	"bytes" ;
GLOBAL BYTE	*msg006 =	"Minimum Required Buffer Space: " ;
GLOBAL BYTE	*msg007 =	"Buffer Space Allocated: " ;
GLOBAL BYTE	*msg008 =	"Cluster Buffer Size: " ;
GLOBAL BYTE	*msg009 =	"SubDir Buffer Size: " ;
GLOBAL BYTE	*msg010 =	"Root Buffer Size: " ;
GLOBAL BYTE	*msg011 =	"Fat Buffer Size: " ;

/***  messages used by main module*/

GLOBAL BYTE	*msg012 =	"Fix Switch " ;
GLOBAL BYTE	*msg012a =	"disabled" ;
GLOBAL BYTE	*msg012b =	"enabled" ;
GLOBAL BYTE	*msg012c =	"Debug Switch On" ;
GLOBAL BYTE	*msg013 =	"Fat Trace: " ;
GLOBAL BYTE	*msg014 =	"**** READ ERROR " ;
GLOBAL BYTE	*msg014a =	"On Cluster " ;
GLOBAL BYTE	*msg014b =	"\tCluster Will Be Moved To Cluster " ;
GLOBAL BYTE	*msg015a =	"**** WRITE ERROR " ;
GLOBAL BYTE	*msg015b =	"On New Cluster" ;
GLOBAL BYTE	*msg016 =	"**** CLUSTER WRITTEN SUCCESSFULLY" ;
GLOBAL BYTE	*msg017a =	" Has " ;
GLOBAL BYTE	*msg017b =	" Clusters and " ;
GLOBAL BYTE	*msg017c =	" Extents. " ;
GLOBAL BYTE	*msg019a =	"\tRead of Sector " ;
GLOBAL BYTE	*msg019b =	" Within That Cluster Failed With Error Code " ;
GLOBAL BYTE	*msg020 =	"Number Of Clusters With Read Errors:\t" ;
GLOBAL BYTE	*msg021 =	"Number Of Clusters Successfully Moved:\t" ;

GLOBAL BYTE	*msg030 =	"Attempting to Fix File " ;
GLOBAL BYTE	*msg031 =	"Attempting to Read File " ;

/***  Help Messages*/


#define	MCRLF	"\r\n"

GLOBAL BYTE *msghelp[] = 
{
	"Usage Is: ",
	MCRLF, 		/* CRLF, */
	"\trecfile",		/*  pgmname, */
	" [options] filename [filename...]",
	MCRLF,		/*  CRLF, */
	"Where Valid Options Begin With the Switch Character Followed By:",
	MCRLF,		/*  CRLF, */
	"\th (or H) - Display This Message",
	MCRLF,		/*  CRLF ,  */
	"\tv (or V) - Display Current Version",
	MCRLF,		/*  CRLF ,  */
	"\tf( or F) - Actually Fix the File",
	MCRLF,		/*  CRLF ,  */
	"\tt( or T) - Do Not Display the Fat Trace of Clusters Examined",
	MCRLF,		/*  CRLF ,  */
} ;

#define	NBRHELP	(  sizeof(msghelp) / sizeof(BYTE *)  )

GLOBAL WORD   nohelpmsgs = NBRHELP ;

/*****************************
**  ffehelp -
**	print the help message
*/
VOID	ffehelp()
{
WORD	i ;

	for( i = 0 ; i < nohelpmsgs ; ++i ) 
	{
		puts_out( msghelp[i] ) ;
	}
}	

/******************************
**  ffsyserr -
**	print system error message
*/
VOID	ffsyserr(s)
BYTE	*s ;
{
	puts_out( CRLF );
	puts_out( pgmname );
	puts_out( msgsyserr );
	puts_out( CRLF );
	puts_out( msgtab );
	puts_out( s );
	puts_out( DCRLF );
}


/***************************************************************************
**  ffunkopt -
**	unknown option error
*/

VOID	ffunkopt( opt )
BYTE	*opt ;
{
	ffpgmname() ;
	puts_out( em0003a );
	puts_out( opt );
	puts_out( em0003b );
	puts_out( CRLF );
}

/***************************************************************************
**  ffhdr -
*/
VOID	ffhdr()
{
	puts_out( DCRLF );
	puts_out( "---------------");
	puts_out( msgvers );
	puts_out( versno );
	puts_out( "---------------");
	puts_out( DCRLF );
}

/***************************************************************************
**  ffftr -
*/

VOID	ffftr(cnt)
WORD	cnt ;			/*  nbr of files fixed		*/
{
	puts_out( DCRLF) ;

	if( cnt )
	  {
	    puts_out( "Total Number of Files Fixed: ");
	    itoa(cnt,temp); puts_out( temp );
	    puts_out( CRLF );
	  }
	else
	  {
	    puts_out( "***** NO FILES WERE FIXED *****" );
	    puts_out(CRLF) ;
	  }
}
