/*===============================================================
 *   Version 1.2	KONMSG.C
 *			Error Handling for Konfig
 *---------------------------------------------------------------
 *    VERSION	DATE      BY	CHANGE/COMMENTS
 *---------------------------------------------------------------
 *	1.0	04-03-85 ktb	creation
 *	1.01	10-04-85 jsr	added NEVER define
 *	1.2	04-16-86 DR-K	removed NEVER and CONFIRM and some
 *				bad vars, made portable.
 *===============================================================*/
#include	"portab.h"
#include	"concur.h"

EXTERN	BYTE cc0463[];

BYTE	pgmname[] = "CONFIG" ;	/* Program Name */

	/*
	**  ext -
	**	error xlate table
	**	used by xltec, indexed by the utility error code (slightly
	**	modified.  translates into the more generic utility error
	**	return code.
	*/


/*
**  Error messages
*/

BYTE	*hlpmsg[] =
{
"%0: usage is\n\r\
\t%0 [dev:[ baud[ wordlen[ parity[ stopbits ] ] ] ] ]\n\r" ,

"%6\n\n\rwhere\n\r%2%3%4%5%9",

""				/*  no level 4 message		*/

} ;


	/*
	**  hldevmsg -, hlbdmsg -, hlwlmsg -, hlprmsg -, hlstmsg -
	**	substrings for the higher level help messages
	*/

BYTE	hldevmsg[] =
"\tdev\tis the name of the port controlling device to be modified,\n\r\
\t\tincluding the colon (:)\n\r" ;

BYTE	hlbdmsg[] =
"\tbaud\tis a valid baud rate indicator:\n\r\
\t\t50, 75, 110, 134.5, 150, 150, 300, 600,\n\r\
\t\t1200, 1800, 2000, 2400, 3600, 4800, 7200,\n\r\
\t\t9600, 19200\n\r\
\t\t(Note: Only the 1st two digits of baud are required\n\r";

BYTE	hlwlmsg[] = 
"\twordlen\tis a valid word length (bits per word) indicator:\n\r\
\t\t5, 6, 7, or 8\n\r" ;

BYTE	hlprmsg[] =
"\tparity\tis a valid indicator for the type of parity to use:\n\r\
\t\tEVEN (or E), ODD (or O), NONE (or N)\n\r" ;

BYTE	hlstmsg[] = 
"\tstopbits is a valid indicator of the number of stop bits to use:\n\r\
\t\t1, 1.5, or 2" ;

/*
**  pemsg -
**	parameter error message.  used when the baud, wordlength, or parity
**	indicators on the command line is not recognizable.
*/

BYTE	*pemsg[] = 
{
"%0: Invalid %3 parameter was entered.\n\r",	/* %3 is pemxxx */
"%6",
""
} ;

	/*
	**	pemxx -
	**		pembaud -, pemword -, pempar -, pemstop -
	**			parameter indicators for pemsg.
	*/

BYTE	pembaud[]	=	"Baud Rate" ;
BYTE	pemword[]	=	"Word Length" ;
BYTE	pempar[]	=	"Parity" ;
BYTE	pemstop[]	=	"Stop Bit" ;

/*
**	pe2many -
**		error message for too many parameters
*/

BYTE	*pe2many[] =
{
"%0: There are too many parameters on the command line.\n\r",
"%6",
""
} ;


/*
**	iemssg -
**		Error message for device not installed.
**		case 1:  The device to be config'd (usually a port device)
**			is not installed yet.
**		case 2:  The parent, or one of the ancestors of the the device
**			to be config'd is not installed yet.
*/

BYTE	*iemssg[] =
{
	"%0: %3 has not been completely installed.\n\r",
						/* %3 is ie1msg or ie2msg  */
	"",					/* use iemssg[0]	   */

	"%6%8"
						/* %6 is iemssg[0]	   */
						/* %8 is trymsg		   */
} ;


/*
**	nsdmsg -
**		device needs a subdrive
*/

BYTE	*nsdmsg[] =
{
	"%0: %3 is only partially installed.\n\r",
				/*  %3 is either ie1msg or ie2msg	*/
	"",			/*  use nsdmsg[0]			*/

	"%6%8",
				/*  %6 is nsdmsg[0]			*/
				/*  %8 is trymsg			*/
} ;

/*
**	ie1msg -, ie2msg -
**		to be used as insert paramters in iemssg
*/
BYTE	ie1msg[] 	= 	"%1" ;		/* %1 is device name	 */
BYTE	ie2msg[]	=	"%2, a device which controls %1,";
						/* %2 is uninstalled dev */


/*
**	trymsg -
**		used in various commands as parm 8
*/
BYTE	trymsg[] = "Try the command again.  If this message appears again, \
		then the\n\rDevice cannot be configured at this time.\n\r" ;

/*
**	cflmsg -
**		device conflict message
*/
BYTE	*cflmsg[] =
{
	"%0: %3" ,		/*  %3 is one of cfl1msg or cfl2msg	*/
	"%0: %6%7",		/*  %6 is cflmsg. %7 is cc0465		*/
	""
} ;

/*
**	cfl1msg -, cfl2msg -
**		for cflmsg.
*/
BYTE	cfl1msg[] = "Device Conflict opening %1.\n\r" ;
BYTE	cfl2msg[] = "%1 Device is Locked.\n\r" ;

/*
**  accmsg -
**	access error message
*/

BYTE	*accmsg[] =
{
	"%0: Access Error %3 %1.\n\r",
		/*  %3 is "opening", %1 is open device name		*/
	"",

	"%6%8"
} ;


/*
**  dnfmsg -
**	device not found
*/

BYTE	*dnfmsg[] =
{
	"%0: Device Not Found\n\r",
	cc0463,
	""
} ;


/*
**  typmsg -
**	table is of bad type
*/

BYTE	*typmsg[] =
{
	"%0: Bad Device Type",
	"%0: [%1] is not a Serial Device",
	"%7%3"
} ;


/*
**  internmsg -
**	internal error.
*/

BYTE	*internmsg[] =
{
	"%0: Internal Error %9(hex)\n\r",
	"%3",
	""
} ;

/*
**  inter1msg -
**	sub message for internmsg.
*/

BYTE	inter1msg[] =
	"\n\rInternal Error Code: %9(hex)\n\r" ;


