
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.1        FORMAT.H				 *
 *                      Header file for FORMAT utility.		 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *	1.1   08/01/85	jsr	Added FMERR027, FMERR028,	 *
 *				FMERR029, FMERR030 & BLASTSECS.	 *
 *	1.0   03/20/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* define some things for FORMAT */

#define	TEST		FALSE		     /* set to TRUE for TEST version */
				     /* also include CCDBUG.L86 in LINK file */

#define	NUMSWITCH	8			/* number of option switches */

#define	SWITCHB		0			    /* option switch indexes */
#define	SWITCHO		1
#define	SWITCHP		2
#define	SWITCHS		3
#define	SWITCHV		4
#define	SWITCH1		5
#define	SWITCH4		6
#define	SWITCH8		7

#define	NUMFMTS		5		     /* number of formats in library */

						 /* Format Library selectors */
#define	RMV5FF		0
#define	RMV5FE		1
#define	RMV5FD		2
#define	RMV5FC		3
#define	RMV5F9		4
#define	OEMFLOP		5

				    /* values for logical fixed disk formats */
#define	FXDSKDIR	0x0200			    /* number of DIR entries */
#define	FXDSKSEC	0x7fa8	   /* nsecs at which FATsize and SPB changes */
#define	SPB1		0x0008			/* SPB value for small disks */
#define	SPB2		0x0004			/* SPB value for large disks */

						       /* sector size values */
#define	SS128		128
#define	SS256		256
#define	SS512		512
#define	SS1024		1024
#define	SS2048		2048
#define	SS4096		4096

					  /* N values for above sector sizes */
#define	N128		(BYTE)0
#define	N256		(BYTE)1
#define	N512		(BYTE)2
#define	N1024		(BYTE)3
#define	N2048		(BYTE)4
#define	N4096		(BYTE)5

						     /* error SPECial values */
#define	SPEC_DEV	0x0000					   /* device */
#define	SPEC_DM		0x0001				/* device: MBPR area */
#define	SPEC_DS		0x0002				  /* device: SYSAREA */
#define	SPEC_DB		0x0003				/* device: BOOT area */
#define SPEC_DF		0x0004				 /* device: FAT area */
#define	SPEC_DD		0x0005				 /* device: DIR area */
#define	SPEC_DOS	0x0006				 /* device: DOS area */
#define	SPEC_FILE	0x0010				       /* file (sys) */
#define	SPEC_VOL	0x0020				     /* volume label */

#define	BLINKR		5		     /* still alive blink rate value */

#define	REPLY0		0
#define	REPLY1		1
#define	REPLYSIZ	2

#define	BLASTSECS	100

						       /* error return codes */
#define	FMERR000	0		/* no error			     */
#define	FMERR001	1		/* device name too long		     */
#define	FMERR002	2		/* non-disk device specified	     */
#define	FMERR003	3		/* sector size too big		     */
#define	FMERR004	4		/* too many sectors per track	     */
#define	FMERR005	5		/* /P, /1 or /8 used on fixed disk   */
#define	FMERR006	6		/* Internal errors (switches, etc.)  */
#define	FMERR007	7		/* No OEM format provided for device */
#define	FMERR008	8		/* S_GET,S_LOOKUP or S_SET (non-DF)  */
#define	FMERR009	9		/* S_OPEN on device		     */
#define	FMERR010	10		/* S_READ or S_RDELIM on STDIN	     */
#define	FMERR011	11		/* S_SPECIAL (INITF)		     */
#define	FMERR012	12		/* S_SPECIAL (FMSYS)		     */
#define	FMERR013	13		/* S_SPECIAL (WRTSYS)		     */
#define	FMERR014	14		/* critical area error (RD/WRT)	     */
#define	FMERR015	15		/* S_MFREE error		     */
#define	FMERR016	16		/* partition size was too small	     */
#define	FMERR017	17		/* user abort			     */
#define	FMERR018	18		/* S_MALLOC error (no memory)	     */
#define FMERR019	19		/* S_SPECIAL (MDCHK)		     */
#define	FMERR020	20		/* S_CREATE or S_OPEN of sysfile     */
#define	FMERR021	21		/* sysfile "format" error	     */
#define	FMERR022	22		/* S_GET,S_LOOKUP or S_SET (DF)	     */
#define	FMERR023	23		/* fixed && (sdev == ddev)	     */
#define	FMERR024	24		/* Not enuf room for sysfile	     */
#define	FMERR025	25		/* S_READ or S_WRITE file	     */
#define	FMERR026	26		/* Not enuf room for non-sysfile     */
#define	FMERR027	27		/* user terminated (Ctrl-C)	     */
#define	FMERR028	28		/* user terminated (process)	     */
#define	FMERR029	29		/* S_SPECIAL (FMTRK)		     */
#define	FMERR030	30		/* S_SPECIAL (RDSYS)		     */

/**/
