/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 2.2        FORMAT.C				 *
 *                      Main module for FORMAT utility.		 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *      2.2    861119    reb    undo change 2.1
 *      2.1    861029   reb	corrected use of hidesecs        *
 *      2.0    10/24/86  KPB    Fix formula in fdrcalc to return *
 *                              the correct number of fat sectors*
 *	1.9    9/22/86	DR-K	Open the drive before call to	 *
 *				setfip to get the cmos idea of	 *
 *				what type/size drive we got here *
 *	1.8    7/29/86	DR-K	filesys didn't understand disk so*
 *				label would be placed into fat,  *
 *				do close then reopen in fmdovol	 *
 *	1.7    5/09/86  DR-K	modified for MetaWare compiler	 *
 *	1.6   11/22/85  dlb	Fixed problem that prevented     *
 *				file names from being entered in *
 *				lower case from the keyboard for *
 *				upper case only media.		 *
 *								 *
 *	1.5   09/25/85	jsr	Fixed parse problem that required*
 *				the format device to be found in *
 *				the PROCDEF table. Caused FORMAT *
 *				not to work when device name was *
 *				upper case or physical.		 *
 *	1.4   08/07/85	jsr	Fixed problem with no null on	 *
 *				end of "fmsfile" name after	 *
 *				shift to remove device name.	 *
 *				Optimized fmparseswi() search.	 *
 *	1.3   08/01/85	jsr	Added CRLF, DOSERR, terminate	 *
 *				code, require <CR> on menu pmpt, *
 *				blast disk if S_GET error, fixed *
 *				wrong block mappout problems.	 *
 *	1.2   06/06/85	jsr	Added "//" for network.		 *
 *	1.1   05/08/85	jsr	Fixed bug in FMFDCALC().	 *
 *	1.0   04/10/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* include some header files */

#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"format.h"

/* declare local (global) variables */

BYTE		fmtail[BUFSIZ];				     /* command tail */
BYTE		fmldef[DEVMAX];		      /* logical default device name */
BYTE		fmlfdev[DEVMAX];	       /* logical format device name */
BYTE		fmpfdev[DEVMAX];	      /* physical format device name */
BYTE		fmlsdev[DEVMAX];	       /* logical system device name */
BYTE		fmsfile[SPECMAX];		         /* system file spec */
BYTE		*fmbfptr;			    /* pointer to malloc buf */
WORD		fmdlims[2];				 /* input delimiters */
UWORD		fmbadblks;				  /* bad block count */
UWORD		fminti;					 /* interleave index */
UWORD		fmskew;					/* current skew rate */
UWORD		fmdff;				    /* default floppy format */
BOOLEAN		fmdevopen, fmfd, fmblink;		  /* condition flags */
BOOLEAN		fmswp, fmsws, fmswv;		      /* option switch flags */
BOOLEAN		fmsw1, fmsw4, fmsw8;
BOOLEAN		fmswb;
LONG		fmbfsiz;			       /* size of malloc buf */
LONG		fmfdnum;			/* format device file number */
LONG		fmfoff;			   /* byte offset of file area start */
DISK		fmdtbl;			    /* format device DISK_INFO table */
FMTINFO		*fmtptr;		      /* selected format FMTINFO ptr */
MCB		fmmcb;				    /* Message Control Block */
jumpbuff	fmjbuf;		      /* error bailout transfer control info */



/* cast local procedures */

BOOLEAN	fmmore();
VOID	fminit(), fmsetup(), fmtsys(), fmtdsk();
VOID	fmmediainit(), fmdovol(), fmfreeup(), fmgtdinfo();
VOID	fmparseswi(), fmgetfmt(), fmfdcalc(), fmcheck();

/* declare external variables */
							  /* from FMTLIB.OBJ */
EXTERN	FMTINFO	fmtlib[];
							  /* from CCMSGS.L86 */
EXTERN	BYTE	valchar[], numconv[], nullstr[], defname[], dblslant[];
EXTERN	BYTE	carret, eschar, devdelim, extdelim, blank, tab;
EXTERN	BYTE	crlfmsg[];

EXTERN	BYTE	cc0306[], cc0312[], cc0317[];
EXTERN	BYTE	*cc0602[];
							 /* from FMTMSGS.OBJ */
EXTERN	BYTE	fm0000[], fm0001[], fm0003[];
EXTERN	BYTE	*fm0010[], fm0011[];
EXTERN	BYTE	fm0022[], fm0023[], fm0024[];
EXTERN	BYTE	fm0040[], fm0041[], fm0042[], fm0043[];
EXTERN	BYTE	fm0044[], fm0045[], fm0047[];

/* declare external procedures */
							  /* from OEMFMT.OBJ */
EXTERN	VOID	setfip();
							  /* from FMTLIB.OBJ */
EXTERN	VOID	fmlibint();
							    /* from FMUTLS.C */
EXTERN	BOOLEAN	fmynpmpt();
EXTERN	VOID	fmtdos(), fmtcon();
EXTERN	VOID	fmmemalloc(), fmgtdsk();
EXTERN	VOID	fmfatinit(), fmfatwrt();
EXTERN	VOID	fmdirinit(), fmdirwrt();
EXTERN	VOID	fmbotinit(), fmbotwrt();
EXTERN	VOID	fmmbprinit(), fmmbprwrt();
EXTERN	VOID	fmsyawrt(), fmterminate();
							  /* from FMERHAND.C */
EXTERN	VOID	fmxfmap(), fmerhand();
							  /* from CCUTLS.L86 */
EXTERN	LONG	utstjmp();
EXTERN	BYTE	utgtsch(), ut2upr();
EXTERN	BYTE	*utskpwht(), *utskpzro(), *utul2ds();
EXTERN	WORD	utds2i(), utxfrsys();
EXTERN	LONG	utslen(), utgtdf(), utprnmsg();
EXTERN	VOID	strcat(), utt1();
EXTERN	VOID	utintmcb(), uterrmsg();
							   /* from CCRTL.L86 */
EXTERN	LONG	e_termevent();
EXTERN	LONG	s_close(), s_get(), s_lookup(), s_open();
EXTERN	LONG	s_rdelim(), s_set(), s_special();
EXTERN	LONG	s_write(), s_mfree();
							  /* from CCDBUG.L86 */
#if TEST
EXTERN	VOID	dbpstr();
#endif

/* start of code */

LONG utlmain(rawtail)

BYTE	*rawtail;

{

    WORD	xferr;
    BOOLEAN	active;

    e_termevent( fmterminate, (LONG)0);

    if( (fmmcb.retcode = utstjmp(fmjbuf)) != 0)
    {
	if(fmdevopen)
	    s_close(0, fmfdnum);		   /* close device on errors */
	uterrmsg(&fmmcb, STDERR, FATAL);
	goto bailout;
    }

    active = TRUE;
    utt1(rawtail, fmtail);		   /* strip any garbage from rawtail */
    fminit(fmtail);		/* parse command tail and perform main setup */
    while(active)			  /* while a disk is to be formatted */
    {
	fmsetup();				/* get ready for disk format */
	fmtsys();				  /* format it's system area */
	fmtdsk();			      /* format the rest of the disk */
	fmmediainit();					 /* logically format */
	if(fmswv)				   /* volume label desired ? */
	    fmdovol();
	fmfreeup();			 /* close format device, free memory */
	if(fmsws)					 /* system file xfer */
	    if( (xferr = utxfrsys(fmlfdev, fmlsdev, fmsfile, &fmmcb)) !=0)
		fmxfmap(xferr);
	active = fmmore();     /* check if another format is to be performed */
    }
    fmmcb.retcode = UR_SUCCESS;

bailout:

    s_write(WRF_END, STDOUT, (LONG)crlfmsg, utslen(crlfmsg), (LONG)0);

    if(fmmcb.retcode < 0)
	fmmcb.retcode = (UR_SOURCE | UR_DOSERR);

    return(fmmcb.retcode);
}

/* local procedures */

/* fminit() : initialize variables etc, and parse command tail */

VOID fminit(tail)

REG BYTE	*tail;

{

    REG	BYTE	*ptr;
    BYTE	switchar;
    BYTE	temp[BUFSIZ];
    REG WORD	i;
    DEFINE	defbuf;			      /* default device buffer table */

						/* initialize some variables */
    fmtptr = 0;

    fmsfile[0] = fmlsdev[0] = fmlfdev[0] = fmpfdev[0] = fmldef[0] = NULL;

    fmfd = fmdevopen = fmswp = fmsws = fmswb =
      fmswv = fmsw1 = fmsw4 = fmsw8 = FALSE;		      /* reset flags */

    fmdlims[0] = 1;
    fmdlims[1] = carret;

    utintmcb(&fmmcb,fm0000,fmlfdev,nullstr,nullstr,nullstr);    /* setup MCB */

    fmdff = utds2i(fm0003);
    fmlibint();				      /* initialize internal library */
    switchar = utgtsch();		     /* get current switch character */

    if((fmmcb.retcode =
      utgtdf(defname, &defbuf, GDLITR, &fmmcb)) <= 0)		 /* ldef dev */
    {
	if(!fmmcb.retcode)
	    fmerhand(FMERR006, 0, (UR_SOURCE|UR_INTERNAL), SPEC_DEV);
	else
	    fmerhand(FMERR008, fmmcb.dosfunc, fmmcb.retcode, SPEC_DEV);
    }
    strcat(fmldef, defbuf.def_prefix);
					    /* parse command line for fmtdev */
    tail = utskpwht(tail);
    i = 0;
    ptr = tail;
    while(*ptr && (*ptr != switchar))			/* check for fmt dev */
    {
	if(i < (BUFSIZ - 1))
	    temp[i] = *ptr;			     /* store char in buffer */
	if((*ptr==devdelim)&&(*(ptr+1)!=devdelim)&&(*(ptr-1)!=devdelim))
	{
	    temp[++i] = NULL;		  /* stop if devdelim and not a node */
	    break;
	}
	++i;							     /* next */
	++ptr;
    }
    ptr = (*ptr == devdelim) ? temp : fmldef;		  /* default if none */
    if(utslen(ptr) >= (DEVMAX - 1)) 		 /* check device name length */
	fmerhand(FMERR001, 0, (UR_SOURCE|UR_PARM), SPEC_DEV);
    strcat(fmlfdev, ptr);		/* save device name string in buffer */

    if((fmmcb.retcode = s_lookup(PATH_INFO,LUF_FCAS,fmlfdev,&temp,
      (LONG)sizeof(temp),(LONG)sizeof(temp),(LONG)0)) <= 0)	/* get pfdev */
    {
	fmmcb.pptr[PARM4] = cc0317;
	if(!fmmcb.retcode)
	    fmerhand(FMERR006, 0, (UR_SOURCE|UR_INTERNAL), SPEC_DEV);
	else
	    fmerhand(FMERR008, S_LOOKUP, fmmcb.retcode, SPEC_DEV);
    }
    ptr = (BYTE *)(temp + utslen(temp) - 1);
    while((ptr > temp) && (*ptr != devdelim))
	--ptr;
    *++ptr = NULL;
    strcat(fmpfdev, temp);
    strcat(fmpfdev, dblslant);
						       /* parse any switches */
    fmparseswi(tail, switchar);
					  /* check if disk and get disk info */
    fmgtdinfo();

    fmgetfmt();				    /* set up "fmtptr" (and "fmfd" ) */
    if(fmfd)						   /* fixed disk ... */
    {
	if(fmdtbl.dsk_ioptions & DIO_PDD)	      /* with partitions ... */
	{
	    fmtptr->fi_nsecs = fmdtbl.dsk_nsectors;	  /* use partition - */
	    fmtptr->fi_hidesecs = fmdtbl.dsk_nhidesecs;   /* sensitive info */
	}
	fmfdcalc();		/* calculate secblk, nfsecs, dirsize, format */
    }
}

/* fmsetup() : setup for disk format */

VOID fmsetup()
{

    MDB		mdb;

    fmmemalloc();				     /* allocate some memory */
    fmgtdsk();				     /* prompt for format disk ready */

    mdb.mdb_ssize = fmtptr->fi_ssize;			       /* set up mdb */
    mdb.mdb_firstsec = fmtptr->fi_bootsecs;
    mdb.mdb_nsectors = fmtptr->fi_nsecs;
    mdb.mdb_spt = fmtptr->fi_spt;
    mdb.mdb_spb = fmtptr->fi_spb;
    mdb.mdb_nfats = fmtptr->fi_nfats;
    mdb.mdb_media = fmtptr->fi_media;
    mdb.mdb_fsecs = fmtptr->fi_fsecs;
    mdb.mdb_dirsize = fmtptr->fi_dirsize;
    mdb.mdb_nheads = fmtptr->fi_nhds;
    mdb.mdb_format = fmtptr->fi_format;
    mdb.mdb_sysize = fmtptr->fi_sysize;
    mdb.mdb_hidesecs = fmtptr->fi_hidesecs;

					     /* NOTE: no syssize added below */
    fmfoff = (LONG)fmtptr->fi_ssize * (LONG)(fmtptr->fi_bootsecs +
      (LONG)(fmtptr->fi_nfats * fmtptr->fi_fsecs) +
      ((fmtptr->fi_dirsize * BPDE) / fmtptr->fi_ssize));

    if((fmfdnum =
      s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS|OP_PMOUNT),(LONG)fmpfdev))<SUCCESS)
	    fmerhand(FMERR009, S_OPEN, fmfdnum, SPEC_DEV); /* fmtdev openerr */
    fmdevopen = TRUE;

    if((fmmcb.retcode=s_special(SPF_INITF,0,fmfdnum,&mdb,(LONG)sizeof(mdb),
      (LONG)0,(LONG)0)) < SUCCESS)
	fmerhand(FMERR011, S_SPECIAL, fmmcb.retcode, SPEC_DEV);

    fmblink = TRUE;
    fmbadblks = fminti = fmskew = 0;
    fmfatinit(fmbfptr);
    utprnmsg(fm0045, fmmcb.pptr, STDOUT);		     /* "Formatting" */
}

/* fmtsys() : format the system area */

VOID fmtsys()
{

    REG BYTE	*bp;

    if(fmtptr->fi_sysize)			  /* if a system area exists */
    {
	bp = (BYTE *)(fmbfptr + (fmtptr->fi_fsecs * fmtptr->fi_ssize));

	if(fmdtbl.dsk_ioptions & DIO_PDD)	    /* on a partitioned disk */
	{
	    if((fmmcb.retcode = s_special(SPF_RDSYS, 0, fmfdnum, (LONG)bp,
	      fmtptr->fi_sysize, (LONG)0, (LONG)0)) < SUCCESS)
		fmerhand(FMERR030, S_SPECIAL, fmmcb.retcode, SPEC_DS);
	}

	else					/* on a non-partitioned disk */
	    if((fmmcb.retcode = s_special(SPF_FMSYS, 0, fmfdnum, (LONG)0,
	      (LONG)0, (LONG)0, (LONG)0)) < SUCCESS)
		fmerhand(FMERR012, S_SPECIAL, fmmcb.retcode, SPEC_DS);
    }
}

/* fmtdsk() : format non-system disk area */

VOID fmtdsk()
{
    if(fmtptr->fi_ltype == DOSLIST)
	fmtdos();
    else
	fmtcon();
}

/* fmmediainit() : write out sysarea, mbpr, boot, fat and directory images */

VOID fmmediainit()
{
					      /* first, write out the FAT(s) */
    fmfatwrt(fmbfptr, (LONG)fmtptr->fi_fsecs * fmtptr->fi_ssize);
					    /* then clear the directory area */
    fmdirinit(fmbfptr);
					/* then write out the directory area */
    fmdirwrt(fmbfptr, (LONG)(fmtptr->fi_dirsize * BPDE));
				    /* now initialize the boot record header */
    fmbotinit();
				       /* and then write out the boot record */
    fmbotwrt(fmbfptr, (LONG)(fmtptr->fi_bootsecs * fmtptr->fi_ssize));
				   /* next initialize the MBPR (if necessary */
    fmmbprinit();
				  /* then write out the MBPR (if neccessary) */
    fmmbprwrt(fmbfptr,(LONG)(fmtptr->fi_hidesecs * fmtptr->fi_ssize));
				      /* lastly, write out any given sysarea */
    fmsyawrt();
			 /* that's it, so show the "format complete" message */
    utprnmsg(fm0047, fmmcb.pptr, STDOUT);
}

/* fmdovol() : handle prompting for and writing out a volume label */

VOID fmdovol()
{

    REG BYTE	*ptr1, *ptr2, *ptr3;
    BYTE	c, volbuf[VOLMAX + 2];
    REG WORD	i;
    REG BOOLEAN	invalid, pret;
					/* close then reopen the drive, so */
    s_close(0,fmfdnum);			/* it will be logged in correctly */
    if((fmfdnum =
      s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS|OP_LMOUNT),(LONG)fmpfdev))<SUCCESS)
	    fmerhand(FMERR009, S_OPEN, fmfdnum, SPEC_DEV); /* fmtdev openerr */
    fmdevopen = TRUE;

    if((fmmcb.retcode =
      s_get(DISK_INFO,fmfdnum,(LONG)&fmdtbl,
      (LONG)sizeof(fmdtbl))) < SUCCESS)
    {
	fmmcb.pptr[PARM4] = cc0306;
	fmerhand(FMERR008, S_GET, fmmcb.retcode, SPEC_DEV);  /* DISK get err */
    }

    invalid = TRUE;			/* set a flag, for validity of entry */

    while(invalid)
    {
	for(i = 0; i <= VOLMAX + 1; ++i)
	    volbuf[i] = NULL;

	utprnmsg(fm0022, fmmcb.pptr, STDOUT);		      /* prompt user */
	if((fmmcb.retcode = s_rdelim((RDF_FLS|RDF_DLM|RDF_EDT|RDF_FP),
	  STDIN,(LONG)volbuf,(LONG)VOLMAX,(LONG)0,fmdlims)) < SUCCESS)
	    fmerhand(FMERR010, S_RDELIM, fmmcb.retcode, SPEC_DEV);
	if(!fmmcb.retcode)
	{
	    invalid = FALSE;
	    break;		     /* no volume desired, get out from here */
	}

	ptr1 = volbuf;
	ptr2 = fmdtbl.dsk_label;

	while(*ptr1)
	{
	    c = valchar[0];		     /* get number of chars in array */
	    if(fmdtbl.dsk_lamode & DLM_CSE)	    /* lower case valid also */
		for(i=1;((i<=c)&&(ut2upr(*ptr1)!=valchar[i]));++i);
	    else
		{
		   ptr3 = ptr1;
		   while (*ptr3)
		   {
			*ptr3 = ut2upr (*ptr3);
			ptr3++;
		   }
		for(i=1;((i<=c)&&(*ptr1!=valchar[i]));++i);
		}

	    if(i > c)
		break;				    /* abort if invalid char */

	    *ptr2++ = *ptr1++;			    /* else accept this char */
	}

	*ptr2 = NULL;

	if(i > c)					  /* if invalid char */
	{
	    fmmcb.pptr[PARM5] = volbuf;
	    utprnmsg(fm0023, fmmcb.pptr, STDOUT);	     /* report error */
	    continue;			 /* go reprompt user and retry input */
	}

	if(utslen(volbuf) > FILMAX - 2)	     /* insert extdelim if > 8 chars */
	{
	    for(i = FILMAX - 2; i <= VOLMAX; ++i)
		volbuf[i + 1] = volbuf[i];
	    volbuf[FILMAX - 2] = extdelim;
	}

	pret = fmynpmpt(fm0024);		  /* file security desired ? */
	if(pret)
	    fmdtbl.dsk_lamode |= DLM_FSE;	      /* set cntl bit if YES */
	else
	    fmdtbl.dsk_lamode &= ~DLM_FSE;	     /* reset cntl bit if NO */

	if((fmmcb.retcode=s_set(DISK_INFO,fmfdnum,(LONG)&fmdtbl,
	  (LONG)sizeof(fmdtbl))) < SUCCESS)	  /* S_SET the DISK_INFO tbl */
	{
	    fmmcb.pptr[PARM4] = cc0306;
	    fmerhand(FMERR008, S_SET, fmmcb.retcode, SPEC_VOL);
	}
	invalid = FALSE;
    }
}

/* fmfreeup() : close format device and free up memory */

VOID fmfreeup()
{
    s_close(0,fmfdnum);				      /* close format device */
    fmdevopen = FALSE;
    if((fmmcb.retcode = s_mfree(fmbfptr)) < SUCCESS)
	fmerhand(FMERR015, S_MFREE, fmmcb.retcode, SPEC_DEV);
}

/* fmmore() : check if another to do */

BOOLEAN fmmore()
{

    BYTE	numtext[LBUFSIZ];
    REG BOOLEAN	ret;
    LONG	tds, bus, bbs, bad;

    ret = FALSE;		    /* TRUE = another format operation to do */
					    /* calculate the Total Disk Size */
    tds = (fmtptr->fi_nsecs * fmtptr->fi_ssize) + fmtptr->fi_sysize;
					   /* calculate Bytes Used by System */
    bus = fmtptr->fi_sysize;
    bus += (((fmtptr->fi_nfats * fmtptr->fi_fsecs) +
      fmtptr->fi_bootsecs) * fmtptr->fi_ssize);
    bus += (fmtptr->fi_dirsize * BPDE);
				 /* calculate number of Bytes in Bad Sectors */
    bbs = fmbadblks * fmtptr->fi_spb * fmtptr->fi_ssize;
					/* calculate Bytes Available on Disk */
    bad = tds - bus - bbs;
						      /* print status report */
    fmmcb.pptr[PARM5] = utskpzro(utul2ds(tds, numtext));
    utprnmsg(fm0040, fmmcb.pptr, STDOUT);
    fmmcb.pptr[PARM5] = utskpzro(utul2ds(bus, numtext));
    utprnmsg(fm0041, fmmcb.pptr, STDOUT);
    if(bbs != 0)
    {
	fmmcb.pptr[PARM5] = utskpzro(utul2ds(bbs, numtext));
	utprnmsg(fm0042, fmmcb.pptr, STDOUT);
    }
    fmmcb.pptr[PARM5] = utskpzro(utul2ds(bad, numtext));
    utprnmsg(fm0043, fmmcb.pptr, STDOUT);

				/* now check if user wants more formats done */
    if(!fmfd)		     /* ask only if removable media in format device */
	ret = fmynpmpt(fm0044);

    return(ret);
}

/* fmparseswi() : parse out switches from tail */

VOID fmparseswi(tail, switchar)

BYTE	switchar, *tail;

{

    BYTE	option;
    REG BYTE	*ptr, *ptr1, *ptr2;
    REG WORD	i;

					  /* parse command tail for switches */
    ptr = tail;
    while(*ptr) 			       /* now scan tail for switches */
    {
      if(*ptr++ == switchar)
      {
	option = ut2upr(*ptr);

	for(i = 0; i < NUMSWITCH; ++i)
	{
	  if(option == fm0001[i])
	  {
	    switch(i)
	    {

	      case SWITCHB:
		++ptr;
		break;

	     case SWITCHO:
		++ptr;				     /* ignore, but no error */
		break;

	      case SWITCHP:
		fmswp = TRUE;		/* fmswp set, prompt user for format */
		++ptr;
		break;

	      case SWITCHS:
		fmsws = TRUE;   /* fmsws set, xfer system files after format */
		++ptr;
		ptr1 = fmsfile;			  /* save any given filespec */
		while(*ptr&&(*ptr!=blank)&&(*ptr!=tab)&&(*ptr!=switchar))
		  *ptr1++ = *ptr++;
		*ptr1 = NULL;
		break;

	      case SWITCHV:
		fmswv = TRUE;	       /* fmswv set, prompt for volume label */
		++ptr;
		break;

	      case SWITCH1:
		fmsw1 = TRUE;	       /* fmsw1 set, select one sided format */
		++ptr;
		break;

	      case SWITCH4:
		fmsw4 = TRUE;	   /* fmsw4 set, select 9 sector 2 sided fmt */
		++ptr;
		break;

	      case SWITCH8:
		fmsw8 = TRUE;	      /* fmsw8 set, select 8 sectored format */
		++ptr;
		break;

	      default:
		fmerhand(FMERR006, 0, (UR_SOURCE|UR_INTERNAL), SPEC_DEV);
		break;
	    }
	    break;
	  }
	}
      }
    }
						/* setup to get sysfile info */
    if(fmsws)						 /* if /S active ... */
    {
	if(fmsfile[0] == NULL)			 /* if no filespec given ... */
	    strcat(fmlsdev, fmldef);		       /* pass default drive */
	else					  /* something was given ... */
	{
	    ptr = (BYTE *)(fmsfile + utslen(fmsfile));  /* device included ? */
	    while((ptr > fmsfile) && (*ptr != devdelim))
		--ptr;

	    if(*ptr == devdelim)			  /* device included */
	    {
		ptr1 = fmsfile;
		ptr2 = fmlsdev;
		while(ptr1 <= ptr)		    /* use given device spec */
		 *ptr2++ = *ptr1++;
		*ptr2 = NULL;
		++ptr;
	    }
	    else				       /* no device included */
		strcat(fmlsdev, fmldef);	    /* so pass default drive */

	    ptr1 = fmsfile;
	    while(*ptr)
		*ptr1++ = *ptr++;		      /* shift filespec down */
	    *ptr1 = NULL;
	}
    }

#if TEST
    if(fmswp)
	dbpstr("\r\nP switch set.");
    if(fmsws)
	dbpstr("\r\nS switch set.");
    if(fmswv)
	dbpstr("\r\nV switch set.");
    if(fmsw1)
	dbpstr("\r\n1 switch set.");
    if(fmsw8)
	dbpstr("\r\n8 switch set.");
#endif

}

/* fmfdcalc() : calculate secblk, fsecs, dirsize and format		     */
/* This routine should be IBM PCDOS 3.0 compatible.			     */

VOID fmfdcalc()
{

    BYTE	buf[LBUFSIZ];
    LONG	x, y, minsize;
    LONG        HoldLong;

    fmtptr->fi_dirsize = FXDSKDIR;
    HoldLong = fmtptr->fi_nsecs;
    HoldLong -= ((32 * FXDSKDIR) / fmtptr->fi_ssize);

    if(fmtptr->fi_nsecs > FXDSKSEC)
    {
	fmtptr->fi_spb = SPB2;
	fmtptr->fi_format = DFM_DOS2;
    }
    else
    {
	fmtptr->fi_spb = SPB1;
	fmtptr->fi_format = DFM_DOS1;
    }

						    /* calc # of fat entries */
    x = HoldLong / fmtptr->fi_spb;
							 /* calc size factor */
    y = x;
    if(fmtptr->fi_format == DFM_DOS1)
    {
	y = x / 2;
	if(x & 1)
	   ++y;
    }
				     /* calc minimum size in bytes for a FAT */
    x += y;
			

    x = x/ fmtptr->fi_ssize;
    x = x * fmtptr->fi_nfats;
    x = (HoldLong - x) / fmtptr->fi_spb;

    y = x;
    if(fmtptr->fi_format == DFM_DOS1)
    {
	y = x / 2;
	if(x & 1)
	   ++y;
    }
				     /* calc minimum size in bytes for a FAT */
    x += y;
    /* calc # of sectors for a FAT */
    fmtptr->fi_fsecs = x / fmtptr->fi_ssize;
    if(x % fmtptr->fi_ssize)
	++fmtptr->fi_fsecs;

    minsize = (fmtptr->fi_nfats * fmtptr->fi_fsecs) +
      (fmtptr->fi_dirsize / (fmtptr->fi_ssize / BPDE)) +
      fmtptr->fi_bootsecs;
    if(fmtptr->fi_nsecs < minsize)
    {
	minsize = ((minsize / fmtptr->fi_spt) / fmtptr->fi_nhds);
	fmmcb.pptr[PARM5] = utskpzro(utul2ds(minsize, buf));
	fmerhand(FMERR016, 0, (UR_SOURCE|UR_FORMAT), SPEC_DEV);
    }
}

/* fmgetfmt() : set "fmtptr" for desired format */

VOID fmgetfmt()
{

    REG	BYTE	*ptr;
    BYTE	nfmts[2], buf[2];
    WORD	dlims[3];
    REG WORD	i;

    if(!(fmdtbl.dsk_type & DTP_RMV))		    /* non-removable media ? */
    {
	fmfd = TRUE;					  /* device is fixed */

	if( !fmdevopen ) 	/* hard drive needs to be open before setfip call */
	    if((fmfdnum =
	      s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS|OP_PMOUNT),(LONG)fmpfdev))<SUCCESS)
		    fmerhand(FMERR009,S_OPEN,fmfdnum,SPEC_DEV);   /* fmtdev open err */
	fmdevopen = TRUE;

	setfip(&fmtptr, fmfdnum, &fmdtbl);		/* get OEM disk info */
	if(fmtptr == 0)
	    fmerhand(FMERR007,0,(UR_SOURCE|UR_FORMAT),SPEC_DEV);/* no OEMfmt */

	fmcheck();					 /* check OEM format */
	return;			    /* exit, fixed disk format selected okay */
    }

    if(!fmswp)					/* use default floppy format */
    {
	if(fmdff != OEMFLOP)			 /* use format library entry */
	    fmtptr = &fmtlib[fmdff];
	else
	{
	    setfip(&fmtptr, fmfdnum, &fmdtbl);		/* get OEM disk info */
	    if(fmtptr == 0)
		fmerhand(FMERR007,0,(UR_SOURCE|UR_FORMAT),SPEC_DEV);
	}

	fmcheck();				    /* check selected format */
	return;			   /* exit, floppy disk format selected okay */
    }

    for(i = 0; i <= NUMFMTS; ++i)		    /* print menu of formats */
	utprnmsg(fm0010[i], fmmcb.pptr, STDOUT);
						    /* set up prompt message */
    nfmts[0] = numconv[NUMFMTS + 1];
    nfmts[1] = NULL;
    fmmcb.pptr[PARM5] = nfmts;
							/* set up delimiters */
    dlims[0] = 2;
    dlims[1] = (WORD)carret;
    dlims[2] = (WORD)eschar;

    while(fmtptr == 0)				    /* get a valid selection */
    {
	utprnmsg(fm0011, fmmcb.pptr, STDOUT);		      /* prompt user */

	if((fmmcb.retcode =
	  s_rdelim((RDF_FLS|RDF_DLM|RDF_INC|RDF_EDT|RDF_FP), STDIN,
	  (LONG)buf, (LONG)sizeof(buf),(LONG)0, (LONG)dlims)) < SUCCESS)
	    fmerhand(FMERR010, S_RDELIM, fmmcb.retcode, SPEC_DEV);

	ptr = (BYTE *)(buf + fmmcb.retcode - 1);

	if(*ptr == eschar)
	    fmerhand(FMERR017,0,(UR_SOURCE|UR_UTERM),SPEC_DEV); /* usr abort */

	if((*ptr != carret) && (fmmcb.retcode != 2))		 /* reprompt */
	    continue;

	for(i = 1; i <= (NUMFMTS + 1); ++i)
	    if(numconv[i] == buf[0])
		break;			   /* break if valid selection match */

	switch(i)
	{
	    case 1:
	    case 2:
	    case 3:
	    case 4:
	    case 5:
		fmtptr = &fmtlib[i - 1];	     /* use a library format */
		break;	    
	    case 6:
		setfip(&fmtptr, fmfdnum, &fmdtbl);	   /* get OEM format */
		if(fmtptr == 0)
		{
		    utprnmsg(cc0602[HLVL2], fmmcb.pptr, STDOUT);
		    continue;
		}
		break;
	}
    }

    fmcheck();
}

/* fmcheck() : check if given OEM format doesn't exceed limits */

VOID fmcheck()
{
    if(fmfd && (fmswp || fmsw1 || fmsw4 || fmsw8))
	fmerhand(FMERR005, 0, (UR_SOURCE|UR_PARM), SPEC_DEV);
    if(!(fmfd || fmswp))
    {
	if(fmsw4)
	    fmtptr = &fmtlib[RMV5FD];
	if(fmsw1)
	    if(fmtptr->fi_nhds != 1)
		fmtptr=(fmtptr->fi_spt==8)?&fmtlib[RMV5FE]:&fmtlib[RMV5FC];
	if(fmsw8)
	    if(fmtptr->fi_spt != 8)
		fmtptr=(fmtptr->fi_nhds==1)?&fmtlib[RMV5FE]:&fmtlib[RMV5FF];
    }
    if(fmtptr->fi_ssize > MAXBPS)
    {
	fmmcb.pptr[PARM5] = fmdtbl.dsk_name;
	fmerhand(FMERR003, 0, (UR_SOURCE|UR_FORMAT), SPEC_DEV);
    }
    if(fmtptr->fi_spt > MAXSPT)
    {
	fmmcb.pptr[PARM5] = nullstr;
	fmerhand(FMERR004, 0, (UR_SOURCE|UR_FORMAT), SPEC_DEV);
    }
}

/* fmgtdinfo() : get information about format disk (sets fmdtbl info) */

VOID fmgtdinfo()
{

    BYTE	blastbuf[SS512];
    REG WORD	i;
    LONG	offset;
    FILENUM	fntbl;


    if((fmfdnum =
      s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS|OP_PMOUNT),(LONG)fmpfdev))<SUCCESS)
	    fmerhand(FMERR009,S_OPEN,fmfdnum,SPEC_DEV);   /* fmtdev open err */
    fmdevopen = TRUE;

    if((fmmcb.retcode =
      s_get(FNUM_INFO,fmfdnum,(LONG)&fntbl,(LONG)sizeof(fntbl))) < SUCCESS)
    {
	fmmcb.pptr[PARM4] = cc0312;
	fmerhand(FMERR008,S_GET,fmmcb.retcode,SPEC_DEV);   /* FNUM get error */
    }

    if(fntbl.fn_table != DISK_INFO) 		/* error if not a dsk device */
	fmerhand(FMERR002, 0, (UR_SOURCE|UR_PARM), SPEC_DEV);

    if((fmmcb.retcode =
      s_get(DISK_INFO,fmfdnum,(LONG)&fmdtbl,(LONG)sizeof(fmdtbl)))<SUCCESS)
    {
	/*								*/
	/* NOTE: FORMAT needs to know the following non-media dependant	*/
	/* information:							*/
	/*								*/
	/*	1) Whether the device media is removable or not.	*/
	/*	2) Whether the device is partitioned or not.		*/
	/*	3) If the device IS partitioned, then it also needs ...	*/
	/*		3a) Size of the partition.			*/
	/*		3b) Offset of the partition.			*/
	/*								*/
	/*   All of this information is known once the device driver	*/
	/* is installed. However, since the S_GET(DISK_INFO) call also	*/
	/* returns media dependant information, it may fail under	*/
	/* certain conditions. This leaves FORMAT "up the creek" since	*/
	/* there is no other way (short of prompting the user) of	*/
	/* gathering this information. This is ultimately due to	*/
	/* deficiencies in the media determination routines in the	*/
	/* disk drivers. When the media is unformatted or formatted in	*/
	/* a known format, the media determination code works fine.	*/
	/* But, if the media is only physically formatted (readable)	*/
	/* or if it is only partially logically formatted, then the	*/
	/* drivers get confused. At this point they may think they	*/
	/* know the media type, without fully verifying their		*/
	/* their assumption. If the media type could not be fully	*/
	/* verified, the determination code should return that the	*/
	/* media is raw (unformatted).					*/
	/*								*/
	/*   In order to get around this problem, FORMAT (and DISKCOPY)	*/
	/* will be required to "blast" out zero bytes to the disk so	*/
	/* that the device driver will not get confused as to the media	*/
	/* type. How many bytes to write, and what sector size to use	*/
	/* for these writes is questionable.				*/
	/*								*/
	/*   This problem really should be fixed in the drivers, and	*/
	/* the kludge code removed from FORMAT and DISKCOPY.		*/
	/*								*/

			  /* open connection was broken, but close up anyway */
	s_close(0, fmfdnum);
	fmdevopen = FALSE;
					    /* now re-open the format device */
	if((fmfdnum =
	  s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS|OP_PMOUNT), (LONG)fmpfdev)) < SUCCESS)
	    fmerhand(FMERR009,S_OPEN,fmfdnum,SPEC_DEV);   /* fmtdev open err */
	fmdevopen = TRUE;
					       /* clear out the blast buffer */
	for(i = 0; i < SS512; ++i)
	    blastbuf[i] = 0;
						    /* blast out to the disk */
	for(i = 0, offset = 0; i < BLASTSECS; ++i, offset += SS512)
	{
	    s_write(WRF_BEG, fmfdnum, (LONG)blastbuf,
	      (LONG)sizeof(blastbuf), offset);
	}
					 /* now retry the DISK get operation */
	if((fmmcb.retcode = s_get(DISK_INFO, fmfdnum,
	  (LONG)&fmdtbl, (LONG)sizeof(fmdtbl))) < SUCCESS)
	{
	    fmmcb.pptr[PARM4] = cc0306;		/* give up if still an error */
	    fmerhand(FMERR008, S_GET, fmmcb.retcode, SPEC_DEV);
	}
    }

    s_close(0, fmfdnum);
    fmdevopen = FALSE;
}

/* */
