/******************************************************************************
* PANIC.H - System Panic Codes					Version 1.2.00
*******************************************************************************
* Copyright (c) 1985, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.2.00 04/03/86 FRH	Add XX_UNINT
* v1.0.03 12/11/85 MA	Added XX_MFTWO, XX_NOASR
* v1.0.02 12/04/85 mei  added XX_MX
* v1.0.01 08/17/85 FRH	Added XX_ABANY, XX_EVREM
* v1.0.00 08/01/85 GAT	FlexOS 286 1.0 Release Version
******************************************************************************/
/*
**  10/1/86  PKB
**  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
*/


#define	XX_NMI		0	/* NMI encountered			*/
#define XX_GP		1	/* GP exception while in system		*/
#define XX_DX		2	/* Double Jeopardy exception		*/
#define	XX_NEXTASR	3	/* Failure to call nextasr in asr 	*/
				/* 	causing an event.		*/
#define	XX_MGSIZE	4	/* MGETBLK - bad size 			*/
#define	XX_MGADDR	5	/* MGETBLK - bad addr in free list	*/
#define	XX_MGSPACE	6	/* MGETBLK - no space			*/
#define	XX_MFROOT	7	/* MFREBLK - bad root in hidden fields	*/
#define XX_TERM		8	/* Dispatches disabled calling terminate() */
#define XX_SALLOC	9	/* Dispatches disabled calling salloc()	*/
#define XX_MWAIT	10	/* Dispatches disabled calling mwait()	*/
#define XX_GOSWI	11	/* Cannot find SWI event in GOSWI	*/
#define XX_EXPEW	12	/* Exited expew with dispatches disabled*/
#define XX_INIT		13	/* Resource manager initialization failed */
#define XX_ABANY	14	/* Aborting process not in RUN state	*/
#define XX_EVREM	15	/* No e_pred in evremove		*/
#define XX_MX		16	/* Mutual exclusion failure		*/
#define XX_NOASR	17	/* Out of free ASRs			 */
#define XX_MFTWO	18	/* MFREBLK - attempt to free block twice */
#define XX_UNINT	19	/* Uninitialized Interrupt		*/

