h28606
s 00003/00003/00043
d D 1.2 83/01/28 13:54:37 tes 2 1
c initial_internal_update
e
s 00046/00000/00000
d D 1.1 83/01/28 13:02:56 tes 1 0
c date and time created 83/01/28 13:02:56 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gplinx (index, lstart, lend, ilabel, nmtics)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output a linear axis                                   #
#                                                                      #
#     Input Parameters:                                                #
#            index  - flag to indicate axis direction  (1=x, 2=y)      #
#            lstart - label starting value                             #
#            lend   - label ending value                               #
#            ilabel - number of labels on axis                         #
#            nmtics - number of tics per label                         #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gpgnax - generate an axis with labels                     #
#            gpitic - initialize tic environment                       #
#                                                                      #
########################################################################
integer index, ilabel, nmtics
real lstart, lend

D 2
PLOTxREALS PLOTxGETREAL
E 2
I 2
real gtreal 
E 2
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) index, lstart, lend
DxB 100 format (' gplinx:', i5, 2f10.5)
 
   natype(index) = LINEARxAXIS
   ntstat(index) = nmtics
   call gpitic (index)   # Set up axis tic environment
D 2
   call gptenv (index, PLOTxGETREAL(lstart), PLOTxGETREAL(lend), ilabel)
   call gpgnax (index, PLOTxGETREAL(lstart))   # Output axis
E 2
I 2
   call gptenv (index, gtreal (lstart, 0), gtreal (lend, 0), ilabel)
   call gpgnax (index, gtreal (lstart, 0))   # Output axis
E 2
 
   return
end
E 1
