h58577
s 00000/00000/00073
d D 1.2 83/03/31 12:47:02 mmm 2 1
c 
e
s 00073/00000/00000
d D 1.1 83/03/15 21:46:25 tes 1 0
c date and time created 83/03/15 21:46:25 by tes
e
u
4
U
t
T
I 1
subroutine gzvwtn
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: calculate the modeling and viewing transform           #
#                                                                      #
#     Input Parameters:                                                #
#            none                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzcpmt - copy a square matrix                             #
#            gzdtrm - calculate determinant of a matrix                #
#            gzinvs - calculate the inverse of a matrix                #
#            gzmtid - set a matrix to identity                         #
#            gzcale - calculate and set the current clipping edge      #
#                                                                      #
########################################################################
integer k3, kctn
real gzdtrm,
     tmat1(3,3), mat11, mat22, mat31, mat32
 
include(`gkscom')
 
# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       tmat1(1,1) :: mat11
#       tmat1(2,2) :: mat22
#       tmat1(3,1) :: mat31
#       tmat1(3,2) :: mat32
 
equivalence (tmat1(1,1), mat11), (tmat1(2,2), mat22),
            (tmat1(3,1), mat31), (tmat1(3,2), mat32)
 
   nview = 0
 
   k3 = 3
   call gzmtid (tmat1)

   # determine current transformation index
   kctn = nrmcur + 1
 
   #   tmat1(1,1) = (vxmax)-vxmin))/(wxmax)-wxmin))
   mat11 = (vxmaxl(kctn)-vxminl(kctn))/(wxmaxl(kctn)-wxminl(kctn))
 
   #   tmat1(2,2) = (vymax-vymin)/(wymax-wymin)
   mat22 = (vymaxl(kctn)-vyminl(kctn))/(wymaxl(kctn)-wyminl(kctn))
 
   #   tmat1(3,1) = vxmin - tmat1(1,1)*wxmin
   mat31 = vxminl(kctn) - mat11*wxminl(kctn)
 
   #  tmat1(3,2) = vymin - tmat1(2,2)*wymin
   mat32 = vyminl(kctn) - mat22*wyminl(kctn)
 
   if (abs(gzdtrm (tmat1)) >= zeps15) {
      call gzcpmt (tmat1, viewtx)
      call gzinvs (viewtx, rview)
      }

   call gzcale

   return
end
E 1
