h31726
s 00003/00004/00075
d D 1.2 83/03/31 12:37:28 mmm 2 1
c 
e
s 00079/00000/00000
d D 1.1 83/03/15 21:41:26 tes 1 0
c date and time created 83/03/15 21:41:26 by tes
e
u
4
U
t
T
I 1
subroutine grqvl (wkid, vldnr, inivl, valrng, stat, val)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Request valuator                                       #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#            lcdnr  - valuator device number                           #
#            inivl  - initial value                                    #
#            valrng - array containing legal range of value to return  #
#     Output Parameters:                                               #
#            stat - status (OK = 1, NONE = 0)                          #
#            val  - value                                              #
#                                                                      #
#     Errors:                                                          #
#            7 GKS not in proper state: GKS must be in one of the      #
#              states WSOP, WSAC or SGOP                               #
#           20 Specified workstation identifier is invalid             #
#           25 Specified workstation is not open                       #
#           36 Specified workstation is neither an input workstation   #
#              nor an output/input workstation                         #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - call current device driver                       #
#            errchk - perform appropriate error checking               #
#            grmnmx - bound a real input parameter                     #
#                                                                      #
########################################################################
integer wkid, vldnr, stat
real inivl, val, valrng(2)
 
integer contrl(5), intin(2), intout(1), ptsdum(1)

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')
D 2
real grmnmx, rval
REALS GETREAL
E 2
I 2
real grmnmx, rval, gtreal 
E 2
 
include(`gkscom')
 
ifdef(`ERROR_ON',`
      rounum = GRQVL
      errind = errchk(wkid, ierdum)
      ')
 
   rval = 0.0   # Initialize output parameter for no value
 
   contrl(OPCODE) = INPUTxVALUATOR
   contrl(VERTICESxIN) = 0

   intin(1) = vldnr
D 2
   intin(2) = GETREAL(inivl)
E 2
I 2
   intin(2) = gtreal (inivl, 0)
E 2
   # Initialize output for non-choice devices
   contrl(5) = NONE
   rval = 0.0

   call gzddop (contrl, intin, ptsdum, intout, ptsdum)
 
   stat = contrl(5)
 
   if (stat == OK) {
      # Ensure that the returned value is within the range    
      #   specified within the valuator data record in common    
      rval = grmnmx(float(intout(1)), valrng(1), valrng(2))
      }

D 2
   PUTREAL(rval, val)  # Put back into user format real
E 2
I 2
   call ptreal (rval, 0, val)  # Put back into user format real
E 2

   return
end
E 1
