h12122
s 00005/00006/00079
d D 1.2 83/03/31 12:30:04 mmm 2 1
c 
e
s 00085/00000/00000
d D 1.1 83/03/15 21:36:41 tes 1 0
c date and time created 83/03/15 21:36:41 by tes
e
u
4
U
t
T
I 1
subroutine gicla (wkid,pxy,nmax,mmax,errind,invval,n,m,colia)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire a cell array                                   #
#                                                                      #
#     Input Parameters:                                                #
#            wkid    - workstation identifier                          #
#            pxy(1)  - lower left x point in world coordinates         #
#            pxy(2)  - lower left y point in world coordinates         #
#            pxy(3)  - upper right x point in world coordinates        #
#            pxy(4)  - upper right y point in world coordinates        #
#            nmax    - number of elements in each row                  #
#            mmax    - number of rows in color index array             #
#                                                                      #
#     Output Parameters:                                               #
#            errind  - error indicator                                 #
#            invval  - presence of invalid values in color index array #
#            n       - number of elements in each row used             #
#            m       - number of rows used in color index array        #
#            colia   - color index array                               #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in the state      #
#               WSAC or in the state SGOP                              #
#           20  Specified workstation identifier is invalid            #
#           25  Specified workstation is not open                      #
#           37  Specified workstation is not an output workstation     #
#               nor an output/input workstation                        #
#           38  Specified workstation has no pixel store readback      #
#               capability                                             #
#           85  Dimensions of color array are invalid                  #
#                                                                      #
#     Routines Called:                                                 #
#               gwddc2 - convert/clip line from world to device        #
#               gzddop - d/i driver interface                          #
#               errchk - perform necessary error checking              #
#                                                                      #
########################################################################
integer wkid, nmax, mmax, errind, invval, n, m, colia(1)     
real pxy(4)

D 2
real tpxy(4)
REALS GETREAL
E 2
I 2
real tpxy(4), gtreal
E 2

ifdef(`ERROR_ON',`
   integer errchk, ierary(2), erary1, erary2
   ')

include(`gkscom')
ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1), (ierary(2), erary2)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GICLA
      #   ierary(1) = wrktyp; ierary(2) = nmax * mmax
      erary1 = wrktyp
      erary2 = nmax * mmax
      errind = errchk (wkid, ierary)
      if (errind !=  0) return
      ')

   # Convert from user format reals to fortran real format
D 2
   tpxy(1) = GETREAL(pxy(1))
   tpxy(2) = GETREAL(pxy(2))
   tpxy(3) = GETREAL(pxy(3))
   tpxy(4) = GETREAL(pxy(4))
E 2
I 2
   tpxy(1) = gtreal (pxy, 0)
   tpxy(2) = gtreal (pxy, 1)
   tpxy(3) = gtreal (pxy, 2)
   tpxy(4) = gtreal (pxy, 3)
E 2

   # Check for invalid cell array corners
   if (tpxy(3) < tpxy(1) | tpxy(4) < tpxy(2)) return

   call gzcell (tpxy, nmax, mmax, invval, n, m, colia)

   return
end
E 1
