h45068
s 00975/00000/00000
d D 1.1 83/03/17 17:59:06 bog 1 0
c date and time created 83/03/17 17:59:06 by bog
e
u
4
U
t
T
I 1
      SUBROUTINE GIOINI (DEVICE)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: INITIALIZE GSS-CORE I/O                                C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            DEVICE - OUTPUT GRAPHIC DEVICE                            C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED:                                                 C
C            GIOCHN - SET GRAPHIC INPUT / OUTPUT CHANNELS BASE ON      C
C                     DEVICE                                           C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER DEVICE
      INTEGER*1 CINMAX,CINCNT
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      EQUIVALENCE (CINMAX , CINBUF(1))
      EQUIVALENCE (CINCNT , CINBUF(2))
C
C     INITIALIZE CHARACTER COUNTS AND POINTERS
C
C     CINPTR AND CINCNT ARE INITIALIZED TO THE MAXIMUM SO THAT THE
C     FIRST ATTEMPT TO READ A CONSOLE CHARACTER FINDS THE CONSOLE
C     CHARACTER BUFFER EMPTY AND FORCES A NEW BUFFER TO BE READ.
C
      CINMAX = 80
      CINCNT = CINMAX + 1
      CINPTR = CINMAX + 3
C
C     SET STANDARD INPUT CHANNEL AND OUTPUT CHANNEL
C
      STDIN = 1
      STDOUT = 2
C
C     SET CURRENT INPUT CHANNEL AND OUTPUT CHANNEL
C
      CINCHN = STDIN
      COTCHN = STDOUT
C
C     UPDATE CURRENT GRAPHIC DEVICE INPUT AND OUTPUT CHANNELS
C     BASED ON DEVICE
C
      CALL GIOCHN (DEVICE)
C
      RETURN
      END
      SUBROUTINE GIOCHN (DEVICE)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: SET THE INPUT/OUTPUT CHANNELS FOR A GIVEN GRAPHIC      C
C               DEVICE                                                 C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            DEVICE - OUTPUT DEVICE TO BE USED                         C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED:                                                 C
C            DIVID - DIVIDE 2 UNSIGNED 16-BIT NUMBERS                  C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER DEVICE
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
      INTEGER I, J, DIVID
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
C      SET CURRENT GRAPHIC DEVICE INPUT CHANNEL AND OUTPUT CHANNEL
C      BASED ON THE GRAPHIC DEVICE.
C            0-10  CRT DEVICE
C           11-20  PLOTTER DEVICE
C           21-30  PRINTER
C           31-40  OTHER
C           41-50  CRT DEVICE
C           51-60  PLOTTER
C           ETC.......
C
C     MAP DEVICE BETWEEN 1 AND N
      I = MAX0 (DEVICE-1, 0)
      I = DIVID (I, 10, J) + 1
C     MAP INTO LOGICAL DEVICE (1-4)
      I = DIVID ((I-1), 4, J)
      J = J + 1
      GO TO (900, 200, 300, 900),J
C
C     PLOTTER
C
200   CONTINUE
      CINCHN = 3
      COTCHN = 4
      GO TO 900
C
C     PRINTER
C
300   CONTINUE
      CINCHN = 5
      COTCHN = 6
      GO TO 900
C
C     OTHER
C
400   CONTINUE
      GO TO 900
C
900   CONTINUE
      RETURN
      END
      SUBROUTINE GCSTIN (LENIN, STRING, LENOUT)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: GET A STRING OF ADE FORMAT CHARACTERS FROM THE         C
C               STANDARD CONSOLE DEVICE WITH ECHO                      C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            LENIN - MAXIMUM LENGTH (<= 81) OF STRING TO BE RETURNED   C
C                    (INCLUDING THE 'NEW LINE' CHARACTER)              C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            STRING - STRING OF ADE CHARACTERS                         C
C            LENOUT - ACTUAL NUMBER OF CHARACTERS INPUT (NOT INCLUDING C
C                     THE 'NEW LINE' CHARACTER)                        C
C                                                                      C
C     ROUTINES CALLED: KCHRIN - GET CHARACTER FROM STANDARD CONSOLE    C
C                               DEVICE                                 C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER LENIN, STRING(1), CHAR, LENOUT
      INTEGER*1 I, NEWLIN, TMPLEN
C
      DATA NEWLIN /10/
C
C     CHECK FOR VALID LENGTH
C
      LENOUT = 1
      IF (LENIN .LE. 0) GO TO 500
      TMPLEN = 81
      IF (LENIN .LT. 81) TMPLEN = LENIN
C
C     GET STRING FROM STANDARD CONSOLE DEVICE
C
      DO 200 I = 1 , TMPLEN
         CALL GCHRIN (CHAR)
         STRING (I) = CHAR
         LENOUT = I
         IF (CHAR .EQ. NEWLIN) GO TO 900
200   CONTINUE
C
C     PUT THE 'NEW LINE' CHARACTER (LINE FEED) AT THE END OF THE STRING
C
500   CONTINUE
      STRING(LENOUT) = NEWLIN
C
900   CONTINUE
      LENOUT = LENOUT - 1
      RETURN
      END
      SUBROUTINE GDSTIN (LENIN, STRING, LENOUT)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: GET A STRING OF ADE FORMAT CHARACTERS FROM THE CURRENT C
C               GRAPHIC DEVICE WITHOUT ECHO                            C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            LENIN - MAXIMUM LENGTH OF STRING TO BE RETURNED           C
C                    (INCLUDING THE 'NEW LINE' CHARACTER)              C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            STRING - STRING OF ADE CHARACTERS                         C
C            LENOUT - ACTUAL NUMBER OF CHARACTERS INPUT (NOT INCLUDING C
C                     THE 'NEW LINE' CHARACTER)                        C
C                                                                      C
C     ROUTINES CALLED: TTYIN  - GET CHARACTER FROM CONSOLE WITHOUT ECHOC
C                      RDRIN  - GET CHARACTER FROM READER WITHOUT ECHO C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER LENIN, STRING(1), LENOUT
      INTEGER*1 CHAR, I, NEWLIN, CR, TMPLEN
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      DATA NEWLIN /10/
      DATA CR /13/
C
C     CHECK FOR VALID LENGTH
C
      LENOUT = 1
      IF (LENIN .LE. 0) GO TO 500
      TMPLEN = 81
      IF (LENIN .LT. 81) TMPLEN = LENIN
C
C     GET STRING FROM CURRENT GRAPHICS DEVICE
C     SEE IF CURRENT DEVICE IS CONSOLE
C
      IF (CINCHN .NE. STDIN) GO TO 300
         DO 200 I = 1 , TMPLEN
            CALL TTYIN (CHAR)
            STRING (I) = CHAR
            LENOUT = I
            IF (CHAR .EQ. CR) GO TO 500
200      CONTINUE
         GO TO 500
C
300   CONTINUE
      IF (CINCHN .NE. 3) GO TO 500
C
C        GET CHARACTER FROM READER DEVICE
C
         DO 400 I = 1 , TMPLEN
            CALL RDRIN (CHAR)
            STRING(I) = CHAR
            LENOUT = I
            IF (CHAR .EQ. CR) GO TO 500
400      CONTINUE
C
C     PUT THE 'NEW LINE' CHARACTER (LINE FEED) AT THE END OF THE STRING
C
500   CONTINUE
      STRING(LENOUT) = NEWLIN
      LENOUT = LENOUT - 1
C
      RETURN
      END
      SUBROUTINE GCNWIN (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: INPUT AN ADE FORMAT CHARACTER FROM STANDARD CONSOLE    C
C               DEVICE WITH ECHO, WITHOUT WAITING                      C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            C - ADE VALUE OF CHARACTER INPUT FROM DEVICE              C
C                                                                      C
C     ROUTINES CALLED: TTYINW - GET CHARACTER FROM CONSOLE WITHOUT     C
C                               WAIT                                   C
C                      TTYOUT - OUTPUT CHARACTER TO CONSOLE            C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C
      INTEGER*1 CR, CHAR, NEWLIN
C
      DATA NEWLIN /10/, CR /13/
C
      C = -1
C
C     SEE IF THERE IS CHARACTER AVAILABLE
C
      CALL TTYINW (CHAR)
      IF (CHAR .LT. 0) GO TO 100
         C = CHAR
C
C        ECHO THE CHARACTER
C
         CALL TTYOUT (CHAR)
         IF (CHAR .NE. CR) GO TO 100
C
C           OUTPUT A LINEFEED BECAUSE CPM DOES NOT ON CARRIAGE RETURN
C
            CALL TTYOUT (NEWLIN)
C
 100  CONTINUE
      RETURN
      END
      SUBROUTINE GCHRIN (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: INPUT AN ADE FORMAT CHARACTER FROM STANDARD CONSOLE    C
C               DEVICE WITH ECHO                                       C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            C - ADE VALUE OF CHARACTER INPUT FROM DEVICE              C
C                                                                      C
C     ROUTINES CALLED: TTYINE - GET CHARACTER BUFFER FROM CONSOLE      C
C                               WITH ECHO                              C
C                      TTYOUT - OUTPUT CHARACTER TO CONSOLE            C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C
      INTEGER*1 CINMAX, CINCNT, NEWLIN
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      EQUIVALENCE (CINMAX , CINBUF(1))
      EQUIVALENCE (CINCNT , CINBUF(2))
C
      DATA NEWLIN /10/
C
C     GET CHARACTER FROM STANDARD CONSOLE INPUT DEVICE
C     SEE IF ANY CHARACTERS LEFT IN BUFFER
C
      CINPTR = CINPTR + 1
      IF (CINPTR .LE. (CINCNT+2)) GO TO 240
C
C     NO, READ ANOTHER BUFFER
C
      CALL TTYINE (CINBUF)
      CALL TTYOUT (NEWLIN)
      CINCNT = CINCNT + 1
      CINBUF(CINCNT+2) = NEWLIN
      CINPTR = 3
C
C     EXTRACT CHARACTER FROM BUFFER
C
240   CONTINUE
      C = CINBUF(CINPTR)
C
      RETURN
      END
      SUBROUTINE GDNWIN (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: INPUT AN ADE FORMAT CHARACTER FROM THE CURRENT         C
C               GRAPHIC DEVICE WITHOUT ECHO WITHOUT WAITING            C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C	     NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            C - ADE VALUE OF CHARACTER INPUT FROM DEVICE              C
C                                                                      C
C     ROUTINES CALLED: TTYIN  - GET CHARACTER FROM CONSOLE WITHOUT ECHOC
C                      RDRIN  - GET CHARACTER FROM READER WITHOUT ECHO C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C
      INTEGER*1 CHAR, NEWLIN, CR
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      DATA NEWLIN /10/
      DATA CR /13/
C
C     GET CHARACTER FROM CURRENT GRAPHICS DEVICE
C     SEE IF CURRENT DEVICE IS CONSOLE
C
      IF (CINCHN .NE. STDIN) GO TO 300
         CALL TTYINW (CHAR)
C
C        TURN CARRIAGE RETURN INTO 'NEW LINE' (LINE FEED)
C
         IF (CHAR .EQ. CR) CHAR = NEWLIN
         C = CHAR
         GO TO 500
300   CONTINUE
C
C     CPM CAN'T DO NO WAIT INPUT ON OTHER THAN THE CONSOLE, SO WE DO NORMAL
C     DEVICE INPUT
C
      CALL GDEVIN (C)
C
500   CONTINUE
      RETURN
      END
      SUBROUTINE GDEVIN (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: INPUT AN ADE FORMAT CHARACTER FROM THE CURRENT         C
C               GRAPHIC DEVICE WITHOUT ECHO                            C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C	     NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            C - ADE VALUE OF CHARACTER INPUT FROM DEVICE              C
C                                                                      C
C     ROUTINES CALLED: TTYIN  - GET CHARACTER FROM CONSOLE WITHOUT ECHOC
C                      RDRIN  - GET CHARACTER FROM READER WITHOUT ECHO C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C
      INTEGER*1 CHAR, NEWLIN, CR
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      DATA NEWLIN /10/
      DATA CR /13/
C
C     GET CHARACTER FROM CURRENT GRAPHICS DEVICE
C     SEE IF CURRENT DEVICE IS CONSOLE
C
      IF (CINCHN .NE. STDIN) GO TO 300
      CALL TTYIN (CHAR)
      GO TO 500
300   CONTINUE
      IF (CINCHN .NE. 3) GO TO 400
C
C        GET CHARACTER FROM READER DEVICE
C
         CALL RDRIN (CHAR)
         GO TO 500
400   CONTINUE
C
C        GET A CHARACTER FROM THE PRINTER...SINCE THE PRINTER DOES'NT
C        DO INPUT ON CPM, WE JUST RETURN A 'NEW LINE'
C
         CHAR = NEWLIN
500   CONTINUE
C
C     TURN CARRIAGE RETURN INTO 'NEW LINE' (LINE FEED)
C
      IF (CHAR .EQ. CR) CHAR = NEWLIN
      C = CHAR
C
      RETURN
      END
      SUBROUTINE GCSTOT (LEN, STRING)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT A STRING OF ADE FORMAT CHARACTERS TO THE        C
C               STANDARD CONSOLE DEVICE                                C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            LEN - LENGTH OF STRING                                    C
C            STRING - STRING OF ADE CHARACTERS                         C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED: KCHROT - OUTPUT CHARACTER TO STANDARD CONSOLE   C
C                               DEVICE                                 C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER LEN, STRING(1), I
C
C     OUTPUT STRING TO STANDARD CONSOLE DEVICE
C
      IF (LEN .LE. 0) RETURN
      DO 200 I = 1 , LEN
         CALL GCHROT (STRING(I))
200   CONTINUE
C
      RETURN
      END
      SUBROUTINE GDSTOT (LEN, STRING)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT A STRING OF ADE FORMAT CHARACTERS TO THE        C
C               CURRENT GRAPHIC DEVICE                                 C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            LEN - LENGTH OF STRING                                    C
C            STRING - STRING OF ADE CHARACTERS                         C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED: KDEVOT - OUTPUT CHARACTER TO CURRENT GRAPHIC    C
C                               DEVICE                                 C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER LEN, STRING(1), I
C
C     OUTPUT STRING TO CURRENT GRAPHICS DEVICE
C
      IF (LEN .LE. 0) RETURN
      DO 200 I = 1 , LEN
         CALL GDEVOT (STRING(I))
200   CONTINUE
C
      RETURN
      END
      SUBROUTINE GCHROT (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT AN ADE FORMAT CHARACTER TO THE STANDARD CONSOLE C
C               OUTPUT DEVICE                                          C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            C - ADE CHARACTER TO BE OUTPUT                            C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED: KCHNOT - PUT A CHARACTER TO A SPECIFIED CHANNEL C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C, CRLFCD
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      DATA CRLFCD /-4/
C
C     OUTPUT A CHARACTER TO THE STANDARD CONSOLE OUTPUT CHANNEL
C
      CALL GCHNOT (C, STDOUT)
C
      RETURN
      END
      SUBROUTINE GCNWOT (C, RESULT)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT AN ADE FORMAT CHARACTER TO THE STANDARD CONSOLE C
C               OUTPUT DEVICE ONLY IF THE DEVICE IS READY FOR OUTPUT   C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            C - ADE CHARACTER TO BE OUTPUT                            C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            RESULT - 0 IF SUCCESSFUL, -1 IF UNABLE TO OUTPUT          C
C                                                                      C
C     ROUTINES CALLED: GCHNOT - PUT A CHARACTER TO A SPECIFIED CHANNEL C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C, RESULT
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
C     SINCE CPM CAN'T CHECK STATUS OF OUTPUT PORT, JUST OUTPUT IT.
C     OUTPUT A CHARACTER TO THE STANDARD CONSOLE OUTPUT CHANNEL
C
      CALL GCHNOT (C, STDOUT)
C
      RETURN
      END
      SUBROUTINE GDEVOT (C)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT AN ADE FORMAT CHARACTER OUT TO THE CURRENT      C
C               GRAPHIC DEVICE                                         C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            C - ADE CHARACTER TO BE OUTPUT                            C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED: KCHNOT - PUT A CHARACTER TO A SPECIFIED CHANNEL C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
C     OUTPUT A CHARCTER TO THE CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C
      CALL GCHNOT (C, COTCHN)
C
      RETURN
      END
      SUBROUTINE GDNWOT (C, RESULT)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT AN ADE FORMAT CHARACTER OUT TO THE CURRENT      C
C               GRAPHIC DEVICE WITHOUT WAITING FOR DEVICE READY        C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            C - ADE CHARACTER TO BE OUTPUT                            C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            RESULT - 0 IF SUCCESSFUL, -1 IF UNABLE TO OUTPUT          C
C                                                                      C
C     ROUTINES CALLED: GCHNOT - PUT A CHARACTER TO A SPECIFIED CHANNEL C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C, RESULT
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
C     OUTPUT A CHARCTER TO THE CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C
      CALL GCHNOT (C, COTCHN)
      RESULT = 0
C
      RETURN
      END
      SUBROUTINE GCHNOT (C, CHANEL)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: OUTPUT AN ADE FORMAT CHARACTER TO THE SPECIFIED CHANNELC
C                                                                      C
C     INPUT PARAMETERS:                                                C
C            C - ADE CHARACTER TO BE OUTPUT                            C
C            CHANEL - OUTPUT CHANNEL                                   C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED: NONE                                            C
C            TTYOUT - OUTPUT CHARACTER TO CONSOLE                      C
C            PCHOUT - OUTPUT CHARACTER TO PUNCH                        C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INTEGER C, CHANEL
      INTEGER*1 NEWLIN, CRLFCD, CHAR, CR, LF
C
C   STDIN       STANDARD CONSOLE INPUT CHANNEL
C   STDOUT      STANDARD CONSOLE OUTPUT CHANNEL
C   CINCHN      CURRENT GRAPHIC DEVICE INPUT CHANNEL
C   COTCHN      CURRENT GRAPHIC DEVICE OUTPUT CHANNEL
C   CINPTR      POINTER TO LAST CHARACTER ACCESSED IN CINBUF ARRAY
C   CINBUF      STANDARD CONSOLE DEVICE INPUT BUFFER
C
      INTEGER  STDIN, STDOUT, CINCHN, COTCHN
      INTEGER*1 CINPTR, CINBUF(83)
C
      COMMON /GIOCOM/ STDIN,STDOUT,CINCHN,COTCHN,CINPTR,CINBUF
C
      EQUIVALENCE (NEWLIN , LF)
C
      DATA NEWLIN /10/
      DATA CRLFCD /-4/
      DATA CR /13/
C
      IF (CHANEL .LE. 0) RETURN
C
C     CHECK FOR SPECIAL CODES
C
      IF ((C .LT. 0 .OR. C .GT. 255) .AND. C .NE. CRLFCD) RETURN
      IF (C .EQ. NEWLIN) RETURN
C
C     IF THE CURRENT CHARACTER IS THE SPECIAL CARRIAGE RETURN,
C     LINE FEED CHARACTER OUTPUT THE TWO CHARACTERS.
C
      IF (C .NE. CRLFCD) GO TO 500
      IF (CHANEL .NE. STDOUT) GO TO 300
C
C        CHECK TTY PORT STATUS FOR A CONTROL S, WAIT FOR CONTROL Q
C
         CALL GCHKSQ
C
C        OUTPUT CARRAIGE RETURN AND LINE FEED TO STANDARD CONSOLE DEVICE
C
         CALL TTYOUT (CR)
         CALL TTYOUT (LF)
         GO TO 900
300   CONTINUE
      IF (CHANEL .NE. 4) GO TO 400
C
C        OUTPUT CARRIAGE RETURN AND LINE FEED TO PUNCH DEVICE
C
         CALL PCHOUT (CR)
         CALL PCHOUT (LF)
         GO TO 900
400   CONTINUE
C
C        OUTPUT CARRIAGE RETURN AND LINEFEED TO PRINTER DEVICE
C
         CALL LPTOUT (CR)
         CALL LPTOUT (LF)
         GO TO 900
500   CONTINUE
C
C     CHARACTER NOT SPECIAL.  OUTPUT TO DEVICE.
C
      CHAR = C
      IF (CHANEL .NE. STDOUT) GO TO 600
C
C        CHECK TTY PORT STATUS FOR A CONTROL S, WAIT FOR CONTROL Q
C
         CALL GCHKSQ
C
C        OUTPUT CHARACTER TO THE STANDARD CONSOLE DEVICE
C
         CALL TTYOUT (CHAR)
         GO TO 900
600   CONTINUE
      IF (CHANEL .NE. 4) GO TO 700
C
C        OUTPUT CHARACTER TO PUNCH DEVICE
C
         CALL PCHOUT (CHAR)
         GO TO 900
700   CONTINUE
C
C        OUTPUT CHARACTER TO PRINTER DEVICE
C
         CALL LPTOUT (CHAR)
C
900   CONTINUE
      RETURN
      END
      SUBROUTINE GCHKSQ
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: CHECK TERMINAL FOR CONTROL S AND WAIT FOR CONTROL Q    C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C	     NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED:                                                 C
C            NONE                                                      C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      INTEGER*1 CHAR, CNTLS, CNTLQ
C
      DATA CNTLS /19/, CNTLQ /17/
C
100   CONTINUE
C
C     CHECK TO SEE IF THERE IS A CHARACTER
C
      CALL TTYINW (CHAR)
C
      IF (CHAR .NE. CNTLS) GO TO 900
C     
C        THERE WAS A CHARACTER AND IT WAS A CONTROL S, NOW WE CHECK UNTIL
C        A CONTROL Q IS INPUT
C        NOTE:
C           YOU WILL NOTICE THAT ANYOTHER INPUT MIGHT BE BIT BUCKETED 
C           HERE
C
200      CONTINUE
         CALL TTYINW (CHAR)
         IF (CHAR .NE. CNTLQ) GO TO 200
C
900   CONTINUE
      RETURN
      END
      SUBROUTINE GIOSTP
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        C
C          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           C
C          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          C
C          WITH THE TERMS OF THAT AGREEMENT.                           C
C                                                                      C
C          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            C
C          ALL RIGHTS RESERVED.                                        C
C                                                                      C
C     FUNCTION: CLOSE THE GSS I/O SYSTEM                               C
C                                                                      C
C     INPUT PARAMETERS:                                                C
C	     NONE                                                      C
C                                                                      C
C     OUTPUT PARAMETERS:                                               C
C            NONE                                                      C
C                                                                      C
C     ROUTINES CALLED:                                                 C
C            NONE                                                      C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      RETURN
      END
E 1
