version	==	0
revision==	0
	.title	'Copy hard disk partition to partition'
	.sbttl	'COPYPART'
;----------
; This program copies one hard disk partition to
; another hard disk partition.  The format of the
; COPYPART command is:
;
;		COPYPART x = y
;
; x is the destination drive (A-D).
; y is the source drive (A-D).
; 
; COPYPART verifies that both drives are assigned to 
; hard disk or network partitions, and that both
; partitions are the same size.  If so, then the copy
; operation begins.  One CP/M track (128 sectors = 16K)
; is read from the source drive, then written to the
; destination drive.  A dot is printed on the screen
; after each track is copied.  After all tracks have
; been copied, a message is printed and the program
; terminates.
;----------
	.pabs
	.phex
	.loc	100h
;----------
; Misc constants
cr	==	0Dh	; return
lf	==	0Ah	; line feed
;----------
; Greet the user
	lxi	SP,100h
	lxi	D,greetmsg
	mvi	C,9
	call	5
;
; Only works with CP/M 1.4 (for now)
	mvi	C,0Ch
	call	5
	mov	A,L	; version number should be zero
	ora	A
	jnz	vererr
;
; Parse the command line, determining src and dst disks
	call	BLANKS	; zero or more blanks
	call	GETDSK	; destination disk
	sta	dstdsk
	call	BLANKS	; zero or more blanks
	cpi	'='	; equals sign
	jnz	synerr
	call	BLANKS	; zero or more blanks
	call	GETDSK	; source disk
	sta	srcdsk
	lhld	comchr
	lda	80h
	adi	80h
	cmp	L
	jnz	synerr	; error if extra command chars
;
; Determine disk size
	lda	dstdsk
	call	GETSIZE	; destination size
	sta	numtrk
	lda	srcdsk
	call	GETSIZE	; source size
	lxi	H,numtrk
	cmp	M	; sizes should be the same
	jnz	sizerr
;----------
; Copy from track 0 to numtrk - 1
	sub	A
	sta	curtrk
;
; Read 16K from source disk
..loop:
	lda	srcdsk
	sta	curdsk
	lxi	H,iobuff
	shld	curdma
	mvi	A,1
	sta	cursec
..read:
	call	SETUP
	call	READ
	call	NEXTSEC
	jrnz	..read
;
; Write 16K to destination disk
	lda	dstdsk
	sta	curdsk
	lxi	H,iobuff
	shld	curdma
	mvi	A,1
	sta	cursec
..write:
	call	SETUP
	call	WRITE
	call	NEXTSEC
	jrnz	..write
;
; Advance to next track
	mvi	E,'.'
	mvi	C,2
	call	5	; print a dot after 16K copied
	lda	curtrk
	inr	A
	sta	curtrk	; increment track number
	lxi	H,numtrk
	cmp	M
	jrnz	..loop
	lxi	D,donemsg
	mvi	C,9
	call	5	; print "Partition copied OK"
	jmp	0	; warm boot
;----------
; Skip zero or more blanks on command line
;  Regs out:  A = next non-blank char
BLANKS:
	lhld	comchr
	inx	H
	shld	comchr	; increment command line pointr
	lda	80h
	adi	81h
	cmp	L
	jz	synerr	; error if end of command line
	mov	A,M	; get current command line char
	cpi	' '	
	jrz	BLANKS	; if blank, then scan some more
	ret		; if non-blank, then return
;----------
; Extract disk number from command line
;  Regs in:  A = disk selection (A-D) from command line
;  Regs out: A = legal disk number (0-3)
GETDSK:
	sui	'A'	; convert uppercase A-D to 0-3
	cpi	0
	jc	dskerr	; error if < 0
	cpi	4
	rc		; return if legal disk selector
	sui	'a'-'A'	; convert lowercase a-d to 0-3
	cpi	0
	jc	dskerr	; error if < 0
	cpi	4
	jnc	dskerr	; error if > 3
	ret
;----------
; Extract disk size from disk parameter table in BIOS
;  Regs in:  A = disk to be sized (0-3)
;  Regs out: A = disk size (in CP/M tracks, 16-256)
GETSIZE:
	mov	C,A
	call	SELDSK
	call	CPMMAP
	bit	7,A	; don't allow floppy copy
	jz	parterr
	inx	H
	inx	H
	inx	H
	inx	H
	mov	A,M	; get "sectors per block - 1"
	inr	A
	slar	A	; compute tracks per disk
	ret
;----------
; Setup a CP/M disk operation
SETUP:
	lda	curdsk
	mov	C,A
	call	SELDSK	; set disk number
	lbcd	curtrk
	call	SETTRK	; set track number
	lda	cursec
	mov	C,A
	call	SETSEC	; set sector number
	lbcd	curdma
	call	SETDMA	; set DMA address
	ret
;----------
; Advance to next sector
;  Regs out:  Z flag set if end of track
NEXTSEC:
	lda	cursec
	cpi	128
	rz
	inr	A	
	sta	cursec  ; increment sector number
	lhld	curdma
	lxi	D,128
	dad	D
	shld	curdma	; increment DMA address
	ret
;----------
; CP/M BIOS interface
SELDSK:	lxi	D,18h	; set disk number
	jmpr	BIOS
SETTRK:	lxi	D,1Bh	; set track number
	jmpr	BIOS
SETSEC: lxi	D,1Eh	; set sector number
	jmpr	BIOS
SETDMA:	lxi	D,21h	; set DMA address
	jmpr	BIOS
READ:	lxi	D,24h	; read
	jmpr	BIOS
WRITE:	lxi	D,27h	; write
	jmpr	BIOS
CPMMAP:	lxi	D,60h	; get disk parameter table
BIOS:
	lhld	1
	dad	D
	pchl
;----------
; Error routines
;-----
vermsg:	.ascii	'COPYPART only works with CP/M 1.4$'
vererr:	lxi	D,vermsg
	jmp	error
;-----
synmsg:	.ascii	'Command line syntax error$'
synerr:	lxi	D,synmsg
	jmp	error
;-----
dskmsg:	.ascii	'Bad disk selector on command line$'
dskerr:	lxi	D,dskmsg
	jmp	error
;-----
partmsg:.ascii	'Bad source or destination disk '
	.ascii	'assignment$'
parterr:lxi	D,partmsg
	jmp	error
;-----
sizemsg:.ascii	'Source and destination disk sizes '
	.ascii	'do not match$'
sizerr:	lxi	D,sizemsg
;-----
error:
	mvi	C,9
	call	5	; print error message
	jmp	0	; warm boot
;----------
; Misc messages
greetmsg:.ascii	'COPYPART version '
	.byte	version+'0','.',revision+'0',cr,lf,'$'
donemsg:.ascii	[cr][lf]'Partition copy completed$'
;----------
; Misc variables
comchr:	.word	80h	; command line pointer
dstdsk:	.byte	0	; destination disk (0-3)
srcdsk:	.byte	0	; source disk (0-3)
numtrk:	.byte	0	; CP/M tracks on disk (16-256)
curdsk:	.byte	0	; current disk (0-3)
curtrk:	.word	0	; current track (0-255)
cursec:	.byte	0	; current sector (1-128)
curdma:	.word	0	; current DMA address
iobuff	==	4000h	; 16K I/O buffer
	.end
