
MODULE MAILUTIL;	{ Common utility subroutines }
CONST
  ord_DEL	=	$7F;

VAR
  goto_esc : EXTERNAL string[4];
  offset,
    r_zero,
    c_zero   : EXTERNAL byte;
  row_first: EXTERNAL Boolean;
  cr,bs    : EXTERNAL char;


EXTERNAL PROCEDURE out_ch(ch:char);
EXTERNAL FUNCTION  in_nech:char;

PROCEDURE p35_read_and_echo_console_string(max_len:integer;var s:string;
				echo:Boolean);
VAR
  cur_len:integer;
  ch : char;
BEGIN
  s := '';
  cur_len := 0;
  REPEAT		{ Assume max_len>=1 }
    ch := in_nech;
    if ch=cr then EXIT; { DONE }
    if (ch>=' ') AND (ch<='~') then
       begin
	 if cur_len<max_len then
	    begin
	      if echo then out_ch(ch)		{ Show it on screen }
		      else out_ch(' ');		{ Don't--show blank instead }
	      cur_len := cur_len + 1;  { Count it	   }
	      s := concat(s,ch);       { Record it	   }
	      if cur_len=max_len then out_ch(bs); { Pull cursor back if
						    this one went in last
						    char posn }
	    end
       end
    else if (ch=bs) OR (ch=chr(ord_DEL)) then
	    begin
	      if cur_len>0 then 
		 begin
		   delete(s,cur_len,1);      { Pull char out of string }
		   if cur_len<max_len then out_ch(bs);
		   out_ch(' '); out_ch(bs);  { Blank screen posn       }
		   cur_len := cur_len - 1;
		 end;
	    end;
					UNTIL false;
END;

PROCEDURE ucase(source:string; var up:string);
VAR
  l : integer;
BEGIN
  up := source; 	  { Necessary to set length byte }
  for l:= 1 to length(source) do
      if source[l] in ['a'..'z'] then up[l] := chr(ord(source[l]) & $5F)
				 else up[l] := source[l];
END;

FUNCTION ch_ucase(c:char):char;
BEGIN
  if c in ['a'..'z'] then ch_ucase := chr(ord(c) & $5F)
		     else ch_ucase := c;
END;

PROCEDURE strip_lead_blanks(var s:string);
BEGIN
  while s[1]=' ' do delete(s,1,1);
END;

PROCEDURE remove_trail_blanks(var s: string);
VAR
  p : integer;
BEGIN
  for p:= length(s) downto 0 do
      begin
	if s[p]<>' ' then exit;
	delete(s,p,1);
      end;
END;

PROCEDURE clean(source:string; var result:string);
BEGIN
  u_case(source,result);
  remove_trail_blanks(result);
  strip_lead_blanks(result);
END;

PROCEDURE conv_i_s(i:byte; var s:string);
BEGIN
  s := '';
  while i <> 0 do
    begin
      s := concat(s,chr((i MOD 10) + ord('0')));
      i := i DIV 10;
    end;
END;

PROCEDURE goto_row_col(row,col:byte);
VAR
  act_row,
    act_col : integer;
BEGIN
  write([addr(out_ch)],goto_esc);
  act_row := row + offset;
  act_col := col + offset;
  if act_row=0 then act_row := r_zero;
  if act_col=0 then act_col := c_zero;
  if row_first then write([addr(out_ch)],chr(act_row),chr(act_col))
	       else write([addr(out_ch)],chr(act_col),chr(act_row));
END;

(************** 7/2/82 doesn't work for PM signin, after midnight roll
PROCEDURE AM_PM(hour:byte; var resulting_hour:byte; var phrase:string);
BEGIN
  if hour>12 then      { Know we've rolled past noon }
     begin
       resulting_hour := hour - 12;
       phrase := 'PM';
     end
  else
     begin	       { Don't really know what we've got... }
       resulting_hour := hour;
       phrase := '  '; { Would be AM instead of '  ' if we knew }
     end;
END;
	 **************)
MODEND.
