	.title	'Viewpoint Emulation'
	.ident	view
vpversion ==	2
vprevision ==	0	;last modified 14-Apr-83

;
;		TABLE OF CONTENTS		PAGE
;
; 1. Equates
;	equates for crtfox rom			2
;	equates for emulation			6
; 2. General Purpose Macros			7
; 3. ROM entry points				8
; 4. Initialisation Code			10
; 5. Mainline emulation			
;	normal printable character processing	12
;	adjust attributes for changed bit map	14
;	escape sequence processing		20
;	erase line or screen			21
;	change attributes across screen		23
;	tag setting and keyboard locking	25
;	linefeed and scroll			26
;	bitmap routines				27
;	bitmap data structures			34
; 6. Emulation ram data				36
; 7. Ram for rom definitions			38
;

	.insert	romequs
	.page
	.sbttl	'equates for emulation'
forversion ==	2	;rom version this emulation is 
			;to be run with
forrevision ==	0	;revision emulation is for

;
;	the following are attribute bytes to 
;	implement viewpoint attributes
;
vpnormal ==	80h
vphalfintensity == 81h
vpblinking ==	82h
vphiblinking == 83h
vpreverse ==	90h
vprevhi	==	91h
vprevblink ==	92h
vprvhiblink ==	93h
vpunderline ==	0a0h
vpunhi	==	0a1h
vpunblink ==	0a2h
vpunhblink ==	0a3h
vpsuppress ==	vpnormal	;true suppress not implemented

vptagreset ==	80h	;true normal

	.insert genmacro
	.insert romentry.20
	.page
	.sbttl	'Initialisation Code'
	.pabs
	.phex
	.sall
;
;	the downloaded emulation can be located at
;	4000h if the rom is being used, or if the
;	rom is in ram at 7400h
;
	.ife	romeloc,[
	.loc	ramloc][
	.loc	7400h]

	lhld	disptab	;get address of first line
	res	7,h	;on screen
	shld	elloc
	lxi	h,hbf1	;emulation of viewpoint
	lded	elloc
	lxi	b,charsperline
	ldir		;copy buffer error line
	lda	verloc
	cpi	forversion
	jrnz	..badversion
	lda	revloc
	cpi	forrevision
	jrz	..versionok
..badversion:
	lxi	h,hbf2	;improper rom version exiting
	lded	elloc
	lxi	b,charsperline
	ldir
;
;	stall for a bit before reseting
;	controller
;
	mvi	h,5
			;note bc not inited first
			;time thru but who cares
..stallloop:
	dcx	b
	mov	a,b
	ora	c
	jrnz	..stallloop
	lxi	b,0ffffh
	dcr	h
	mov	a,h
	ora	a
	jrnz	..stallloop
	jmp	0	;software reset of
			;crt controller
	.page
..versionok:
;
;	set up table of actions to be taken for
;	non printable ascii chars
;
	lxi	h,vpcharact
	shld	acttabloc

;
;	set up to process escape sequences not present
;	in rom
;
	lxi	h,vpesc
	shld	altesc

;
;	set up for special processing of 
;	ascii printable characters
;
	lxi	h,vpasc
	shld	ascspecial

;
;	insure rom interupt processing, in case
;	taking over from other emulator
;
	lxi	h,normint
	shld	altint

	call	verase		;clear screen to make
		;all bits and screen chars right for
		;new emulation
	jmp	normret		;now ready for processing

	.page
	.sbttl	'normal printable character processing'

;
;	see if substitution for foreign char
;	set needed
;
vpasc:
	lxi	h,disptranspose
	add	l	;add character to table 
	mov	l,a	;which is on boundary to
	mov	a,m	;assure no carry
	lhld	nextchar	;adr of next screen pos
	mov	m,a		;insert char

;
;	if screen position is already tagged
;	as it should be, no need to set/reset bit
;	or adjust display attribute characters
;
	lhld	lcurxy	;position of bit
	call	bmbtest		;test existing bit
				;value
	jrnz	..isset
	lda	tagfollows
	cpi	true
	jrz	..doadjust
	jmpr	..bumpcur
..isset:
	lda	tagfollows
	cpi	true
	jrz	..bumpcur
;
;	adjust the bit map and then display 
;	characters
;
..doadjust:
	lhld	lcurxy	;set up for taging 
	lda	tagfollows	;bitmap
	cpi	true
	jrz	..maketag
	call	bmbreset	;reset tag bit
	jmpr	..tagdone
..maketag:
	call	bmbset		;set tag bit
..tagdone:
	call	adjlinedisplay	;adjust display to
				;reflect new tag bit
..bumpcur:
	lhld	nextchar
	inx	h
	call	skipattributechar
	lxi	h,maxchar	;chars to end of line
	dcr	m
	jz	vdocrlf		;scroll
	call	bumpcur		;bump cursor one forward
	ret
	.insert	bmadjust
	.page
	.sbttl	'escape sequence processing'
;
;	process escape sequences not present in rom
;
vpesc:
	cpi	'k'
	jrz	doeratoendofscreen
	cpi	'K'
	jrz	doeraline
	cpi	'0'
	jrz	vpsetattributes
	cpi	'5'
	jz	vplockkybd
	cpi	'6'
	jz	vpunlockkybd
	jmp	normesc
	.page
	.sbttl	'erase line or screen'
;
;	erase to end of screen and line including
;	bitmap
;
doeratoendofscreen:
	call	normret	;set up for normal return

veratoendofscreen:
	lhld	lcurxy
	call	bmesreset  ;reset to end of screen
	call	veraline  ;erase to end of current
			;line
	lda	lines
	lxi	h,lcury
	sub	m	;a is count of lines
		;to clear, note: current line
		;is already cleared
	push	psw	;save count of lines
	call	hltobeginingcurrentline
	inx	d
	xchg
	pop	psw
	call	bsetalterattribute
..erascreenloop:
	dcr	a
	jz	bresetalterattribute
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	push	psw
	call	vfilline
	pop	psw
	jmpr	..erascreenloop

;	fill line with blanks with normal display set

;	
;	on input regs are:
;	de - address to fill
;	hl - address of count of attribute
;		chars on line
;
;	de,bc,a destroyed
;	NOTE: FILLINE DOES NOT SET ALTERING ATTRIBUTE
;	COUNT FLAG DEPENDING ON CALLING ROUTINE TO
;	DO SO
;
vfilline:
	push	h	;save incoming hl register
	mvi	m,1	;set count of attribute chars
	xchg
	res	7,h	;reset bit that may be set to
			;tell 8275 to grab char
	mvi	m,vpnormal	;control char to get
			;normal display of chars
	inx	h
	mvi	m,' '	;blank first char on line
	push	h
	pop	d
	inx	d
	lda	chars
	dcr	a
	mov	c,a
	mvi	b,0
	ldir		;fill line with blanks
	pop	h	;restore
	ret


doeraline:
	call	normret		;set up normal return
veraline:
	lhld	lcurxy
	call	bmelreset	;reset to end of line
	call	eraline		
makenormal:		;insert control char to make
			;following screen normal
			;character display
	mvi	a,vpnormal
	jmp	storecontrol	;return from there
	.page
	.sbttl	'change attributes across screen'
;
;	set attributes across the screen
;
vpsetattributes:
	lxi	h,vpsa2
	shld	actspecial
	ret

;
;	see what the attribute should be
;
vpsa2:
	mvi	c,vpnormal
	cpi	'@'
	jrz	..found
	mvi	c,vphalfintensity
	cpi	'A'
	jrz	..found
	mvi	c,vpblinking
	cpi	'B'
	jrz	..found
	mvi	c,vphiblinking
	cpi	'C'
	jrz	..found
	mvi	c,vpreverse
	cpi	'P'
	jrz	..found
	mvi	c,vprevhi
	cpi	'Q'
	jrz	..found
	mvi	c,vprevblink
	cpi	'R'
	jrz	..found
	mvi	c,vprvhiblink
	cpi	'S'
	jrz	..found
	mvi	c,vpunderline
	cpi	'`'
	jrz	..found
	mvi	c,vpunhi
	cpi	'a'
	jrz	..found
	mvi	c,vpunblink
	cpi	'b'
	jrz	..found
	mvi	c,vpunhblink
	cpi	'c'
	jrz	..found
	mvi	c,vpsuppress
	cpi	'D'
	jrz	..found
	jmp	normret		;return from there
				;no action
..found:
;
;	now replace all occurances of old
;	attribute with new attribute on screen
;
	mov	a,c
	sta	tagattribute
	
	mvi	c,linesonscreen - 1
	lxi	h,disptab+3	;skip error line
..lineloop:
	mvi	b,charsperline
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	inx	h	;h set up for next time thru
	res	7,d	;get rid of high bit
			;in char address
..charloop:
	ldax	d
	bit	7,a
	jrz	..notspecial
;
;	see if bit is set in map, if so needs to 
;	be changed, otherwise is terminateing return
;	to normal character
;
	push	b	;save registers
	push	d
	push	h
	mvi	a,linesonscreen-1
	sub	c	;calculate current row
	mov	h,a
	mvi	a,charsperline
	sub	b	;calculate current column
	mov	l,a
	call	bmbtest	;test the bit
	pop	h	;restore regs
	pop	d
	pop	b
	jrz	..notbitset
	lda	tagattribute
	stax	d
..notbitset:
	inx	d
	jmpr	..charloop
..notspecial:
	inx	d
	djnz	..charloop
	dcr	c
	jrnz	..lineloop

	jmp	normret		;return from there
	.page	
	.sbttl	'tag setting and keyboard locking'
;
;	set and reset tagbits
;
tagset:
	mvi	a,true
	sta	tagfollows
	ret
tagreset:
	mvi	a,false
	sta	tagfollows
	ret

vplockkybd:
	lxi	h,flags2
	set	kybdlocked,m
	jmp	normret		;return from there

vpunlockkybd:
	lxi	h,flags2
	res	kybdlocked,m
	jmp	normret		;return from there
	.page
	.sbttl	'linefeed and scroll'
;
;	do linefeed to include bitmap scroll
;
vdocrlf:call	docr		;here for both

;
;perform line feed
;
vdolf:
	lxi	h,lcury
	inr	m
	lda	lines
	cmp	m		;past bottom line
	jrz	..scroll
	jmp	newcursor	;set cursor to new line
				;return from there
..scroll:
	push	h		;save ptr to lcury for
				;scroll routine
	call	bmscrreset	;scroll bitmap
	pop	h
	call	scroll		;scroll characters,
	lhld	lcurxy
	push	h
	mvi	l,0		;put normal character
	shld	lcurxy
	call	newcursor	;at beginning of line
	call	makenormal
	pop	h
	shld	lcurxy
	jmp	newcursor	;return from there
;
;	make screen erase include reset of bit map
;
verase:
	call	gothome
	jmp	veratoendofscreen

	.insert foxbitm

	.page
	.sbttl	'Emulation ram data'
;
;	viewpoint message buffers
;
;		/1234567890123456789012345678901234567890/
hbf1:	
	.ascii	/                          Viewpoint E/
	.ascii	/mulation Ver /
	.byte	vpversion+'0','.',vprevision+'0'
	.ascii	/                           $/

hbf2:	
	.ascii	/                  This emulation must ru/
	.ascii	/n with crt version /
	.byte	forversion + '0','.',forrevision + '0'
	.ascii	/                   /

;
;	key action table for non-printable characters
;	for Viewpoint
;
vpcharact:
	.word	donull		;0
	.word	gothome		;1
	.word	gotasc		;2
	.word	gotasc		;3
	.word	gotasc		;4
	.word	gotasc		;5
	.word	gotforward	;6
	.word	gotbell		;7
	.word	gotback		;8
	.word	gottab		;9
	.word	vdolf		;10 (ah)
	.word	gotasc		;11 (bh)
	.word	verase		;12 (ch)
	.word	docr		;13 (dh)
	.word	tagset		;14 (eh)
	.word	tagreset	;15 (fh)
	.word	gotasc	;16 (10h) 10h-19h for dasoft
	.word	gotasc	;17 (11h) special characters
	.word	gotasc		;18 (12h)
	.word	gotasc		;19 (13h)
	.word	gotasc		;20 (14h)
	.word	gotback	;21 (15h) nak is backspace
	.word	gotasc		;22 (16h)
	.word	gotasc		;23 (17h)
	.word	gotasc		;24 (18h)
	.word	gotasc		;25 (19h)
	.word	gotup		;26 (1ah)
	.word	esckey		;27 (1bh)
	.word	gotasc		;28 (1ch)
	.word	gotasc		;29 (1dh)
	.word	gotasc		;30 (1eh)
	.word	gotasc		;31 (1fh)


elloc:	.blkw	1	;location of error line

tagattribute: .byte	vphalfintensity	;default 
			;current attribute
notagattribute: .byte vpnormal ;none tagged attribute
			;character
tagfollows: .byte	false	;true if following
			;characters to be tagged
			;false if following characters
			;to be without tags

	.ife	romeloc,[
	.ifg	. - (ramloc + lencode),[
	.prntx /Code too long/][
	.prntx /Code length ok/]
	][
	.ifg	. - (8000h),[
	.prntx /Code too long/][
	.prntx /Code length ok/]
	]
	.insert	ramfrrom
	.end
	
