
	.title	'LOGIN - log into the HiNet'
	.sbttl	'LOGIN'
version	==	3
revision==	0
	.pabs
	.phex
	.loc	100h
;----------
; Log into the HiNet by grabbing 
; the network code and executing it
; 
;
;   Version 3.0   The login program has been completely
;		rewritten.  The program simply shuts off
;		the timer interupt, and executes a 
;		patched prom image.
;
;		  Login now logs into HiNet by deter-
;		mining what prom the user has, copying
;		down that prom from high memory, and
;		jumping down to 0 to execute.  Each of
;		the proms is patched to run through the
;		initialization code and jump into the
;		network boot routine.
;
;		NOTE: Whenever either of the proms are
;		updated, so must this program. Here is
;		a sample of code from PROM 1.09 and how
;		it was patched to automatically attempt
;		a network boot.
;
; Initialization section
;
; Enter monitor if front-panel switch is on
;	in	PIOAD
;	bit	7,A	; check front-panel switch
;	jrnz	Monitor <<<---THROUGH ZDT THIS WAS
;			      MADE INTO 2 NOPs.
;
; Check for auto-boot
;	.ifn	TAPEopt,[
;	in	SIO1AC	;  DCD  STS
;	bit	3,A	;  ---  ---
;	jnz	Network <<<---THROUGH ZDT THIS WAS MADE
;	bit	5,A	      AN UNCONDITIONAL JUMP.
;	jnz	Harddisk;   0    1   Harddisk boot
;	jmp	Floppy
;	]
;
;
;   How to construct LOGIN:
;
;		A>azm login o
;		A>zdti login.hex
;		 -iprom.com
;		 -r700		; DSC3/4 prom is 1K
;		 -ifoxprom.com
;		 -rB00  	; Fox prom is any size
;		 -(Patch both proms as demonstrated
;		 - above. Remember the offsets! )
;		 -^C		
;		A>save 15 login.com
;
; Port definitions:
DMA	==	38h	; DMA chip
CTC3	==	33h	; CTC channel 3
cr	==	0Dh	; carriage return
lf	==	0Ah	; line feed
NETusr	==	47h	; HiNet user number
stack	==	9400h	; Share stack with PROM
getIObyte==	07h	; CP/M IOByte request funtion
BDOS	==	05h	; BDOS entry point

;----------
; Step 1 - Greet the user, then flush floppy buffer
	lxi	sp,stack	; always need a stack
	lxi	D,greeting
	mvi	C,9
	call	BDOS	; greet the user
	mvi	C,getIOByte
	call	BDOS	; get our users IObyte
	sta	IOByte	; and save it for DSC3/Fox
			; comparison.
	lda	NETusr
	ora	A
	jrnz	..ok	; if not master, then OK
	lxi	D,master
	mvi	C,9
	call	BDOS	; If master, then we can't 
	jmp	0	; login. We boot.
;----------
; Step 2 - Disable interupts from the CTC clock timer.
..ok:	mvi	A,43h	  ;Disable code
	out	CTC3	  ;goes to channel 3.

;----------
; Step 3 - Determine the genre of machine we are on.
	lda	IObyte
	ani	3	; Use only console bits
	cpi	02	; Are we on a Fox (parallel)?
	jz	FOX	; Jump up to high mem and
			;download appropriate prom.
	cpi	00	; Are we on a DSC3 or DSC4?
	jz	DSC	; Jump up to high mem and
			;download appropriate prom.
	lxi	D,CANTmsg
	call	prtmsg	; Tell user we cant login
	jmp	0	; and boot.

; We stick the utilites and messages in low memory
;to be written over when one of the proms is down-
;loaded.

;----------
; Messages
greeting:.ascii	[cr][lf]"HiNet Login version "
	.byte	version+'0','.',revision+'0'
	.ascii	[cr][lf][lf]" Please stand by..."
	.ascii	[cr]"$"
master:	.ascii	[cr][lf]
	.ascii	"Sorry, the master can't re-login.$"
waiting:.ascii	[cr][lf]"*** Waiting$"
CANTmsg:.ascii	[cr][lf]"Sorry, LOGIN can't be used "
	.ascii	"here. Use the PROM's BN command.$"

IOByte:	.byte	0	; holds users IObyte.
;----------
; Print a message to the console
PRTMSG:	mvi	C,9
	call	BDOS
	ret

; This code had better not be past 600h!  If so,|
;change high mem location.			|
;-----------------------------------------------|


;-----------
; These are high memory routines.  From here we
;load one of the prom images down into low memory
;and jump to the appropriate network boot location.

;------------
; Step 5 - Copy down the appropriate ROM image and
;	jump into the BN section.

	.loc	600h

DSC:	di		  ;No stray interupts
	lxi	H,DSCprom ;Copy the DSC3/4 prom down
	lxi	D,0	  ;into its natural address
	lxi	B,400h	  ;space.
	LDIR
	ei		  ;Re-enable 
	jmp	0	  ;jump into prom intialization

FOX:	di		  ;No stray interupts
	lxi	H,FOXprom ;Copy the fox prom down
	lxi	D,0	  ;into its natural address
	lxi	B,400h	  ;space.
	LDIR
	ei		  ; Re-enable 
	jmp	0	  ;jump into prom initialization

; The DSC3/4 prom code is loaded here.
	.loc	700h
DSCprom:.blkb	400h   ; Prom is only 1K long.

;----------
; The FOX prom code is loaded here.
	.loc	0B00h
FOXprom:.blkb	400h	; Can be 1K or longer.

.end
