.title 'HELP for the user.'
	.ident HELP
;
version == 	1
revision==      1
patch	==	'A'
;
	.pabs
	.phex
	.loc	100h
	sspd    saveSP
	lxi	sp,stack ;stack at end of program
;
; rev 1  05/20/82
; Install new conversion routine to make a decimal
; number for memory size.
;
;---------------
; If the op system version number is not = to 14 or 22,
; the operator has done a floppy write.  Print a 
; message to the operator and return to CP/M.
;
	lxi	H,login
	call	prtmsg	;print login message
        lxi     H,versnum ;where version # is stored
 	mov     A,m     ;what is in memory
	cpi	14 	;if version # = 14 or
	jrz     ..ok	;22, the operator has not done 
	cpi 	22	;a floppy write and the data
	jnz     flopwrt ;in memory is valid. Otherwise,
         		;print error message.
..ok:   lda     usernum ;if user number = FFh the
	cpi     0ffh	;op system is CP/M single user
	jrz	SINGusr
	cpi	00	;if user number = 00, the
	jrz	mast	;op system is for a master
; 
; If neither of the above, we have a station
;
	lxi	H,STNmsg
	call	prtmsg	;print CP/M user station msg
	call    getCPM  ;get the CPM version number
	call	testID	;test ID # for validity
	call    getID   ;get prom ID number
	lxi     H,crlf
	call    prtmsg  ;space one line down
	lxi	H,prtHiNetmnu
	call    prtmsg	;print Hinet menu
	call    retCCP  ;return to the CCP
.page
mast:	
        lxi	H,MASmsg
	call	prtmsg	;print CP/M master msg
	call    getCPM  ;get the CPM version number
	call	testID	;test ID # for validity
        call    getID   ;get prom ID number
	lxi     H,crlf
	call    prtmsg  ;space one line down
	lxi	H,prtHiNetmnu
	call    prtmsg	;print Hinet menu
	call    retCCP  ;return to the CCP
SINGusr:
	lxi	H,USRmsg
	call	prtmsg	;print CP/M single user msg
	call    getCPM  ;get the CPM version number
	call	testID	;test ID # for validity
	call    getID   ;get prom ID number
	lxi     H,crlf
	call    prtmsg  ;space one line down
	lxi	H,prtCPMmnu
	call    prtmsg	;print Hinet menu
	lxi     H,crlf
	call    prtmsg  ;space one line down
	call    retCCP  ;return to the CCP
flopwrt:
        lxi	H,FLOPmsg
	call	prtmsg	;print floppy write message
	lxi     H,crlf
	call    prtmsg  ;space one line down
	lxi	H,prtHiNetmnu
	call    prtmsg	;print Hinet menu
	lxi     H,crlf
	call    prtmsg  ;space one line down
	call    retCCP  ;return to the CCP
.page
.sbttl 'SUBROUTINES'
;---------------
; SUBROUTINES
;---------------
; subroutine testID: test the unique prom number
;                    for valid characters
testID:
	lxi     H,IDmsg
	call    prtmsg  ;print the id message
	lda	IDnum	;if first byte of the ID 
	cpi	00	;number is not 00, does  
	jrnz	..tstFF	;it = FF?
	lda	IDnum+1 ;if first byte = 00, is 
	cpi	00	;second byte = to 00?
	jrz	..unk	;yes, print unknown prom #
	rnz
        lda     IDnum   ;no, reload the IN number
..tstFF:cpi	0FFh	;is first byte = FF?
	rnz		;if not = 00 and not = FF, ok
	lda	IDnum+1 ;otherwise, test second byte
	cpi     0FFh    ;if = FF, we have unknown #
	rnz
..unk: 	lxi	H,unkmsg ;unknown number, print a
	call    prtmsg	;message and get the 
	call    getmem	;size of memory
	lda     usernum ;if user number is FF, print
	cpi	0FFh	;the CP/M commands
	jrz	..net	;otherwise
	lxi	H,prtCPMmnu
	call    prtmsg	;print CP/M commands
	call	retCCP	;return to CCP
..net:  lxi	H,prtHiNetmnu ;print the Hinet
	call	prtmsg	;commands
	call	retCCP	;return to CCP
;---------------
; Print a character on the console
;  Regs in:   A = character to be printed
CONOUT:
	push	H
	push	D
	push	B
	mvi	C,2
	mov	E,A
	call	5	; print using BDOS
	pop	B
	pop	D
	pop	H
	ret
.page
;--------------- 
; subroutine getID:  get the unique prom number
;	             and top of memory
getID:
	lxi     H,idnum
	mov     A,m	;get what is in memory
	call    prtby2  ;print the first prom number
	lxi     H,idnum+1;get the second byte
	mov     A,m	;get what is in memory
	call    prtby2  ;print the second prom number
;
; Now get the amount of memory available to the user
;
getmem: lxi	H,MEMmsg
	call	prtmsg	 ; print message
        lhld	BDOSadr  ;get what is in memory
	call	HLDEconv ;convert to a decimal
	lxi	H,string
	call	prtmsg	 ;print decimal number
;
; Last, print the number in hex, in quotation marks
;
	mvi	C,' '
	call    charout ;print a space
	mvi     C,'('   
	call    charout ;left quote mark
	lda     BDOSadr+1
	call    prtby2	;print first 2 numbers in hex
	lda 	BDOSadr
	call    prtby2	;print second 2 numbers in hex
	lxi     H,hexmsg;print ' hex)'
	call    prtmsg
	ret		;and were done.
.page
;---------------
; Subroutine getCPM:  Get the CP/M version number and
;		      the DMS revision number
getCPM:
        lxi     H,versnum ;where version # is stored
 	mov     A,m     ;what is in memory
	call    cvtbcd	;convert to bcd number and
	call    prtbyt	;print it
	lxi     H,versnum+1;get second byte
	mov     A,m	;get what is in memory
	call    cvtbcd
	call    prtby2  ;print the DMS conversion #
	ret		;that's all folks
;---------
; print char in C (using BDOS)
;
CHAROUT:
	push	PSW	; save A
	mov	E,C	; char is in C
	mvi	C,2	; command 2
	call	BDOS	; print the char
	pop	PSW	; get A back
	ret		; thats all
;----------
; Subroutine prtchr:  Print chrs to the console
; Regs  in:	B =length of string
;		HL=addr of string
; Regs out:	HL=addr of last chr printed
;Destroyed:	B,A
;
prtchr:
	mov	A,M
	call	CONOUT
	dcr	B
	mov	A,B
	cpi	0	; all B chrs printed?
	rz
	inx	H	; next chr addr
	jmpr	prtchr	
.page
;---------------
; Subroutine HLDEconv: convert one or two hex bytes to
;		       a decimal value
; Reg in:  HL
; Reg out: none	
; Destroyed: All
;
HLDEconv:
	lxi	B,string ;where the result is stored
	lxi	D,10000	; convert 10000 place
	call	cvdec	; convert high byte to decimal
	inx	B	; next byte in string
	lxi	D,1000	; convert 1000 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	lxi	D,100	; convert 100 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	lxi	D,10	; convert 10 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	lxi	D,1	; convert 1 place
	call	cvdec	; convert last byte
	ret
;---------------
; Subroutine cvdec:  Convert the hex number
; Reg in:  B = string address
; 	   D = byte to convert
; Reg out: None
; Destroyed: None
;
cvdec:
	mvi	A,30h	; start with 0
	ora	A	; reset the carry flag to 0
cvdsu:
	dsbc	D	; DE sub from HL
	jc	subdone
	inr	A	; next decimal number
	jmpr	cvdsu	; and check again
subdone:
	dad	D	; restore value of HL
	stax	B	; store value in string
	ret
.page
;---------------
; Print a message on the console
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	CONOUT
	inx	H
	jmpr	prtmsg
;----------
; Print a byte on the console, with a dot in the string 
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtbyt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	jrz	..1	; dont print leading zeros
	call	prtnbl
	mvi     A,'.'
	call    CONOUT
..1:	pop	PSW
prtnbl:	ani	0Fh
	adi	'0'
	cpi	'9'+1
	jc	CONOUT
	adi	'A'-('9'+1)
	jmp	CONOUT
.page
;----------
; Print a byte on the console
;  (Do print leading zeros)
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtby2:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	call	..prtnbl
	pop	PSW
..prtnbl:ani	0Fh
	adi	'0'
	cpi	'9'+1
	jc	CONOUT
	adi	'A'-('9'+1)
	jmp	CONOUT
;----------
; Convert binary to BCD
;  Regs in:   A = byte to be converted
;  Regs out:  A = byte, in BCD format
;  Destroyed: B
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
;--------------
; Subroutine retCCP: return to the CCP
;
retCCP:
	lspd    saveSP  ;load the value of the SP when
	ret		;execution started and return  
			;to the CCP
.page
.sbttl 'CONSTANTS'
;
; constants
;
cr	==	0Dh
lf	==	0Ah
BDOS	==      5
usernum ==	47h
idnum   ==      0FFFEh	;prom ID number
versnum ==      0FFFCh	;version # of the op system
Wboot   ==      00h
BDOSadr ==      06h	;loc in BIOS with top of
			;user memory
saveSP:	.word	0
string:	.blkb	5
	.byte	0
;
.page
.sbttl 'CRT messages'
; All CRT information is located here
;
login:	.ascii [cr][lf] 'Help for the user, version '
	.byte  version+'0','.'
	.byte  revision/10+'0',revision@10+'0'
	.byte  patch
	.asciz [cr][lf]
STNmsg: .asciz [cr][lf] 'HiNet user station, version '
MASmsg: .asciz [cr][lf] 'HiNet master, version '
USRmsg: .asciz [cr][lf] 'CP/M version '
IDmsg:  .asciz [cr][lf] 'The CPU ID number is '
FLOPmsg:.ascii [cr][lf] 'If you need your ID number, '
	.ascii		' you need to reboot first.'
	.ascii [cr][lf] 'This is because you have '
	.asciz          'done a floppy disk write.'
MEMmsg: .asciz [cr][lf] 'Top of user memory is '
hexmsg: .asciz          ' hex)'
unkmsg: .asciz		'unknown'
prtHiNetmnu: 		;HiNet command memu
        .ascii [cr][lf] 'Digital Microsystems '
        .ascii          'CP/M and HiNet commands:'
	.ascii [cr][lf]
        .ascii [cr][lf] 'ALLOC    Create or modify the'
        .ascii          ' hard disk allocatio table'
        .ascii [cr][lf] 'ASSIGN   Assign disk device '
        .ascii          'to A,B,C, or D'
        .ascii [cr][lf] 'DIRNET   Display HiNet '
        .ascii          'partition names'
        .ascii [cr][lf] 'FDCOPY   Floppy disk copy '
	.ascii [cr][lf] 'FDHDCOPY Floppy disk copy '
	.ascii		'using a harddisk'
        .ascii [cr][lf] 'FORMAT   Floppy disk format' 
        .ascii [cr][lf] 'HARDBACK Hard disk to floppy '
        .ascii          'backup utility'
        .ascii [cr][lf] 'HARDHELP Hardistest ' 
        .ascii          'and diagnosis'
        .ascii [cr][lf] 'LOGIN    Log into HiNet'
        .ascii [cr][lf] 'SETBAUD  Set baud rate of a '
        .ascii          'serial port'
        .ascii [cr][lf] 'SETTIME  Set the time-of-day'
        .ascii [cr][lf] 'SPOOL    Set spooling mode'
        .ascii [cr][lf] 'TIME     Display time-of-day'
        .ascii [cr][lf] 'USERS    Modify login table'
        .ascii [cr][lf] 'WHO      See who is logged '
        .asciz          'into HiNet'
.page
;
prtCPMmnu: 		;CP/M command menu
;
        .ascii [cr][lf] 'Digital Microsystems CP/M '
        .ascii          'commands:'
	.ascii [cr][lf]
        .ascii [cr][lf] 'ALLOC    Maintaihardis '
        .ascii          'allocatio table'
        .ascii [cr][lf] 'ASSIGN   Assign disk device '
        .ascii          'to A,B,C, or D'
        .ascii [cr][lf] 'DIRHARD  Display hard disk '
        .ascii          'partition names'
        .ascii [cr][lf] 'FDCOPY   Floppy disk copy' 
	.ascii [cr][lf] 'FDHDCOPY Floppy disk copy '
	.ascii		'using a harddisk'
        .ascii [cr][lf] 'FORMAT   Floppy disk format' 
        .ascii [cr][lf] 'HARDBACK Hard disk to floppy '
        .ascii          'disk backup utility'
        .ascii [cr][lf] 'HARDHELP Hardistest and '
        .ascii          'diagnosis'
        .ascii [cr][lf] 'READ0    Read from hard disk '
        .ascii          'partition 0 to a file'
        .ascii [cr][lf] 'SETBAUD  Set baud rate of a '
        .ascii          'serial port'
        .ascii [cr][lf] 'SETTIME  Set time-of-day'
        .ascii [cr][lf] 'TIME     Display time-of-day'
        .ascii [cr][lf] 'WRUN0    Write to hard disk '
        .ascii          'partition 0 from a file'
crlf:   .asciz [cr][lf] 
	.blkw	30
stack:
.end
	