.title	'Set emulation mode for 1280'
	.ident	enable
	.pabs
	.phex
	.loc	100h

vers	==	'1'	; version
rev	==	'2'	; revision
mod	==	' '	; modification
;
; update history:
;
; 1.2  6/7/83	Add a few equates, .page listing,
;		clean up listing, add some comments,
;		set for release. DRB
;
;  A   6/6/83	cleaned up code as per test's
;		suggestions
;
; 1.1  6/2/83	added patch to bios for scr #48
;
; 1.0  5/23/83  wrote this utility to enable hardware
;		hand-shaking for various dms-1280
;		emulation modes.  Mike Pompa
.page
;
; CP/M equates
; 
bdos	==	5	;bdos entry point
conout	==	2	;console byte out
consout ==	9	;console string out
conin	==	1	;console byte input
conio	==	6	;direct console byte out
fcb	==	5ch
;
; ASCII equates
;
ctrln	==	'N' & 1fh
ctrlf	==	'F' & 1fh
ctrltilde ==	'~' & 1fh
ctrlo	==	'O' & 1fh
esc	==	'[' & 1fh	; escape
cr	==	'M' & 1fh	; carriage rtrn
lf	==	'J' & 1fh	; linefeed
apost	==	"`"
chara	==	'A'
charf	==	'F'
tilde	==	'~'
;
; misc equates
;
test	==	1	; 1=no 0=yes
.page
start:	
	pop	h	; save return to ccp
	shld	retpt
	sspd	sptr	; save stack ptr
	lxi	sp,stack ; load local stack
	lxi	d,signon ; sign-on version msg
	mvi	c,consout
	call	bdos
	lxi	h,option ; find terminal option
loop:
	lxi	d,fcb+1	; check cmd line option
	mvi	b,3
	call	blkcmp
	jz	output
	inx	h   ;increment past string ptr
	inx	h
	mov	a,m	; check if done
	cpi	0
	jnz	loop

	lxi	d,ask
	mvi	c,consout ; ask interactively
	call	bdos
again:
	mvi	c,conin	; get 1 byte answer
	call	bdos

	sui	'0'	;convert response to bin
	jc	error	;too low
	jz	finish	;zero option - skip patch
	cpi	6	
	jnc	error	;too high
	dcr	a	;adjust displacement
	push	psw	;save a
	lxi	d,crlf	; new line
	mvi	c,consout
	call	bdos
	pop	psw	;restore a
	lxi	h,inttab ; get table base
	slar	a	; compute offset
	mov	c,a	; bc <- a
	mvi	b,0
	dad	b	; hl <- hl + bc
	jmp	output
error:
	lxi	d,notfound
	mvi	c,consout
	call	bdos
	jmp	again	; loop if invalid
.page	
output:
	mov	a,M	; hl <- (hl)
	inx	h
	mov	h,M
	mov	l,a	; HL = ASCII message
next:
	mov	a,M	; get control char
	cpi	0	; done?
	jz	done	;yes

	push	h	
	mov	e,a	; send char to screen
	mvi	c,conio
	call	bdos
	pop	h

	inx	h	; bump to next char
	jmp	next
.page
; before we go away, let's install a patch to 
; the bios that will disable the adds ctrlp 
; printer code
;
done:
	lxi	h,oldver ; check absence of ver#
	lxi	d,biover ; where bios ver is
	mvi	b,verlen
	call	blkcmp
	jnz	finish	; no don't do it

	lxi	h,oldcode ; check for old code
	lxi	d,biocode ; where old code is
	mvi	b,codlen
	call	blkcmp
	jnz	finish	; no don't do it

	lda	47h	; at a master?
	cpi	0
	jz	finish	; master, don't do it

	mvi	a,ret	; well, it seems ok, 
			; patch a ret operand
	sta	patch	; here goes nothing!
finish:
	lspd	sptr	; restore stack pointer
	lhld	retpt	; ptr to return to ccp
;
.ife test,[jmp	0]	; reboot during test
	pchl		; return to ccp
.page
.sbttl 	'Subroutines'
;---------------
; Subroutine blkcmp:  Compare a block of bytes
;
; Reg in:    hl  points to one string
;	     de	 points to other string
;	     b	 is length to compare
;
; Reg out:   tz	 if match
;	     fz	 if mismatch
;	     hl	 points to end of str1
;	     de	 points to end of str2
; Destroyed: All
;
blkcmp:
	ldax	d
	cmp	m
	jrnz	scan
	inx	h
	inx	d
	djnz	blkcmp
	ret
;
scan:	inx	h
	inx	d
	djnz	scan
	ori	0ffh
	ret
.page
.sbttl	'CRT messages'
;
signon:	.ascii	[lf]'Enable 1280 emulation mode, '
	.ascii	'version '
	.ascii	[vers]'.'[rev][mod][cr][lf][lf]'$'
ask:	.ascii	'0=exit 1=fr 2=tv 3=haz 4=adm 5=adds: $'
notfound: .ascii [cr][lf]'option not found'
	.ascii	', re-enter: $'
crlf:	.ascii	[cr][lf]'$'
;
retpt:	.word	0
sptr:	.blkb	32
stack:
.page
; standard options are: fr tv haz adm adds
; alternatively, use:   1  2  3   4   5
; several other common spellings and misspellings
;  are also acceptable, although not documented
;
; when run interactively, only digit options are valid
;
option:
	.ascii	'FR1'
	.word	fr100
	.ascii	'FR '
	.word	fr100
	.ascii	'1  '
	.word	fr100
;
	.ascii	'TV9'
	.word	tv910
	.ascii	'TE9'
	.word	tv910
	.ascii	'TV '
	.word	tv910
	.ascii	'2  '
	.word	tv910
;
	.ascii	'ADD'
	.word	adds
	.ascii	'ADS'
	.word	adds
	.ascii	'5  '
	.word	adds
;
	.ascii	'ADM'
	.word	adm
	.ascii	'4  '
	.word	adm
;
	.ascii	'HAZ'
	.word	haz
	.ascii	'H14'
	.word	haz
	.ascii	'3  '
	.word	haz
;
	.byte	0
.page
inttab:
	.word	fr100,tv910,haz,adm,adds
fr100:
	.ascii	'free'
	.byte	ctrln
	.ascii	'dom 1'
	.byte	esc,ctrlf
	.ascii	'00'
	.byte	0
tv910:
	.ascii	'tele'
	.byte	ctrln
	.ascii	'video 9'
	.byte	esc,ctrlf
	.ascii	'10'
	.byte	0
haz:
	.ascii	'hazel'
	.byte	esc,apost
	.ascii	'tine 1'
	.byte	esc,ctrlf
	.ascii	'420'
	.byte	0
adm:
	.ascii	'a'
	.byte	ctrlo
	.ascii	'd'
	.byte	esc,apost
	.ascii	'm 3'
	.byte	esc,ctrlf
	.ascii	'/5'
	.byte	0
adds:
	.ascii	'ad'
	.byte	ctrln
	.ascii	'ds 2'
	.byte	esc,tilde
	.ascii	'5'
	.byte	0
.page
; Equates and code for blkcmp and modification  of
; station BIOS so DMS-1280 works correctly
;
biover	==	0dc6ch	; loc of bios version #
			; If it is the old version
oldver:			; a rst 0 is there
	rst	0
verlen	==	.-oldver
;
biocode	==	0ded4h	; The BIOS code to modify
			; starts at this addr and
oldcode:		; looks like this.
	cpi	'P'-40h
here:	rnz		; Here is where we want a RET
	mov	b,a
	lda	3
codlen	==	.-oldcode
			; the patch addr is set up 
patch	==	biocode+here-oldcode ; with an equate
;
	.end

