
	.page
	.sbttl	'history of updates'

	.PABS
	.PHEX
	.SALL
VERSION	==	2
REVISION ==	0 	
assembly ==	' '	;change every assembly
			;last changed 4-May-83
;
;	CRT CONTROL PROGRAM
;
;	FIRST VERSION 6-30-81
;
; 2.0	1-Apr-83	Les Wilson
;	delay 30 seconds before accessing ram to
;	allow power to come to equilibrium
;	correct loading of key with zero length to
;	delete key string
;
; 1.9	14-Dec-82	Les Wilson
;	removed keyboard lock and unlock, made
;	tranposition table to be sent in its
;	entirity rather than a character at a 
;	time.  cause interupt routine to output
;	blank line if attribute chars being changed
;
; 1.8	20-NOv-82	Les Wilson
;	added function key reset and special escape
;	to access rom escape functions even while
;	in emulation mode
;	added ability to save or set brightness and
;	whether whole screen is reversed
;
; 1.7	11-Nov-82	Les Wilson
;	changed from rom defined foreign language
;	sets to full transposition tables for
;	transposing input from the keyboard and
;	for transposing characters before entering
;	into display buffers

; 1.5	20-Oct-82	Les Wilson
;	added ability to send programmable keys
;	to host 

;
; 1.4	7-Oct-82	Les Wilson
;	download now loads 1000h from host
;	no default keys on reset
;	ram memory layout somewhat rearranged

; 1.3	27-Sept-82	Les Wilson
;
;	interupt action goes thru indirect jump word
;	to allow down loaded interupt code
;
	.page
	.sbttl	'special purpose macros'
;
;	output a string to the screen
;
	.define	outstring[stringloc]=[
	lxi	h,stringloc
	call	os	]

;
;	output a string to the error line
;
	.define	outerr[errloc]=[
	lxi	h,errloc
	call	oe	]

;
;	blank a string on the error line from the
;	string to get length
;
	.define	blankerr[errloc]=[
	lxi	h,errloc
	call	be	]

	.page
	.sbttl	'top of rom'
	.loc	romloc
crtfox:
	di
	im1
;
;	initialize screen controller chip
;
	mvi	a,reset8275
	out	crts	;reset 8275 to paramters in next four
			;bytes
	mvi	a,nonspacedrows ! horzcharperrow
	out	crtm
	mvi	a,rowpervrtc ! rowsperframe
	out	crtm
	mvi	a,linenumberofunderline ! linesperchar	
	out	crtm
	mvi	a,lcm ! revnoblink ! charperhrtc ! transparent
	out	crtm


	mvi	a,preset8275counters
	out	crts

	mvi	a,start8275 ! burstspace ! burstlength
	out	crts
;
;	delay 15 seconds to allow power to stabilize
;
	lxi	h,delaylength
..delay:djnz	..delay
	dcx	h
	mov	a,h
	ora	l
	jrnz	..delay

	lxi	sp,normstack	;stack for non interupt use
;
;	start init
;
	lxi	h,data8048
	mvi	m,0
	.ife	revvid,[res normalvideo,m][
 	set	normalvideo,m]
	jmp	init
	.ifg	. - (romloc + 36h),[.prntx 'version overwrite'][
	.prntx	'version ok']
	.loc	romloc + 36h
;	version and revision go just before
;	interupt so they can be in same place in all
;	size roms
	.byte	version
	.byte	revision

	.page
	.sbttl	'crt interupt code'

;
;
	.loc	romloc + 38h	;interrupt code
	exaf
	exx
	sspd	savestackduringinterupt
	lhld	altint		;get inturupt code address
	pchl			;jump to interupt code
normint:			;normal rom interupt processing
	lxi	h,flags1 ;set flag that active
	set	intactive,m
;
;	see if screen (8276) on last line
;
	in	crts
	bit	5,a
	cnz	resync	;vertical sync not correct
go:
        lxi	h,count1
        dcr	m
	jrnz	sendbit
	inr	m
	lxi 	h,count4
 	dcr	m
	jrnz	syncflg
 	inr	m
	lxi	h,count3
 	dcr	m
	jrnz	usual
 	inr	m
	lxi	h,count2
 	dcr	m
	jrnz	sendbit
 	inr	m
	lxi	h,count5
 	dcr	m
 	jrnz	syncflg
	lxi	h,counts	;reinit all counts
	lxi	d,linedisplaying
	lxi	b,cntlen
	ldir
	jmp	messstuff	;go stuff message to kybd bits
sendbit:lxi	h,messout
	slar	m		;get ready for next bit in messout
	bit	3,m
	lxi	h,data8048
	jrz	..res
	set	datatokey,m	
	jmpr	..int
..res:	res	datatokey,m
..int:	res	intkeyboard,m
	res	disakeyout,m
	mov	a,m
 	out	int8048
;	nop		;give 8048 some time
;	nop
;	nop
;	nop
;	nop		;5
;	nop
;	nop
;	nop
;	nop
;	nop		;10
;	nop
;	nop
;	nop		;13
;	nop
;	nop		;15
;
;	fifteen timing nops now replaced with
;	following code which should take 60 cycles
;	to execute
;
	mvi	b,5
..stall:djnz	..stall

	set	intkeyboard,m
	mov	a,m
 	out	int8048
 	jmpr	usual
syncflg:
	lxi	h,data8048
	set	disakeyout,m	;sync bit
	res	intkeyboard,m
	mov	a,m
 	out	int8048
 	lxi	h,flags1
 	set	readabit,m
endsync:
;	nop		;give the 8048 some time
;	nop
;	nop
;	nop
;	nop		;5
;	nop
;	nop
;	nop
;	nop
;	nop		;10
;	nop
;	nop
;
;	twelve timing nops now replaced with
;	following code which should take 52 cycles
;	to execute
;
	mvi	b,4
..stall:djnz	..stall

	lxi	h,data8048
	set	intkeyboard,m
	mov	a,m
	out	int8048
usual:  lhld	tabadr		;adr of next line info
	mov	e,m
	inx	h
	mov	d,m
	inx	h
;
;	see if number of attribute characters is being
;	altered, if so output nullline rather
;	than mucked up one

	push	h
	lxi	h,flags2
	bit	alterattribute,m
	jrnz	..mucked
	bit	linealterattribute,m
	jrz	..notmucked
	lda	linechanging
	lxi	h,linedisplaying
	cmp	m
	jrnz	..notmucked
..mucked:
	pop	h
	xchg
	lxi	sp,nullline + 8000h	;set high bit 
				;for 8275
	jmpr	pop40		;output null line
..notmucked:
	pop	h
	mov	c,m
	bit	0,c	;see if odd number of extra
			;characters on line
	jrz	..notodd
	ldax	d	;get one character into 8275buf
	inx	d
..notodd:
	xchg
	sphl		;stack pointer set up for pops
			;now decide how many pops
	srlr	c	;divide by two
	mvi	b,0	;clear high bytes
	lxi	h,pop40
	ora	a	;clear carry
	dsbc	b
	pchl
dopop:	
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
pop40:
	mvi	b,4
..pop40loop:
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h
	pop	h

	djnz	..pop40loop
	xchg
	inx	h
	lda	linedisplaying	;check for last line
	inr	a
	sta	linedisplaying
	cpi	linesonscreen
	jrnz	..2
	lxi	h,disptab
..2:	shld	tabadr
        lxi	h,flags1
 	bit	readabit,m
 	jrnz	recvbit
return:	
	lxi	h,flags2
	bit	masstransfer,m
	jrnz	..xchgregisters	;dont get chars from
			;host if mass transfer going
			;on
	lxi	sp,intstack
	call	gethost	;see if any chars from host
..xchgregisters:
	exaf
	lxi	h,flags1  ;no longer active
	res	intactive,m
	exx 
	lspd	savestackduringinterupt
	ei
	ret

;
;	receive bits from keyboard
;
recvbit:in	ppstat
 	ani	80h
 	lxi	h,keycollect
 	srlr	m
 	ora	m
 	mov	m,a
 	lxi	h,bitcount
 	dcr	m
 	jrnz	return
 	mvi	m,08h
 	lxi	h,flags1
 	res	readabit,m
 	ora	a		;0 and 0ffh are ignored
	jrz	return
 	cpi	0ffh
	jrz	return

;	actually place character in queue of received 
;	characters

	cpi	resetchar
	jz	0	;start as if from hard
				;reset
	cpi	flushchar	;see if flush of buffer
	jrnz	..queue		;desired
	lxi	h,flags2
	set	flushrequested,m
..queue:
;
;	if not a function key, transpose before
;	placing in queue
;
	bit	7,a	;set for function keys
	jrnz	..notranspose
	lxi	h,kybdtranspose	;transpose kybd input
	add	l
	mov	l,a
	mov	a,m
..notranspose:
	lxi	h,keyqin  ;address of queue structure
	lxi	sp,intstack	;get a normal stack
	call	enque
 	jmpr	return

;
;	stuff message to keyboard bits for next time
;
messstuff:
	lxi	h,flags1
	bit	messbit,m
	jrz	zeromessout
	res	messbit,m
	lda	nxtmessout
	sta	messout
gosyncflg: jmp	syncflg
zeromessout:
	xra	a
	sta	messout
 	jmpr	gosyncflg

;
;	get back in sync with vertical
;
resync:
	lxi	h,counts
	lxi	d,linedisplaying
	lxi	b,cntlen
	ldir
	lxi	d,disptab
	sded	tabadr
	ret
 
	.page
	.sbttl	'initialization'

;
init:
	mov	a,m
	set	disakeyout,a
	out	int8048
      	lxi	h,begfree	;start of unallocated disp ram
	shld	nextmem		;next mem to allocate
	lxi	h,begdr		;beggining of display region
	lxi	d,begdr+4
	
;
;	fill buffer with Fox
;
	mvi	m,'F'
	inx	h
	mvi	m,'o'
	inx	h
	mvi	m,'x'
	inx	h
	mvi	m,' '
	dcx	h
	dcx	h
	dcx	h
	lxi	b,topdr-begdr-4	;len of disp ram
	ldir
;
;	initialize programmable	key table
;
initprog:
	lxi	h,progtab	;zero the table first
	lxi	d,progtab+1
	lxi	b,lenprogtab-1
	mvi	m,0
	ldir

	lxi	h,lenpbuf
	shld	freeinprogbuf	;make all space in buffer
				;availible
;
;	initialise keyboard and display transposition
;	tables to unity
;
	call	initkybdtranspose
	call	initdisptranspose
;
;	blank error line and null line
;
	lxi	h,errline
	lxi	d,errline+1
	lxi	b,lenstatusline + charsperline - 1
	mvi	m,' '
	ldir

;
;	set up circular queue pointers
;
	mvi	a,2
	sta	houtqin
	sta	hinqin

	sta	keyqin
	mvi	a,typeahead+2
	sta	houtqout
	sta	hinqout
	sta	keyqout

;
;	set default bell length and frequency
;
	lxi	h,100
	shld	cgbellen
	lxi	h,55
	shld	cgbelfreq

;
;	set default screen brightness
;
	mvi	a,8
	sta	valuebrightness
	out	portbrightness

	lxi	h,defparam	;set default scrn param
	lxi	d,scrno
	lxi	b,paramlen
	ldir
	call	resync
;
;	init top line on screen as being a single
;	line at the beginning of screen data region
;
	mvi	a,(errline)&0ffh	;low byte of address
	stax	d
	inx	d
	mvi	a,((errline)>8)!80h	;high byte of address
				;with high bit set for pop stuff
	stax	d
	inx	d
	xra	a		;count of extra chars on line
	stax	d
	inx	d
	call	creatscrn	;24*80 main screen

;
;	create screen for use of crt
;	in programming key displays
;
	call	savescrn	;save host screen
	lxi	h,defparam	;set default scrn param
	lxi	d,scrno
	lxi	b,paramlen
	ldir
	mvi	a,crtscrn
	sta	scrno
	lxi	d,disptab+3	;init pointer to 
				;disptab for creatscrn
	call	creatscrn	;create the crt's screen
	call	savescrn	;save the crt's screen

	mvi	a,hostscrn
	call	restorescrn	;restore the host screen

	lxi	h,charact
	shld	acttabloc	;location of character action table
	lxi	h,normact
	shld	actspecial	;action to take in dochar routine
	lxi	h,normesc
	shld	altesc		;action to take in processing 
				;escape sequences
	lxi	h,normasc	;action to take in 
	shld	ascspecial	;processing printable
				;ascii (gotasc routine)
	lxi	h,normint	;action to take in interupts
	shld	altint		;store in indirect word

	xra	a			
	sta	keyflag
	sta	keydata
 	sta	messout
	sta	flags1
	sta	flags2
 	lxi	h,bitcount
 	mvi	m,08h

	
;
;	set up cursor postion and start it up
;
	call	newcursor
	ei

	.page
	.sbttl	'main loop'

;
;	main loop
;
mainloop:
	lxi	h,flags2
	bit	flushrequested,m
	cnz	flushkeyin
	lxi	h,flags1
	bit	zerodup,m	;see if in zero 
	jrnz	..getkybd	;duplex mode
	call	gethost		;get host into queue
	lxi	h,hinqin
	call	deque		;input from host
	cnz	dochar		;if yes
	call	puthost		;check for out to host
..getkybd:
	call	getkey		;chek in from keyboard
	jrz	mainloop
	lxi	h,flags2
	bit	kybdlocked,m	;ignore chars from
	jrnz	mainloop	;keyboard if locked
	call	prockybd	;process key from keyboard
	jmpr	mainloop

	.page
	.sbttl	'process character from keyboard'
prockybd:
 	bit	7,a		;msb means local command
 	jrz	notlocal
	mov	b,a
	ani	60h
	xri	60h
	mov	a,b
	jrz	dolocal	;treat control shift keys as 
			;local,return from there
	lxi	h,flags1
	bit	passprog,m
	jrz	dolocal	;treat keys as local
notlocal:
	lxi	h,flags1
	bit	zerodup,m	;see if in zero dup mode
	jrnz	..iszerodup	;process,but dont 
				;send to host
	lxi	h,flags2
	bit	inblockmode,m	;if in block mode
	jrnz	..iszerodup	;process but dont 
				;send to host
 	jmp	qhout		;que for output
				;return from there
..iszerodup:		;zerodup,put char on screen
	jmp	dochar	;return from there

getkey:			;get keyboard input if any
	lxi	h,keyqin
	jmp	deque	;return from there
	
	.page
	.sbttl	'local command from keyboard'

;
dolocal:			;local command from keyboard
	push	psw		;save the key
	ani	60h		;see if cntr and shift both set
	xri	60h
	jrz	locreserved	;a reserved key
	pop	psw		;restore the char
	call	keyaddress	;get address of key
				;string
	mov	a,h
	ora	l
	rz		;no string to output
	mov	a,m		;count of chars in string
	mov	c,a
	mvi	b,0
	dad	b
	inx	h		;point one past string
pkloop:				;loop putting string into 
	dcx	h		;keyboard buffer
	push	psw		;save count
	mov	a,m
	push	h		;save string pointer
	call	aintolifo	;put a reg in keyinq
				;lifo
	pop	h		;restore string pointer
	pop	psw		;restore count
	dcr	a
	jrnz	pkloop
	ret		;go process some more

;
;	passed programable key code in a
;	return keystring address in hl
;
keyaddress:
	ani	7fh		;get rid of high order bit
	slar	a		;mult by two
	mov	e,a
	mvi	d,0
	lxi	h,progtab
	dad	d		;get address of entry
	indirect		;get address of string
	ret

locreserved:			;process reserved keys
	pop	psw		;restore the key
	cpi	resetchar
	jz	0	;take action as if 
				;hardware reset
	cpi	trapchar	;enter trap mode key
	jrz	traptoggle
	cpi	progchar
	jrz	progkey
	cpi	localchar
	jrz	zdtoggle
	cpi	flushchar
	jrz	flushkeyin
	cpi	escchar
	jrz	escin
	ret

escin:		;process as rom escape even
			;if emulation active
	lxi	h,normesc
	shld	actspecial
	ret

flushkeyin:			;flush unprocessed
		;chars from keyboard and chars to 
		;be sent to host that haven't gone
		;out yet
	mvi	a,2	;next in
	sta	keyqin
	sta	houtqin
	mvi	a,typeahead+2	;next out
	sta	keyqout
	sta	houtqout
	lxi	h,flags2
	res	flushrequested,m
	ret

traptoggle:			;toggle the trap setting
	lxi	h,flags1
	bit	traprequested,m
	jrz	..settrap
	res	traprequested,m	;reset trap(disable)
	lxi	h,mbf7		;erase mode message
	jmp	be		;return from there
..settrap:
	set	traprequested,m
	lxi	h,mbf7		;trap mode message
	jmp	oe		;return from there

zdtoggle:			;toggle the zeroduplex setting
	lxi	h,flags1
	bit	zerodup,m
	jrz	..setzerdup
	res	zerodup,m	;reset zerodup flag
	lxi	h,mbf8		;erase mode message
	jmp	be		;return from there
..setzerodup:
	set	zerodup,m
	lxi	h,mbf8		;local message
	jmp	oe		;return from there

	.page
	.sbttl	'program keys from keyboard'
progkey:
	call	savescrn
	mvi	a,crtscrn
	call	restorescreen	;get crtscreen up
;
;	save all parameters that may be altered
;	by a running emulation program and set
;	them to ROM defaults for proper screen
;	editing of strings
;
	lhld	acttabloc
	push	h
	lxi	h,charact
	shld	acttabloc

	lhld	actspecial
	push	h
	lxi	h,normact
	shld	actspecial

	lhld	altesc
	push	h
	lxi	h,normesc
	shld	altesc

	lhld	altint
	push	h
	lxi	h,normint
	shld	normint

	lhld	ascspecial
	push	h
	lxi	h,normasc
	shld	ascspecial

	call	erase		;erase the screen
..askwhich:
	outstring mbf14		;ask which key to program
..whichkey:
	call	getkey
	jrz	..whichkey
	call	blanklast	;blank any old error message
	cpi	progchar	;compare for exit key
	jz	pkexit
	bit	7,a		;see if a programable
	jrnz	..isprogkey	;function key
..notprogkey:
	outstring mbf15		;give error message
..outbell:
	call	gotbell
	lxi	h,flags1
	set	pkerr,m		;flag that error on
	jmpr	..askwhich	;screen
..isprogkey:
	sta	newkey		;save key
	ani	60h		;see if a reserved key
	xri	60h
	jrnz	..notreserved
	jmpr	..notprogkey
..notreserved:
	outstring mbf14
	lda	newkey
	call	dispkey
	mvi	a,' '
	call	gotasc
;
;	copy string to work area
;
	lda	newkey		;key to program
	ani	7fh		;strip high bit
	slar	a		;mult by 2
	mov	e,a
	mvi	d,0
	lxi	h,progtab
	dad	d		;point to string pointer
	indirect		;hl points to string
	mov	a,h
	ora	l
	jrnz	..stringexists
	xra	a
	sta	newstring	;length
	jmpr	..callkeystring
..stringexists:
	mov	a,m		;string length
	mov	c,a
	mvi	b,0
	inx	b		;string length including string byte
	lxi	d,newstring	;place to copy to
	ldir
..callkeystring:
	call	keystring	;display the string
;
;	go get the new string, if first character
;	is any but cntr shift f1 then erase old
;	string and make char part of new string
;
	outstring mbf27
..fgetkey:call getkey
	jrz	..fgetkey
	cpi	progchar
	jrz	..saveasis
	push psw
	xra	a
	sta	newstring	;zero length
	pop	psw
	jmpr	..gotfirst
..goget:
	call	keystring
..ggchar:call	getkey
	jrz	..ggchar
..gotfirst:
	call	blanklast
	push	psw	;save char
	cpi	progchar	;see if complete
	jrz	..complete
	cpi	delchar	;see if delete desired
	jrz	..delete
;stick character in if room
	lda	newstring
	cpi	typeahead
	jrnz	..lenok
..toss:
	pop	psw	;toss char
	jmpr	..goget
..lenok:
	inr	a
	sta	newstring
	mov	c,a
	mvi	b,0
	lxi	h,newstring
	dad	b		;point to next char pos
	pop	psw		;restore char
	mov	m,a		;store char
	jmpr	..goget		;go get another char
..delete:
	lda	newstring
	ora	a		;see if zero length
	jrz	..toss
	dcr	a		;make length one less
	sta	newstring
	jmpr	..toss		;toss char
..complete:
	pop	psw		;toss char
;
;	save the current string
;
..saveasis:
	lda	newkey
	lxi	h,newstring
	call	inskey		;insert into table
	jmp	pkexit

;
;	blank the last (error) line on screen
;
blanklast:
	push	psw
	lxi	h,flags1
	bit	pkerr,m
	jrz	..blexit
	res	pkerr,m
	outstring mbf33
..blexit:
	pop	psw
	ret

;
;	display a keystring from newstring location
;
keystring:
	outstring mbf24
	lda	newstring	;string length
	lxi	h,newstring+1	;point to first char
ksloop:
	cpi	0
	jrz	ksend
	push	psw
	push	h
	mov	a,m
	call	dispkey
	pop	h
	pop	psw
	inx	h	;point to next char
	dcr	a	;decrement string length count
	jmpr	ksloop
ksend:
	outstring mbf25
	ret

;
;	display a key passed in a reg
;	make all special keys displayable
;
dispkey:
	push	psw
	bit	7,a		;see if function key
	jnz	..dsfunc
	cpi	' '		;see if printable
	jrc	..notprintable
	cpi	delete
	jrnz	..gotasc
	lxi	h,mbf1
	jmpr	..outstring
..gotasc:
	call	gotasc
	pop	psw	;restore stack
	ret

..notprintable:
	cpi	home
	jrnz	..nothome
	lxi	h,mbf16
	jmpr	..outstring
..nothome:
	cpi	forward
	jrnz	..notforward
	lxi	h,mbf17
	jmpr	..outstring
..notforward:
	cpi	bell
	jrnz	..notbell
	lxi	h,mbf18	
	jmpr	..outstring
..notbell:
	cpi	backward
	jrnz	..ntbackward
	lxi	h,mbf19
	jmpr	..outstring
..ntbackward:
	cpi	tab
	jrnz	..nottab
	lxi	h,mbf20
	jmpr	..outstring
..nottab:
	cpi	lf
	jrnz	..notlf
	lxi	h,mbf35
	jmpr	..outstring
..notlf:
	cpi	erascr
	jrnz	..noterascr
	lxi	h,mbf21
	jmpr	..outstring
..noterasecr:
	cpi	cr
	jrnz	..notcr
	lxi	h,mbf34
	jmpr	..outstring

..notcr:
	cpi	up
	jrnz	..notup
	lxi	h,mbf22
	jmpr	..outstring
..notup:
	cpi	escape
	jrnz	..ntescape
	lxi	h,mbf23
..outstring:
	pop	psw	;get char off stack
	jmp	os	;return from there

..ntescape:			;put out control char
	mvi	a,'^'
	call	gotasc
	pop	psw
	push	psw
	adi	'`'
	jmpr	..gotasc
;
;	display a function key
;
..dsfunc:			;first see if key is shifted or controlled
	bit	6,a
	jrnz	..cntset
	bit	5,a
	jrz	..prefixdone
	mvi	a,'$'		;key is shifted
	call	gotasc
	jmpr	..prefixdone
..cntset:
	bit	5,a
	jrz	..noshift
	mvi	a,symcntrshift	;both controll and shift char
	call	gotasc
	jmpr	..prefixdone
..noshift:
	mvi	a,'^'
	call	gotasc
..prefixdone:
	mvi	a,'F'
	call	gotasc
	pop	psw	;restore the char
	push	psw
	ani	1fh	;strip control shift bits
	mvi	b,'0'	;convert to decimal
..tenloop:
	sui	10
	jc	..tendone
	inr	b
	jmpr	..tenloop
..tendone:
	adi	'0'+10
	mov	c,a
	push	b	;save both digits	
	mov	a,b
	cpi	'0'
	jrz	..ntfirst
	call	gotasc
..ntfirst:
	pop	b
	mov	a,c
	jmp	..gotasc
	.page
;
;	exit from programming keys
;
pkexit:
;
;	restore screen parameters that may
;	have been active for emulations at time
;	of programming keys
;
	pop	h
	shld	ascspecial
	pop	h
	shld	altint
	pop	h
	shld	altesc
	pop	h
	shld	actspecial
	pop	h
	shld	acttabloc

	mvi	a,hostscrn
	call	restorescreen	;restore host screen
	jmp	setcur		;restore the cursor
				;return from there

	.page
	.sbttl	'host communication routines'
qhout:	lxi	h,houtqin	;host output que
 	jmpr	enque		;put A in que
				;ret from there

gethost:di 
	in	ppstat		;get par port stat
	bit	0,a
	jrz	fullqueue
;
;	see if any room left in buffer
;
	lxi	h,hinqin
	mov	a,m
	inx	h
	cmp	m
	jrz	fullqueue	;queue full,leave 
				;data in port
	dcx	h
	in	ppdati   	;get data
	jmpr	enque		;go put data in queue
				;and exit from there

puthost:		;send char to host if avail
	in	ppstat	;see if port busy
	bit	2,a
	rnz
	lxi	h,houtqin	;address of host queue
	call	deque
	rz			;no chars
	out	ppdato
	jmpr	puthost		;see if any more chars to output

forcehost:		;output char in c to host
	in	ppstat
	bit	2,a
	jrnz	forcehost
	mov	a,c
	out	ppdato
	ret

	.page
	.sbttl	'circular queue routines'

;
;	on input a is char to put in queue
;	hl is address of queue structure
;
enque:			;put (A) into que (HL)
	di
	mov	c,a	;save char
	mov	a,m	;nextin
	inx	h
	cmp	m	;compare nextin with nextout
	jrz	fullqueue
	dcx	h
	push	h
	mvi	d,0
	mov	e,a
	dad	d	;point to nextin spot in buffer
	mov	m,c	;put char in buffer
	inr	a	;compute nextin + 1
	ani	typeahead+2
	jrnz	..1
	mvi	a,2	;wraparound
..1:	pop	h
	mov	m,a	;store new nextin
fullqueue:
	lxi	h,flags1
	bit	intactive,m
	rnz		;dont enable interupts if
			;called from interupt routine
	ei
	ret
;
;	on input a is char to put in queue
;	hl is address of queue structure
;	entry is made to end of structure so
;	it will be first out
;
lifoque:			;put (A) into que (HL)
	di
	mov	c,a	;save char
	mov	a,m	;nextin
	inx	h
	cmp	m	;compare nextin with nextout
	jrz	fullqueue
	push	h
	mvi	d,0
	mov	e,m
	dcx	h
	dad	d	;point to nextout spot in buffer
	mov	m,c	;put char in buffer
	pop	h
	mov	a,m
	dcr	a	;compute nextout - 1
	cpi	1
	jrnz	..1
	mvi	a,typeahead+2	;wraparound
..1:	mov	m,a	;store new nextout
	jmpr	fullqueue

;
;	on input hl points to queue structure
;	on return a has character
;	if no character a is zero, and zero flag
;	is set
;
deque:			;load (A) from que (HL)
	mov	c,m	;nextin
	inx	h
	mov	a,m
	inr	a	;a = nextout + 1
	ani	typeahead+2
	jrnz	..1
	mvi	a,2	;wraparound
..1:	mov	b,a	;save nextout + 1
	sub	c
	jrz	..ret		;no characters 
	push	h
	dcx	h
	mvi	d,0
	mov	e,b
	dad	d
	mov	a,m	;get the character
	pop	h
	mov	m,b	;store nextout
..ret:	
	push	psw	;save zero flag
	lxi	h,flags1
	bit	intactive,m
	jrnz	..notactive
	pop	psw	;restore zero flag
	ret		;dont enable since called
			;from interupt
..notactive:
	pop	psw	;restore zero flag
	ei
	ret		;found

	.page
	.sbttl	'character processing'

;
;	find action to take for character
;
dochar:	

	lxi	h,flags1	;see if in trap mode
	bit	traprequested,m
	jrz	notrap
	push	psw		;save the char
	call	errchar		;display char in hex on errline
	mvi	a,'A'		;trap active
	sta	errline+7
traploop:			;wait for char from keyboard
	call	getkey		;and discard
	jrz	traploop
	cpi	trapchar
	cz	traptoggle	;get out of trap mode
	mvi	a,'D'		;trap done
	sta	errline+7
	pop	psw		;restore char and process
notrap:

	lhld	actspecial	;see if any special 
	pchl		;actions needed (escape sequences)
normact:
	bit	7,a	;in case high bit set
	jnz	dolocal	;process as special character
			;return from there
	cpi	7fh
	jrz	donull	;toss delete chars
	cpi	' '	;first printable ascii
	jrnc	gotasc	

	lhld	acttabloc
	slar	a	;double character value
	mov	e,a
	srlr	a	;restore character
	mvi	d,0
	dad	d	;hl points to entry in table
	mov	e,m
	inx	h
	mov	d,m
	xchg		;hl has routine entry point
	pchl	



donull:	ret		;null action


;
;get here with printable ascii
;
gotasc:
	lhld	ascspecial	;perform special
	pchl			;actions if needed
;
;	perform display transposition
;
normasc:
	lxi	h,disptranspose
	add	l	;add character to table 
	mov	l,a	;which is on boundary to
	mov	a,m	;assure no carry
	lhld	nextchar	;adr of next screen pos
	mov	m,a		;insert char
	inx	h
	call	skipattributechar
	lxi	h,maxchar	;end of line
	dcr	m
	jz	docrlf		;yes, scroll
	jmp	bumpcur		;move curser,return 
			;form there

	.page
	.sbttl	'escape sequences'
;
;	escape sequence processing
;
esckey:	lxi	h,esc2nd	;wait for second char of
	shld	actspecial	;escape sequence
	ret
esc2nd:
;
;	if alternate esc processing desired
;	go do it
;
	lhld	altesc
	pchl
normesc:
	mov	b,a	;save char
	lxi	h,esctab
..escloop:
	mov	a,m
	ora	a
	jz	normret	;invalid char
	inx	h
	cmp	b
	jrz	..found
	inx	h
	inx	h
	jmpr	..escloop
..found:
	mov	e,m
	inx	h
	mov	d,m
	xchg
	pchl		;jump to routine

esctab:			;table of escape sequences
			;and addresses to process	
	.ascii	'a'
	.word	setfalternate
	.ascii	'A'
        .word	setalternate
	.ascii	'b'
	.word	setbrighter
	.ascii	[bell]
	.word	setbell
	.ascii	'B'
	.word	setblink
	.ascii	'C'
	.word	loadcode
	.ascii	'd'
	.word	setdimmer
	.ascii	'E'
	.word	seteveryattribute
	.ascii	'g'
	.word	getakeystring
	.ascii	'h'
	.word	hidecontrol
	.ascii	'H'
	.word	sethighlight
	.ascii	'i'
	.word	saveintensity
	.ascii	'I'
	.word	setintensity
	.ascii	'k'
	.word	doeratoendofscreen
 	.ascii	'K'
 	.word	doeraline
	.ascii	'l'
	.word	loadkey
	.ascii	'N'
	.word	setnormal
	.ascii	'p'
	.word	setpassprog
	.ascii	'P'
	.word	resetpassprog
;	.ascii	'r'
;	.word	dispresyncs
	.ascii	'R'
	.word	videoreverse
	.ascii	's'
	.word	showchars
	.ascii	'S'
	.word	setstandard
	.ascii	'T'
	.word	togglevideo
	.ascii	'U'
	.word	setunderline
	.ascii	'V'
	.word	dispversion
	.ascii	'w'
	.word	wishkybdtransposition
	.ascii	'W'
	.word	wishdisptransposition
	.ascii	'X'
	.word	examine
	.ascii	'Y'
	.word	curset
	.ascii	'z'
	.word	zerokybdtransposition
	.ascii	'Z'
	.word	zerodisptransposition
	.byte	0		;end of table
;
;	invalid escape sequence, ignore
normret:
	lxi	h,normact
	shld	actspecial
 	ret

;
;	convert reg a to ascii hex and display on error line
;
errchar:
	call	makehex
	mov	a,b
	sta	errline
	mov	a,c
	sta	errline+1
	ret

;
;	convert reg a to ascii hex high nibble in b and low in c
;	reg a is destroyed in process
;
makehex:
	push	psw
	srlr	a
	srlr	a
	srlr	a
	srlr	a	;get high nibble
	cpi	10
	jrc	..add0
	adi	'A'-10
	jmpr	..savhigh
..add0:
	adi	'0'
..savhigh:
	mov	b,a
	pop	psw
	ani	0fh	;get low nibble
	cpi	10
	jrc	..2add0
	adi	'A'-10
	jmpr	..savlow
..2add0:
	adi	'0'
..savlow:
	mov	c,a
	ret

	.page
	.sbttl	'load code from host and execute'

;
;	expect a 1024 bytes of code from host
;	to be loaded at 4000h
;
loadcode:
	.ife	romenterdloc,[
	lxi	h,code	;place to put
	lxi	b,lencode
	][
	lxi	h,7400h	;put downloaded stuff
	lxi	b,lencode - 400h
	]	;at end of ram if rom code is 
		;in ram
	call	domasstransfer
	.ife	romenteredloc,[
	jmp	code ][
	jmp	7400h ]

;
;	do a mass transfer of data from host.
;	first empty out queue then talk directly
;	to port, setting flag that interupt
;	routine should not get characters
;	into queue
;	on input registers:
;		hl - address of place to put data
;		bc - count of transfer
domasstransfer:
	push	h
	lxi	h,flags2
	set	masstransfer,m
	pop	h

..emptyqueueloop:
	push	h
	push	b
..ishostready:			;does host have
	lxi	h,hinqin	;char
	call	deque
	jrz	..dodirect
..charready:
	pop	b
	pop	h
	call	putmem
	jrnz	..emptyqueueloop
	jmpr	..done

..dodirect:
	pop	b
	pop	h
..loop:
	in	ppstat
	bit	0,a	;see if anything ready
	jrz	..loop
	in	ppdati
	call	putmem
	jrnz	..loop
..done:
	lxi	h,flags2
	res	masstransfer,m
	ret

putmem:
	mov	m,a		;put char in memory
	inx	h
	dcx	b		;do we have them all
	mov	a,b
	ora	c
	ret

	.page
	.sbttl	"get a programable key's string"

;
;	get a programable key's string for host
;
getakeystring:
	lxi	h,..whichkey
	shld	actspecial
	ret
..whichkey:
	bit	7,a	;see if programable key
	jrz	..gonormret	;is not return
	mov	b,a
	ani	60h
	xri	60h
	jrz	..gonormret	;is reserved key
	mov	a,b
	call	keyaddress	;get address of string
	mov	a,h
	ora	l
	jrnz	..notnull
	mvi	c,0		;char count for null
	call	forcehost	;output char to host
..gonormret:
	jmpr	tnr
..notnull:
	push	h
	lxi	h,flags1
	bit	zerodup,m
	pop	h
	jrnz	..islocal
	mov	b,m	;length of string
	inr	b	;include length byte in count
..forceloop:		;loop outputing string
	mov	c,m
	call	forcehost
	inx	h
	djnz	..forceloop
	jmpr	tnr
..islocal:
	mov	a,m
	inr	a
	mov	c,a
	mvi	b,0
	dad	b
	call	pkloop	;lifo the string
	jmpr	tnr

	.page
	.sbttl	'examine crt memory contents'
;
;	input memory location in hex is displayed
;
examine:
	lxi	h,exam1
examret:
	shld	actspecial
	ret

exam1:
	call	hexbinary
	slar	a
	slar	a
	slar	a
	slar	a	;get to left
	sta	examloc+1	;get high order digits first
	lxi	h,exam2
	jmpr	examret

exam2:
	call	hexbinary
	lxi	h,examloc+1
	ora	m
	mov	m,a
	lxi	h,exam3
	jmpr	examret

exam3:
	call	hexbinary
	slar	a
	slar	a
	slar	a
	slar	a	;get to left
	sta	examloc
	lxi	h,exam4
	jmpr	examret

exam4:
	call	hexbinary
	lxi	h,examloc
	ora	m
	mov	m,a
	lhld	examloc
	mov	a,m
	call	errchar		;display value of 
	jmpr	tnr		;memory location
;
;	convert a hexidecimal ascii code to binary
;	from and to a register
;
hexbinary:
	cpi	'A'
	jrnc	..islet
	sui	'0'
	ret
..islet:
	sui	'A'-10
	ret

	.page
	.sbttl	'transposition tables setup'
;
;	routines to initialise keyboard
;	and display transposition tables
;	on initialisation the tables will
;	indicate use of each entry for itself
;	(identity)
;
zerokybdtranspose:		;set to unity
	call	initkybdtranspose
tnr:	jmp	normret
zerodisptranspose:		;set to unity
	call	initdisptranspose	
	jmpr	tnr

initkybdtranspose:
	lxi	h,kybdtranspose
inittranspose:			;entry for disp init usage
	mvi	b,lentranspose
	xra	a	;zero a
..initloop:
	mov	m,a
	inr	a
	inx	h
	djnz	..initloop
;
;	shift 0 produces a 1eh code from the keyboard.
;	we wish to make the default transposition of this
;	to be 0 (30h)
	lxi	h,kybdtranspose + 1eh
	mvi	m,'0'
	ret

initdisptranspose:
	lxi	h,disptranspose
	jmpr	inittranspose

;
;	the following routines update
;	the entire transposition tables
;
wishkybdtransposition:
	lxi	h,kybdtranspose
comtransposition:
	lxi	b,lentranspose
	call	domasstransfer
	jmpr	tnr

wishdisptransposition:
	lxi	h,disptranspose
	jmpr	comtransposition


	.page
	.sbttl	'show all chars on screen'

showchars:
	xra	a	
scloop:
	push	psw
	call	gotasc
	pop	psw
	inr	a
	cpi	128
	jrnz	scloop
	jmpr	tnr

	.page
	.sbttl	'toggle passing programable keys to host'

setpassprog:	;set up to pass programable keys to host
	lxi	h,flags1
	set	passprog,m
	outerr	mbf13
	jmpr	tnr

resetpassprog:	;set up to process programable keys to strings
	lxi	h,flags1
	res	passprog,m
	blankerr mbf13
	jmpr	tnr

	.page
	.sbttl	'load a programable key'

loadkey:		;set up to get key to program
	lxi	h,lkkey
	shld	actspecial
	ret
lkkey:
	sta	newkey
	ani	80h
	jrz	lnr	;ignore if invalid key
	lxi	h,lklen
	shld	actspecial
	ret
lklen:
	sta	newstring	;store length of new string
	sta	charsremaining
	ora	a	;make sure length is ok
	jrnz	..checktoolong
	lda	newkey	;delete key if length is zero
	call	delkey
	jmpr	lnr
..checktoolong:
	cpi	typeahead+1
	jrnc	lnr

	lxi	h,newstring+1	;place to stuff chars
	shld	charplace
	lxi	h,lkchars	;place to process chars
	shld	actspecial
	ret
lkchars:
	lhld	charplace
	mov	m,a		;store the char
	inx	h
	shld	charplace
	lda	charsremaining
	dcr	a
	sta	charsremaining
	cpi	0
	rnz
;
;	string is ready
;
	lda	newkey
	lxi	h,newstring
	call	inskey		;insert key into table
lnr:	jmp	normret

	.page
	.sbttl	'overall brightness control'
;
;	set the brightness one increment brighter
;
setbrighter:
	lda	valuebrightness
	inr	a
	sta	valuebrightness
	cpi	16
	jrc	outbright
	mvi	a,15
	sta	valuebrightness
outbright:
	out	portbrightness
	jmpr	lnr
	
;
;	set the brightness one increment dimmer
;
setdimmer:
	lda	valuebrightness
	dcr	a
	sta	valuebrightness
	cpi	0ffh
	jrnz	outdim
	xra	a	
	sta	valuebrightness
outdim:
	out	portbrightness
	jmpr	lnr

;
;	save intensity by passing back byte with
;	high bit set to indicate reverse video
;	screen and low four bits indicating 
;	intensity
saveintensity:
	lda	valuebrightness
	lxi	h,data8048
	bit	normalvideo,m
	jrz	..ret
	set	7,a
..ret:	call	aintolifo
	jmpr	lnr

;
;	set intensity from byte passed from
;	host, high bit set indicates reverse
;	video, low four bits indicating intensity
;
setintensity:
	lxi	h,..si2
	shld	actspecial
	ret
..si2:
	push	psw
	ani	0fh	;get brightness bits
	sta	valuebrightness
	out	portbrightness
	pop	psw
	lxi	h,data8048
	rlc
	jrc	..setreverse
	res	normalvideo,m
	jmpr	..ret
..setreverse:
	set	normalvideo,m
..ret:	jmpr	lnr	;return from there

	.page
	.sbttl	'alternate character set selection'	
;
;	set whole screen to have alternate set of characters
;
setalternate:
	lxi	h,data8048
	set	longchar,m
	mov	a,m
	out	int8048
	jmpr	lnr

;
;	set whole screen to have standard set of characters
;
setstandard:
	lxi	h,data8048
	res	longchar,m
	mov	a,m
	out	int8048
	jmpr	lnr

;
;	set screen following current char position to have
;	alternate set characters
;
setfalternate:
	mvi	a,88h
	jmp	setfield

	.page
	.sbttl	'bell programming and sounding'
;
;	set bell length and frequency
;
setbell:
	lxi	h,0
	shld	cgbellen	;zero bell length
	shld	cgbelfreq	;zero bell frequency
	xra	a
	sta	lencount	;zero length of bell length input
	lxi	h,sblen
sbcret:	shld	actspecial
	ret
sblen:				;set bell length
	lhld	cgbellen
	call	hbyten		;mult by ten
	sui	'0'		;get from ascii to binary
	mov	e,a
	mvi	d,0
	dad	d
	shld	cgbellen
	lda	lencount
	inr	a
	sta	lencount
	cpi	3
	rnz			;haven't got 3 digits of len yet
	xra	a
	sta	lencount	;len for frequency
	lxi	h,sbfreq
	jmpr	sbcret

sbfreq:				;set bell frequency
	lhld	cgbelfreq
	call	hbyten		;mult by ten
	sui	'0'		;get from ascii to binary
	mov	e,a
	mvi	d,0
	dad	d
	shld	cgbelfreq
	lda	lencount
	inr	a
	sta	lencount
	cpi	3
	rnz			;haven't got 3 digits of frequency yet
	jmp	normret
	
hbyten:				;muliply hl by ten
	push	h
	pop	d
	dad	d		;*2
	push	h
	push	h
	pop	d
	dad	d		;*4
	push	h
	pop	d
	dad	d		;*8
	pop	d
	dad	d		;*10
	ret

;
;	sounding bell (control g)
;
gotbell:
	lhld	cgbellen
	shld	belllength
	lhld	cgbelfreq
	shld	bellfreq
	di
bellloop:			;toggle speaker to get tone
	lxi	h,data8048
	set	beepon,m
	mov	a,m
	out	int8048
	lbcd	bellfreq
	call	delay
	res	beepon,m
	mov	a,m
	out	int8048
	lbcd	bellfreq
	call	delay
	lded	belllength
	dcx	d
	sded	belllength
	mov	a,d
	ora	e
	jrnz	bellloop
	ei
	ret

;
;	delay decrementing bc until zero
;
delay:
	dcx	b
	mov	a,b
	ora	c
	rz
	jmpr	delay

	.page
	.sbttl	'version and resync count display'
dispversion:		
;
;	get and display keyboard version
;
	lxi	h,nxtmessout
	mvi	m,getver		;flag to get version from keyboard
	lxi	h,flags1
	set	messbit,m
..getkybdver:
	call	getkey
	jrz	..getkybdver
	call	makehex		;make value hexidecimal
	push	b
	mvi	a,cr
	call	aintolifo
	mvi	a,lf
	call	aintolifo
	pop	b
	push	b
	mov	a,c
	call	aintolifo
	mvi	a,'.'
	call	aintolifo
	pop	b
	mov	a,b
	call	aintolifo

	lxi	h,mbf3l
	mov	a,m
	call	pkloop	;place string lifo in queue
	jmpr	snr

aintolifo:
	lxi	h,keyqin
	jmp	lifoque		;return from there
;
;	display resync count from keyboard
;
;dispresyncs:
;	outstring	mbf5
;
;	get and display resync number
;
;	lxi	h,nxtmessout
;	mvi	m,getresync	;flag to get resync
				; count from keyboard
;	jmpr	fromkybd

	.page
	.sbttl	'field attribute setting'
exittogotasc:			;set action to normal
	call	normret	;and exit to gotasc
	jmp	gotasc

setnormal:	;set screen characteristics to normal
	mvi	a,80h
	jmpr	setfield

sethighlight:  ;set screen characteristics to highlight
	mvi	a,81h
	jmpr	setfield

setunderline:	;set screen to underline
	mvi	a,0a0h
	jmpr	setfield

setblink:			;set screen to blink
       	mvi	a,82h
	jmpr	setfield


videoreverse:			;reverse the video
	mvi a,90h ;tell 8276 to turn on reverse video
	jmpr	setfield	;stick it in buffer

;
;	allow setting of everyattribute at once
;
seteveryattribute:
	lxi	h,se2
	shld	actspecial
	ret
se2:
	ani	3fh	;get lower 6 bits
	set	7,a	;mark as attribute char
	jmpr	setfield

;
;	place control character 
;	(in a register) on screen
;
setfield:
	lxi	h,flags1
	bit	visible,m
	jrnz	exittogotasc	;normal placement
			;if in visible attributtes
			;mode
	call	storecontrol
snr:	jmp	normret	;exit escape processing
	.page
;
;	store control character (in a register)
;	in invisible mode on screen, if control
;	char already present overwrite, otherwise
;	insert unless already 16 control chars on line
;
storecontrol:
	sta	savecontrol
	call	hltobeginningline
	lded	nextchar
	ora	a
	dsbc	d	;see if at beginning of line
	jrz	..notalreadycontrol
	xchg
	dcx	h	;point at previous char to see
			;if control char
	bit	7,m	;if high bit set is control char
	jrz	..notalreadycontrol
	lda	savecontrol
	mov	m,a	;replace with new char
	ret		;done, return
;
;	increment count of extra chars on line
;
..notalreadycontrol:
	lda	lcury
	inr	a	;increment to skip stat line
	mov	b,a
	slar	a	;mult by 2
	add	b	;mult by 3
	lxi	h,disptab+2
	mov	c,a
	mvi	b,0
	dad	b
	mvi	a,controlcharsonline
	cmp	m
	rz	;line already full, ignore 
	push	h	;save pointer to control count
;
;	shift rest of line over to insert control char
;
	dcx	h
	mov	d,m
	res	7,d	;clear high bit used
			;as flag to 8275
	dcx	h
	mov	e,m	;de points to begining of
			;line display area
	xchg
	lda	chars	;chars on line
	adi	controlcharsperline-1
	mov	e,a
	mvi	d,0
	dad	d	
	xchg		;de points to last position of
			;line display area
	push	d
	pop	h
	lbcd	nextchar
	ora	a	;clear carry
	dsbc	b	;hl now chars to move
	push	h
	pop	b
	push	d
	pop	h
	dcx	h
	call	blinesetalterattribute
	lddr

	inx	h	
	lda	savecontrol
	mov	m,a	;insert control char
	pop	h	;get pointer to attribute
			;char count
	inr	m	;and increment
	call	blineresetalterattribute
	lhld	nextchar
	jmp	skipattributechar ;nextchar points a real char
			;return from there

;
;	routines to set or reset the altering attribute
;	characters flag
;
bsetalterattribute:
	push	h
	lxi	h,flags2
	set	alterattribute,m
	pop	h
	ret
bresetalterattribute:
	push	h
	lxi	h,flags2
	res	alterattribute,m
	pop	h
	ret

blinesetalterattribute:
	push	h
	lxi	h,flags2
	set	linealterattribute,m
	push	psw
	lda	lcury
	lxi	h,orgy
	add	m
	sta	linechanging
	pop	psw
	pop	h
	ret
blineresetalterattribute:
	push	h
	lxi	h,flags2
	res	linealterattribute,m
	pop	h
	ret

togglevideo:	;toggle the whole screen to reverse
	lxi	h,data8048	;video or back
	bit	normalvideo,m
	jrz	..set
	res	normalvideo,m
	jmpr	..xit
..set:	set	normalvideo,m
..xit:	jmp	normret

;
;	hide a control character on screen (remove it)
;
hidecontrol:
	call	hltobeginningline	;see if at
	lded	nextchar	;beginning of line,if
	ora	a	;so ignore
	dsbc	d
	jrz	..notcontrol
	xchg
	dcx	h	;point at char
	bit	7,m	;see if control char
	jrz	..notcontrol
	xchg
	lxi	h,flags1
	bit	visible,m
	xchg
	jrz	..invisible
;
;	in visible mode, overlay with blank
;
	mvi	m,' '
	jmpr	..notcontrol
..invisible:
	call	blinesetalterattribute
;
;	remove attribute char
;
	call	hltobeginingcurrentline
	xchg
	inx	h
	dcr	m	;count of attribute chars on 
			;line
	lded	nextchar
	dcx	d	;place to copy to
	push	d
	pop	h
	mvi	m,' '	;repace attribute char
	inx	h	;place to copy from
	lda	maxchar	;chars remaining on line
	inr	a	;include cursor char
	mov	b,a
..movloop:
	mov	a,m
	stax	d
	inx	h
	inx	d
	bit	7,a	;if attribute char
	jrnz	..movloop ;does not count for maxchar
	djnz	..movloop
	lhld	nextchar
	dcx	h
	shld	nextchar
	call	blineresetalterattribute
..notcontrol:
	jmpr	nnr
	

	.page
	.sbttl	'direct cursor addressing'

curset:				;set the row and column
	lxi	h,curstrow
	shld	actspecial
	ret

curstrow:
	sui	20h		;turn row char 
	lxi	h,lines		;into row value
	cmp	m		;maximum row
	jrnc	nnr	;invalid row
	sta	lcury
	lxi	h,curstcol
	shld	actspecial
	ret

curstcol:
	sui	20h		;turn col char into col value
	cpi	80		;see if column max exceeded
	jrnc	nnr		;invalid col
	sta	lcurx
newcursor:			;entry point for use of
	lda	lcurx	;none scroll linefeed
	mov	b,a
	lda	chars
	sub	b
	sta	maxchar		;chars remaining in line
	call	hltobeginingofcurrentline
	lda	lcurx
..findcurxloop:
	call	skipattributechar
	ora	a
	jrz	..storenextchar
	inx	h
	dcr	a
	jmpr	..findcurxloop
..storenextchar:
	shld	nextchar
	call	setcur
nnr:	jmp	normret

;
;	subroutine to set up hl register pointing to
;	begginging of current line buffer
;	de reg set to second byte of lind address
;	in disptab
;
hltobeginingcurrentline:
	lda	lcury
	mov	b,a
	slar	a	;*2
	add	b	;*3
	mov	e,a
	mvi	d,0
	lxi	h,disptab
	dad	d
	call	addorgy	;add in y origin
	mov	e,m
	inx	h
	mov	d,m
	res	7,d		;strip high address bit
	xchg
	ret

	.page
	.sbttl	'erase line,erase screen, home'	
doeraline:
	call	normret	;set up normal actions

;
;	erase to end of line
;
eraline:
	call	blinesetalterattribute
	call	hltobeginingcurrentline
	inx	d
	lbcd	nextchar
	lda	maxchar
	ora	a	;clear carry
	dsbc	b	;if pointing at begining of
	push	b	;line dont inspect previous
	pop	h	;char to see if attribute
	jrz	..blankchar	;char
..eralineloop:
	dcx	h
	bit	7,m	;see if attribute char
	jrz	..notattributechar
	mvi	m,' '
	xchg	;count of attribute chars on
	dcr	m		;line
	xchg
..notattributechar:
	inx	h
..blankchar:
	mvi	m,' '
	dcr	a
	jrnz	..notdone
	call	blineresetalterattribute
	jmpr	newcursor
				;return from there
..notdone:
	inx	h
	bit	7,m	;see if attribute char
	jrz	..eralineloop
	inx	h	;skip past if it is
	jmpr	..eralineloop

;
;	erase to end of screen	
;
doeratoendofscreen:
	call	normret	;set up normal actions

eratoendofscreen:
	call	eraline	;erase to end of current
			;line
	lda	lines
	lxi	h,lcury
	sub	m	;a is count of lines
		;to clear, note: current line
		;is already cleared
	push	psw	;save count of lines
	call	hltobeginingcurrentline
	inx	d
	xchg
	pop	psw
	call	bsetalterattribute
..erascreenloop:
	dcr	a
	jz	bresetalterattribute
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	push	psw
	call	filline
	pop	psw
	jmpr	..erascreenloop

;
;	erase entire screen
;
erase:  
 	call	gothome
	jmpr	eratoendofscreen  ;return from there

;
;	home character
;
gothome:
	xra	a
	sta	lcury	;get to 0th line
	jmp	docr	;carriage return,
			;return from there

	.page
	.sbttl	'forward,backward,delete a char'
;
;	go forward character
;
gotforw:
	lhld	nextchar
	inx	h
	call	skipattributechar
  	lxi	h,maxchar 
  	dcr	m
	jnz	bumpcur
	jmp	docrlf

;
;	skip hl register forward past a attribute char
;	if present and store in nextchar
;
skipattributechar:
	bit	7,m	;see if attribute char
	jrz	..notattributechar
	push	h
	lxi	h,flags1
	bit	visible,m
	pop	h
	jrnz	..notattributechar  ;dont skip char if
			;attribute chars are visible
	inx	h	;skip past attribute char
..notattributechar:
	shld	nextchar
	ret

;
;	delete character
;
gotdel: mvi	d,01h
 	jmpr	del 

;
;	go backward character
;
gotback:mvi	d,00h
del:	lxi	h,maxchar
 	lda	chars
 	cmp	m
	push	d	;save flag indicating backup or delete
 	cz	rdocrlf
	pop	d
 	lhld	nextchar
 	dcx	h
	bit	7,m	;see if attribute char
	jrz	..notattributechar
	push	h
	lxi	h,flags1
	bit	visible,m
	pop	h
	jrnz	..notattributechar  ;dont skip char if
			;attribute chars are visible
	dcx	h	;skip past attribute char
..notattributechar:
 	bit	0,d
 	cnz	space
 	shld	nextchar
 	lxi	h,maxchar
 	inr	m
 	lxi	h,lcurx
 	dcr	m
 	jmpr 	setcur
space:  mvi	m,' '
 	ret

	.page
	.sbttl	'tab'	
;
;	tab character
;
gottab: lded    lcurxy
 	mvi	a,07h
 	ana     e     
 	mov	e,a
 	mvi	a,08h
 	sub     e
 	mov	e,a
 	mvi 	d,00h  
        lda     maxchar 
 	cpi	09h   
        jrc      docrlf
 	sub     e
 	sta	maxchar
 	lda	lcurx
 	add	e      
 	sta     lcurx
 	jmpr	gonewcursor	;ret from there

	.page
	.sbttl	'up,linefeed,cr'
;
;	reverse crlf
;
rdocrlf:
 	lxi	h,maxchar
 	mvi	m,00h
 	lxi	h,lcurx
 	lda	chars
	mov	m,a
;
;	up character
;
gotup:
	lda	lcury
	ora	a
	jrz	gotobottom	;at top, goto bottom
	dcr	a
	sta	lcury
findnext:
gonewcursor:
	jmp	newcursor  ;go set up new cursor position
				;ret from there
gotobottom:			;go to bottom of screen
	lda	lines
	dcr	a
	sta	lcury
	jmpr	findnext

;
;	bump the cursor forward one
;
bumpcur: lxi	h,lcurx		;x logical cur
	inr	m
setcur: lhld	lcurxy
	xchg
	lhld	orgxy		;x,y cur origin
	dad	d		;add logical position
outcur:	
	mvi	a,loadcursor	;load cur comd
	out	crts
	mov	a,l
	out	crtm
	mov	a,h
	out	crtm
	ret

;
;perform carriage return
;
docr:
	xra	a
	sta	lcurx
	jmpr	gonewcursor	;ret from there

;
docrlf:	call	docr		;here for both

;
;perform line feed
;
dolf:
	lxi	h,lcury
	inr	m
	lda	lines
	cmp	m		;past bottom line
	jrz	scroll
	jmpr	gonewcursor	;set cursor to new line
				;return from there

	.page
	.sbttl	'scroll'
;
;	scroll by first copying display table up one line 
;	and then blank filling the last line
;	hl points to lcury on entry
;
scroll:
	call	bsetalterattribute
	dcr	m		;get lcury on scrn
	lxi	h,disptab	;scroll display dable
	call	addorgy		;add in y origin
	mov	e,m
	inx	h
	mov	d,m	;de=first row addr
	push	d
	inx	h
	call	filline	;blank it
	mov	d,h
	mov	e,l	;copy
	dcx	d	;to beg of table
	dcx	d
	inx	h	;source is 2nd entry
	lda	lines	;# to scroll
	dcr	a
	mov	c,a
	rlc		;*2
	add	c	;*3
	mov	c,a
	mvi	b,0
	ldir
	xchg
	pop	d
	mov	m,e
	inx	h
	mov	m,d	;top to bottom
	inx	h
	mvi	m,0	;clear count of attribute chars
	call	bresetalterattribute
	jmpr	gonewcursor	;ret from there
;
;	add orgy to get top screen or bottom screen
;
addorgy:
	lda	orgy
	mov	c,a
	slar	a	;*2
	add	c	;*3
	mvi	d,0
	mov	e,a
	dad	d
	ret

	.page
	.sbttl	'fill line with blanks'

;	
;	on input regs are:
;	de - address to fill
;	hl - address of count of attribute
;		chars on line
;
;	de,bc,a destroyed
;	NOTE: FILLINE DOES NOT SET ALTERING ATTRIBUTE
;	COUNT FLAG DEPENDING ON CALLING ROUTINE TO
;	DO SO
;
filline:
	push	h	;save incoming hl register
	mvi	m,0	;zero count of attribute chars
	xchg
	res	7,h	;reset bit that may be set to
			;tell 8275 to grab char
	mvi	m,' '	;blank first char on line
	push	h
	pop	d
	inx	d
	lda	chars
	dcr	a
	mov	c,a
	mvi	b,0
	ldir		;fill line with blanks
	pop	h	;restore
	ret

	.page
	.sbttl	'save screen parameters'

;	note: multiplying scrno by 96 will only work for three
;	screens or less
;
savescrn:		;save scrn param
	lxi	h,scrno
	mov	a,m		;get scrno
	call	atimes96tode
	lxi	h,scr0
	dad	d
	xchg
	lxi	h,scrno
	lxi	b,scrparlen	;length
	ldir		;restore screen parameters
	lxi	h,disptab
	lxi	b,linesonscreen*3
	ldir			;restore display table
	ret

	.page
	.sbttl	'restore screen parameters'
;
;	screen number to restore passed in reg a
;	note: multiplying scrno by 96 will only 
;	work for three screens or less
;
restorescrn:		;restore scrn param
	call	atimes96tode
	lxi	h,scr0
	dad	d
	lxi	d,scrno
	lxi	b,scrparlen	;length
	ldir		;restore screen parameters
	lxi	d,disptab
	lxi	b,linesonscreen*3
	ldir			;restore display table
	ret

atimes96tode:
	mvi	d,0
	slar	a
	slar	a
	slar	a
	slar	a		;times 16
	slar	a		;times 32
	mov	e,a
	slar	a		;times 64
	add	e		;times 96
	mov	e,a
	ret

	.page
	.sbttl	'create screen'
;
creatscrn:		;create screen from param at scrno
			;de = addr of screen to create
			; on return:
			;zero flag set ok
			;non-zero, not enuff room
	lhld	nextmem		;next free memory
	shld	memstrt
	shld	topscr
	lda	lines		;allocate mem, build tab
	mov	b,a
	mvi	c,0	;extra chars per line
..2:	mov	a,l		;start or row adr
	stax	d
	inx	d
	mov	a,h
	ori	80h		;turn on a15
	stax	d
	inx	d
	mov	a,c		;length of row
	stax	d
	inx	d
	push	d
	mvi	d,0
	lda	chars
	adi	controlcharsperline	;allow space
				;for hidden control chars
	mov	e,a		;bump adr by one row
	dad	d
	pop	d
	mov	a,h		;check enuf mem
	cpi	topdr>8		;top disp ram
	jrnz	..3		;if ok
	inr	a		;to non zero
	ret
..3:	djnz	..2
	shld	nextmem
	dcx	h
	shld	memend		;end of memory for screen
	shld	nextchar
	ret

	.page
	.sbttl	'output string to crt'

;
;	output string to crt.  Start of string passed in
;	register hl.  string must be terminated by $
;
os:
	push	h
	call normret	;make dochar work normally
osloop:
	pop	h
	mov	a,m
	cpi	'$'
	rz
	inx	h
	push	h
	call	dochar
	jmpr	osloop

;
;	output a string to the errorline.  start of string
;	passed in hl.  first byte of string is offset position 
;	on line.  string is terminated by $
;
oe:
	mov	a,m
	xchg
	lxi	h,errline
	mov	c,a
	mvi	b,0
	dad	b	;have startint position for string
	xchg
	inx	h	;h points to beginning of string
oeloop:	
	mov	a,m
	cpi	'$'
	rz		;end of string	
	stax	d
	inx	d
	inx	h
	jmpr	oeloop

;
;	blank a string on the errorline.  start of string
;	passed in hl.  first byte of string is offset position 
;	on line.  string is terminated by $.  all characters on
;	the screen are replaced with blanks
;
be:
	mov	a,m
	xchg
	lxi	h,errline
	mov	c,a
	mvi	b,0
	dad	b	;have startint position for string
	xchg
	inx	h	;h points to beginning of string
beloop:	
	mov	a,m
	cpi	'$'
	rz		;end of string	
	mvi	a,' '
	stax	d
	inx	d
	inx	h
	jmpr	beloop

	.page
	.sbttl	'delete a programable key string'

;
;	delkey is passed a programable key code in a 
;	the entry is removed, space is made free
;	and all entries in progtab after the deleted
;	entry are modified if needed
;
delkey:
	ani	7fh	;get rid of high bit
	slar	a	;mult by two
	mov	e,a
	mvi	d,0
	lxi	h,progtab
	dad	d	;h now address of prog tab entry
	shld	ptentry	;save for inskey
	mov	e,m
	inx	h
	mov	d,m	;de now points to string
	mvi	m,0
	dcx	h
	mvi	m,0	;zero entry in table
	mov	a,e
	ora	d	;check for no entry
	rz		;no entry so nothing to delete
	sded	dsptr	;save pointer to string
			;to be deleted
;
;	calculate new free space
;
	ldax	d	;get length of string
	lhld	freeinprogbuf
	mov	c,a
	mvi	b,0
	inx	b	;length of string including
			;length byte
	push	b	;save length of string
			;to be deleted
	dad	b
	shld	freeinprogbuf
;
;	move everything above deleted string down
;	calculate size of move as end of buffer
;	minus string to be deleted, minus
;	free area in buffer
;
	lxi	h,progbuf+lenpbuf	;end of buffer
	ora	a	;clear carry
	dsbc	d	;minus string to be deleted
	lbcd	freeinprogbuf
	dsbc	b	;minus free area in buffer
	push	h
	pop	b	;get in right reg for ldir
	mov	a,b
	ora	c
	jrnz	..move	;make sure none zero move required
	pop	b	;get rid of length of string
	ret
..move:
	lded	dsptr	;de points to string to overwrite
	pop	h	;length of string deleted
	push	h	;keep saving
	dad	d	;hl points to place to copy from
	ldir
	pop	b	;length of string deleted
	lhld	ptentry	;pointer into progtab of entry deleted
	inx	h
;
;	now modify all table entries following
;
delloop:
	inx	h	;point to next entry in table
	mov	a,l
	cpi	(progtab+lenprogtab)&0ffh  ;low order
			;byte of end of table
	rz		;done
	mov	e,m
	inx	h
	mov	d,m	;de is pointer to string
	mov	a,d
	ora	e
	jrz	delloop	;no entry
	xchg
	ora	a	;clear carry
	dsbc	b	;modify entry
	xchg
	mov	m,d
	dcx	h
	mov	m,e	;store new string pointer
	inx	h
	jmpr	delloop

	.page
	.sbttl	'insert a programable key'

;
;	inskey is passed a programable key code in a
;	and a pointer to a string in hl.  it makes an
;	entry in the table after first deleteing the
;	old entry
;
inskey:
	shld	nsptr	;save new string pointer
	call	delkey	;delete old string
;
;	see if room for new key
;
	lhld	nsptr	;ptr to new string
	mov	a,m
	ora	a	;see if new key non-zero
	rz
	mov	e,a
	mvi	d,0
	inx	d	;len of string including len byte
	sded	nslen	;save length
	lhld	freeinprogbuf
	jmpdegthl noroom	;subtracts de from hl
	shld	freeinprogbuf	
;
;	find address to place new string by looking
;	at entries following entry to be made. the
;	first ram entry will be the address to place
;	the string.  it will also be the first entry
;	that needs to be modified after reshuffling
;	string locations
;
	lhld	ptentry	;set up by delkey
..findloop:		;next entry that points to ram
	inx	h
	inx	h
	mov	a,l
	cpi	(progtab+lenprogtab) & 0ffh
	jrz	lastentry	;entry being modified
				;is last entry
	mov	e,m
	inx	h
	mov	d,m
	dcx	h
	mov	a,d
	ora	e
	jrz	..findloop	;null entry
;
;	have location where new string will go
;
	sded	nsloc
	push	h	;save pointer into progtab
;
;	calculate size of move to move everything
;	beyond newstring loc up in memory
;
	lxi	h,progbuf+lenpbuf-1
	lbcd	freeinprogbuf
	ora	a	;clear carry
	dsbc	b
	push	h
	pop	d	;place to copy to
	lbcd	nslen
	dsbc	b
	push	h	;save place to copy from
	lbcd	nsloc
	dsbc	b
	push	h
	pop	b	;length to copy
	inx	b
	pop	h	;place to copy to
	lddr
;
;	make entry and copy newstring
;
	lhld	ptentry
	lded	nsloc	
	mov	m,e
	inx	h
	mov	m,d
	lhld	nsptr
	lbcd	nslen
	ldir
;
;	modify all following pointers in progtab
;
	pop	h	;get pointer into progtab
	dcx	h
	lbcd	nslen
insloop:
	inx	h	;point to next entry in table
	mov	a,l
	cpi	(progtab+lenprogtab)&0ffh  ;low order
			;byte of end of table
	rz		;done
	mov	e,m
	inx	h
	mov	d,m	;de is pointer to string
	mov	a,d
	ora	e
	jrz	insloop	;no entry
	xchg
	dad	b	;modify entry
	xchg
	mov	m,d
	dcx	h
	mov	m,e	;store new string pointer
	inx	h
	jmpr	insloop

lastentry:	;no entries follow so just 
		;copy string into progbuf
	lxi	h,progbuf+lenpbuf
	lded	freeinprogbuf
	ora	a	;clear carry
	dsbc	d
	lbcd	nslen
	dsbc	b
	xchg		;de is place to copy to
	lhld	ptentry	;update progtab entry
	mov	m,e
	inx	h
	mov	m,d
	lhld	nsptr	;place to copy from
	ldir

	ret

noroom:
	outerr	mbf10
	jmp	gotbell	;return from there


	.page
	.sbttl	'character action table'

;
;	key action table
;
charact:
	.word	donull		;0
	.word	gothome		;1
	.word	gotasc		;2
	.word	gotasc		;3
	.word	gotasc		;4
	.word	gotasc		;5
	.word	gotforward	;6
	.word	gotbell		;7
	.word	gotback		;8
	.word	gottab		;9
	.word	dolf		;10 (ah)
	.word	gotasc		;11 (bh)
	.word	erase		;12 (ch)
	.word	docr		;13 (dh)
	.word	gotasc		;14 (eh)
	.word	gotasc		;15 (fh)
	.word	gotasc		;16 (10h) 10h-19h for dasoft
	.word	gotasc		;17 (11h) special characters
	.word	gotasc		;18 (12h)
	.word	gotasc		;19 (13h)
	.word	gotasc		;20 (14h)
	.word	gotasc		;21 (15h)
	.word	gotasc		;22 (16h)
	.word	gotasc		;23 (17h)
	.word	gotasc		;24 (18h)
	.word	gotasc		;25 (19h)
	.word	gotup		;26 (1ah)
	.word	esckey		;27 (1bh)
	.word	gotasc		;28 (1ch)
	.word	gotasc		;29 (1dh)
	.word	gotasc		;30 (1eh)
	.word	gotasc		;31 (1fh)

	.page
	.sbttl	'message buffers'
;
;	message buffers
;
mbf1:	.ascii	/<del>$/

mbf3:
	.ascii	/FOX  /
	.byte	version+'0','.',revision+'0',assembly
	.ife	revvid,[.ascii 'R'][
	.ascii	'N ']	;note: blank ignored by assembler
	.ife	xpert,[.ascii 'X'][
			.ascii	'P ']
	.ife	delaydesired,[.ascii	'S'][
			.ascii	'L ']
	.byte	cr,lf
	.ascii	/KYBD /
bf3l	==	.-mbf3
mbf3l:	.byte	bf3l

;mbf5:	.byte	cr,lf
;	.ascii	/Resyncs:$/


mbf7:	.byte	75
	.ascii	/Trap$/

mbf8:	.byte	60
	.ascii	/Local$/

mbf10:
	.byte	3
	.ascii	/KEYS FULL$/

mbf13:	.byte	52
	.ascii	/NO PROG$/

mbf14:	.byte	escape,'Y',21h,20h
	.ascii	/Key to program? (/
	.byte	symcntrshift
	.ascii	/F1 to exit):$/

mbf15:	.byte	escape,'Y',20H+23,20h,escape,'K',escape,'B'
	.ascii	/Invalid$/

mbf16:	.ascii	/<home>$/

mbf17:	.ascii	/<fs>$/

mbf18:	.ascii	/<bell>$/

mbf19:	.ascii	/<bs>$/

mbf20:	.ascii	/<tab>$/

mbf21:	.ascii	/<erase>$/

mbf22:	.ascii	/<up>$/

mbf23:	.ascii	/<esc>$/

mbf24:	.byte	escape,'Y',25h,20h
	.ascii	/:>$/

mbf25:	.ascii	/<:/
	.byte	escape,'k','$'

mbf27:	.byte	escape,'Y',23h,20h
	.ascii	/Enter string, /
	.byte	symcntrshift
	.ascii	/F2 to delete$/

mbf33:	.byte	escape,'Y',20h+23,20h,escape,'K','$'

mbf34:	.ascii	/<cr>$/

mbf35:	.ascii	/<lf>$/

	.page
	.sbttl	'rom data'
;
defparam: .byte	0,80,24,0,1,79,23
paramlen == .-defparam
counts:	.byte 0,4,4,4,9,8
cntlen == . - counts
	.ifg	. - (romloc + romavail),[
	.prntx /ROM Overflow/][
	.prntx /ROM length ok/]









