.title 'CP/M logical unit assignment program.'
	.ident ASSIGN
.sbttl 'Table of contents'
version ==	7
revision==	12	;last revised, 04/28/83 DRB
patch	==	' '	;NOT TO BE RELEASED FOR DMS-15
	.pabs
	.phex	
	.loc	100h
;
;	Assign for BIOS 2.240 and later
;
;	Table of contents
;
;  Program description				2
;  Update History				3
;  Equates					5
;  Compute jumps to BIOS			6
;  No comline, print default assignments	7
;  Read comline, change assignment		8
;  Map in change				10
;  Overlay the BIOS				12
;  Read hard disk partition name		14
;  Change the printer assignment		18
;  Subroutines					20
;	Print default assignments		20
;	CRT I/O suboutines			24
;	User error				26
;	Compute type of assign			27
;	Local or HiNet master HD assign		28
;	HiNet station to master HD assign	29
;	8" hard disk subroutines		30
;	5 1/4" Hard disk subroutines		32
;	Look up an entry in param tables	39
;	Communicate with the BIOS		40
;	communicate whth MPM XIOS		41
;  Define storage				42
;  BIOS jumps					43
;  1.4 disk parameter blocks			44
;  2.2 disk parameter blocks			45
;  CRT messages 				46
;
.page
.sbttl 'Program description'
;
; Typing in "ASSIGN" results in a list of all logical
; units and their respective physical device unit. 
; The current printer assignment is also displayed.
;
; To assign a floppy drive, enter ASSIGN X YZ.	X is
; the logical unit (A,B,C orD), Y is the media type
; (single density, double density, etc.) and Z is the
; drive number. A message is printed if the assignment
; is accepted. 
;
; To assign a harddisk or network partition, type 
; "ASSIGN X NAME".  X is the logical unit (A,B,C orD)
; and NAME is the hard disk or network partition name.
; The name and a blank password are sent to the BIOS
; for translation into an absolute physical device and
; unit number.	The user is notified if the assignment
; is accepted or denied.  If it is rejected ASSIGN asks
; for a password.  When you enter the password, ASSIGN
; resubmits the request and the BIOS either accepts or
; rejects the request.	The user has 2 retries in case
; of an error.
;
; Assign can also set the printer. "ASSIGN P <printer>"
; will modify the high 3 bits of the CP/M IOByte.
;  Binary   Hex  <printer>     
;  000xxxxx  0	PORT0		  serial port 0
;  001xxxxx  2	PORT3		  serial port 3
;  010xxxxx  4	PORT2		  serial port 2
;  011xxxxx  6	PORT1*		  serial port 1*
;  100xxxxx  8	PORTP		  parallel port 2
;  101xxxxx  A	Fox parallel port parallel port 1
;  110xxxxx  C	CUSTOM		  specially patched
;  111xxxxx  E	SPOOLER 	  network spooler
;
; *Port 1 assignment not allowed if logged into HiNet.
;
; If an error is found on the command line, the first
; bad command line character is highlighted with an 
; arrow and a summary of instructions is displayed,
; followed by a warm boot.
;
; To debug this program with ZDTI, load the program
; as normal.  Modify 'Comline.asm' to reflect what you
; would type in on the command line.  Assemble the 
; program with AZM.  Load it into memory whit with 
; 'icomline.hex' and 'r'.  This puts it at 80h in
; memory which is where the command line is stored.
.page
.sbttl	'Update history'
;
;	Last changed  03/29/83 DRB
;
; 6.00		First release compatible with MP/M
;
; 6.03	(05/01) First release compatible with HiNet 2.2
;
; 6.04	(06/18) Fixed check vector problem with MP/M
;		(Force check vector = 32 for MP/M)
;
; 6.06	(07/02) Assign now lists out and modifies
;		the current printer assignment.
;		Error printout completely redone.
;
; 7.00	(07/22) PORT3 available as a printer assignment
;
; 7.01	(08/19) Add unassignments
;		Remove "unit already assigned" from 2.2
;
; 7.02	(08/28) Dont list print assignment on MP/M
;
; 7.03	5/03/82 Modify assign to accept the Fox
;		double sided mini-floppy disks. Much
;		of the code for single sided mini-
;		floppies is entered but will not be
;		implemented until later.  The single
;		sided mini-floppy will have a label
;		of 'T' for tiny.  DB
;
; B		Floppy disk parameters were not written
;		back to BIOS correctly.  Fixed.  DB
; C 6/9/82	Add code for multi-harddisks.
; D 7/1/82	Change CRT messages, add a push and
;		pop of BC and DE in asnTP5:
; E 7/8/82	User could not assign a harddisk
;		parition from a floppy boot system
;		Problem corrected.  Add table of
;		contents.  DB
; 7.04 07/20/82 Assign released for BIOS version 2.240
; 7.05 09/13/82 Assign prints out your new assignments
;		when you make changes.	DB
;	'A'	Give user a warm boot when returning
;		to CCP
;	'B'	Change maximum number of physical 
;		drives to 16.  Correct error in routine
;		that tests allocation vector size.
; 7.06 09/30/82 cosmetic only for new release
; 7.07 11/23/82 Implement parallel printer port for
;		Fox.  This uses the parallel port
;		on the CPU board that is used for a
;		hard disk.  You cant have both the Fox
;		parallel port and DMS-15 hard disk.
.page
; 7.08 12/08/82 Stuff the control byte that is in the
;		Alloc table in the DPB for Tracy.
;		Therefore needs 2.243 or later
; 7.09 12/14/82 modify assign to recognize DMS-15
;		(xebec) hard disk partitions
;   E  03/28/83 Fix bug in DMS HD controller interface
;		";" out the overlaying of control byte
;		since BIOS still doesn't use it
; 7.10 03/29/83 Add code to process HiNet master's new
;		error routines.  Doug
; 'A'  04/04/83 Assign incorrectly forces user to
;		reboot if user attempts an assignment
;		to a non-existant hard disk.  Code
;		added which first determines if a HD
;		exists.  DRB
; 'B' 04/07/83  Clean-up code.  8" and 5" hard disk
;		subroutines separated, table of
;		contents updated, .paged, added sub-
;		titles.  Add test to Fox printer
;		assign so DMS-15 cant use it. DRB
; 7.11 04/11/83 The test for a DMS-15 hard disk
;		(testHD) does not work correctly.
;		Consequently, the call for the test
;		has been eliminated for this release.
;		This code must be redone for the
;		DMS-15, but there is not time now. DRB
;		The assign still works so it is intact
; 'A' 4/22/83   Assign works only with BIOS version
;		2.244 and later.  The login message
;		has been modified.  DRB
; 7.12 04/28/83 Bump up version number so release has
;		no patch.  DRB
.page
.sbttl 'Equates'
;
wboot	==	0	; wboot address
BDOS	==	5	; console in/out subroutine
wbadr	==	1	; vector for bios calls
backsp	==	8	; ascii backspace
delete	==	7Fh	; ascii delete
cr	==	0Dh	; ascii carriage return
lf	==	0Ah	; ascii line feed
bell	==	7h	; ascii bell
ctrlc	==	3h	; ascii abort
IObyte	==	3	; Fox, DMS-15 or 5000 56 or F6
maxdriv ==	4h	; drives A,B,C,D
userno	==	47h	; user number
assnNET ==	17h	; assign to NETWORK command
assnHARD==	17h	; assign to HARDDISK command
HARDP	==	01h	; HARDDISK port number
PIOAD	==	08h	; status port
busy	==	0	; busy true high
DAT$CMDport ==	1	; mode set by toggle
toggle	==	0
selcont ==	0C1h	; select controller
deselcont ==	41h	; deselect controller
maxtries==	3	; Max # of retries
loop	==	5	; HiNet RECNET retries
conslout==	2	; CP/M 2,  Console Out
getio	==	7	; CP/M 7,  Get I/O Byte
prtstrg ==	9	; CP/M 9,  Print String
retvsn	==	12	; CP/M 12, Return Version
retdsk	==	25	; CP/M 25, Return Current Disk
openque ==	135	; MPM 135, Open Que
readque ==	137	; MPM 137, Read Que
writque ==	139	; MPM 139, Write Que
nument	==	64	; lines in an alloc table
lentab	==	nument*16 ; length of alloc table
DMStype ==	0	; HDstat byte 5, regular
;---------------
; Device types
SD	==	0<5	; single density map
DD	==	1<5	; double density map
hard	==	2<5	; hard disk map
net	==	3<5	; network map
mini1	==	4<5	; 1 sided mini map
mini2	==	5<5	; 2 sided mini map
DMS15HD ==	6<5	; DMS-15 hard disk!
;
.page
.sbttl 'Compute jumps to the BIOS'
;
; Set up jumps to BIOS
	lxi	SP,stack
	lhld	wbadr	; bios vector
	shld	wbaddr
	mvi	C,retvsn ; CP/M 12, Return Version
	call	BDOS
	mov	a,h	; see if mpm
	cpi	1
	mov	a,l	; use cpm indicator
	jrnz	..1	; skip if not mpm
	mvi	a,0ffh
	lhld	wbaddr	; adjust bios vector
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	sded	wbaddr
..1:	sta	sysflg	; save system indicator
	lbcd	wbaddr	 ; get wboot address
	lxi	H,69h
	dad	B
	inx	H	; get address from BIOS
	mov	E,M
	inx	H
	mov	D,M
	inx	D	; skip NETmsg
	sded	NETadr	; store address in NETadr
	lbcd	wbadr	; get set to move chunks of
			; jump table.
	lxi	H,1Bh	; move some standard jumps
	dad	B	; (setTRK, setSEC,
	push	B	;  setDMA, READ)
	lxi	B,12	; move four jumps
	lxi	D,setTRK
	ldir
	pop	B	; now get SENDNET, RECNET,
	lxi	H,6Ch	; NACKPOLL, ACKPOLL, PORTUout,
	dad	B	; SETPPA, RECTIME, HDSTAT
	lxi	D,SENDNET
	lxi	B,24	; move the next 8 jumps 
	ldir
.page
.sbttl 'No comline, print default assignments'

; Put the number of command line characters into numchr
; Print current assignments if no comline
	lhld	comline
	mov	A,M
	sta	numchr	; save number of com chrs
	cpi	0
	jrz	info	; print assign if no comm line
	cpi	1	; If > 1 char in comline,
	jrnz	getlog	; assume there is a comline
INFO:	lxi	D,LOGmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print LOG-on message
	lxi	D,infomsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print out info message
prtMAP: call	getque	; freeze disk if mpm
	lda	logbyte
	mov	C,A	; get logical in C
	call	seldsk
	call	putque	; ok to free disk now
	call	cpmMAP	; physical is in A
	mov	A,m	; unit # in accum
	sta	unitnum ; and stored
	dcx	H	; now have media
	mov	A,m	; media type in accum
	sta	devtype ; and stored
	call	infout	; output the data
	lda	logbyte ; retrieve logical
	cpi	3	; 0 through 3 displayed yet?
	jrz	..printer ; Yes. Do printer assignment.
	inr	A	; increm to next logical
	sta	logbyte ; store it
	jmpr	prtmap	; loop until finished
..printer:		; print printer info
	lda	sysflg
	ora	A
	jm	RETccp	; don't list print info if mpm
	call	prtrinfo; list out printer info
	jmp	RETccp	; and exit to CCP
.page
.sbttl 'Read comline, change assignment'
;
; Test for proper CP/M drive selects.
; Jump to 'error' if unacceptable entry found
GETLOG:
	call	getque	; freeze disk if mpm
..1:	call	getchr
	cpi	' '	; is it a blank?
	jrz	..1	; loop until chr found
	cpi	'P'	; P means printer asmt.
	jz	PRTasmt
	ani	0DFh	; make upper case
	sui	'A'	; make numeric
	cpi	maxdriv ; maximum drives allowed
	jnc	error
	sta	logname ; logical name
;---------------
; Test for proper density selections
; Jump to READNAME if unacceptable entry
;
..2:	call	getchr
	cpi	' '
	jrz	..2	; fetch a non-blank character
	lhld	comline
	shld	NAMEaddr ; prospective name address
	push	PSW
	lda	chrcnt
	sta	namchr	; prospective num of name chrs
	pop	PSW	
	cpi	'S'
	mvi	C,SD	; single density equate
	jrz	..3
	cpi	'D'
	mvi	C,DD	; double density equate
	jrz	..3
	cpi	'M'
	jnz	READNAME ;not floppy so read a name
	mvi	C,mini2 ; double side mini floppy
..3:	mov	A,C	; get device type in accum
	sta	devtype ; store it.  Device type and
	sta	size	; size same for floppy drives
.page
;
; Fetch the drive number.  Test for proper unit number.
; Jump to READNAME if unacceptabe entry found.
;
	lda	numchr	; get no. of chrs 
	lxi	H,chrcnt ; no. of com chrs read
	sub	M	; A = # of chrs left to read
	cpi	1	; just one chr?
	mvi	B,0
	lhld	comline     
	inx	H	; get next com chr addr
	jrz	..4	; bypass mult if one chr
	mov	A,M	; get ascii chr in A
	cpi	'9'+1	; make sure its a number
	jnc	READNAME
	cpi	'0'
	jc	READNAME
	sui	'0'	; make ascii chr numeric
	mov	B,A	; save original number
	rlc
	rlc		; multiply first chr by 
	rlc		; ten and save
	mov	C,A
	mov	A,B
	rlc
	add	C
	mov	B,A	; save 10*number in B
	inx	H	; increment to 2nd chr addr
..4:	mov	A,M	; get ascii chr in A
	cpi	'9'+1	; make sure its a number
	jnc	READNAME
	cpi	'0'
	jc	READNAME
	sui	'0'	; make ascii chr numeric
	add	B	; add the two chrs
	cpi	15	; past unit number 63?
	jnc	READNAME ; Yes. MAYBE ITS A NAME
	sta	unitnum ; save for later use
.page
.sbttl 'Map in the change'
;
FINDMAP:		; map the drive into BIOS
	lda	sysflg
	ora	a
	jp	..4	; skip if not mpm
	call	putque	; free disk
	lxi	h,1
	lda	logname ; disk number
	ora	A
	jrz	..2	; skip if done
..1:	dad	h	; next drive vector
	dcr	a
	jrnz	..1
..2:	xchg		; vector to DE
	mvi	C,retdsk ;CP/M 25, Return Current Disk
	call	BDOS
	ora	a
	jrz	..3	; skip if it reset ok
	lxi	d,bsymes
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print MPM is busy
	jmp	retCCP	; and exit
..3:	call	getque	; freeze disk again
..4:	lda	sysflg
	ora	a
	jp	cpmxx	; skip if not mpm
	mvi	a,0	; scan for duplicate drv
..ckit: push	psw	; save curr drv #
	mov	C,A
	call	seldsk	; select a drive
	mov	a,h
	ora	l	; error ?
	jrz	..5	; skip if select error
	call	cpmmap	; get DPB-1 address
	lda	unitnum ; is the unit to be changed
	cmp	m	; same as we are logged in on
	jrnz	..5	; skip if not
	lxi	d,nono	; duplicate assign error
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print duplicate error
	jmp	retccp	; and exit
..5:	pop	psw	; get last drv
	inr	a	; next drive
	cpi	16	; past end ?
	jrnz	..ckit	; loop if not all checked
.page
cpmxx:	
	lda	logname
	mov	C,A	; get drive you want to
	call	seldsk	; to assign to
	lda	devtype
	cpi	63	; if fixed heads, size
	jrnz	..chekver
	mvi	A,7	; must be 7
	sta	size
;
; Overlay 8 bytes for CP/M 1.4, and 15 bytes for 2.2
..chekver:
	lxi	B,8	; length of 1.4 overlay string
	lxi	H,param ; param table for CP/M 1
	lda	sysflg
	ora	A
	jrz	..overlay ;overlay in CP/M 1.4
	lxi	B,15	  ;length of 2.2 overlay string
	lxi	H,Param2  ; param table for CP/M 2.2
	push	B	  ; save bytes to overlay
.page
.sbttl 'Overlay the BIOS'
;
..overlay:		; Overlay DPB-1 with disk param
	lda	size
	mov	B,A	; size = byte in param table
	call	lookup	; to stop at
	pop	B	; # of bytes to overlay
	mov	E,m
	inx	H	; next byte to store
	mov	D,m	; addr from memory into reg
	sded	ovlyprm ; addr of pram table stored
	cpi	0ffh	; end of table = FFh, end =
	cz	error	; something wrong
	lda	sysflg
	ora	A	; be overlaid
	jrz	..ok	; jump if CP/M 1.4
;
; Make sure that the CP/M 2.2 allocation vector is
; large enough for this disk
	lxi	H,5
	dad	D	; HL = addr of (block cnt-1)
	mov	E,M
	inx	H
	mov	D,M	; DE = block count -1
	inx	D	; DE = block count
	mov	A,E
	srar	D
	rar
	srar	D
	rar
	srar	D
	rar
	mov	E,A	; DE = block count / 8
	push	D	; save block count
	call	cpmMAP	; get addr of DPB-1
	lxi	D,12
	ora	A
	dsbc	D	; HL = addr of lenalv
	mov	E,M
	inx	H
	mov	D,M	; DE = lenalv
	pop	H	; HL = block count/8
	ora	A
	dsbc	D
	jrc	..ok
	jrz	..ok
	lxi	D,noroom ; Not enough room in BIOS
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	jmp	retCCP
.page
; Finally, we can get down to business and overlay
..ok:
	call	cpmMAP	;get pointer to overlay area
	xchg		;HL = source, DE = dest
	lda	unitnum
	stax	D	;store unitnum where DE points
	dcx	D
	lda	devtype
	stax	D	;store devtype where DE points
	dcx	D
	lda	volume	
	stax	D	;store volume where DE points
	inx	D
	inx	D
	inx	D
	lxi	H,-16	;setup for DPB - 16
	dad	D	;in the HL register
	lda	ctrlbyt ;From Alloc table
;;;;;;; mov	M,A	;Alloc control byte in DPB
	lhld	ovlyprm ;source to overlay from ASSIGN
	ldir		;BC is set in ..chekver

	lda	sysflg	;If dealing with MP/M, force
	ora	A	;check vector size = 32
	jp	..CPM
	xchg
	dcx	H
	dcx	H
	dcx	H
	mvi	M,0	; high byte of chkvect size
	dcx	H
	mvi	M,32	; force check vector = 32
..CPM:	call	cpmMAP	; Compute addr of name in BIOS
	lda	sysflg
	ora	A
	jrz	..CPM1	; skip if cpm1.4
	lxi	D,10	; backup 10 to get to name
	dsbc	D
	jmpr	..both
..CPM1: lda	logname
	mov	B,A
	mvi	A,36
	sub	B
	mvi	B,0
	mov	C,A
	dad	B
..both: 		; Overlay name in BIOS
	xchg
	lxi	H,BIOSbuf
	lxi	B,8
	ldir
	jmp	finish
.page
.sbttl 'Read HD partition name'
;--------------
; Assume the rest of the command line holds a name.
; Backspace to the first chr AFTER the valid logical
; unit name (A,B,C, or D) and  LDIR rest of com line
; into buffer to send to the BIOS.
;
READNAME:
	lda	chrcnt	; character count may change
	mov	C,A
	lhld	NAMEaddr ; see if name has N: or H:
	inx	H
	mov	A,M
	dcx	H
	cpi	':'
	jrnz	..def	; if not default
	mov	A,M	; get disk type (H or N)
	inr	C	; skip past colon
	inr	C
	inx	H
	inx	H
	cpi	'H'	; if harddisk, set locnet=0
	jrz	..loc	; and process request
	cpi	'N'	; if network, set locnet=1
	jrz	..net	; and process request
	cpi	'U'	; if unassign 
	jrz	..unass ; process it
..def:	lda	userno	
	inr	A	; if logged in, locnet=1
	jrz	..loc	; else locnet=0
	jmpr	..net
..unass:
	lda	logname
	mov	C,A
	call	seldsk
	call	cpmMAP
	mvi	M,0FFh	; unassign this unit
	dcx	H	; other byte to set
	mvi	M,0FFh
	jmp	finish
..net:	mvi	A,1	; handle network case
	jmpr	..1
..loc:	sub	A	; mark as local case
..1:	sta	locnet	; store locnet
	lda	numchr	; determine number of chars
	inr	A	; in name
	sub	C	; do not LDIR logical drive
	mov	C,A
	mvi	B,0	; put answer in BC
	lxi	D,BIOSbuf ; DE = address of destination
	LDIR
.page
; The name is in the buffer. Assume the password is
; all blanks (ascii 20's).  Call the BIOS and try to
; convert the name and blank password into a physical
; name and unit number.

	lxi	H,BIOSbuf ; name and pass address
	call	asnNAME
	mov	A,B	; B = FFh if assign is
	cpi	0FFh	; denied
	jnz	savMAP	; No. Its AOK. Make the assnmt.
;---------------
; The blank password assignment was denied.
; Ask for the password. Transfer the password from 
; the console buffer to the password buffer.
;
getPAS: 
	lxi	D,PASSmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print 'Password?' msg
	lxi	H,PASSbuf ; get password address
	mvi	B,0	; initialize chr counter
chrget: push	H
	push	B
	call	CONIN
	pop	B
	pop	H
	cpi	backsp	; backspace entered?
	jrnz	..del	; No. Check for delete.
	mov	A,B
	cpi	0	; All characters deleted?
	jrz	chrget	; Yes. Fetch a character.
	dcr	B	; No. Decr chr counter,
	dcx	H	; backstep to last addr,
	jmpr	chrget	; and fetch a character.
..del:	cpi	delete	; delete entered?
	jrnz	..crrtn ; No. Check for carriage ret
	mov	A,B
	cpi	0	; All characters deleted?
	jrz	chrget	; Yes. Fetch a character.
	dcr	B	; No. Decr char counter
	dcx	H	; and backstep to last addr
	jmpr	chrget	; then fetch a character.
..crrtn:cpi	cr	; car ret entered?
	jrz	BIOScall; Yes. Attempt the assignment.
			; No. check for non-prtng chrs.
	cpi	ctrlc
	jz	retCCP	; Abort if Control-C.
	cpi	20h	; Is chr a non-printing chr?
	jc	chrget	; Ignore non-printing chrs.
.page
; Valid password chr found. Load it into PASSbuf.
	mov	M,A	; Put valid chr into password.
	inx	H	; Get to next PASS buffer addr
	inr	B	; Increment chr counter.
	mov	A,B
	cpi	7	; 7 chrs entered yet?
	jc	chrget	; No. fetch a character.
	push	H
	push	B
	mvi	A,bell	; Yes. Ring the bell.
	call	CONOUT
	pop	B
	pop	H
	dcr	B	; Decrement the chr counter.
	dcx	H	; Move back to sixth space
	jmp	chrget	; and get the next chr.
;
; Name and password obtained.  Call the BIOS and
; convert them into a physical name and unit number.
BIOScall:
	lxi	D,crlf
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	  ; space down a line
	lxi	H,BIOSbuf ; name and pass address
	call	asnNAME
	mov	A,B	; B = FFh is assign is
	cpi	0FFh	; denied
	jrnz	savMAP	; No. Its AOK.
	lxi	D,DENIEDmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; Print the denied msg
	lda	retries ; How many password tries?
	inr	A	; A = num of pass retries.
	cpi	maxtries; Last allowable time?
	jz	retCCP	; Yes. Exit to the CCP
	sta	retries ; No. Save the retries
	jmp	GETPAS	; and ask again.
.page
savMAP: cpi	0	; to partition 0
	jz	error
	sta	unitnum ; save the units number
	mov	A,C	
	sta	size	; save size of partition
	mov	A,D
	sta	volume	; save the volume number
	mov	A,E
	sta	ctrlbyt ; save the alloc control byte
	lxi	D,volmsg
	mvi	C,prtstrg
	call	BDOS
	lda	volume	; print the volume number
	call	prtbyt	
	lxi	D,crlf
	mvi	C,prtstrg
	call	BDOS	; space one line
	jmp	FINDMAP ; map in new DPB
.page
.sbttl	'Change the printer assignment'
;--------------
; THE FIRST LETTER OF THE COMMAND LINE WAS A 'P'.
;
; Acceptable characters: P   (Port0,Port1,Port2,PortP)
;			 S   (network Spooler)
;			 C   (Custom-patched driver)
;			 F   (Fox parallel port)
PRTasmt:
..1:	call	getchr
	cpi	' '	; fetch the next non-blank
	jrz	..1	; command line character.
	cpi	'C'	; If this is custom driver use
	mvi	B,0C0h	; Hex value for CUSTOM IOByte
	jz	ASSNport ;if this is custom assign
	cpi	'S'	; ELSE, test for spool, use
	mvi	B,0E0h	; Hex value for SPOOL IOByte
	jz	ASSNport; for this assignnment
	cpi	'P'	; ELSE, test for printer.
	jnz	ERROR	; If not, C,S, or P,
			; Bad entry, show user.
	call	getchr	; ELSE, We have a 'P'.
	cpi	'O'
	jnz	ERROR
	call	getchr	; Check spelling...
	cpi	'R'
	jnz	ERROR
	call	getchr
	cpi	'T'
	jnz	ERROR	; eat the ORT out of PORT
; Acceptable input:	0 is for PORT0
;			1 is for PORT1
;			2 is for PORT2
;			3 is for PORT3
;			P is for PORTP
;			F is for Fox parallel port
	call	getchr	; get 0,1,2,3, P, or F
	cpi	'0'
	mvi	B,00h	; Hex value for port0 IOByte
	jrz	ASSNport
	cpi	'1'	; jump around this
	jrnz	..next	; if not Port 1
	lda	userno	; 0=net mast, FF=local user
			; else net station
	cpi	0FFh	; if we are a local user, OK
	mvi	B,60h	; Hex value for port1 IOByte
	jrz	ASSNport ;ELSE, KICK YOU OFF!
	mvi	C,prtstrg ; CP/M 9, Print String
	lxi	D,noP1msg ; no, cant reassign port 1
	call	BDOS	; while on network.
	mvi	C,prtstrg ; CP/M 9, Print String
	lxi	D,DENIEDmsg
	call	BDOS	; Tell user 'ASSN DENIED'
	jmp	retCCP	; and exit to the CCP.
.page
..next: cpi	'2'
	mvi	B,40h	; Hex value for port2 IOByte
	jrz	ASSNport
	cpi	'3'
	mvi	B,20h	; Hex value for port3 IOByte
	jrz	ASSNport
	cpi	'P'
	mvi	B,80h	; Hex value for PP IOByte
	jrz	ASSNport
	cpi	'F'
	jnz	ERROR	; Incorrect input, flag it
;;;;	call	testHD	; user must not have a hard
;;;;	jrz	..noHD
;;;;	cpi	selcont	; disk to do this printer
;;;;	jnz	ERROR	; dont allow assign, ELSE, ok
..noHD:	mvi	B,0A0h	; 3 bit code for Fox PP IObyte
	lda	IObyte	; ELSE, be sure its a Fox
	ani	6	; Fox IObyte has bits 1 & 2 set
	cpi	6	; so don't change LIST device
	jrz	ASSNport ;ELSE, its a fox, do it
	lxi	D,nofoxmsg
	mvi	C,prtstrg ;CPM 9, Print String
	call	BDOS
	jmp	retCCP
;--------------
; Get the current IOByte from the BIOS.  Reg B has new
; new IObhte.  AND the two bytes together, and 
; replace as the new IOByte.
;
; Regs	in:  B = Hex value for device code for IOByte
; 
ASSNport:
	lda	IObyte	; Current IObyte in memory
	ani	1Fh	; only change list device
	ora	B	; put A and B together
	sta	IObyte	; put it back in memory
;---------------
finish:	lxi	D,LOGmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print LOG-on message
	lxi	D,EXITmsg  ; 'Assignment accepted'
	mvi	C,prtstrg  ; CP/M 9, Print String
	call	BDOS
	jmp	prtMAP
.page
.sbttl 'Print default assignments'
;
;		Subroutines
;-------------
; Subroutine: infout print the users assignments
; Regs in: A = logical unit
;	   D = physical unit
;Regs out: none
;
infout:
	lda	logbyte ; get logical unit in A
	adi	'A'	; 0,1,2,3 = A,B,C,D
	mov	E,A	; put logical in E
	mvi	C,conslout ;CP/M 2, Console Output
	call	BDOS	; print logical unit
	lda	devtype
	cpi	0ffh	; unassigned ?
	jrnz	..1	; skip if not
	lxi	d,unamsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	ret		; done with entry
;
; Print out a message for type of drive.
..1:	cpi	SD
	lxi	D,singmsg
	jrz	prtflop
	cpi	DD	; 1 is double density
	lxi	D,doubmsg
	jrz	prtflop
	cpi	mini1	; mini floppy, single side
	lxi	D,minisgl 
	jrz	prtflop
	cpi	mini2	; mini floppy, double side
	lxi	D,minidbl
	jrz	prtflop
	cpi	hard	; local harddisk
	lxi	D,hdskmsg 
	jrz	prtNAME 
	cpi	net	; network harddisk
	lxi	D,netmsg
	jrz	prtNAME
	cpi	DMS15HD ; DMS-15 hard disk
	lxi	D,fhdmsg
	jrz	prtNAME
.page
; Assignment being listed is floppy.
prtflop:
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; output physical name
	lda	unitnum ; load the unit number
	ani	3Fh	; mask unneeded bits for unit #
	call	cvtbcd	; make unit number decimal
	call	prtbyt	; print out drive number
	lxi	D,SIZmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	  ; print 'size'
	lda	devtype
	lxi	D,msg243K ; Load sing dens size.
	cpi	SD	  
	jz	prtSIZ	  ; Yes. Print the size.
	lxi	D,msg486K ; Load doub dens size.
	cpi	DD	  
	jz	prtSIZ
	cpi	mini1	  ; single side mini
	lxi	D,msg307K
	jz	prtSIZ
	cpi	mini2	  ; double side mini
	lxi	D,msg614K
	jz	prtSIZ
	lxi	D,Qmsg	  ; size = ???
	jmp	prtSIZ	  ; and print the ??? for size.
;
; Assignment being listed is a network partition or HD
;
prtNAME:
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; Print out assignment type
	call	cpmMAP	; Print out assignment name
	lda	sysflg	; Name in different
	ora	A	; place in CP/M 1.4 and 2.2
	jrz	..aCPM1 ; skip if cpm1.4
	lxi	D,10
	dsbc	D
	jmpr	..aboth
..aCPM1:lda	logbyte ; HL = BIOS MAP address
	mov	B,A
	mvi	A,36
	sub	B	; A = 36 - logical unit number
	mvi	B,00
	mov	C,A	; BC = 36 - logical unit number
	dad	B	  ; HL = BIOS MAP Name addr
..aboth:lxi	D,NAMEstr ; DE = Destination
	lxi	B,8	  ; BC = num of bytes 
	LDIR		  ; Copy bytes from BIOS
.page
	mvi	C,prtstrg ; CP/M 9, Print String
	lxi	D,NAMEstr
	call	BDOS	  ; print the assignment name
	mvi	C,prtstrg ; CP/M 9, Print String
	lxi	D,SIZmsg
	call	BDOS	; print size header
	call	getsize ; get size of harddisk
	call	cpmMAP	; check for fixed heads
	cpi	63
	jrnz	..notf	; jump if not fixed heads
	lxi	D,msg136K
	jmpr	prtSIZ
..notf: lda	size
	cpi	1
	lxi	D,msg256K
	jrz	prtSIZ
	cpi	2
	lxi	D,msg512K
	jrz	prtSIZ
	cpi	3
	lxi	D,msg1M
	jrz	prtSIZ
	cpi	4
	lxi	D,msg2M
	jrz	prtSIZ
	cpi	5
	lxi	D,msg4M
	jrz	prtSIZ
	cpi	6
	lxi	D,msg8M
	jrz	prtSIZ
	lxi	D,Qmsg	;all efforts for a size fail,
			;so print question marks
prtSIZ: mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	lxi	D,crlf
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	  ; space down one line
	ret		  ; and return
.page
;---------------
;  Subroutine: PRTRinfo Print the printer assignment.
;  Regs  in:  none
;  Regs out:  none
;  Destroyed: all
;  
PRTRinfo:
	lxi	D,PRTRmsg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	  ; space down a line
	mvi	C,getio   ; CP/M 7, Get I/O Byte
	call	BDOS	  ; reg A = CP/M IOByte
	rrc		  ; Bits 5,6,7 hold the
	rrc		  ;printer code. Now we
	rrc		  ;make the code a number
	rrc		  ;from 0 to 7.
	rrc
	ani	00000111b
	cpi	0	  ; 0 = Serial port 0
	lxi	D,SP0msg
	jrz	..prtasmt
	cpi	1	  ; 1 = Serial port 3
	lxi	D,SP3msg
	jrz	..prtasmt
	cpi	2	  ; 2 = Serial port 2
	lxi	D,SP2msg
	jrz	..prtasmt
	cpi	3	  ; 3 = Serial port 1
	lxi	D,SP1msg
	jrz	..prtasmt
	cpi	4	  ; 4 = parallel port 2
	lxi	D,PP2msg
	jrz	..prtasmt
	cpi	5	  ; 5 = Fox parallel port1
	lxi	D,PFoxmsg
	jrz	..prtasmt
	cpi	6	  ; 6 = Customized (thru
	lxi	D,CUSTmsg ;    BIOS patch) driver
	jrz	..prtasmt
	cpi	7	  ; 7 = Network spooler
	lxi	D,SPOOLmsg
	jrz	..prtasmt
	lxi	D,Qmsg	  ; Print the ????? message.
..prtasmt:		  ; Print printer assignment
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	lxi	D,crlf
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	  ; space down one line
	ret
.page
.sbttl 'CRT I/O subroutines'
;
; Subroutine getchr: read next character, inc chrcnt
; Regs in: none     
; Regs out: A (next command chr)
;
getchr: 	
	lxi	H,comline
	inr	M	; increment to next byte
	lxi	H,chrcnt
	inr	M	; increment chr counter
	lda	numchr
	inr	A
	cmp	M	; compare with chrcnt
	jz	error	; abort if last chr read
	lhld	comline ; read the command char
	mov	A,M
	ret		; got the chr now go back
;---------------
;		Subroutine: prtbyt
; Regs	in:	A=byte to be printed
; Regs out:	none
; Destroyed:	A,B,C
;Print a byte on the console
prtbyt:
	push	PSW	; save the chr
	rlc
	rlc
	rlc
	rlc
	call	prtnbl
	pop	PSW
	call	prtnbl
	ret
prtnbl: ani	0Fh
	adi	'0'
	cpi	'9'+1
	jc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
.page
;---------------
;		Subroutine: cvtbcd
; Regs	in:	A=byte to be converted
; Regs out:	A=byte, in BCD format
; Destroyed:	B
;Convert binary to BCD
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
;---------------
; Subroutine CONOUT:  Print a character on console
;  Regs in:	A = character to be printed
;  Regs out:	none
;  Destroyed:	C
;
CONOUT:
	mov	e,a
	mvi	C,conslout ;CP/M 2, Console Output
	jmp	BDOS

.page
.sbttl	'User error'
;
ERROR:	
	lda	chrcnt	; get num of chrs read
	adi	7	; increment past 'ASSIGN '
	push	PSW	; space-over count in reg A
arrow:	mvi	E,' '
	mvi	C,conslout ;CP/M 2, Console Output
	call	BDOS	; print a space
	pop	PSW
	sbi	1
	cpi	0
	push	PSW
	jnz	arrow	; repeat until under error
	pop	PSW
	mvi	E,'^'
	mvi	C,conslout ;CP/M 2, Console Output
	call	BDOS	; print arrow under error
	lxi	D,stxerr
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; and print SYNTAX ERROR
	lxi	H,8000h
..delay:dcx	H
	mov	A,L
	cpi	0
	jrnz	..delay
	ora	H
	jrnz	..delay ; and delay a second.
	lxi	D,errmsg; NOW print the long err msg
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS	; print error message and
	jmp	retCCP	; jump to CCP
.page
.sbttl	'Compute type of assign'
;---------------
; PERFORM ASSIGN for HARDDISK or NETWORK - 5 cases
;
;	0 - single user with local harddisk
;		communicate directly with harddisk
;	1 - single user with network harddisk
;		not allowed
;	2 - master with local harddisk:  not allowed
;	3 - master with network harddisk
;		communicate to harddisk through BIOS
;	4 - user stn with local harddisk
;		communicate directly with harddisk
;	5 - user stn with network harddisk
;		communicate on NETWORK through BIOS
;
;  On return the values in the registers are:
;  B = partition number
;  C = size of parition
;  D = Volume number
;  E = control byte
;
asnNAME:
	lda	sysflg
	ora	a
	jp	mpmno	;If MPM execute following code
	lxi	d,56h
	lixd	wbaddr
	dadx	d
	pcix		;use bios assign for mpm
mpmno:	lda	userno	;else, continue here
	inr	A	; use locnet and userno to
	cpi	2	; jump to the appropriate case
	jrc	..1
	mvi	A,2
..1:	slar	A
	mov	B,A
	lda	locnet
	add	B
	cpi	0	
	jrz	asnTP0
	cpi	1
	jrz	asnTP1
	cpi	2
	jrz	asnTP2
	cpi	3
	jrz	asnTP3
	cpi	4
	jrz	asnTP4
	cpi	5
	jrz	asnTP5
	lxi	D,intERR ; internal ERROR
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	call	wboot
.page
.sbttl	'Local or HiNet master HD assign'
asnTP0:
asnTP4:
	lda	IObyte
	bit	1,A	;if IObyte has bit 1 low,
	jrz	..8in	;it is an 8 inch HD
	mvi	A,0FFh	;ELSE, DMS-15 HD
	sta	DMS15flg ;set the flag to FF hex
;;;;;	call	testHD	;and test for hard disk
;;;;;	jz	HDdead	;HOWEVER, test doesnt work
;;;;;	cpi	selcont ;If no HD, back to
;;;;;	jz	HDdead	;CPM
;;;;;	mvi	A,deselcont 
;;;;;	call	outstatus
	call	DMS15as	;do the assign
	ret
..8in:	call	HARDas	;Regular HD, standard process
	ret
asnTP1:
	lxi	D,noNET   ; print error message
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	call	retCCP
asnTP2:
	lxi	D,badMST  ; print error message
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	call	retCCP
asnTP3:
	mvi	C,net	; network disk equate
	mov	A,C
	sta	devtype ; network harddisk
	lded	NETadr	; move NAME and PASSWORD
	inx	D	; into BIOS area
	lxi	B,14
	di
	ldir
	lhld	NETadr	; load in ASSIGN command
	mvi	M,assnNET
	ei
..1:	mov	A,M	; wait for BIOS to finish
	ora	A
	jrnz	..1
	inx	H
	mov	C,M	; partiton size is in reg C
	inx	H
	mov	A,M	; partition number from
	mov	B,A	; alloc table is in reg B
	inx	H
	mov	E,M	; Reg E has control byte
	inx	H
	mov	D,M	; Reg D has volume number
	ret
.page
.sbttl	'HiNet station to master HD assign'
asnTP5:
	mvi	C,net	; network disk equate
	mov	A,C
	sta	devtype ; network harddisk
	lxi	H,loops	; countdown code for NACKpoll
	mvi	m,loop	; start with 5
..loop: push	H	; save counter addr
;
..retry:lxi	H,retry
	mvi	m,maxtries ;start with 3
..poll: push	H	; save retries addr
	call	NACKpoll ;get ahold of NETWORK
	bit	0,a	; if no poll, then 3 retries
	pop	H	; retries addr back
	jrnz	..cont
	dcr	m	; if retries is not 0, look
	jrnz	..poll	; for another poll
	jmp	NETdead ; ELSE, no network
;
..cont:	sub	A	; 0 = send request to master
	lxi	B,15
	lxi	H,NETcom
	call	SENDNET ; through BIOS
	lda	userno	; get response
	lxi	B,4	; from MASTER
	lxi	H,NETres ; through BIOS
	call	RECNET
	call	CKrecstat 
	jrz	..ok
	pop	H	; get loop count addr
	dcr	m	; dec the counter
	jrnz	..loop	; if not 0, try again
	jmp	NETdead	; ELSE, it is all over
;
..ok:	pop	H	; balance stack
	lbcd	NETres	; B has unit #, C has size
	lded	NETres+2 ;D has vol #, E has ctrl byte
	push	B
	push	D
	call	ACKpoll ; restart BIOS polling
	pop	D
	pop	B	; save the registers
	ret
.page
.sbttl	'8 inch hard disk subroutines'
;--------------
; Hard disk unit assignment
;  Regs in:   HL = address of unit name and password
;  Regs out:  BC = unit and size
;	       D = volume
;	       E = control byte
HARDas:
	mvi	C,hard	; local harddisk equate
	mov	A,C
	sta	devtype ; local harddisk
	push	H	; save address of name
	mvi	A,assnHARD
	call	CMDhard ; send command to hard disk
	pop	H
	mvi	B,14
	call	SENDHARD; send name and password
	call	RESHARD ; get disk assignment
	lbcd	HARDstat; B = unit, C = size
	lded	HARDstat+2
	ret
;---------------
; Transmit a block to the hard disk
;  Regs in:   HL = block address
;	      B  = byte count
;  Regs out:  none
;  Destroyed: A, BC, HL
SENDHARD:
	mvi	C,HARDP
..1:	in	PIOAD
	bit	3,A
	jrnz	..1
	outi
	jrnz	..1
	ret
;---------------
; Receive a block from the hard disk
;  Regs in:   HL = block address
;	      B  = byte count
;  Regs out:  none
;  Destroyed: A, BC, HL
RECHARD:
	mvi	C,HARDP
..1:	in	PIOAD
	bit	4,A
	jrz	..1
	ini
	jrnz	..1
	sub	A	; CP/M wants A = 0
	ret
.page
;---------------
; Send a command to the hard disk
;  Regs in:   A = command byte
;  Regs out:  none
;  Destroyed: A, BC, HL
cmdHARD:
	sta	HARDcom
	lxi	B,0	; keep activity count
..1:	in	HARDP	; clear status
	mvi	A,51h	; "request to send"
	out	HARDP
..2:	dcx	B
	mov	A,B
	ora	C
	jz	HDdead	; jump if hard disk is dead
	in	PIOAD	; wait for HDC send
	bit	4,A
	jrz	..2
	in	HARDP	; check if "clear to send"
	cpi	52h
	jrnz	..1	; if not, retry
	lxi	H,HARDcom ; send the command
	mvi	B,8
	jmpr	SENDHARD
;---------------
; Receive status info from the hard disk
;  Regs in:   none
;  Regs out:  A = error status
;  Destroyed: A, BC, HL
RESHARD:
	lxi	H,HARDstat
	mvi	B,8
	call	RECHARD
	lda	HARDstat+7
	ora	A
	rz		
HDdead: lxi	D,deadHD  ; print error message
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
	call	retCCP
.page
.sbttl '5 1/4" hard disk subroutines'
;---------------
; Subroutine testHD:  Test if there is a DMS-15 HD
; Reg in:   None
; Reg out:  zero flag is zero if no char
;	    A = char if there is one returned
; Destroyed: A
;
testHD:
	lxi	B,4000
..out:	call	instatus
	bit	busy,A
	jrz	..chr	;non zero means char back
	dcx	B
	mov	A,C
	ora	B
	rz		;no char after timeout
	jmpr	..out	;no char, try again
..chr:	mvi	A,selcont ;select controller
	call	outstatus ;send data out
	lxi	B,4000
..back: call	instatus
	bit	busy,A
	rnz		;non zero means char back
	dcx	B
	mov	A,C
	ora	B
	rz		;no char after timeout
	jmpr	..back	;no char, try again
;--------------
; Subroutine instatus and outstatus: test the port
; Reg in:  None
; Reg out:  A = C1 hex if there is a printer port
; Destroyed:  A
;
instatus:
	out	toggle
	in	DAT$CMDport
	out	toggle
	ret
outstatus:
	out	toggle	;to select XEBEC port
	out	DAT$CMDport ;data to XEBEC port
	out	toggle
	ret
.page
;--------------
; Subroutine DMS15as:  DMS-15 Hard disk assignment
;  Regs in:   HL = address of unit name and password
;  Regs out:  BC = unit and size (B=FF if denied)
;	      DE = volume and control byte
DMS15as:
	mvi	C,DMS15HD ; local harddisk equate
	mov	A,C
	sta	devtype ; local harddisk
	push	H	; save address of name
	call	r15alloc ; read DMS-15 alloc table(s)
	pop	H
	call	srchtab ; search four volumes
	ret
;-------------
; Search for a name/psw in the alloc table(s)
; Regs in:   none
; Regs out:  BC = unit and size  (B = FF if not found)
;	     DE = volume & control byte
;	     Z if not found, NZ if found
; Trashed:   Everything else
;
SRCHTAB:
	mvi	D,0	; current volume
..vol:	call	present ; see if there is such a volume
	cnz	SRCHVOL ; if so, check its alloc table
	rnz		; found it
	inr	D	; set up for next volume
	mvi	A,4	; see if all vols checked
	cmp	D
	jrnz	..vol
	mvi	B,0FFh	; not found
	ret
;--------------
; Search one volume's table for a name/psw
; Regs in:  D = volume number
; Regs out: Z if not found, NZ if found
;	    BC = unit & size   "   "
;	    DE = vol & ctl byte "  "

SRCHVOL:
	push	D	; volume number
	call	pntvol	; point HL at proper table

	mvi	B,nument; number of lines to check
..comp: call	cline	; compare one line
	jrnz	..out	; NZ if found
	djnz	..comp
..out:	pop	D	; vol number
	cnz	..got	; fill up other registers
	ret		; zero: didn't get it
.page
;
; NOTE:  This subroutine must stay with SRCHVOL above
; ****
; Regs in:  HL = ptr to begin of NEXT entry
;	    D  = volume number
;	    B  = (number of units - unit number)
;	    C  = size byte
; Regs out: DE = volume & control byte
;	    BC = unit number & size
; Trashed:  HL,B,E  (but NOT PSW.)
; 
..got:
	dcx	H	; point to control byte
	mov	E,M	; now D and E are right
	push	PSW	; save NZ flag
	mvi	A,nument; change loop ctr to
	sub	B	;   unit number
	mov	B,A	; now B is right.
			; C was set in CLINE 
	pop	PSW
	ret		; NZ: got it
;---------------
; Point HL to proper allocation table
; Regs in:   D	= volume number
; Regs out:  HL = ptr to alloc table
; Trashed:   A,B,HL  (not C or D)
pntvol:
	lxi	H,allotab
	mov	A,D
	ora	A
	rz		; don't increment if vol 0
	mov	B,A	; loop cntr
	lxi	D,lentab
..dad:	dad	D
	djnz	..dad	; point to right vol's tabl
	ret
;--------------
; Compare two strings
; Regs in:  DE, HL point to strings
;	    B = length (must NOT be 0)
; Regs out: Z if match, NZ if not
; Trashed:  PSW,B,DE,HL
cname:
	ldax	D
	cmp	M
	rnz		; bad
	inx	H
	inx	D
	djnz	cname	; drop if we've got it
	ret
.page
;---------------
; Compare one line's name/psw with test value
; Regs in: HL = ptr to beginning of line
; Regs out:HL = ptr to begin of next line
;	    C = size
;	    Z if NOT match, NZ if match
; Trashed: everything
cline:
	push	B	; line counter
	push	H	; begin of line
	inx	H	; point to name
	lxi	D,BIOSbuf; point to test name
	mvi	B,14
	call	cname	; compare name
	pop	H	; begin of line, (to get size)
	mov	A,M	; in case we'll want it
	push	PSW	; Z=result of compare
			; and A=size
	lxi	B,16
	dad	B	; begin of next line 
	pop	PSW	; get flag back
	pop	B	; loop counter
	jrnz	..bad
	mov	C,A	; put size in C
	ori	0FFh	; no Z flag
	ret
..bad:	xra	A	; Z flag
	ret
;---------------
; Determine whether a volume exists
; Regs in:   D = volume number
; Regs out:  A = volume status
;	     Z set if A=0
; Trashed:  A,BC  (HL,DE not harmed)
present:
	push	H
	mov	A,D
	rlc		; multiply A by 32, which
	rlc		; is the length of a volume
	rlc		; status block.
	rlc
	rlc
	mov	C,A
	mvi	B,0
	lxi	H,volinfo
	dad	B
	mov	A,M
	ora	A
	pop	H
	ret
.page
;--------------
r15alloc:
	call	ovrlay	; set up for partition 0
	mvi	D,0
..vol:	push	D
	call	r15vol  
	pop	D
	inr	D	; next volume
	mvi	A,4
	cmp	D
	jrnz	..vol
	call	restore ; restore old assignment
	ret
;---------------
; Read in alloc table for one DMS-15 volume
; Regs in:  D = volume number
r15vol:
	call	present
	rz		 ; don't read if no volume!
	call	setvol	; set CP/M volume number
	call	pntvol	; point HL to alloc tabl loc
	call	pntDMA	; get DMA initialized
	call	pntCPM	; get track, sector right
	mvi	B,lentab/128 ; read 8 CP/M records
..read: push	B
	call	READ
	call	inrDMA	; increment DMA
	call	inrCPM	; increment CP/M sector
	pop	B
	djnz	..read
	ret
;---------------
; Set the volume in the DPB
; Regs in:   D = volume
; Regs out:  none
; Trashed:   HL
;
setvol:
	lhld	DPBminus1
	dcx	H
	dcx	H	; point at volume
	mov	M,D
	ret
;---------------
; Point the DMA to the alloc table area
; Regs in:  HL = address of table to read 
;
pntDMA: mov	C,L
	mov	B,H
	sbcd	cpmDMA
	call	setDMA
	ret
.page
;---------------
; Point the CP/M track & sector to the
;  allocation table in partition 0

pntCPM: lxi	B,0
	sbcd	cpmTRK
	call	setTRK	; track 0
	mvi	A,79h
	sta	cpmSEC
	mov	C,A
	call	setSEC	; sector 121
	ret
;---------------
; Increment the CP/M sector

inrCPM: lda	cpmSEC
	inr	A
	sta	cpmSEC
	mov	C,A
	call	setSEC
	ret
;---------------
; Increment the DMA address

inrDMA: lhld	 cpmDMA
	lxi	B,80h
	dad	B
	call	pntDMA
	ret
.page
;---------------
; Put Unit 0 stuff in; save old
; Also save DPBminus1 value
; Regs in:  none
; Regs out: none
; Trashed: all
ovrlay:
	call	CPMmap
	shld	DPBminus1
	dcx	H	; device type
	dcx	H	; volume
	push	H
	lxi	D,saveDPB
	lxi	B,18
	ldir		; it's saved.
	pop	H
	mvi	M,0	; start w/vol 0
	inx	H
	mvi	M,DMS15HD
	inx	H
	mvi	M,0	; unit 0 of course
	inx	H	; point to DPB proper
	xchg		; it's the destination
	lxi	H,H2DSKqM ; it's a quarter meg
	lxi	B,15	; DPB length
	ldir
	ret
;---------------
; Restore user's disk assignment after
; we're done reading partition 0
; Regs in:  none
; Regs out: none
; Trashed:  all except PSW
restore:
	lxi	H,saveDPB
	lded	DPBminus1
	dcx	D
	dcx	D
	lxi	B,18
	ldir
	ret
.page
.sbttl	'Lookup an entry in PARAM table'
;---------------
; Subroutine lookup: look for a word in a table
; Reg in:  B  = byte to look up
;	   HL = base of table address
; Reg out: A  = FFh if entry not found
;	   HL = Address of desired word   
;
lookup:
	push	D	; save your register
	lxi	D,3	; to add to HL for next byte
..1:	mov	A,B	; if addr you want is same as
	cmp	m	; whats in HL, we are there
	jrz	..done
	mvi	A,0FFh	; end of table has FFh 
	cmp	m
	jrz	..not
	dad	D	; increment HL 3 bytes
	jmpr	..1	; look at next entry
..done: inx	H	; HL points to word
..not:	pop	D	; here is your register
	ret
;---------------
; Subroutine getsize:  Get the size of the harddisk
; reg in:  None
; Reg out: A = size of harddisk for lookup
; Reg destroyed: A, HL
;
getsize:
	call	cpmMAP
	inx	H
	inx	H
	inx	H
	lda	sysflg	; Size computed differently
	ora	A	; in CP/M 1.4 and 2.2
	jrz	..CPM1	; skip if cpm1.4
	mov	B,M	; use BSH and DSM to find size
	lxi	D,4
	dad	D	; increment HL + 4
	mov	A,M
	ora	A
..1:	jrz	..2
	inr	B
	srar	A
	jmpr	..1
..2:	mov	A,B
	jmpr	..both
..CPM1: mov	A,M	; A = log of sectors per block
..both: sui	2	; A = size of unit (1-6)
	sta	size
	ret
.page
.sbttl	'Communicate with the BIOS'
CONIN:	
	lhld	wbaddr
	lxi	d,6
	dad	D
	pchl
seldsk: 
	lda	sysflg
	ora	a
	jp	notmpm	; skip if some cpm version
	lxi	h,selret
	push	h	; force return to us
notmpm: lhld	wbaddr
	lxi	d,18h
	dad	d
	pchl		; goto bios
selret: shld	mpmtab	; save dpb address
	ret
cpmMAP: 
	lda	sysflg
	ora	A
	jm	mpmmap	; skip if mpm system
	lhld	wbaddr
	lxi	d,60h
	dad	d
	pchl		; goto bios
;--------------
; Subroutine CKrecstat: Check network transmissions
; Reg in:  A = RECstatus
; Reg out: Timeout  = Z set,   C set
; 	   CRC$OVR  = Z reset, C set
;	   no error = Z reset, C reset
CKrecstat:
	bit	7,a	;first check for timeout
	jrz	..bad
	bit	0,a	;then no poll
	jrnz	..bad	;if poll, no good
	ani	60h	;mask out crc and ovrrun error
	jrnz	..bad
	ret		;all tests good
;
..bad:  mvi	A,0ffh  ;ELSE, test is bad, set
	ora	A	;flags and
	ret		;return
;--------------
NETdead:lxi	D,deadNEt ; print NETWORK dead
	mvi	C,prtstrg ; CP/M 9, Print String
	call	BDOS
retCCP:
	lda	4
	mov	C,A	; re-select correct disk
	call	SELDSK
	jmp	wboot	; give user a warm boot
.page
.sbttl	'Communicate with MPM XIOS'
;
getque: lda	sysflg
	ora	a
	jp	..1	;skip if not mpm
	mvi	a,0ffh
	sta	queflg
	mvi	C,openque ;MPM 135, Open Que
	lxi	d,mpmq
	call	BDOS
	mvi	C,readque ;MPM 137, Read Que
	lxi	d,mpmq
	call	BDOS
..1:	ret
;---------------
putque: lda	queflg
	ora	a
	rz
	xra	a	; reset flg
	sta	queflg
	mvi	C,writque ;MPM 139, Write Que
	lxi	d,mpmq
	call	BDOS
	ret
;---------------
mpmmap: lhld	mpmtab
	lxi	d,10	; offset to disk parm tab
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	dcx	d	; point to unit+devtype
	xchg
	mov	a,m	; get unit byte
	ret
.page
.sbttl 'Define storage'
;---------------
wbaddr: .word	0	;bios vector address
comline:.word	80h	;beginning of command line
medtype:.word	0	;media type to write to
chrcnt: .byte	0	;num of command chrs entered
namchr: .byte	0	;num of com chrs entred at NME
numchr: .byte	0	;num of command chrs read
MAPbyte:.byte	0	;physical command byte
logname:.byte	0	;logical unit name
logbyte:.byte	0	;current logical unit
devtype:.byte	0	;physical unit name
unitnum:.byte	0	;unit number from alloc table
size:	.byte	0	;unit size from alloc table
volume: .byte	0	;multi-harddisk number
ctrlbyt:.byte	0	;control byte from alloc table
NAMEaddr:.word	00	;address of name assignment
ovlyprm:.word	00	;address of param to overlay
conbuf: .byte	10,0
	.ascii	'                '  ; console buffer
NETcom: .byte	assnNET ; Network assign command
BIOSbuf:.ascii	'        '	    ; BIOS Name holder
PASSbuf:.ascii	'       '	    ; Password holder
NETres: .blkb	4	; Network assign result
HARDcom:.byte	assnHARD ; Hard disk assign command
	.byte	0,0,0,0,0,0,0
HARDstat:.blkb	8	; hard disk status
volinfo: .blkb	128	; rest of HD status
locnet: .byte	0	; 0 if local, 1 if NETwork
DMS15flg:.byte	0	; 0 if DMS comtroller, FF if Xebec
sysflg: .byte	0	; 0ffh if mpm, 0 if cpm1.4
NAMEstr:.ascii	'        $'
DPBminus1:.word 0	; filled in by ovrlay
cpmDMA: .word	allotab
cpmTRK: .word	0
cpmSEC: .word	121
retries:.byte	0	; password retries
mpmtab: .word	0
retry:	.byte	0	; Nackpoll retry counter
loops:	.byte	0	; network retry loop cntr

NETadr: .word	0	; address of NETcom in BIOS
queflg: .byte	0
mpmq:	.byte	0,0
	.word	qbuff
	.ascii	'MXDisk  '
qbuff:	.byte	0,0
.page
;---------------
;  BIOS jump vectors
setTRK: jmp	0
setSEC: jmp	0
setDMA: jmp	0
READ:	jmp	0
SENDNET:jmp	0
RECNET: jmp	0
NACKpol:jmp	0
ACKpoll:jmp	0
	jmp	0
	jmp	0
	jmp	0
HDstat: jmp	0
.page
.sbttl	'1.4 disk parameter blocks'
Param:
	.byte	SD
	.word	SD1
	.byte	DD
	.word	DD1
	.byte	1
	.word	H1DSKqM
	.byte	2
	.word	H1DSKhM
	.byte	3
	.word	H1DSK1M
	.byte	4
	.word	H1DSK2M
	.byte	5
	.word	H1DSK4M
	.byte	7
	.word	H1DSKf
	.byte	0FFh
;---------------
;  CP/M 1.4 disk parameters
;
; (1) physical device and unit number
; (2) sectors per track
; (3) maximum directory number
; (4) logarithm of sectors per block ( 3 means 2**3 )
; (5) sectors per block minus one
; (6) number of blocks minus one
; (7) bits indicate blocks for op sys
; (8) number of op sys tracks
; (9) 4Eh for CP/M sector mapping, 0C0h otherwise
;
;		(2) (3) (4) (5) (6) (7)  (8) (9)
SD1:	.byte	 26, 63,  3,  7,242,0C0h,  2,4Eh
DD1:	.byte	 52,127,  4, 15,242,0C0h,  2,0Ch
H1DSKqM:.byte	128, 63,  3,  7,255,0C0h,000,0Ch
H1DSKhM:.byte	128, 95,  4, 15,255,0C0h,000,0Ch
H1DSK1M:.byte	128,127,  5, 31,255,080h,000,0Ch
H1DSK2M:.byte	128,191,  6, 63,255,080h,000,0Ch
H1DSK4M:.byte	128,254,  7,127,255,080h,000,0Ch
H1DSKf: .byte	128, 31,  3,  7,135,080h,000,0Ch
.page
.sbttl '2.2 disk parameter blocks'
Param2: .byte	SD   ;CP/M 2.2 pointer to disk params
	.word	SD2
	.byte	DD
	.word	DD2
	.byte	MINI2
	.word	DS2MINI
	.byte	1
	.word	H2DSKqM
	.byte	2
	.word	H2DSKhM
	.byte	3
	.word	H2DSK1M
	.byte	4
	.word	H2DSK2M
	.byte	5
	.word	H2DSK4M
	.byte	6
	.word	H2DSK8M
	.byte	7
	.word	H2DSKf
	.byte	0FFh
;----------
;  CP/M 2.2 disk parameters
;
SD2:	.word	26	; sectors per track
	.byte	3,7,0	; blk shift, blk and ext mask
	.word	242	; number of blocks - 1
	.word	63	; maximum directory entry
	.byte	0C0h,0	; bits indicate directory blks
	.word	16	; check vectors size
	.word	2	; number of op sys tracks
;
DD2:	.word	52	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	242	; number of blocks - 1
	.word	127	; maximum directory entry
	.byte	0C0h,0	; bits indicate directory blks
	.word	32	; check vectors size
	.word	2	; number of op sys tracks
;
DS2MINI:.word	32	; sectors per track
	.byte	5,31,0	; blk shift, blk and ext mask
	.word	156	; number of blocks - 1
	.word	127	; maximum dorectory entry
	.byte	080h,0	; bits indicate directory blks
	.word	32	; check vector size
	.word	3	; number of op sys tracks
;
H2DSKqM:.word	128	; sectors per track
	.byte	3,7,0	; blk shift, blk and ext mask
	.word	255	; number of blocks - 1
	.word	63	; maximum directory entry
	.byte	0C0h,0	; bits indicate directory blks
	.word	16	; check vectors size
	.word	0	; number of op sys tracks
;
H2DSKhM:.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	255	; number of blocks - 1
	.word	127	; maximum directory entry
	.byte	0C0h,0	; bits indicate directory blks
	.word	32	; check vectors size
	.word	0	; number of op sys tracks

H2DSK1M:.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	511	; number of blocks - 1
	.word	255	; maximum directory entry
	.byte	0F0h,0	; bits indicate directory blks
	.word	64	; check vectors size
	.word	0	; number of op sys tracks

H2DSK2M:.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	1023	; number of blocks - 1
	.word	511	; maximum directory entry
	.byte	0FFh,0	; bits indicate directory blks
	.word	128	; check vectors size
	.word	0	; number of op sys tracks

H2DSK4M:.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory entry
	.word	0FFFFh	; bits indicate directory blks
	.word	256	; check vectors size
	.word	0	; number of op sys tracks

H2DSK8M:.word	128	; sectors per track
	.byte	5,31,1	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory entry
	.byte	0FFh,0	; bits indicate directory blks
	.word	256	; check vectors size
	.word	0	; number of op sys tracks

H2DSKf: .word	128	; sectors per track
	.byte	3,7,0	; blk shift, blk and ext mask
	.word	135	; number of blocks - 1
	.word	31	; maximum directory entry
	.byte	080h,0	; bits indicate directory blks
	.word	8	; check vectors size
	.word	0	; number of op sys tracks

saveDPB:.blkb	18	; temporary storage for user's
			; DPB while we read part.0
.page
.sbttl 'CRT MESSAGES'
;------------------
; Data for console output
LOGmsg: .ascii	[cr][lf]'ASSIGN for BIOS 2.244 and '
	.ascii	'later, version '
	.byte	version +'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch
	.ascii	[cr][lf]'$'
stxerr: .ascii	'  *** SYNTAX ERROR ***'[cr][lf]'$'
errmsg:
    .ascii  '|-FLOPPY DISK assignments:--------------|'
    .ascii  '|-HiNet or HARD DISK assignments:-----|'
    .ascii  '| ASSIGN <CP/M-disk> <density> <drive>  |'
    .ascii  '| ASSIGN <CP/M-disk> <partition-name> |'
    .ascii  '|                                       |'
    .ascii  '|                                     |'
    .ascii  '| where:                                |'
    .ascii  '| where:                              |'
    .ascii  '|   <CP/M-disk> = A,B,C,or D            |'
    .ascii  '|   <CP/M-disk>      = A,B,C,or D     |'
    .ascii  '|   <density>   = S for single density  |'
    .ascii  '|   <partition-name> = hard disk or   |'
    .ascii  '|               = D for double density  |'
    .ascii  '|                      HiNet partition|'
    .ascii  '|   <drive>     = floppy disk drive     |'
    .ascii  '|                      name.          |'
    .ascii  '|                 number (from 0 to 7)  |'
    .ascii  '|                                     |'
    .ascii  '|                                       |'
    .ascii  '| Example: A>ASSIGN D PAYROLL         |'
    .ascii  '| Example: A>ASSIGN B D1                |'
    .ascii  '|                                     |'
    .ascii  '|                                       |'
    .ascii  '| This assigns CP/M disk drive D to a |'
    .ascii  '| This assigns CP/M disk drive B to a   |'
    .ascii  '| hard disk or HiNet partition named  |'
    .ascii  '| double density floppy diskette on the |'
    .ascii  '| PAYROLL. A password may be needed.  |'
    .ascii  '| second floppy drive.                  |'
    .ascii  '| Use the DIRNET (or DIRHARD) command |'
    .ascii  '|---------------------------------------|'
    .ascii  '| for a list of available partitions. |'
    .ascii  '| PRINTER assignments:  ASSIGN P <ptr>  |'
    .ascii  '|-------------------------------------|'
    .ascii  '| where:                                |'
    .ascii  '| For a list of CURRENT assignments   |'
    .ascii  '|   <ptr> =  PORT0, PORT1, PORT2, PORT3 |'
    .ascii  '| enter only:                         |'
    .ascii  '|_____PORTF, PORTP, SPOOL, or CUSTOM ___|'
    .ascii  '|_____________ ASSIGN ________________|'
    .ascii  '$'
volmsg: .ascii	[cr][lf]'This partition is on volume $'
.page
PASSmsg:.ascii	[cr][lf]'Enter Password: $'
bsymes: .ascii	[cr][lf]' rejected - disk busy.$'
nono:	.ascii	[cr][lf]' REJECTED -'
	.ascii	' unit already assigned!$'
infomsg:.ascii	[cr][lf]'          '
	.ascii	' Current Disk Assignments '
	.ascii	[cr][lf]'          '
	.ascii	' ------------------------ '
	.ascii	[cr][lf][lf]'$'
space4: .ascii	'    $'
crlf:	.ascii	[cr][lf]'$'
PRTRmsg:.ascii	[cr][lf]'Printer assigned to $'
SP0msg: .ascii	'PORT0 (serial port 0)$'
SP1msg: .ascii	'PORT1 (serial port 1)$'
SP2msg: .ascii	'PORT2 (serial port 2)$'
SP3msg: .ascii	'PORT3 (serial port 3)$'
PFoxmsg:.ascii	'PORTF (parallel port 1 for Fox '
	.ascii	'with NO HARD DISK)$'
PP2msg: .ascii	'PORTP (parallel port 2)$'
CUSTmsg:.ascii	'CUSTOM (special printer driver)$'
SPOOLmsg:
	.ascii	'SPOOL (HiNet print spooler)$'
noP1msg:.ascii	'PORT1 cannot be re-assigned while on'
	.ascii	' the HiNet.'[cr][lf]'$'
EXITmsg:.ascii	[cr][lf]'Assignment accepted.'[lf]
	.ascii	[cr][lf]'          '
	.ascii		' Your new assignments are:'
	.ascii	[cr][lf]'          '
	.ascii		' -------------------------'
	.ascii	[cr][lf][lf]'$'
DENIEDmsg:
	.ascii	'Assignment denied. $'
singmsg:.ascii	' - single density,   drive $'
doubmsg:.ascii	' - double density,   drive $'
minisgl:.ascii	' - single side mini, drive $'
minidbl:.ascii	' - double side mini, drive $'
netmsg: .ascii	' - HiNet partition,  $'
unamsg: .ascii	' - ** unassigned **'[cr][lf]'$'
hdskmsg:.ascii	' - local partition,  $'
fhdmsg: .ascii	' - DMS-15 partition, $'
SIZmsg: .ascii	'    size: $'
msg243K:.ascii	'243K bytes$'	; sing dens disk size
msg486K:.ascii	'486K bytes$'	; doub dens disk size
msg307K:.ascii	'307K bytes$'	; mini-floppy sgl side
msg614K:.ascii	'614K bytes$'	; mini-floppy dbl side
msg256K:.ascii	'256K bytes$'	; disk partition sizes
msg512K:.ascii	'512K bytes$'
msg1M:	.ascii	'  1M bytes$'
msg2M:	.ascii	'  2M bytes$'
msg4M:	.ascii	'  4M bytes$'
msg8M:	.ascii	'  8M bytes$'
msg136K:.ascii	'136K bytes$'
Qmsg:	.ascii	'   ??? $'
.page
noNET:	.ascii	'Not logged in.$'
badMST: .ascii	'Cannot assign local hard disk.$'
deadNET:.ascii	'Your Network is not operational.'
	.ascii	[cr][lf]'Please check your HiNet '
	.ascii		'master station.$'
deadHD: .ascii	'Hard disk not operational.$'
intERR: .ascii	'Internal error.$'
noroom: .ascii	[cr][lf]'However, the floppy disk '
	.ascii		'CPM BIOS allocation vector '
	.ascii		'is too small.'
	.ascii	[cr][lf][lf]'Please try Drive D for '
	.ascii		    'this assignment.$'
noFoxmsg:.ascii [cr][lf][lf]'This is not a Fox.  You '
	.ascii		'can not do this assignment.'
	.ascii	[cr][lf]'$'
badmsg	==	intERR
	.blkb	60	   ; room for stack
stack:			   ; stack location
allotab:
	.end

