.title 'List and/or modify the Disk Allocation Table'
	.sbttl 'Table of contents'
	.ident ALLOC
version ==	4
revision==	11
patch	==	' '	;last modified 04/26/83 DRB
	.pabs
	.phex
	.loc	100h
; 
;     Program: ALLOC for 2.243 and later BIOS
;
;		Table of contents
;
;  Table of contents				 1
;  Program description				 2
;  Update history				 3
;  Get the system type				 4
;  Get size and type of harddisk		 5
;  Get the user command 			 8
;  Help and change volumes			10
;  Print the volumes				11
;  Add an entry to the alloc table		10
;  Modify an entry in the alloc table		12
;  Modify and zero out the table commands	15
;  Save the changes to the alloc table		17
;  Delete an entry in the alloc table		18
;  Erase MPM directory				19
;  Exits					23
;  Beginning of Subroutines			23
;	Console I/O and print subroutines	24
;	Harddisk I/O subroutines		34
;	BIOS calls				38
;  Equates					40
;  Define storage				41
;  CRT messages 				43
.page
.sbttl 'Program description'
;
; Disk Allocation Table description
;
; The current table will be read in from track 0 sec- 
; tor 79 of the HiNet master or stand-alone hard disks.
; It is a 16 byte x 64 line table and has the following
; format:
;
;	size  partition-name   password   ctrl
; bytes  1	    8		  6	   1
;
; The size byte can be from 1 to 6. A zero size byte
; signifies the end of the table.
; The name is 8 upper case characters. (blanks incl)
; The password is 6 upper or lower case characters 
; with blanks included.
; The control (ctrl) byte is any hex value and is not
; used at this time.
;
; Step 1 - Read in allocation map from harddisks
;	   Calculate size of harddisks
;
; Step 2 - Get user command
;		A - Add an entry (user cannot
;		    overallocate the disk)
;		C - Change the volume
;		D - Delete an entry
;		E - Erase MPM directory (MPM only)
;		H - Help
;		M - Modify (user cannot overallocate
;		    the harddisk)
;		Q - Quit the program
;		L - List out the allocation table
;		    and space allocated on disk
;		S - save your allocation table (user
;		    cannot overallocate the disk)
;		V - Print out the volume titles
;		Z - Zero out current table in memory
;
; Step 3 - Test the alloc table.  If it exceeds the
;	   total disk space available, do not allow
;	   the save.  Otherwise, save as the current
;	   allocation map on the harddisk.
.page
.sbttl 'Update history'
;
; LAST REVISED	22 Apr 83	TPL
;
; Version  1.02 Delete command added with warning
;		message.  Size change issues a 
;		warning messages.  ESCAPE to 
;		'command*' prompt added.
;
; Version  2.00 Amount of space allocated is now 
;		printed out after each list (Lcom)
;
; Version  4.00 Locked partition 0(system) to 
;		prevent modification.
;
; Version  4.01 Works with MPM again
;
; Version  4.02 Additional user warnings.  Compare
;		size of allocations to prevent 
;		overallocating the harddisk.
;		Print out alloc table before save
;		If the user attempts a QUIT and
;		changes have not been saved, give
;		a warning.
;
; Version  4.03 Modified to reflect changes made
;		in cpmMAP  
;
; Version  4.04 Change the decimal convert routine.
;		Eliminate more of the magic numbers.
;
; Version  4.05 Add code to check that the user does
;		not use the same partition name twice.
;
; Version  4.06 Add code to determine which volume of
;		the harddisk the user wants to modify.
;
; A 		Install subroutine Getvol
; B 		Install the change command and code
; C 		Install code to read separate volumes
; D 		Install the jump to HDstat in the BIOS
; E 		Install code to print volume names
; F 		Modify getvol and rename setvolptr
; G 		Add code to compare new partition name
;   		to all existing names on all volumes
; H 		Not used
; I 		Remove the out 00 instruction in Scom.
;   		This assumes the HD will not be busy
;		during the 5 second countdown.  A
;		message was added telling the user
;		to reboot after changes.
;
; 4.07 10/09/82 Version number changed for release of 
;		BIOS 2.240
;
; 4.08 10/28/82	If one volume present will not ask
;		ask which volume on startup.
;		handles 46meg drive.  Les Wilson
;	
; 4.09 12/14/82	Works on Fox hard disk Dave Bradburn
;
; A  		only on Xebec controller
; B  		asks BIOS for controller type
; C  		accomodates buffered writes
;    		recognizes 4 types of 5.25 inch disks
; D  		now recognizes Rodime hard disk
;    		& spells miniscribe correctly
;		**** READY **** as 4.09
;
; 4.10 04/22/83	Tracy Lakin
;
; Response to Software Change Request #0008
;	Fix bugs:
;	   1-	For single volume hard disk system
;		do not allow partition 0 for first
;		addition. Multi-volume does a list
;		of the table which calls prtTABL;
;		this sets the first entry as used.
;		So call Lcom (which calls prtTABL)
;		as in multi-volume case.
;		Also only print HELPmsg upon startup
;		if multi-volume (put in Ccom).
;		Only print those volumes which are
;		present (changes at newHD). This is
;		to make single disk startup look
;		better, since command table not listed,
;		the table is instead.
;	   2-	The first entry after partition 0
;		can have a duplicate name. Fix by
;		setting cheknam to 0 in compnam, at
;		..ok. It was a 1 with the result that
;		the first time through ..loop partition
;		0's name would be checked, then
;		checknam is incremented to 2, skipping
;		the next entry.
;	   3-	Output the login header before the 
;		warning (quitwarn).
;	   4-	CONIN has an illegal jump to GETCOM
;		upon recieving an escape. It doesn't
;		clean up the stack, allowing the stack
;		to overflow with repeated escapes.
;		So set stack to STACK-2 before jumping
;		to GETCOM, so only return to CCP is on
;		the stack.
; 'E' 04/26/83	Help menu printed out too often.
;		Change Help menu a bit.  Clean up some
;		comments, and .ascii msgs.  DRB
; 4.11 04/28/83 Eliminate patch and advance version
;		number to 4.11.  DRB
.page
.sbttl 'Get the system type'
;
	ei		; to execute with ZDTI
	lxi	sp,stack
	lhld	wbadr	 
	shld	WBaddr	; save for BIOS calls
	mvi	C,retvsn ;CP/M 12, Return Version Num
	call	BDOS	; BDOS returns 1 if MPM
	mov	A,H	; see if MPM
	cpi	CPMflag
	mov	A,L	; move reg L into accum and
	sta	sysflg	; store it as the flag
	jnz	gotCPM	; and jump if not MPM
	mvi	a,MPMflag ;else, MPM flag
	sta	sysflg	; stored as flag
	lhld	WBaddr
	inx	H
	mov	E,m
	inx	H
	mov	D,m	; get Wboot address for MPM
	sded	WBaddr
	jmpr	START
gotCPM:
	lda	usernum   ; A  = network user code
	cpi	localHD   ; FF = hard disk (no HiNet)
	jrz	START	  ; we can proceed if Hard disk
	cpi	masterHD  ; 00 = network master
	jrz	START	  ; We can proceed if Network
	lxi	H,NOGOmsg ; do not run if this user
	jmp	bootm	  
.page
.sbttl 'Get size and type of harddisk'
START:	
	lxi	H,LOGmsg  ;print log-on message
	call	prtmsg
	lxi	H,quitwrn
	call	waitCR	  ;user must respond to warning
	lxi	H,crlf
	call	prtmsg
	lxi	H,vPrsntMsg	; 'Volumes present' msg
	call	prtmsg
	sub	A
	sta	volnum	  ; zero the volume counter
	call	setvolptr
	lxi	B,statbuf ; do this now chaMAPbyt needs
	call	HDstat	  ;  to know type of HD
	call	chaMAPbyt ; assign unit 0 to hard disk
	call	getque	  ; grab disk if mpm
	lda	statbuf+7 ; HDstat got this set up
	ora	A	  ; 
	jrz	newHD	  ; is a multi HD
	mvi	A,0	  ; send drive # in C
	call	seldsk	  ; select drive
	lxi	B,0	  ; track 0
	call	settrk
	mvi	C,1	  ; sector number
	call	setsec
	lxi	B,HDCbuff ; disk controller buffer
	call	setdma	  
	call	read	  ; read controller info
	lda	HDCbuff+18h ; move old HDC disk type
	mov	vlitype(x),A ;to new location
	lda	HDCbuff+19h ; move old HDC disk type
	mov	vlisize(x),A ;to new location
	mvi	vlipresent(x),true ;sets byte to true
	mvi	vlilabel(x),'D'
	mvi	vlilabel+1(x),'E'
	mvi	vlilabel+2(x),'F'
	mvi	vlilabel+3(x),'A'
	mvi	vlilabel+4(x),'A'
	mvi	vlilabel+5(x),'U'
	mvi	vlilabel+6(x),'L'
	mvi	vlilabel+7(x),'T'
	mvi	vlilabel+8(x),' ' ;write label to
	mvi	vlilabel+9(x),' ' ;old HDC
	mvi	A,1
	call	setvolptr ;set volume 1 to false
	mvi	vlipresent(x),false
	mvi	A,2
	call	setvolptr ;set volume 2 to false
	mvi	vlipresent(x),false
	mvi	A,3
	call	setvolptr ;set volume 3 to false
	mvi	vlipresent(x),false
.page
newHD:
	mov	A,vlipresent(x)
	cpi	true		; If no volume, do not
	jnz	..nextVol	;print anything.
	lxi	H,vol
	call	prtmsg	 ; print 'volume'
	lda	volnum
	call	prtNBL	 ; print volume number
	call	prtlabel ; label printed to CRT
	call	readTABL ; read in DAT from Hard disk
	call	prtvol
	lded	voladdr  ;HL set in prtvol
	xchg		 ;DE = size, HL = address
	mov	m,E
	inx	H
	mov	m,D	 ; size of HD stored
..nextVol:
	lda	volnum
	cpi	maxvol	 ; test if last vol done
	jrz	restore
	inr	A
	sta	volnum	 ; next volume
	call	setvolptr ; addressed
	jmpr	newHD	  ; do the next volume
restore:call	resMAPbyt ; restore users unit 0 assmt
	call	putque	  ; free disk if mpm
;
;	if volume other than zero present ask user
;	which to change to, ELSE, print only one out
;
presloop:
	mov	a,vlipresent(x)
	cpi	true
	jz	Ccom	  ; Print command summary and
			  ;ask user which vol to change
	lda	volnum
	dcr	a
	sta	volnum
	call	setvolptr
	lda	volnum
	ora	a
	jrnz	presloop
	jmp	Lcom	; List the table and call
			;GETCOM. This sets partition 0
			;of the alloc table as unusable

.page
.sbttl 'Get the user command'
GETCOM: 		 ; Get user commands
	lxi	H,COMmsg
	call	prtmsg	 ; tell user we are ready
wait:	call	CONSTAT
	jrnc	wait	 ; wait for a user command
	call	CONIN	 ; read in the chr
	cpi	'A'	 ; add a new entry*
	jz	Acom
	cpi	'C'	 ; Change the volume*
	jz	Ccom
	cpi	'D'	 ; delete an entry*
	jz	Dcom
	cpi	'E'	 ; erase dir wanted (MPM only)
	jz	Ecom 
	cpi	'H'	 ; help listout requested*
	jz	Hcom
	cpi	'L'	 ; print out allocation map*
	jz	Lcom
	cpi	'M'	 ; modify allocation map*
	jz	Mcom
	cpi	'Q'	 ; do we abort*
	jz	Qcom	 
	cpi	'S'	 ; Do we save current allo-
	jz	Scom	 ; cation table on hard disk*
	cpi	'V'
	jz	Vcom
	cpi	'Z'	 ; zero out allocation table*
	jz	Zcom	
	lxi	H,AIDmsg ; Bad entry. Print help msg
	call	prtmsg
	jmpr	GETCOM	 ; and ask again
;---------------
Lcom:
	lxi	H,crlflf
	call	prtmsg
	lxi	H,tblMsg ; 'Alloc table for' header
	call	prtMsg
	lxi	H,vol
	call	prtmsg
	lda	volnum
	call	prtNBL	 ; print volume number
	call	prtvol	 ; print disk info
	call	prtlabel ; print volume label
	call	prtTABL  ; List the table
	call	prtSPACE
	call	addsiz	  ; set flags if overallocated
	jrnc	 ..ok	  
	lxi	H,crlf
	call	prtmsg
	lxi	H,nosave  ; tell user why no save
	call	prtmsg
..ok:	jmp	GETCOM	 ; get next command
.page
.sbttl	'Help and change volumes'
;---------------
Hcom:	lxi	H,logmsg ;print version number
	call	prtmsg	 ;for each HELP
	lxi	H,helpmsg ;Print help msg
	call	prtmsg
	jmp	GETCOM
;---------------
Ccom:
	mvi	A,false   ; Change the volume
	lhld	curflag
	cmp	m	  ; if flag is false,
	jrz	..1	  ; user is ok
	lxi	H,chgmsg
	call	prtmsg
	lxi	H,crlf
	call	prtmsg
..1:	lxi	H,volmsg  ; which vol do you want
	call	prtmsg
	call	conin	  ; get user response
	sui	'0'	  ; make ascii # numeric
	cpi	4
	jrc	..cont
	lxi	H,errmsg
	call	prtmsg
	jmpr	..1
..cont: sta	volnum
	call	setvolptr
	mov	A,vlipresent(x)
	cpi	true	 ; if there is a volume, list
	jz	Lcom	 ; it.	Else
	lxi	H,novol  ; tell user, no volume here 
	call	prtmsg
	jmpr	Ccom	 ; and try again
.page
.sbttl	'Print the volumes'
;---------------
Vcom:	lda	volnum
	push	PSW	 ; save current volume
	sub	A	 
	sta	volnum	 ; start with first volume
	lxi	H,crlflf 
	call	prtmsg	 ; space 2 lines
	lxi	H,vPrsntMsg ; 'Volumes present' msg
	call	prtmsg
..1:
	lxi	H,vol
	call	prtmsg
	lda	volnum
	call	prtNBL	 ; print volume number
	call	prtvol
	call	prtlabel ; print the volume label
	lda	volnum	 ; incremented in setvolptr
	cpi	maxvol	 ; test if last vol done
	jrz	..exit
	inr	A
	sta	volnum
	call	setvolptr
	jmpr	..1
..exit: pop	PSW
	sta	volnum
	call	setvolptr
	lxi	H,volnmmsg
	call	prtmsg
	lda	volnum	 ; print the current volume
	call	prtNBL
	jmp	getcom
.page
.sbttl 'Add an entry to the alloc table'
;
Acom:			 ; Add a new entry into table
	mvi	A,0	 ; start at 1st line in table
..SRCH: push	PSW	 ; A = table line number
	call	ADDRfind ; HL = starting addr of line
	mov	A,M	 ; get 1st byte of that line
	cpi	0	 ; IS IT 0* 0 means its free.
	jrz	..found  ; YES. Opening in table found.
	pop	PSW	 ; NO. Retreive table line num
	inr	A	 ; and set it to the next line.
	cpi	64	 ; HAVE WE checked all 63 lines
	jrc	..SRCH	 ; NO.	Loop and try next line.
	lxi	H,tblfulmsg ;YES. Load `table full` msg
	call	prtmsg	 ; and print it.
	jmp	GETCOM	 ; Get next user command.
;	
; Unused line found. Now leave the first character as a
; 0 (that keeps this an unused line for the time being)
; fill next 13 characters of that entry in name table
; with blanks.	This is name/password area.  
;
..found:  ;Unused table line number is on TOP of STACK
	pop	PSW	; Restore line number
	sta	unit	; and save it.
;
;HL=starting address of line of the name table
	inx	H	; Leave the 1st byte a 0
	mov	D,H
	mov	E,L
	inx	D	; DE = HL + 1
	mvi	M,' '	; Put in a blank
	lxi	B,13	; Blank out 13 characters
	LDIR
;
; Tell user what line in table has been selected.
; Jump to getNAM in Mcom to get the name, password, 
; disk assignments , and type-ahead buffer from user.
;
	lxi	H,addmsg ; `Table line number is` msg
	call	prtmsg	 ; Print msg.
	lda	unit	 ; Get the table line number
	call	cvtbcd	 ; Make line number decimal
	call	prtbyt	 ; and print it.
	JMPR	getSIZ	 ; Only user input is needed
.page
.sbttl 'Modify an entry in the alloc table'
;
; Check that the entry is in use and can be modified.
; We do this by checking the first byte of that entry.
; If it is 0, it cannot be modified.  An error message
; is printed telling the user to use the 'A' command
; to make a new entry. Then, we jump back to GETCOM.

Mcom:
getUNI: call	getUNT	  ; get unit
	lda	unit	  ; HL=addr of start of table
	cpi	0	  ; user can not modify part 0
	cz	error	  
	jz	GETCOM	  ; get next command
	call	ADDRfind  ; returned:
			  ; HL=addr of line in table
	mov	A,M	  ; A = 1st byte in the line
	cpi	0	  ; Is entry in use*
	jrnz	..prtHEAD ; Yes. We can proceed.
	lxi	H,badmodmsg
	call	prtmsg	  ; No.  Print `unused` msg
	JMP	GETCOM	  ; and await more commands.
..prtHEAD:
	push	H	  ; HL = addr of entry in table
	lxi	H,Headmsg
	call	prtmsg
	pop	H	  ; addr of selected line
	call	prtline   ; print the Temp line
..ASKifOK:
	lxi	H,VERIF2msg ;is this line to modify*
	call	prtmsg
	call	CONIN	; get Y or N
	ani	0DFh	; make upper case
	cpi	'N'
	jz	getCOM	; User wants to start over
	cpi	'Y'
	cnz	error	; incorrect entry 
	jrnz	..ASKifOK
;
; User has verified this as the line to modify.
;
getSIZ: lxi	H,SIZmsg ; what size*
	call	putBUF
	cpi	3	 ; buf more than two chrs*
	cp	error
	jp	getSIZ
	cpi	1	 ; buf less than 1 chr long*
	jrnc	..makSIZ ; No. Make chrs into a byte.
;
;User used the <CR> default option. Fill in old size.
;
	lda	unit	; Yes. Fill in old size.
	call	ADDRfind
	mov	A,M	; is size in table 0
	cpi	0	
	jrnz	..cont	; No.  We can assume its valid.
	call	error	; YES. Entry num is bad.
	jmpr	getSIZ	; 0 is end of table
..cont: lxi	D,size
	lxi	B,1
	LDIR		; Copy old entry into Tempentry
	jmpr	getNAM
..makSIZ:
	call	makHBYT  ; make chrs into a byte
	cpi	7	 ; is SIZE more than 6*
	cp	error
	jp	getSIZ
	cpi	1	 ; size is less than 1*
	cc	error	 ; Tell user 'bad entry'
	jrc	getSIZ	 ; and ask again.
	sta	size	 ; save valid size value
;---------------
; Test this size against the size stored in the table.
; Bypass this test if this is the last line in table.
; If this an add, any new size is accepted.  If it is
; a modify, and the sizes are different, we print 
; warning messages that a drastic change in 
; file allocation will take place.
	lda	unit
	cpi	63	; Is this the last entry*
	jz	getNAM	; Yes. Bypass the test.
	call	ADDRfind; HL=addr of old size
	push	H	; Save if we dont bypass test
	lxi	D,16
	dad	D	; HL=next line in table
	mov	A,M	; A =next lines 'size'
	pop	H	; HL=addr of old size again
	cpi	0	; Is next line the end of tbl*
	jz	getNAM	; Yes. We can bypass test
;
;Test if user is modifying a size inside the table
;
	lda	size	; get new size in A
	cmp	M	; Are they the same*
	jrz	getNAM	; Yes. Proceed. Get the name
	mov	A,M	; No. Is this entry unused*
	cpi	0	; 0 means unused/open entry
	jrz	getNAM	; Yes. Proceed. Get the name
	; No. Print warning message
	lxi	H,WARNmsg
	call	prtmsg	; Light the lights, ring sirens
	lxi	H,Sizwarn
	call	prtmsg
	lxi	H,WARNend
	call	prtmsg	;
.page
..getYN:lxi	H,WARNask
	call	prtmsg	; Ask user "want to go on*"
	call	CONIN	; Get y/n
	ani	0DFh	; make it upper case
	cpi	'N'
	jz	GETCOM	;  User doesnt want to go on
	cpi	'Y'
	cnz	error	; bad entry
	jrnz	..getYN ; ask again
getNAM: lxi	H,NAMmsg ; get name from user
	call	putBUF	 ; put name in buffer
	cpi	9	 ; if > 8 chars,
	cp	error	 ; error, let user try
	jp	getNAM	 ; again
	cpi	1	 ; if no chars, copy old name
	jrnc	..makNAM ; else enter new name
	lda	unit	 ; use the old name
	call	ADDRfind  
	inx	H	 ; H = addr on name in table
	lxi	D,NAMaddr; old name copied into
	lxi	B,8
	ldir		 ; Tempentry, then
	jmp	getPAS	 ; ask for the password
..makNAM:
	lxi	B,8	 ; amount to move
	lxi	H,conbuf+2 ;where the new name is
	lxi	D,NAMaddr ;where it goes
	LDIR		 ; load Name into temp buffer
	lxi	H,NAMaddr
	mvi	B,8	 ; if any characters are
..1:	mov	A,M	 ; lower case, convert to
	cpi	'a'	 ; upper case
	jrc	..2	 
	ani	0DFh	 ; make it upper case
	mov	M,A	 ; and put it back
..2:	inx	H	 ; get next chr address
	dcr	B	 ; decrement the counter
	mov	A,B
	cpi	0	 
	jrnz	..1	 ; all 8 chars checked
.page
; User can not use the same parition name twice
;
	call	compnam  ;compare partition name, set
	jc	getcom	  ;flag if identical names
;
getPAS: lxi	H,PASmsg ; what's the password*
	call	putBUF
	cpi	7	 ; more than 6 chrs long*
	cp	error
	jp	getPAS
	cpi	1	 ; less than 1 chr long*
	jrnc	..makPAS ; No. Make buf into password
	lda	unit
	call	ADDRfind ; H = addr of password 
	lxi	D,9
	dad	D
	lxi	D,PASaddr
	lxi	B,6
	ldir		; Copy old entry into Tempentry
	jmpr	getCTL	; and ask for the password.
..makPAS:
	lxi	B,6
	lxi	H,conbuf+2
	lxi	D,PASaddr
	ldir		 ; load Password into temp addr
getCTL: lxi	H,CTLmsg ; what's the Control value*
	call	putBUF
	cpi	3	 ; more than two chrs*
	cp	error
	jp	getCTL
	cpi	1	 ; Less than 1 chr long*
	jrnc	..makCTL ; No. make buf chrs into byte
	lda	unit
	call	ADDRfind ; H = addr of control value
	lxi	D,15
	dad	D
	lxi	D,control
	lxi	B,1	 ; copy old entry
	ldir		 ; into Tempentry
	jmpr  ..prtHEAD  ; and print out the line.
..makCTL:
	call	makHBYT  ; make chrs into hex byte
	sta	control  ; and save
..prtHEAD:		 ; print line header
	lxi	H,HEADmsg
	call	prtmsg
	lxi	H,TEMPentry ; addr of Temp line
	call	prtline  ; print the Temp line
.page
.sbttl 'Modify and zero table commands'
..ASKifOK:		 ; is this listing correct
	lxi	H,VERIFYmsg
	call	prtmsg
	call	CONIN	 ; get Y or N
	ani	0DFh	 ; make upper case
	cpi	'N'
	jz	getCOM	 ; User wants to start over
	cpi	'Y'
	cnz	error	 ; incorrect entry 
	jrnz	..ASKifOK
putTABL:lda	unit	 ; get table address of
	call	ADDRfind ; this partition
	lxi	B,16	 ; copy temptable into table
	xchg		 ; get table destination in DE
	lxi	H,TEMPentry
	ldir		 ; put Temp line into table
	call	addsiz	 ;add amt of disk allocated
	jrnc	 ..ok	 ;flag set in addsiz
	lxi	H,nosave ;else, size of disk is 
	call	prtmsg	 ;exceeded, warn user
	jmp	getcom	 ;and return to choices
..ok:	lhld	curflag  ;addr of current flag
	mvi	m,true	 ;set flag to a change if true
	lxi	H,COMPmsg
	call	prtmsg	 ; tell user function completed
	jmp	getCOM	 ; get next user command
;---------------
Zcom:
	lxi	H,zeromsg ;do you want to
	call	prtmsg	 ; zero out the table
	lxi	H,warnask
	call	prtmsg	 ; print 'do you want to cont'
	call	conin	 ; get user response
	ani	0DFh	 ; make upper case
	cpi	'N'	 ; if not, get next
	jz	getcom	 ; command
	call	zerotbl  ; Else, zero the table
	lxi	H,COMPmsg
	call	prtmsg	 ; tell user function completed
	jmp	GETCOM	 ; get next command
.page
.sbttl 'Save the changes to the alloc table'
;
Scom:			  ; save the alloc table
	call	prttabl   ; print alloc table to save
	call	prtspace  ; print amount allocated
	call	addsiz	  ; set flags if overallocated
	jrnc	 ..ok	  
	lxi	H,crlf
	call	prtmsg
	lxi	H,nosave  ; tell user why no save
	call	prtmsg
	jmp	getcom	  ; let user modify table
..ok:	lxi	H,savemsg ; is this the alloc table
	call	prtmsg	  ; you want to save
	call	conin	  ; get user response
	ani	0DFh	  ; make upper case
	cpi	'Y'	  
	jrz	..save
	lxi	H,crlf
	call	prtmsg
	lxi	H,advmsg  ; if this is destroyed,
	call	prtmsg	  ; reboot
	lxi	H,crlf
	call	prtmsg
	jmp	getcom	  ; no, try again
..save: lhld	curflag   ; current volume saved
	mvi	m,false   ; user gets no warning
	lxi	H,crlf
	call	prtmsg	  ;space a line
	lxi	H,SAVmsg
	call	prtmsg	  ; Yes. Print 'Saving' message
	call	getque	 ; enque disk if mpm
	call	chaMAPbyt; Assign hard disk to unit 0
	call	writTABL ; write the D A T to disk
;	call	resMAPbyt; restore users unit 0 assmt
			 ;    ***** LATER *******
			 ; Fox hard BIOS currently needs
			 ; DPB's to stay the same until  
			 ; timeout flush occurs.
	call	putque	 ; free disk if mpm
	mvi	A,00	 ; delay 5 secs to
..1:	push	PSW	 ; flush controller
	lxi	H,0FFFFh ; count from FFFF down to 0000
..2:	dcx	H	 ; inner loop 
	mov	A,L	 
	cpi	0
	jrnz	..2
	ora	H
	jrnz	..2	 ; 5 sec delay
	pop	PSW	 
	inr	A	 ; count from 0 to 11
	cpi	11	 ; outer loop
	jrc	..1
	call	resMAPbyt; we've flushed so it's ok to
			 ; reset partition assgnmnt
	lxi	H,COMPmsg
	call	prtmsg	 ; tell user function completed
	jmp	GETCOM
.page
.sbttl 'Delete an entry in the alloc table'
;
Dcom:	call	getUNT	 ; modify what unit number*
	lxi	H,HEADmsg ;Print out the header
	call	prtmsg
	lda	unit	  ;print unit to be deleted
	call	ADDRfind  ; Get table line addr
	call	prtline   ; print the unit
..ASKifOK:		  ; is this unit to be deleted
	lxi	H,VERIF3msg
	call	prtmsg
	call	CONIN	; get Y or N
	ani	0DFh	; make upper case
	cpi	'N'
	jz	getCOM	; No, user wants to start over
	cpi	'Y'
	cnz	error	; incorrect entry 
	jrnz	..ASKifOK
	lda	unit
	cpi	63	; last line of table*
	jrz	..Dlete ; Yes. We can delete this.
	inr	A	; No. Lets check next entry
	call	ADDRfind; HL=addr of next line in tbl
	mov	A,M	; A = 1st byte of next line
	cpi	0	; 0 means unused entry
	jrz	..Dlete ; delete line without damage
	lxi	H,WARNmsg ;else, print warning message
	call	prtmsg	; Light the lights, ring sirens
	lxi	H,Delwarn
	call	prtmsg
	lxi	H,WARNend
	call	prtmsg
..getYN:lxi	H,WARNask
	call	prtmsg	; Ask user "want to go on*"
	call	CONIN	; Get y/n
	ani	0DFh	; make it upper case
	cpi	'N'
	jz	GETCOM	;  User doesnt want to go on
	cpi	'Y'
	cnz	error	; bad entry
	jrnz	..getYN ; ask again
..Dlete:lda	unit	; User wants to delete line
..kil1: push	PSW
	call	movLINE ; bump down higher table line
	jrc	..done	; carry bit set if were done
	pop	PSW
	inr	A	; increment unit number
	cpi	64
	jrnz	..kil1	; done if all 64 entries bumped
	push	PSW
..done: pop	PSW	; just for stack balance
	lhld	curflag  ;addr of current flag
	mvi	m,true	 ;set flag to a change if true
	lxi	H,COMPmsg
	call	prtmsg	; tell user function completed
	jmp	GETCOM	; and get the next command.
.page
.sbttl 'Erase MPM directory'
;
Ecom:	
	lda	sysflg
	ora	a
	jp	badcm	; error if not mpm
	lxi	h,dirbuf
	lxi	b,128
..fill: mvi	m,0e5h
	inx	h
	dcr	c
	jrnz	..fill	; initialize buffer
	call	getUNT	; get unit
	lxi	h,vermes
	call	prtmsg	; verify it
	call	conin
	ani	0DFh	; make upper case
	cpi	'Y'
	jrz	erasok	; skip if good
badcm:	lxi	h,nvrmes
	call	prtmsg
	jmp	getcom
erasok: call	conin	; force [cr] to be typed
	cpi	0dh
	jrnz	badcm	; error if not
	call	getque	; enque if mpm
	mvi	c,0	; start at disk 0
	lda	unit
	ori	80h	;make hard disk
	sta	unit
	lxi	h,1	; drive vector
dsklp:	push	h	; save drive vector
	push	b	; save unit
	call	seldsk	; try to select
	pop	b	;restore unit
	mov	a,h
	ora	l
	jrz	nodsk	; skip if bad select
	lxi	d,10
	dad	d	; skip to dpb pointer
	mov	e,m
	inx	h
	mov	d,m
	dcx	d	; point to unit byte
	ldax	d	; get unit
	lxi	h,unit
	cmp	m	; same *
	jrz	gotdsk	; skip if so
nodsk:	pop	h	; old drive vector
	dad	h	; next drive vector
	inr	c	; next disk
	mov	a,c
	cpi	16
	jrnz	dsklp	; loop if more disks
	lxi	h,nota
	call	prtmsg	; tell disk not assigned
	jmp	getcom
gotdsk: xchg		; unit addr to hl
	inx	h
	mov	a,m	; get sector/track
	inr	a	; make end + 1
	sta	spt
	lxi	d,7
	dad	d	; skip to # of directory ents
	mov	e,m
	inx	h
	mov	d,m	; get # of directory  ents
	inx	d	; make true number
	sded	numdir
	lxi	d,5
	dad	d	; skip to # sys trk
	mov	e,m
	inx	h
	mov	d,m
	sded	trkaddr ; save as start track
	call	putque	; free disk
	pop	d	; get drive vector
	mvi	c,25h	; reset drive function
	call	BDOS
	ora	a
	jrz	dirloop ; skip if drive not busy
	lxi	h,bsymes
	call	prtmsg
	jmp	getcom	; reject command as drive busy
;
; write out 'e5' to all directory blocks
;
dirloop:call	getque	; freeze disk again
	lxi	b,dirbuf
	call	setDMA
nxtrk:	lbcd	trkaddr
	call	SETtrk
	mvi	a,1
	sta	wsec	; stArt sector
nxtsec: mov	c,a
	mvi	b,0
	call	setSEC
	call	write
	lhld	numdir	; get # dir ents
	dcx	h
	dcx	h
	dcx	h
	dcx	h	; account for 4 ent/block
	shld	numdir	; save
	xra	a
	ora	h	; done *
	jm	done	; skip if so
	jrnz	mor	; skip if more
	ora	l
	jrz	done	; skip if no more
.page
mor:	lda	wsec
	inr	a
	sta	wsec
	lxi	h,spt
	cmp	m
	jrnz	nxtsec
	lbcd	trkaddr
	inx	b	; next track
	sbcd	trkaddr
	jmpr	nxtrk
done:	call	putque	; free disk
	jmp	getcom	; next command
.page
.sbttl 'EXITS'
;---------------
Qcom:			  ;quit alloc program
	mvi	A,true	  ;warn user if changes to a
	sta	quitflg   ;volume have not been saved
	mvi	A,false   ;accum = false
	lxi	H,vol0quit  
	cmp	m
	jrz	..ok0
	sta	quitflg   ;if there are changes, store
	lxi	H,vol0msg ;accum and give message
	call	prtmsg
..ok0:
	mvi	A,false 
	lxi	H,vol1quit
	cmp	m
	jrz	..ok1
	sta	quitflg
	lxi	H,vol1msg
	call	prtmsg
..ok1:
	mvi	A,false 
	lxi	H,vol2quit
	cmp	m
	jrz	..ok2
	sta	quitflg
	lxi	H,vol2msg
	call	prtmsg
..ok2:
	mvi	A,false 
	lxi	H,vol3quit
	cmp	m
	jrz	..ok3
	sta	quitflg
	lxi	H,vol3msg
	call	prtmsg
..ok3:
	lda	quitflg
	cpi	true	  ; quitflg is same so
	jrz	..quit	  ; no changes.  Else,
	lxi	H,quitmsg ; do you want to save changes
	call	prtmsg
	call	conin	  ; get user's response
	ani	0DFh	  ; make it upper case
	cpi	'Y'	  ; if yes,
	jz	getcom	  ; let user do it
..quit: lxi	H,quitwrn ; else, fall thru and die
;---------------
;  Send user back to BDOS with a message
bootm:
	call	waitCR	; print the message, get user
	jmp	wboot	; respone and die
.page
.sbttl	"SUBROUTINES"
;
; Subroutine: movLINE
; Regs	in:	A = line number in table
; Regs out:	none
; Destroyed:	any/all
;
; Bump down the next table entry into the given
; table entry line number.  
; We first test for the last entry number (63)
; and then we test for zeroed name entries. We 
; return with the carry bit set in either case.

movLINE:cpi	64
	stc		; set carry just in case
	rz		; we're at the top of the table
	push	PSW	; save our line num
	call	ADDRfind ; HL will be addr of line
	lxi	D,16
	xchg		 ; HL = addr of next line num
	dad	D	 ; DE = addr of given line num
	pop	PSW
	push	PSW	 ;Restore and resave line num
	cpi	63	 ;Is this the last line in tbl*
	jrz	..zerolin;Yes. Zero the line and ret 
;
;---Check for a 'zeroed out' following entry.
;   Zero out the given line if thats the case.	
;
	mov	A,M	 ; Check first byte for 0
	cpi	0	 ; Is this a deleted entry*
	jrnz	..cont	 ; NO. Continue with set up.
..zerolin:		 ; Zero line pointed to by DE
	mov	H,D	 ; Yes. Delete given line
	mov	L,E	 ; HL = addr of given line num
	inx	D	 ; DE = HL + 1
	mvi	M,0
	lxi	B,15	 ; Zero out 16 bytes total
	LDIR		 ; Zero out the given line.
	pop	PSW	 ; Rebalance the stack
	stc		 ; Set carry bit as flag.
	ret		 ; Rest of tbl is blank.
;---A 0 in the table would have meant no more entries.
..cont: lxi	B,16	 ; 16 bytes per table line
	LDIR		 ; Bump down the next line	
			 ; into the given line number
	pop	PSW	 ; restore line num
	ora	A	 ; Make sure cry bit is reset.
	ret		 ; One line has been bumped
;--------------
; Wait for the user to type a CR in response
;
waitCR:
	call	prtmsg
..loop: call	conin
	cpi	cr
	jrnz	..loop
	ret
.page
.sbttl 'Console I/O and print subroutines'
;
; Subroutine getUNT:  get unit routine
 
getUNT: lxi	H,UNImsg ; modify what unit number*
	call	putBUF
	cpi	3	 ; more than two chrs long*
	cp	error
	jp	getUNI
	cpi	1	 ; less than 1 chr long*
	cm	error
	jm	getUNI
	call	makDBYT  ; make chrs into a byte
	cpi	64	 ; is UNIT more than 63*
	cp	error
	jp	getUNI
	sta	unit	 ; and save
	ret
;---------------
; Subroutine prtTABL: Print alloc table
; Regs	in:	none
; Regs out:	none
; Destroyed	A,H,L
; Print the DAT.  Halt if the size is 0.
; Always print the 63rd listing.
prtTABL:
	lhld	curvol	;If the table is empty,
	mov	A,m
	cpi	0e5h	;freshly formated
	jrz	..dozero
	cpi	0	;zeroed in format
	jrnz	..donotzero
..dozero:
	cz	zerotbl ;zero the table
..donotzero:
	mvi	A,0
	sta	unit	; re-initialize 
	lxi	H,crlf
	call	prtmsg
	lxi	H,HEADmsg
	call	prtmsg	; print table header
	lhld	curVOL
..1:	call	prtline ; print a table line
	jrc	..2	; print 63rd line if
			;STOPprt sets carry bit
	lda	unit
	inr	A	; increment the line
	sta	unit
	cpi	63
	jrnz	..1
..2:	mvi	A,63
	sta	unit
	call	ADDRfind
	call	prtline ; print 63rd listing
	ret
.page
;----------
; Subroutine prtline:  print line of alloc table
; Regs	in:	HL=addr in the allocation table
; Regs out:	HL=next addr in the allocation table
; Destroyed:	A, BC
;
prtline:
	push	H	; save allocation table address
	call	CONSTAT ; is console chr ready*
	jrnc	..4	; NO.
	call	CONIN	; eat the chr
..3:	call	CONSTAT ; is 2nd console chr ready*
	jrnc	..3	; wait for it
	call	CONIN	; eat the chr, and proceed
..4:	pop	H	; restore allocation tabl addr
	mov	A,M	; get the size (end of table
	cpi	0	; is a 0)end of table*
	jz	STOPprt ; Yes, Return
	cpi	0E5h	; might be unformatted too
	jz	STOPprt
	push	H	; No, print it
	lxi	H,crlf	; space down a line
	call	prtmsg
	lxi	H,space4 ; space over 4 spaces
	call	prtmsg	
	lda	unit	 ; unit number in A
	call	cvtbcd
	call	prtbyt	 ; print the unit number
	lxi	H,space4 ; space over 4 spaces
	call	prtmsg
	pop	H
	mov	A,M	 ; get the size in A
	push	H
	call	prtbyt	 ; print the size
	lxi	H,space4
	call	prtmsg	 ; space over 4 spaces
	pop	H
	inx	H	 ; get to name addr
	mvi	B,8
	call	prtchr	 ; print 8 chr name
	push	H
	lxi	H,space4 ; space over 4 spaces
	call	prtmsg
	pop	H
	inx	H	 ; get to password addr
	mvi	B,6
	call	prtchr	 ; print 6 chr password
	push	H
	lxi	H,space4
	call	prtmsg
	pop	H
	inx	H	 ; get to control addr
	mov	A,M
	call	prtbyt
	inx	H	 ; next addr in table
	ora	A	 ; clear A
	ret
;---------------
; Subroutine prtSPACE: print space allocated on HD
;   Regs  in:	none
;   Regs out:	none
;
prtSPACE:
	call	ADDSIZ	 ; HL=sum of sizes (in K)
	call	HLDEconv ;convert to a decimal
	lxi	H,spamsg
	call	prtmsg
	lxi	H,string
	mvi	B,6	 ;length of string
	call	prtchr
	lxi	H,endmsg
	call	prtmsg	; print 'Kbytes',
	lhld	voladdr ;addr of size of this volume
	mov	E,M
	inx	H
	mov	D,M
	xchg		; HL has the max size
	call	prtsize ; of disk.  Now, print it
	ret		; and were done.
;---------------
; Subroutine prtsize: print max storage of harddisk
;   Regs  in:  HL = size to print
;   Regs out:	none
;
prtsize:
	call	HLDEconv ;convert to a decimal
	lxi	H,crlf
	call	prtmsg	 ; space one line
	lxi	H,maxmsg
	call	prtmsg
	lxi	H,string
	mvi	B,6	 ;length of string
	call	prtchr
	lxi	H,endmsg
	call	prtmsg	; print 'Kbytes',

	ret
.page
;---------------
; Subroutine HLDEconv: convert one or two hex bytes to
;		       a decimal value
; Reg in:  HL
; Reg out: none 
; Destroyed: All
;
HLDEconv:
	lxi	B,string ;where the result is stored
	lxi	D,10000 ; convert 10000 place
	call	cvdec	; convert high byte to decimal
	cpi	30h	; if the first byte is a 0,
	jrnz	..1
	mvi	A,20h	; make it blank
	stax	B	
..1:	inx	B	; next byte in string
	lxi	D,1000	; convert 1000 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	mvi	A,','	; put a comma
	stax	B	; there
	inx	B	; next byte in string
	lxi	D,100	; convert 100 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	lxi	D,10	; convert 10 place
	call	cvdec	; convert next byte
	inx	B	; next byte in string
	lxi	D,1	; convert 1 place
	call	cvdec	; convert last byte
	ret
;---------------
; Subroutine cvdec:  Convert the hex number
; Reg in:  B = string address
;	   D = byte to convert
; Reg out: None
; Destroyed: None
;
cvdec:
	mvi	A,30h	; start with 0
	ora	A	; reset the carry flag to 0
..loop:
	dsbc	D	; DE sub from HL
	jc	subdone
	inr	A	; next decimal number
	jmpr	..loop	; and check again
subdone:
	dad	D	; restore value of HL
	stax	B	; store value in string
	ret
.page
;--------------
; Subroutine addsiz:  add up amount of disk used
; Reg in:  None
; Reg out: HL
; Destroyed: All
;
ADDSIZ:
	lxi	H,0
	shld	usedspa ;initialize space counter
	mvi	A,0
	call	ADDRfind;get starting DAT address
addup1: push	H	;HL = start of a line in DAT
	mov	A,M	; A = size of partition
	cpi	0	; end of table is a 0
	jrz	cmpsiz	; compare alloc to maxalloc
	lxi	H,128
..duble:dad	H	; add HL to itsself each time
	dcr	A	; for each loop for A
	jrnz	..duble
	xchg		; DE <-> HL
addsum: lhld	usedspa ; get current total
	dad	D	; update it
	shld	usedspa ; and save it.
	pop	H	; Restore where we are in table
	lxi	D,16	; move to next line
	dad	D	; HL=next line addr
	jmp	addup1	; and keep on adding up lines
cmpsiz: 		; compare alloc to maxalloc
	pop	H	; balance stack
	lhld	voladdr ; addr of max space on HD
	mov	E,m
	inx	H
	mov	D,m
	lhld	usedspa ; to compare and print it
	push	H	; save used space
	xchg		; switch HL with DE
	ora	A	; clear carry flags
	dsbc	D	; max avail space - used space
	pop	H	; get used space back
	ret
;---------------
; Subroutine putBUF:  put console input in buffer
; Regs	in:	HL=address of message to print
; Regs out:	A =number of chrs put in buffer
;
putBUF:
	call	prtmsg
	call	clrBUF	 ; clear the console buffer	
	mvi	C,bufread
	lxi	D,conbuf
	call	BDOS	 ; put console input in buffer
	lxi	H,conbuf+1
	mov	A,M	 ; put num of buffer chrs in A
	ret
;---------------
; Subroutine prtvol:  Print the volume information
; Reg in:  None
; Reg out: HL = size
; Destroyed: A, DE, HL
;
prtvol:
	lda	volnum
	call	setvolptr
	mov	A,vlipresent(x)
	cpi	true
	jrz	..cont
	lxi	H,novol
	call	prtmsg
	ret
..cont: lda	STATbuf+5   ; determine controller type
	cpi	'X'	    ; X for Xebec
	jrz	..ok5	    ; (fox disks are 5 inches)
	mov	A,vlitype(x) ;sectors per track
	cpi	11	; sects/trk on 8 inch disk
	jrz	..ok8
	cpi	17	; sects/trk on 14 inch disk
	jrz	..ok14
	cpi	23
	jrz	..ok23
	jmpr	..bad	  ;error in HD controller pgm

..ok8:	mov	A,vlisize(x) ;# of read/write heads
	cpi	3	;head mask for 11 meg harddisk
	lxi	D,size8s ;small 8 HD
	lxi	H,max11 ;maximum storage for this disk
	jrz	..ok
	cpi	7	;head mask for 23 meg harddisk
	lxi	D,size8b ;big 8 HD
	lxi	H,max23 ;maximum storage for this disk
	jrz	..ok
	jmpr	..bad	  ;error in HD controller pgm

..ok14: mov	A,vlisize(x) ;# of read/write heads
	cpi	3	;3 heads, 14 meg harddisk
	lxi	D,siz14s ;small 14 HD
	lxi	H,max14 ;maximum storage for this disk
	jrz	..ok
	cpi	7	;7 heads, 28 meg harddisk
	lxi	D,siz14b ;big 14 HD
	lxi	H,max28 ;maximum storage for this disk
	jrz	..ok
	jmpr	..bad 

..ok23: mov	A,vlisize(x) ; # of read/write heads
	cpi	7	;7 heads, 46 meg harddisk
	lxi	D,size8g ;giant 8 hd
	lxi	H,max46 ;maximum storage for this disk
	jrz	..ok
	jmpr	..bad

..ok5:	mov	A,vlisize(x) ; "head mask" (disk type)
	cpi	1	; arbitrary label for cmi
	lxi	D,siz5cmi
	lxi	H,max15f
	jrz	..ok
	cpi	2	; miniscribe
	lxi	D,siz5mini
	lxi	H,max16f
	jrz	..ok
	cpi	3	; rms
	lxi	D,siz5rms
	lxi	H,max13f
	jrz	..ok
	cpi	4	; syquest removable
	lxi	D,siz5syq
	lxi	H,max5f
	jrz	..ok
	cpi	5	; rodime 
	lxi	D,siz5rod
	lxi	H,max16Rf
	jrz	..ok
	jmpr	..bad

..ok:	push	H	  ;save max storage
	xchg		  ;HL has message to print
	call	prtmsg
	pop	H	  ;Restore max storage
	ret
..bad:	lxi	H,badcntl ;error in HD controller pgm
	jmp	bootm

.page
;---------------
; Subroutine compnam:  Compare the partition names to
;			prevent duplications
; Reg in:  DE = first name to compare
;	   HL = name to be compared to
; Reg out: Carry flag conditionally set
; Destroyed: All
;
compnam:
	ora	A	;set carry flag off
	lda	volnum
	push	PSW	;save users current vol
	sub	A
	sta	volnum	;start with first volume
	call	setvolptr ;set up volume pointers
	lxi	H,NAMaddr ;where temp name is stored
	lded	curVOL	  ;first mame to compare
..over: mov	A,vlipresent(x)
	cpi	true
	jrz	..ok
	lda	volnum
	cpi	maxvol
	jrz	..exit	;last one, do no more
	inr	A
	sta	volnum
	call	setvolptr
	lded	curvol
	jmpr	..over
..ok:	mvi	A,0
	sta	cheknam	; Incremented to partition 1
			;in ..loop
	sta	compcnt ; Counter for ..loop
..next: ldax	D
	cpi	0	;a zero is end of table
	jrnz	..loop	;not end of table, do next one
	lda	volnum	;else, end of table do next vol
	cpi	maxvol	;last volume is 3
	jrz	..exit	;last one, do no more
	inr	A	;else, do next volume
	sta	volnum
	call	setvolptr
	lded	curvol
	jmpr	..over

;  (continued next page)
.page
..loop: lda	compcnt ;compare all letters in name
	inr	A
	sta	compcnt 
	cpi	10	;if all letters compare, we
	jrz	..dup
	inx	D
	ldax	D	;byte to test
	cmp	m	;with memory addr by HL
	inx	H	;next byte to compare
	jrz	..loop	;letters are same, try next
	sub	A	;not same, do next name
	sta	compcnt
	lda	cheknam ; get the next table entry
	inr	A
	sta	cheknam
	call	ADDRfind ;addr of next partition name
	xchg		 ;to compare in DE
	lxi	H,NAMaddr ;addr of name to compare to
	jmpr	..next	 ;next compare
..dup:	sub	A	 ;have a duplicate name
	sta	compcnt  ;zero counter for next time
	lxi	H,dupmsg
	call	prtmsg
	pop	PSW	 ;users current volume
	sta	volnum
	call	setvolptr ;set pointers
	stc		 ;set the carry flag
	ret		 ;ret with carry flag set
..exit: sub	A
	sta	compcnt  ;zero counter for next time
	pop	PSW	 ;restore current vol
	sta	volnum
	call	setvolptr ;set the pointers
	ret		 ;ret without carry flag set
.page
;---------------
; Subroutine CONSTAT:  Check console status
; Regs	in:	none
; Regs out:	carry bit set if chr ready
; Destroyed:	
CONSTAT:
	mvi	C,conready
	call	BDOS
	rrc		; set parity bit if
	ret		;chr is ready.
;---------------
; Subroutine clrBUF:  Clear the console buffer
; Regs	in:	none
; Regs out:
; Destroyed:
;
clrBUF:
	lxi	B,12
	lxi	H,clrBYTS
	lxi	D,conbuf+2
	ldir
	ret
;----------
; Subroutine makDBYT: Make decimal byte from buffer
; Regs	in:	A=length of console buffer
; Regs out:	A=decimal byte made from console buffer
; Destroyed:	HL,A,B,C
;
makDBYT:
	cpi	1	   ; just one chr
	mvi	B,0
	lxi	H,conbuf+2 ; load 1st chr addr
	jrz	..1
;multiply first chr by 10 and save
	mov	A,M
	sui	'0'	; make ascii chr numeric
	mov	B,A	; save original number
	rlc
	rlc
	rlc
	mov	C,A
	mov	A,B
	rlc
	add	C
	mov	B,A	;save 10*number in B
	inx	H	; get 2nd chr addr
..1:	mov	A,M
	sui	'0'	; make ascii chr numeric
	add	B	; add the two chrs
	ret
.page
;---------------
; Subroutine makHBYT: make hex byte from buffer
; Regs	in:	A=length of console buffer
; Regs out:	A=hex byte made from console buffer
; Destroyed:	HL,A,B,C
;
makHBYT:
	cpi	1	   ; just one chr*
	mvi	B,0
	lxi	H,conbuf+2 ; load 1st chr addr
	jz	aa1	   ; process 1st chr only
;multiply first chr by 16 and save in B
	mov	A,M	; get 1st chr
	inx	H	; get to next chr
	cpi	'A'
	jm	aa2
	ani	0DFh	; make all letters upper case
	sui	'A'-'9'-1
aa2:	sui	'0'
	cpi	0
	jz	aa1	; skip mult if nibble is 0
	ora	A	; reset carry flag
	rlc
	rlc
	rlc
	rlc
	mov	B,A	;save 16*firstnumber in B
aa1:	mov	A,M	; get 2nd chr
	cpi	'A'
	jm	aa3
	ani	0DFh	; make all letters upper case
	sui	'A'-'9'-1
aa3:	sui	'0'
	ora	A	; reset the flags
	add	B	; add the two chrs
	ret
;---------------
; Subroutine ADDRfind: Find addr of a line in a table
; Regs	in:    A = needed addr of a line in table  
; Regs out:    HL= Addr of that line in the table 
;Destroyed:    A,DE
;
ADDRfind:
	lhld	curVOL	  ; start addr of table
	cpi	0	  ; first line of table*
	rz		  ; then were done
..1:	lxi	D,16	  ; incr table 16 bytes
	dad	D
	dcr	A	  ; decr table line number
	ora	A	  ; all done
	jrnz	..1	  ; incr to next line
	ret
.page
;---------------
; Subroutine STOPprt:  abort from subroutine set carry
; Regs	in:	none
; Regs out:	none
;Destroyed:	HL,A
;
STOPprt:
	lxi	H,crlf	; space down a line
	call	prtmsg
	stc		; set the carry bit
	ret
;---------------
; Subroutine cvtbcd:  convert binary to BCD
;
; Regs	in:	A=byte to be converted
; Regs out:	A=byte, in BCD format
; Destroyed:	B
;
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
;---------------
; Subroutine CONIN: get character from console
; Make all input letters UPPER CASE,
; and abort if chr is a ^C.
;
CONIN:
	mvi	C,1
	call	BDOS
	cpi	3	; 3 is ^C
	jz	WBOOT	; boot if ^C
	cpi	1Bh	; 1B is ESC
	jrnz	..1	; If escape jump to GetCom 
			;directly.First clean up stack.
	lxi	SP,stack-2	; Stack needs only have
	jmp	GetCom		;return address to CCP
..1:
	cpi	'a'
	rm
	cpi	'z'+1
	rp
	sui	'a'-'A'
	ret
.page
;---------------
; Subroutine prtbyt: print a byte on the console
; Regs	in:	A=byte to be printed
; Regs out:	none
; Destroyed:	A,B,C
;
prtbyt:
	push	PSW	; save the chr
	rlc
	rlc
	rlc
	rlc
	call	prtNBL
	pop	PSW
	call	prtNBL
	ret
prtNBL: ani	0Fh
	adi	'0'
	cpi	'9'+1
	jc	CONOUT
	adi	'A'-('9'+1)
	jmp	CONOUT
;---------------
; Subroutine prtchr: print characters to console
; Regs	in:	B =length of string
;		HL=addr of string
; Regs out:	none
;Destroyed:	B,A
;
prtchr:
	mov	A,M
	cpi	0	; is char just a null*
	jrnz	..1	
	mvi	A,20h	; Yes. Print a space instead
..1:	push	B
	push	H
	call	CONOUT
	pop	H
	pop	B
	dcr	B
	mov	A,B
	cpi	0	; all B chrs printed*
	rz
	inx	H	; next chr addr
	jmpr	prtchr	
.page
;---------------
; Subroutine prtmsg:  print message on console
; 
;  Regs in:	HL = address of string (ended by null)
;  Regs out:	none
;  Destroyed:	A, HL
;
prtmsg:
	mov	A,M
	ora	A
	rz
	push	h
	call	CONOUT
	pop	h
	inx	H
	jmpr	prtmsg
;---------------
; Subroutine Error: tell user incorrect entry made
; Regs	in:	none
; Regs out:	none
;Destroyed:	HL
;
ERROR:	
	push	PSW	; save status flag
	lxi	H,errmsg
	call	prtmsg
	pop	PSW
	ret
;---------------
; Subroutine CONOUT:  print character on console
;  Regs in:	A = character to be printed
;  Regs out:	none
;  Destroyed:	C
;
CONOUT:
	push	h
	push	d
	push	b
	mov	e,a
	mvi	c,conslout ;CP/M 2, Console Output
	call	BDOS
	pop	b
	pop	d
	pop	h
	ret
.page
.sbttl 'Harddisk I/O subroutines'
;---------------
;Subroutine:	chaMAPbyt
; Regs	in:	none
; Regs out:	none
;Destroyed:	all
; Save the previous assignment for restoration.
; Current unit 0 assignment (network,etc) returns in A
; BIOS address of the byte returns in HL
;
chaMAPbyt:
	mvi	C,0
	call	SELDSK	; select unit 0 f
	call	CPMmap	; get current unit 0 assignment
	sta	UNITno	; save it for later restoration
	sub	A
	mov	M,A	; Make it unit number 0
	dcx	H	; point at the media type
	mov	A,M	; get the media type
	sta	DEVtype ; store for later
	dcx	H	; point to volume number
	mov	A,m
	sta	savevol ; save it
	inx	H	; back to where we were
	lda	sysflg
	cpi	0FFh	; use hard disk if MP/M
	jrz	..hddsk
	lda	47h	; get our user number
	cpi	0FFh	; Are we a hard disk*
	jrz	..hddsk ; Yes.
	mvi	M,NETbyt; No. Assign to network master
	ret
..hddsk:lda	STATbuf+5; DMS or Xebec controller*
	cpi	'X'	; X if Xebec (fox)
	jrnz	..dms
	mvi	M,FoxHDbyt
	ret
..dms:	mvi	M,HDbyt ; assign unit 0 to a hard disk
	ret
;--------------
; Subroutine  resMAPbyt: restore previous unit assign
; Regs	in:	none
; Regs out:	none
; Destroyed:	any and/or all registers
; Current unit 0 assignment (hard disk) returns in A
; BIOS address of the byte returns in HL
;
resMAPbyt:
	lxi	B,0
	call	seldsk	; Select drive A
	call	cpmMAP	; Get addr of unitno
	lda	UNITno
	mov	M,A	; Restore unit number
	dcx	H	; Point at media type
	lda	DEVtype
	mov	M,A	; Restore media type
	dcx	H
	lda	savevol
	mov	m,A	; restore volume number
	ret
.page
;--------------
; Subroutine readTABL:	Read DAT from HD into buffer
; Regs	in:	none
; Regs out:	none
; Destroyed:	All
; Network Hard Disk Track 0, sectors 121-128
;
readTABL:
	mov	A,vlipresent(x)
	cpi	true
	rnz		;stat buff has a 0 if no drive
	mvi	A,121	;else, read the table
	sta	cursec	;set value for first sector
	lhld	curVOL	
	shld	DMAaddr ;set value for first DMA addr
	call	HOME
	ora	A	; reset the carry flag
..1:	rc		; return if carry bit set
	mvi	C,0	; read unit 0
	call	SELDSK	; select hard disk
	call	CPMmap
	dcx	H
	dcx	H	; point to volume # in BIOS
	lda	volnum	
	mov	m,A	; Stuff volume number there
	lxi	B,0
	call	SETTRK	; select track 0
	lda	cursec	; load current sector
	mov	C,A
	call	SETSEC	; select current sector
	lbcd	DMAaddr
	call	SETDMA	; select proper buffer location
	call	READ	; and read from the disk
	call	INRdata ; increment DMA addr and sector
	jmpr	..1	; read until INRaddr sets carry
.page
;---------------
; Subroutine zerotbl:	Zero the alloc table if the
;			disk is freshly formatted
; Reg in:  None
; Reg out: None
; Destroyed: All
;
zerotbl:
	lxi	B,16*64  ; length of table
	lhld	curVOL	 ; addr of table
	mvi	M,1	 ; so partition 0 can not be
			 ;allocated by user.
	inx	H	 ; next table address
	dcx	B	 ; decrement the counter
..loop: mvi	M,0	 ; put a 0 into table
	inx	H	 ; next table addr
	dcx	B	 ; decrement the counter
	mov	A,C	 ; test the counter
	cpi	0
	jrnz	..loop
	mov	A,B
	cpi	0
	jrnz	..loop
	lhld	curflag  ;addr of current flag
	mvi	m,true	 ;set flag to a change is true
	ret
;---------------
; Subroutine writTABL:	Write DAT from buffer to HD
; Regs	in:	none
; Regs out:	none
;Destroyed:	All
writTABL:
	mvi	A,121
	sta	cursec	;set value for first sector
	lhld	curVOL
	shld	DMAaddr ;set value for first DMA addr
	ora	A	; reset the carry flag
..1:	rc
	mvi	C,0
	call	SELDSK	; select hard disk
	call	CPMmap
	dcx	H
	dcx	H	; point to volume # in BIOS
	lda	volnum	
	mov	m,A	; Stuff volume number there
	lxi	B,0
	call	SETTRK	; select track 0
	lda	cursec	; load current sector
	mov	C,A
	call	SETSEC	; select current sector
	lbcd	DMAaddr
	call	SETDMA	; select proper buffer location
	call	WRITE	; and write to the disk
	call	INRdata ; increment DMA addr and sector
	jmpr	..1	; read until INRaddr sets carry
.page
;---------------
;Subroutine INRdata: increment DMA address and sect #
; Regs	in:	none
; Regs out:	carry bit* (used as a flag)
;Destroyed:
;
; *Set the carry bit if last sector (128) has been read
;
INRdata:
	lhld	DMAaddr ; get current DMA address
	lxi	D,128
	dad	D	; increment by 128 bytes
	shld	DMAaddr ; and save it

	lda	cursec	; get the current sector
	inr	A
	sta	cursec
	cpi	129	; past 128th sector*
	jrnc	..1
	ora	A	; no. Resume reading or writing
	ret
..1:	stc		; set the carry flag
	ret		; and return
;---------------
; Subroutine prtlabel:	Print the volume label
; Reg in:  None
; Reg out: None
; Destroyed: A
;
prtlabel:
	mov	A,vlipresent(x)
	ora	A
	jrz	..dflt
	mvi	A,' '
	call	conout
	mov	A,vlilabel(x)
	call	conout
	mov	A,vlilabel+1(x)
	call	conout
	mov	A,vlilabel+2(x)
	call	conout
	mov	A,vlilabel+3(x)
	call	conout
	mov	A,vlilabel+4(x)
	call	conout
	mov	A,vlilabel+5(x)
	call	conout
	mov	A,vlilabel+6(x)
	call	conout
	mov	A,vlilabel+7(x)
	call	conout
	mov	A,vlilabel+8(x)
	call	conout
	mov	A,vlilabel+9(x)
	call	conout
	mvi	A,' '
	call	conout
	ret		; volume label printed

..dflt: lxi	H,nvolabl
	call	prtmsg
	ret

;---------------
; Subroutine setvolptr:  Set the x register to point
;			 to the next volume in volbuff
; Reg in: A
; Reg out: x = addr of volume info
;	   HL= storage for volume in use
;	   DE= addr of current volume in use
; Destroyed: A,DE,HL
;
setvolptr:
	lda	volnum
	slar	A	;A * 2
	mov	E,A
	mvi	D,0
	lxi	H,vliindex
	dad	D	;HL points to vol info pointer
	mov	E,m
	inx	H
	mov	D,m	;DE points to vol info
	push	D
	pop	x	;x points to vol info
	lda	volnum
	cpi	0
	lxi	B,vol0quit
	lxi	D,vol0max
	lxi	H,vol0
	jrz	..exit
	cpi	1
	lxi	B,vol1quit
	lxi	D,vol1max
	lxi	H,vol1
	jrz	..exit
	cpi	2
	lxi	B,vol2quit
	lxi	D,vol2max
	lxi	H,vol2
	jrz	..exit
	lxi	B,vol3quit
	lxi	D,vol3max
	lxi	H,vol3
..exit: sbcd	curflag ;flag for current volume
	sded	voladdr
	shld	curvol	;current volume here
	ret
.page
.sbttl 'BIOS calls'
; Call BIOS using WBaddr in low memory
;
HOME:
	lhld	WBaddr
	lxi	D,15h
	dad	D
	pchl
SELDSK:
	lda	sysflg
	ora	a
	jp	notmpm	; skip if not mpm
	lxi	h,selret
	push	h	; return to us
notmpm: lhld	WBaddr
	lxi	D,18h
	dad	D
	pchl
selret: shld	mpmtab	; save dpb address
	ret
SETTRK:
	lhld	WBaddr
	lxi	D,1Bh
	dad	D
	pchl
SETSEC:
	lhld	WBaddr
	lxi	D,1Eh
	dad	D
	pchl
SETDMA:
	lhld	WBaddr
	lxi	D,21h
	dad	D
	pchl
READ:
	lhld	WBaddr
	lxi	D,24h
	dad	D
	pchl
WRITE:
	mvi	C,0	; regular buffered write
	lhld	WBaddr
	lxi	D,27h
	dad	D
	pchl
CPMMAP:
	lda	sysflg
	ora	a
	jm	mpmmap	; skip if mpm
	lhld	WBaddr
	lxi	D,60h
	dad	D
	pchl
.page
mpmmap: lhld	mpmtab	; dpb address
	lxi	d,10	; offset to parm tab addr
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	dcx	d	; unit + devtype byte
	xchg		; into hl
	mov	a,m	; get unit+devtype
	ret
SETBYT:
	lhld	WBaddr
	lxi	D,66h
	dad	D
	pchl
HDstat:
	lhld	WBaddr
	lxi	D,81h	;# of bytes after jump point
	dad	D	;added to HL addr
	pchl
;
; getque - get disk mutual exclusion que if mpm
;
getque: lda	sysflg
	ora	a
	rp		; return if cpm
	mvi	c,87h	; open que
	lxi	d,mpmq
	call	BDOS
	mvi	c,89h	; read que
	lxi	d,mpmq
	call	BDOS
	mvi	a,0ffh
	sta	queflg	; indicate que got
	ret
;
; putque - free disk que if got
;
putque: lda	queflg
	ora	a
	rz		; somehow this rz got to
			; be missing but here it is
	xra	a
	sta	queflg	; reset flag
	mvi	c,8bh	; write que function
	lxi	d,mpmq
	call	BDOS
	ret
.page
.sbttl	'Equates'
;----------------
WBOOT	==	00h
BDOS	==	05h
wbadr	==	1	;vector for BIOS calls
cr	==	0Dh	;ascii non-printing commands
lf	==	0Ah
bell	==	07h
tb	==	09h
PIOAD	==	08h	;PIO channel A, data
HARD	==	01h	;hard disk data port
DMA	==	38h	;DMA data port
max11	==	10648	;max storage for 11m harddisk
max23	==	21296	;max for 23m harddisk
max46	==	44528	;max for 46m harddisk
max14	==	13600	;max for 14m harddisk
max28	==	27200	;max for 28m harddisk
max15f	==	14680	;max for 15m harddisk (cmi)
max16f	==	15352	;max for 16m harddisk (mscrb)
max16Rf ==	15544	;max for 16m harddisk (rodime)
max13f	==	12280	;max for 13m harddisk (rms)
max5f	==	4888	;max for 5m harddisk (syquest)
conslout==	2h	;CP/M 2,  Console Output
bufread ==	0Ah	;CP/M 10, Read Console Buffer
conready==	0Bh	;CP/M 11, Get Console Status
retvsn	==	0Ch	;CP/M 12, Return Version Num
CPMflag ==	01h	;test flag for CPM or
MPMflag ==	0FFh	;MPM operating system
usernum ==	47h	;storage area in bios
localHD ==	0FFh
masterHD==	0h
HDbyt	==	2<5	;byte assigns hard disk to 0
NETbyt	==	3<5	;byte assigns network to 0
FoxHDbyt==	6<5	;byte assigns Fox hard disk to 0
true	==	0FFh	;volume present
false	==	0h	;volume not present
maxvol	==	3h	;maximum # of volumes
vlipresent ==	0	;FF = yes, 0 = no
vlicurtrack==	1	;current track for volume
vlitracks  ==	2	;tracks on volume
vlitype    ==	3	;sectors per track
vlisize    ==	4	;number of read-write heads
vlibiastable==	5	;loc of partition offset table
vlibadtable==	7	;location of BST for volume
vlidirty   ==	9	;loc of bad table dirty flag
vliopenerr ==	11	;failure in volume open (init)
vlilabel   ==	12	;10 byte volume label
vlibufsiz  ==	32	;size of info in volume entry
.page
.sbttl 'Define storage'
;--------------
; Storage for the harddisk allocation tables
;
	.loc	(.+15)&(0FFF0h) ;loc on 16 byte bndry
vol0:	.blkb	1024	;beginning of volume 0
	.ascii	'END OF VOLUME 0 '
vol1:	.blkb	1024	;beginning of volume 1
	.ascii	'END OF VOLUME 1 '
vol2:	.blkb	1024	;beginning of volume 2
	.ascii	'END OF VOLUME 2 '
vol3:	.blkb	1024	;beginning of volume 3
	.ascii	'END OF VOLUME 3 '
	.loc	(. + 1fh)&(#(1fh)) ;loc on 32 byte bdry
vliindex:
	.word	vli0
	.word	vli1
	.word	vli2
	.word	vli3
statbuf:.blkb	8	;DO NOT SEPARATE THESE 2 BUFS
VOLbuff:		;harddisk controller data here
vli0:	.blkb vlibufsiz ;volume 0 HDC data area
vli1:	.blkb vlibufsiz ;volume 1 HDC data area
vli2:	.blkb vlibufsiz ;volume 2 HDC data area
vli3:	.blkb vlibufsiz ;volume 3 HDC data area
HDCbuff:.blkb	128	;storage for old HDC
savevol:.byte	0	;storage of volume # from BIOS
curVOL: .word	0	;storage for volume in use
volnum: .byte	0	;flag used to tell user
voladdr:.word	0	;store addr of current volume 
vol0max:.word	0	;max alloc of volume 0
vol1max:.word	0	;max alloc of volume 1
vol2max:.word	0	;max alloc of volume 2
vol3max:.word	0	;max alloc of volume 3
quitflg:.byte	0	;store status at quit request
curflag:.word	0	;store the current flag
vol0quit:.byte	false	;change flag for volume 0
vol1quit:.byte	false	;change flag for volume 1
vol2quit:.byte	false	;change flag for volume 2
vol3quit:.byte	false	;change flag for volume 3
;---------------
;Temporary locations for Disk Allocation Table entries
;
compcnt:.byte	0h	;store number of compares
cheknam:.byte	0h	;store # of next name to check
unit:	.byte	00h	;Hex byte (not in table)
TEMPentry:		;Beginning of table line
size:	.byte	00h	   ; size of HD partition
NAMaddr:.ascii	'        ' ; partition name
PASaddr:.ascii	'      '   ; partition password
control:.byte	00h	   ; control byte not used
.page
;----------------
; Hard disk size identification table
HDsiztbl:
;    secs/trk	heads	num of tracks	disk size (Meg)
.byte	11,	  4,	    241,	   10
.byte	11,	  8,	    241,	   23
.byte	23,	  8,	    241,	   46
.byte	17,	  4,	    199,	   14
.byte	17,	  8,	    199,	   28  
.byte	00h	; End of table marker
;
UNITno: .byte	0	; storage for drive A unit
DEVtyp: .byte	0	; storage for drive A media type
DMAaddr:.word	00h	; current DMAaddr for disk I/O
cursec: .byte	00h	; current sector for disk I/O
mapres: .word	0	; map byte address
WBaddr: .word	0	; for bios access
mpmtab: .word	0
queflg: .byte	0	; 0ffh if disk que got
mpmq:	.byte	0,0
	.word	qbuff
	.ascii	'MXDisk  ' ; disk q name
qbuff:	.byte	0,0	   ; q message
;---------------
; Used for allocated disk space computation 
;
allospa:.byte	00
	.word	0000	;allocated disk space (in BCD)
usedspa:.word	0000h	;Sum of sizes allocated (in K)
maxalloc:.word	0h	;storage for max to allocate
string: .blkb	6	;store the decimal conversion
;---------------
; System identification (MPM, CP/M 1.4 or 2.2
;
sysflg: .byte	0
; FFh is MPM, 0 is CP/M 1.4, else CP/M 2.2
;---------------
; erase data areas
;
spt:	.byte	0	; end of track sector number
numdir: .word	0	; number of dirents
trkaddr:.word	0	; track address save
wsec:	.byte	0	; running sector number
dirbuf: .blkb	128	; hex 'e5' buffer
;
conbuf: .byte	12,0
	.byte	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.page
.sbttl 'CRT Messages'
;---------------
; CRT Messages
;
LOGmsg: .ascii	[cr][lf]'ALLOC for BIOS 2.243 and '
	.ascii		'later, version '
	.byte	version+'0','.'
	.byte	revision/10 + '0',revision@10+'0'
	.byte	patch
	.ascii	[cr][lf]'Disk Allocation Table Program'
	.asciz	[cr][lf]
badcntl:.asciz	[cr][lf]'Controller program is bad.'
size8s: .asciz	'  8 inch Fujitsu harddisk.  (11 Meg.)'
size8b: .asciz	'  8 inch Fujitsu harddisk.  (23 Meg.)'
size8g: .asciz	'  8 inch Fujitsu harddisk.  (46 Meg.)'
siz14s: .asciz	'  14 inch Shugart harddisk. (14 Meg.)'
siz14b: .asciz	'  14 inch Shugart harddisk. (28 Meg.)'
siz5cmi:.ascii	'  5.25 inch CMI harddisk.   (15 Meg.)'
	.asciz	'     '
siz5min:.ascii	'  5.25 inch Miniscribe harddisk.'
	.asciz	'  (16 Meg.)'
siz5rms:.ascii	'  5.25 inch RMS harddisk.  '
	.asciz	'  (13 Meg.)    '
siz5syq:.ascii	'  5.25 inch Syquest removeable.'
	.asciz	'  (5 Meg.)  '
siz5rod:.ascii	'  5.25 inch Rodime harddisk.'
	.asciz	'  (16 Meg.)    '
novol:	.asciz	'  No volume present'
nvolabl:.asciz	' .......... '
vPrsntMsg: .asciz [cr][lf]'Volumes present:'[lf]
tblMsg:	.asciz	[cr][lf]'Alloc table for'
UNImsg: .asciz	[cr][lf]'    Unit     (0,1,..63)? '
SIZmsg: .asciz	[cr][lf]'    Size     (1,2,..6) ? '
NAMmsg: .asciz	[cr][lf]'    Name (up to 8 chrs)? '
PASmsg: .asciz	[cr][lf]'Password (up to 6 chrs)? '
CTLmsg: .asciz	[cr][lf]' Control     (0,1,..FF)? '
.page
Helpmsg:.ascii	[cr][lf][lf][tb]
	.ascii	'      ALLOC Command Summary '
	.ascii	[cr][lf][tb]
	.ascii	'--------------------------------'
	.ascii	[cr][lf][tb]'A - Add an entry '
	.ascii			'to the table'
	.ascii	[cr][lf][tb]'C - Change your volume'
	.ascii	[cr][lf][tb]'D - Delete an entry '
	.ascii			'in the table'
	.ascii	[cr][lf][tb]'E - Erase MPM directory '
	.ascii			'on disk'
	.ascii	[cr][lf][tb]'ESC - Return to the '
	.ascii	'"Command ?" prompt ( hit any time )'
	.ascii	[cr][lf][tb]'H - Print Help summary'
	.ascii	[cr][lf][tb]'L - List out current table'
	.ascii	[cr][lf][tb]'M - Modify an entry in '
	.ascii			'the table'
	.ascii	[cr][lf][tb]'Q - Quit the program'
	.ascii	[cr][lf][tb]'S - Save changes for '
	.ascii			'the permanent table'
	.ascii	[cr][lf][tb]'V - Print out the volume '
	.ascii			'titles'
	.ascii	[cr][lf][tb]'Z - Zero out entire table'
	.ascii	[cr][lf]'Use Control-C to abort '
	.ascii		'the program at any time.'
crlf:	.asciz	[cr][lf]
COMmsg: .asciz	[cr][lf]' Command ?'
.page
AIDmsg: .ascii	[cr][lf]'  Please type H for a '
	.asciz		'command summary'
HEADmsg:.ascii	[cr][lf]'   Unit  Size   Name    '
	.ascii		'   Password  Ctrl'
	.ascii	[cr][lf]'   ----  ----   ----    '
	.asciz		'   --------  ----'
VERIFYmsg:
	.ascii	[cr][lf]'Is this listing correct? '
	.asciz		'(Y or N)'
VERIF2msg:
	.ascii	[cr][lf]'Is this the entry to modify? '
	.asciz		'(Y or N)'
VERIF3msg:
	.asciz	[cr][lf]'Is this the entry to delete? '
NOGOmsg:.ascii	[cr][lf]'ALLOC cannot be used '
	.asciz		'on this station.'[cr][lf]
WARNmsg:.asciz	[cr][lf][bell][tb]' *** WARNING *** '
DELwarn:.asciz	[cr][lf]'DELETION OF THIS ENTRY '
SIZwarn:.asciz	[cr][lf]'CHANGING PARTITION SIZE '
WARNend:.ascii		'WILL CAUSE ALL FOLLOWING'
	.ascii	[cr][lf]'ENTRIES TO HAVE THEIR '
	.ascii		'FILES DESTROYED.'
zeromsg:.ascii	[cr][lf]'THIS CAN ONLY BE SAFELY '
	.asciz		'DONE AFTER A FORMAT'
WARNask:.asciz	[cr][lf][lf]'Do you want to continue?'
SAVmsg: .ascii	[cr][lf]'WAIT - Saving Disk '
	.asciz		'Allocation Table '
COMPmsg:.asciz	[cr][lf]'Function Completed'
space4: .asciz	'    '
errmsg: .ascii	[cr][lf]' Incorrect entry.  '
	.asciz		'Please try again.'
tblfulmsg:
	.ascii	[cr][lf]'Allocation table is filled.  '
	.asciz		'Use the (M) modify command.'
badmodmsg:
	.ascii	[cr][lf]'That line does not have an '
	.asciz	'entry.  Use the A (add) command.' 
addmsg: .asciz	[cr][lf]'The next available line is '
clrBYTS:.ascii	'                          '
nvrmes: .asciz	[cr][lf]' command aborted.'
vermes: .ascii	[cr][lf]' type "Y" if you really'
	.asciz	' want to erase directory : '
nota:	.asciz	[cr][lf]' unit not assigned.'
bsymes: .asciz	[cr][lf]' rejected - unit is busy.'
MAXmsg: .asciz	[cr][lf]'Maximum disk storage: '
SPAmsg: .asciz	[cr][lf]'Allocated disk space: '
endmsg: .asciz		' Kbytes'
savemsg:.ascii	[cr][lf]'Is this the alloc table '
	.asciz		'you want to save? (Y or N)'
.page
volnmmsg:.asciz [cr][lf][lf]'The current volume is '
chgmsg: .ascii	[cr][lf][lf]'**You have made changes '
	.asciz	[bell]'to this volume without a save **'
vol0msg:.ascii	[cr][lf][lf]'Your changes in volume 0 '
	.asciz		'have not been saved.'
vol1msg:.ascii	[cr][lf][lf]'Your changes in volume 1 '
	.asciz		'have not been saved.'
vol2msg:.ascii	[cr][lf][lf]'Your changes in volume 2 '
	.asciz		'have not been saved.'
vol3msg:.ascii	[cr][lf][lf]'Your changes in volume 3 '
	.asciz		'have not been saved.'
quitmsg:.ascii	[cr][lf][lf]'Do you want to save your '
	.asciz	[bell]	'changes? (Y or N)'
advmsg: .ascii	[cr][lf][lf]'If you have a major error'
	.ascii		', it is best to type ctrl C '
	.asciz		'and reload ALLOC.'
nosave: .ascii	[cr][lf]'You wil not be allowed to '
	.ascii	[bell]	'save this alloc table. '
	.ascii	[cr][lf]'It exceeds the total disk '
	.asciz	[bell]	'space available.'
dupmsg: .ascii	[cr][lf]'This is a duplicate use of '
	.asciz	[bell]	'this partition name.'
volmsg: .ascii	[cr][lf]'Which volume do you want '
	.asciz		'to work on? (0,1,2, or 3) '
vol:	.asciz	[cr][lf]'    Volume '
quitwrn:.ascii	[cr][lf]
	.ascii	[cr][lf]'When you quit ALLOC, you '
	.ascii		'must do a cold boot of the '
	.ascii		'operating system.'
	.ascii	[cr][lf]
	.ascii	[cr][lf]'Therefore, NO USERS should '
	.ascii		'be using HiNet while you '
	.ascii		'modify your alloc table.'
	.ascii	[cr][lf]
	.ascii	[cr][lf]'Please hit RETURN when you '
	.ascii		'understand this message.'
crlflf:	.asciz	[cr][lf][lf]
;
	.blkb	100
stack:
	.end
