  .page
  .sbttl	'hard 8 disk reads and writes'
  .prntx	'made it to hard 8 rd/wr'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	DMS 8 Inch Hard Disk Drivers		+
; +						+
; +	last modified>	12jan84 jlw		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

OPTM0	=	OPTM0 + (1<Hard8)  ; set opt map bit

LocalOpt	==	0	; local user flag
lenLastDesc	==	5
MapErr		==	30h	; cp/m mapping error

  .ife	Master,[
NewVol: 	.byte	0ffh
NewUnit:	.byte	0ffh
NewTrk: 	.word	0ffffh
NewSec: 	.word	0ffh
	]		; end ' master '

;
;----------
; Hard disk read - 128 byte
HARDrd: 

  .ifn	MastOpt, [call HARDprep]
  .ife	MastOpt, [jmp  CALLerr ]
;
;-------
; entry>   HL = DMA address
;	   DE = track number	 (0-511)
;	   B  = HD volume number (0-3)
;	   C  = sector number	 (1-128)
;	   A  = unit number (0-63)

HARDr:
	push	H	; save DMA address

  .ife	Master,[
	call	ck4Seq	; set sequential flag
	]		; end ' Master '

	call	HARDrw
	mvi	A,readHARD
	call	CMDhard ; send read command
	call	REShard ; get result status
	pop	H
	rnz		; ret if error
;
	lxi	B,128
	call	REChard ; get data bytes
	xra	a

  .ife	Master,[sta	AutoRd] ; report success

	ret
;
;----------
;	-- Hard disk read 1K --
; entry>   HL = DMA address
;	   DE = track number	 (0-511)
;	   B  = HD volume number (0-3)
;	   C  = sector number	 (1-128)
;	   A  = unit number (0-63)
;
HARD1:
	push	H	; save DMA address

  .ife	Master,[
	call	ck4Seq	; set sequential flag
	]		; end ' Master '

	call	HARDrw
	mvi	A,read1HARD
	call	CMDhard ; send read command
	call	REShard ; get result status
	pop	H
	rnz		; ret if error
;
	lxi	B,1024
	call	REChard ; get data bytes
	xra	a

  .ife	Master,[sta	AutoRd] ; report success

	ret
;

  .ife	Master,[
;-------
; entry>	 b = volume#
;		 a = unit#
;		de = track#
;		 c = sector#
; exit> 	 b = volume
;		 a = unit
;		de = track
;		 c = sector
; check for sequential read request
ck4Seq:
	sta	NewUnit
	mov	a,b	; save all the read parameters
	sta	NewVol
	sded	NewTrk
	mov	a,c
	sta	NewSec
;
	call	CompReq ; check for sequential request
	lxi	h,InSequence
	mvi	m,0ffh	; default is not sequential
	jrnz	..setLast
;
	mvi	m,0
..setLast:
	call	GetLast
	lxi	d,NewVol
	xchg
	lxi	b,(lenLastDesc-1)
	ldir
	xchg
	lda	NewSec
	dcr	a
	ani	0f8h	; force 1k boundary
	inr	a
	mov	m,a
;
	lda	NewVol
	mov	b,a	; restore the read parameters
	lda	NewSec
	mov	c,a
	lda	NewUnit
	lded	NewTrk
	ret
;
;------
; entry>	none
; exit> 	Z set if sequential read
CompReq:
	call	GetLast ; hl = .SeqList(CurUsr)
	lxi	d,NewVol	
	call	CompVolUnit
	cz	CompTrkSec
	ret
;
;-------
; entry>	hl = .LastVol
;		de = .NewVol
; exit> 	if matched -
;		   hl = .LastUnit
;		   de = .NewUnit
;		    Z set
CompVolUnit:
	ldax	d
	cmp	m	; compare volume
	rnz
;
	inx	h
	inx	d
	ldax	d
	cmp	m	; compare unit
	ret
;
;-------
; entry>	hl = .LastUnit
;		de = .NewUnit
; exit> 	 Z set on match
CompTrkSec:
	inx	h	; hl = .LastTrk(low)
	inx	d	; de = .NewTrk(low)
	lda	NewSec
	sui	(RecsInBuf+1)
	jm	..wrap	; adjust track and sector
;
	ldax	d
	cmp	m	; compare track(low)
	rnz
;
	inx	h
	inx	d
	ldax	d
	cmp	m	; compare track(high)
	rnz
;
	inx	h
	lda	NewSec
	dcr	a
	ani	0f8h	; force 1k boundary
	inr	a
	sui	RecsInBuf
	cmp	m	; compare sector
	ret
;
;------
..wrap:
	lbcd	NewTrk
	dcx	b	; bc = NewTrk - 1
	mov	e,m
	inx	h	; hl = .LastTrk(high)
	mov	d,m
	xra	a
	dsbc	d	; hl = LastTrk - (NewTrk-1)
	rnz
;
	inx	h	; hl = .LastSec
	mvi	a,(MaxRec-RecsInBuf)
	cmp	m
	ret
;
;-------
; entry>	none
; exit> 	hl = .SeqList(CurUsr)
GetLast:
	lxi	h,SeqList
	lded	MastUsr
	mvi	d,0	; de = 0-31
	dad	d
	dad	d
	dad	d
	dad	d
	dad	d	; hl = .SeqList(CurUsr)
	ret
	]		; end ' Master '

;
;----------
; Hard disk write - 128 bytes
HARDwr: 

  .ifn	MastOpt, [call HARDprep]
  .ife	MastOpt, [jmp  CALLerr ]
;
;-------
; entry>   HL = DMA address
;	   DE = track number	 (0-511)
;	   B  = HD volume number (0-3)
;	   C  = sector number	 (1-128)
;	   A  = unit number (0-63)
HARDw:
	push	H	; save DMA address
	call	HARDrw
	mvi	A,writeHARD
	call	CMDhard ; send write command
	pop	H
	lxi	B,128
	call	SENDhard; send data bytes
	jmp	REShard ; get result status
;
;----------
; Prepare hard disk parameters
  .ifn	MastOpt,[
HARDprep:
	call	cpmMAP
	mov	D,A	; store unit # in D
	dcx	H
	dcx	H
	mov	B,M	; volume # in B
	lda	cpmSEC
	mov	C,A	; sector number in C
	mov	A,D	; put unit # back in A
	lded	cpmTRK	; get track number
	lhld	cpmDMA	; get DMA address
	ret
	]		; end ' not MastOpt '

;----------
; Read/write common code
HARDrw:
	sta	HARDdsk ; store unit number
	push	B	; save volume and sector
	push	D	; save track
	mov	A,B	; put volume # in A
	sta	HARDcom+2; store in cmd. string
	mvi	A,'M'	; 'M' for multi HD feature
	sta	HARDcom+6; store in cmd. string
SendSelect:
	mvi	A,selHARD
	call	CMDhard ; select the unit
;
;	go get status from hard disk controller
;	do this in line as only 8 bytes being read
;	note: this code provides no timeout since
;	on first select after cold boot it may take
;	several seconds for the hard disk controller
;	to respond
;
	lxi	h,hardstat	;block recieve address
	mvi	b,8		;block length
	mvi	c,hardp 	;hdc data port
selloop:
	in	pioad		;status port
	bit	4,a		;data ready bit
	jrz	selloop 	;nothing yet
;
	ini			;read a byte
	jrnz	selloop 	;test if done
;
	dcx	h		;point to error byte
				;in status block
	lxi	b,hardstat+1	;pointer that ioerr 
				;routine wants
	mov	a,m
	ora	a
HSELerr:
	cnz	ioerr	;error did occur (note label is
			;for ioerr deciphering of error
			;origination

	lda	HARDstat+7	; check for controller
	cpi	HdFlushErr	; error on prev flush
	jrz	SendSelect
;
	pop	D	; restore track
	pop	B	; restore sector
	lxi	H,HARDsec
	mov	M,C	; hard disk sector
	inx	H
	mov	M,E	; hard disk track (low byte)
	inx	H
	mov	M,D	; hard disk track (high byte)
	ret
;
;-------
; flush the DMS HDC buffers
; entry>	none
; exit>		none
flush8hard:
	mvi	a,flushHard
	call	CmdHard		; flush the disk buffers
	call	ResHard		; get result status
;		- fall into init8hard
;-------
; perform software reset of DMS HDC
; entry>	none
; exit>		none
init8hard:
	mvi	a,resetHard	; store reset command
	sta	HardCom		; for debugging display
	out	PPstrobe	; does software reset
;
; now wait for the hard disk to home
..waitResetDone:
	in	HardP		; clear input status
	mvi	a,Hd8dummy 	; (aeh) not rdy_to_send
	out	HardP		; send bogus command
;
..dataRdyWait:
	in	PIOAD		; get HDC port status
	bit	4,a		; wait till data avail
	jrz	..dataRdyWait
;
	in	HardP		; get new input status
	cpi	Hd8unknown	; (a1h) unknown command
	jrnz	..waitResetDone	; wait till we agree
	ret
;
;----------
; Get hard disk subsystem status
;  Regs in:	HL = block address
;		on return block has 8 byte hard disk
;		command status followed by 128 byte
;		volume information block
;  Regs out:	none
;  Destroyed:	A, BC, DE, HL
HDstat:
	; If master, request thru local user
  .ife	MastOpt,[
	sbcd	HSTadr	; Store block addr
	mvi	a,hdstNET
	sta	netCOM
	jmp	netREQ	;return from there
	]
;
; If not master, enter directly below
MMhdstat:
	push	B	; save block address
	mvi	A,statHARD ; Cmd in Acc
	call	cmdHARD ; Send cmd to HD subsystem
	pop	H	; Get ready to rcve block
	push	H	; Save addr once again
	lxi	B,8	; block length
	call	RECHARD ; Get 8 byte block
	pop	H	; Get the block addr
	lxi	D,7
	dad	D	; HL points at status byte
	sub	A
	ora	M	; Test status byte for zero
	rnz		; No more if non-zero
;
	inx	H	; Point past 8 byte block
	lxi	B,128
	jmpr	RECHARD ; Get the 128 byte block
;
;----------
; Transmit a block to the hard disk
;  Regs in:   HL = block address
;	      BC = byte count
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDHARD:
  .ifn	MastOpt,[
	mov	B,C	; assume less than 256 bytes
	mvi	C,HARDP
..1:	in	PIOAD
	bit	3,A
	jrnz	..1
;
	outi		; shove'em one at a time
	jrnz	..1
	ret
	]

  .ife	MastOpt,[
	shld	DMAHSadr  ; DMA address
	dcx	B
	sbcd	DMAHSsize ; DMA length
	lxi	H,DMAHdone
	shld	DMAvect   ; DMA interrupt vector
	mvi	A,4
	out	PIOAD	; multiplex hard disk to DMA
	lxi	H,DMAHSprog
	lxi	B,DMAH$<8+DMA
	di		; no ints until local user ok
	outir		; let the DMA fly
	jmpr	GOlocal
	]

;----------
; Receive a block from the hard disk
;  Regs in:   HL = block address
;	      BC = byte count
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
RECHARD:
  .ifn	MastOpt,[
	mov	B,C	; assume less than 256 bytes
	mvi	C,HARDP
..1:	in	PIOAD
	bit	4,A
	jrz	..1
;
	ini		; grab'em one at a time
	jrnz	..1
	ret
	]

  .ife	MastOpt,[
	shld	DMAHRadr  ; DMA address
	dcx	B
	sbcd	DMAHRsize ; DMA length
	lxi	H,DMAHdone
	shld	DMAvect   ; DMA interrupt vector
	mvi	A,5
	out	PIOAD	; multiplex hard disk to DMA
	lxi	H,DMAHRprog
	lxi	B,DMAH$<8+DMA
	di		; no ints until local user ok
	outir

  .ife	LocalOpt,[
;
;-------
; Give the CPU to the local user until DMA done
GOlocal:
	jmp	retUSER
;
;-------
; Return here when DMA is done
DMAHdone:
	call	saveUSER
	mvi	A,0C3h
	out	DMA	; turn off DMA
	ei
	ret		; return to caller
	]		; end ' LocalOpt '

  .ifn	LocalOpt,[
;----------
; Hang until DMA done
GOlocal:
	sub	A
	sta	DMAflag
	ei
..wait: lda	DMAflag
	ora	A
	jrz	..wait
	ret

DMAflag:.byte	0

;----------
; Process DMA interrupt
DMAHdone:
	push	PSW
	mvi	A,0C3h
	out	DMA
	sta	DMAflag
	pop	PSW
	ei
	ret
	]		; end ' not LocalOpt '
	]		; end ' MastOpt '

;----------
; Send a command to the hard disk
;  Regs in:   A = command byte
;  Regs out:  none
;  Destroyed: A, BC, HL
cmdHARD:
	sta	HARDcom
	lxi	B,0	; keep activity count
..1:	in	HARDP	; clear status
	mvi	A,Hd8rts; (51h) "request to send"
	out	HARDP
..2:	dcx	B	; timeout if no (or bad) disk
	mov	A,B
	ora	C
	jrz	BegHdskErr
			; jmp if hard disk is dead
..3:	in	PIOAD	; wait for HDC send
	bit	4,A
	jrz	..2
;
	in	HARDP	; check if "clear to send"
	cpi	Hd8cts	; (52h)
	jrnz	..1	; if not, retry
;
	lxi	H,HARDcom ; send the command
	lxi	B,8
	jmpr	SENDHARD

;----------
; Receive status info from the hard disk
;  Regs in:   none
;  Regs out:  A = error status
;  Destroyed: A, BC, HL
RESHARD:
	lxi	H,HARDstat
	lxi	B,8
	call	RECHARD
	lda	HARDstat+7
	ora	A
	rz
;
  .ife	Master,[
	lda	HardCom 	; check for 1k read
	cpi	Read1hard
	jrz	..ckMapping
;
	cpi	ReadHard	; check for 128 read
	jrnz	BegHdskErr
;
..ckMapping:
	lda	HardStat+7
	cpi	MapErr		; check for cpm map err
	jrnz	BegHdskErr
;
	lda	AutoRd		; if this is an AutoRd
	ora	a		; with a cpm map error
	rnz			; then just return
	]	; end ' Master '

BegHdskErr:	
	lxi	B,HardStat+1	; point to THS
HDSKerr:
	call	IOERR		; HDC error
	ori	0ffh
	ret
;
;----------
; DMA commands
  .ife	MastOpt,[
DMAHSprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	79h	; write
DMAHSadr:.word	0	; filled by SENDNET or RECstart
DMAHSsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byte	28h	; port B fixed, I/O	     1B
	.byte	95h	; byte mode		     2B
	.byte	HARDP	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect&0FFh ; interrupt vector
	.byte	92h	; active low
	.byte	0CFh	; load starting address      2C
	.byte	5	; write
	.byte	0CFh	; load starting address      1A
	.byte	0ABh	; enable interrupts	     2D
	.byte	87h	; start DMA
DMAH$	==	.-DMAHSprog
	]		; end ' MastOpt '
;
DMAHRprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	7Dh	; read
DMAHRadr:.word	0	; filled by SENDNET or RECstart
DMAHRsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byte	28h	; port B fixed, I/O	     1B
	.byte	95h	; byte mode		     2B
	.byte	HARDP	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect&0FFh ; interrupt vector
	.byte	9Ah	; active high
	.byte	0CFh	; load starting address      2C
	.byte	1	; read
	.byte	0CFh	; load starting address      1A
	.byte	0ABh	; enable interrupts	     2D
	.byte	87h	; start DMA
