  .page
  .sbttl	'READ and WRITE disk'
  .prntx	'made it to disk utilities'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +		Disk Utilities			+
; +						+
; +	last modified>	05jan84	jlw		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;
;----------
; Read disk
READ:
	call	cpmMAP	; determine device type
	cpi	0FFh
	jz	CALLerr ; error if unassigned
;
	dcx	H	; point at device byte
	mov	A,M	; put it in Acc
;
  .ife	Flop8opt,[
	cpi	SD	; check for single density
	jz	SDrd	; SD if 8 inch disks
;
	cpi	DD	; check for double density
	jz	DDrd
	]
;
  .ife	Flop5opt,[
	cpi	MINI2	; check if 2-sided floppy
	jz	M2rd
	]
;
  .ife	NETopt,[
	cpi	NET	; check for network
	jz	NETrd
	]
;
  .ife	Hard8opt,[
	cpi	HARD	; check for 8" hard disk
	jz	HARDrd
	]
;
  .ife	Hard5opt,[
	cpi	fHARD	; check for 5" hard disk
	jz	Hd5read
	]
;
	jmp	CALLerr ; if none of the above - error
;----------
; Write disk
WRITE:	
	mov	a,c	; bdos passes this param
	sta	LocType	; 0,1,or 2
	call	cpmMAP	; determine device type
	cpi	0FFh
	jz	CALLerr ; error if unassigned
;
	dcx	H	; point at device type
	mov	A,M	; put it in Acc
;
    .ife	Flop8opt,[
	cpi	SD	; check for single density
	jz	SDwr	; SD 8 inch
;
	cpi	DD	; check for double density
	jz	DDwr
	]
;
    .ife	Flop5opt,[
	cpi	MINI2	; check for 2-sided floppy
	jz	M2wr
	]
;
    .ife	NETopt,[
	cpi	NET	; check for network
	jz	NETwr
	]
;
    .ife	Hard8opt,[
	cpi	HARD	; check for 8" hard disk
	jz	HARDwr
	]
;
    .ife	Hard5opt,[
	cpi	fHARD	; check for 5" hard disk
	jz	Hd5write
	]
;
	jmp	CALLerr ; if none of the above - error
  .page
  .sbttl	'SELDSK select disk drive'
;
;-------
; 	Select disk drive
SELDSK:
	mov	A,C
	cpi	0FFh	; check for boot disk
	jrz	..ok
;
	cpi	NumDisks; check for bad disk selection
	jrc	..ok
;
	xra	a	; invalid drive request
	sta	ccpDsk	; so force drive A: and
	lxi	H,0	; return HL = 0 to CP/M
	ret

..ok:	sta	cpmDSK	; save current disk number
	call	cpmMAP	; get pointer to disk map
;
  .ife	OptFlopAny,[

	push	H	; .dpb-1
	push	D	; .dph
	push	PSW	; unit#
	dcx	H
	mov	A,M	; device type
;
	lxi	h,..exit; return to '..exit' 
	push	h	; from setflop cmd

    .ife	Flop8opt,[
	cpi	SD
	jrz	set8SD
;
	cpi	DD
	jrz	set8DD
	]
;
    .ife	Flop5opt,[
	set	5,a	; force Mini1 to Mini2
	cpi	MINI2
	jrz	set5
	]
;
	pop	h	; balance stack
			; if no type match
..exit:
	pop	PSW	; unit#
	pop	D	; .dph
	pop	H	; .dpb-1
	]		; end ' either floppy '
;
	xchg		; return pointer to DPB
	ret
  .page
  .sbttl	'Floppy specify routines for SELDSK'
;----------
; Set max sector for 8 inch SD
  .ife	Flop8opt,[
set8SD:
	lxi	b,sect8SD <8 + gap8SD
	jmpr	setSpec
;
;----------
; Set max sector for 8 inch DD
set8DD:
	lxi	b,sect8DD <8 + gap8DD
setSpec:
	lda	DS8flag
	jmpr	SPEC
	]		; end ' Flop8opt '
;
;----------
; Set 5 inch params
  .ife	Flop5opt,[
set5:
	lxi	b,sect5 <8 + gap5
	mvi	A,stp5
	]		; end ' Flop5opt '
;			; fall thru to Spec:
;----------
; Specify floppy cmd.
; entry>	a = steprrate & hd unload time
;		b = MaxSec
;		c = FlopGap
; exit>		none
  .ife	OptFlopAny,[
SPEC:
	lxi	h,MaxSec
	mov	m,b
	inx	h	; hl = .FlopGap
	mov	m,c
	sta	spFLOP+1
	in	FLOPSR
	cpi	80h	; valid FDC status
	rnz		; return if no floppy
;
	lxi	H,spFLOP
	jmp	COMMAND
;
;-------
spFLOP:
	.byte	03h	; specify command
	.byte	stp8	; steprate & hd unload time
	.byte	02h	; hd load time & dma flag
	.byte	0FFh	; - hd ld done in hardware
	]		; end ' either floppy '

  .ife	Flop8opt,[
DS8flag:		; set to stp8DS by
	.byte	stp8	; cold boot if Shugart 850
	]		; end ' Flop8opt '

;
;-------
; ** hard disk software reset **
;   - flush the disk buffers and perform the reset
; entry>	c = 0 -> reset network hard disk
;		c = 1 -> reset local hard disk
; exit>		none
InitHard:
	mov	a,c
	cpi	2
	jnc	CallErr	; don't vector wildly
;
	call	Dispatch

  .ife	Master,[
    .ife  HardShare,[
      .ife	Hard8opt, [.word	flush8hard]
      .ifn	Hard8opt, [.word	CallErr]
	]	  ; end ' HardShare '

    .ifn  HardShare,[
	.word	CallErr]	; end ' not HardShare '
	.word	CallErr	; can't have local hard disk
	]		; end ' Master '

  .ife	Station,[
	.word	CallErr	; can't reset masters' disk

    .ife  Hard8opt,[.word	flush8hard]
    .ifn  Hard8opt,[.word	CallErr]
	]		; end ' Station '

  .ife	Alone,[
	.word	CallErr	; there can't be a network disk

    .ife  Hard8opt,[.word	flush8hard]
    .ifn  Hard8opt,[.word	CallErr]
	]		; end ' Alone '
  .page
  .sbttl	'SETTRK set track'
;----------
; Set track
SETTRK:
	sbcd	cpmTRK
	ret

;----------
; Set sector
SETSEC:
	mov	A,C
	sta	cpmSEC	; save current sector number
	ret

;----------
; Set DMA address
SETDMA:
	sbcd	cpmDMA	; save current DMA address
	ret

;----------
; Set DMA size
SETBYT:
	sbcd	cpmBYT	; save current DMA size
	ret

;----------
; Sector translate
SECTRAN:

  .ife	Flop8opt,[
	push	D	; save translation table ptr
	call	cpmMAP	; get current map byte
	dcx	H	; point at disk media type
	mov	A,M	; put it in A
	pop	H	; restore translation table ptr
	cpi	SD	; is it single density
	jrz	..sd	; jump if current disk is SD
;
	]		; end ' Flop8opt '

	mov	H,B	; otherwise, compute sector+1
	mov	L,C
	inx	H
	ret

  .ife	Flop8opt,[
..sd:	dad	B	; single density translation
	mov	L,M
	mvi	H,0
	ret
	]		; end ' Flop8opt '
  .page
  .sbttl	'HOME,SEEK, DELAY'
;
;----------
; Home to track 0
HOME:	lxi	H,0
	shld	cpmTRK	; set track to 0

  .ife	OptFlopAny,[
	call	cpmMAP
	dcx	H
	mov	A,M
;
    .ife	Flop8opt,[
	cpi	SD
	jrz	..flop
;
	cpi	DD
	jrz	..flop
	]		; end ' Flop8opt '
;
    .ife	Flop5opt,[
	set	5,a	; force Mini1 to Mini2
	cpi	MINI2
	jrz	..flop
	]		; end ' Flop5opt '
	]		; end ' AnyFlopOpt '
	ret		; return if not floppy

  .ife	OptFlopAny,[

..flop: 		; arrive here if floppy
;----------
; Recalibrate a drive
reHOME:
	lda	cpmDSK
	sta	iobDSK	; iob is used in iobMAP
	lxi	H,homeFLOP+1

;----------
; Seek a track (used by HOME and READ/WRITE)
; waits for step settle unless no actual step done
; entry>	hl = adr of command(disk)
; exit>		none
SEEK:
	push	H	; save adr of current command
	call	iobMAP	; get current disk map
	pop	H
	mov	M,A	; put unit# into curr command
	dcx	H	; point to beg of curr command
	push	H	; save adr in case of NRDYerr
	call	onMOTOR ; turn on the drive motor
..seek:
	call	COMMAND	; send seek request
	lxi	b,4
	call	Delay	; wait 40 uSecs
	mvi	c,0	; flag for same track
	jmpr	..sense
;
..settle:
	mvi	c,0ffh	; not same track flag
..sense:
	lxi	H,IsenseFLOP
	call	COMMAND ; sense interrupt status
	call	RESULT
	lda	FLOPstat; get first result byte
	mov	B,A	; save status byte
	cpi	80h	; check for no status yet
	jrz	..settle
;
	push	b	; save same track flag
	ani	03	; check that status is
	mov	C,A	; about current drive
	call	iobmap	
	ani	03	; -ignore head select
	cmp	C	; if not same, then
	pop	b	; get same track flag
	jrnz	..settle; and get status again
;
;    see if the drive is ready
	mov	a,b	; get status byte again
	ani	48h	; bit 7=0,6=1,3=1 --
	cpi	48h	; seek terminated
	jrz	DrvNotReady ; due to NRDY error
;
;    see if the seek is finished
	mov	a,b
	bit	5,a	; check seek-done bit (st0,b5)
	jrz	..settle; wait till seek finished
;
;    see if the seek is ok
..skDONE:
	pop	H	; clean up stack
	ani	0D0h	; check if seek ok
	jrnz	..skERR
;
;    seek is finished and good
	mov	a,c
	ora	a
	jrz	..idle	; on same track as before
;
;    not on same track so wait for step settle
	lxi	b,StepSettle	; ~12 mSec delay
	call	delay
..idle:
	jmp	idleMOTOR ; turn off motor in 1 second
;
..skERR:
;     seek finished but bad if we got here
	lda	Mode
	bit	0,a	; check retry bit
	jrnz	reHOME	; retrying flop errors
;
	call	idleMOTOR
	mvi	a,0ffh	; adr, a=ff means seek error
	ret		; return to application
;
;----------
; Delays approx. 10 uSec per iteration @ 4 MHz
; entry>	bc = delay count in 10 uSec units
DELAY:
	dcx	B
	add	m
	add	m
	mov	a,b
	ora	c
	jrnz	DELAY
	ret

DrvNotReady:
	call	idleMotor ; turn off motor in 1 second
NRDYerr:		; label for making ErrTable
	call	IOERR			
	pop	H	; SEEK will save HL again
	inx	H
	jmpr	SEEK
	]		; end ' either floppy '
