  .page
  .sbttl	'hard 5 disk core routines'
  .prntx	'made it to hard 5 core code'

; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +	DMS-15	5 Inch Hard Disk Core Routines	      +
; +						      +
; +	last modified>	05 Dec 83 dave bradburn       +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++

OPTM0	=   OPTM0 + (1<Hard5XEB)    ; set optm map bit

;		XEBEC s1410 controller equates
;		----- ----- ---------- -------
		
CmdMode 	==	00011b	; command mode
WrDataMode	==	00001b	; write data mode
RdDataMode	==	01001b	; read data mode
RetStatMode	==	01011b	; return status mode
FixedData	==	18h	; corrected a crc error

xBusy		==	0	; busy true high
xReqXfer	==	4	; data xfer request bit
Dat$CmdPort	==	1	; output to toggle port
toggle		==	0	; switches D/C port
				; between data and cmd

xDrvReady	==	0	; test drive ready
xREAD		==	08	; read command
xWRITE		==	0ah	; write command
xSENSE		==	03	; status sense
xInitDrv	==	0ch	; initialize drive
xSEEK		==	0bh	; seek command
xRECAL		==	1	; recalibrate head
xERROR		==	02	; illegal command
xRamDiag	==	0e0h	; ram diagnostic
xIDLE		==	40h	; idle command
xInitCont	==	0	; reset controller
xSelCont	==	0c1h	; select controller
xdeSelCont	==	41h	; deselect controller
LenXebCmd	==	6

RecPerTrk	==	128	; records per track
RecSize 	==	128	; bytes per record
SecSize 	==	256	; bytes per sector
  .page
;-----------------------------------------------------;
;						      ;
;		XEBEC controller primitives	      ;
;		----- ---------- ----------	      ;
;						      ;
;-----------------------------------------------------;

;-------
; entry>	de = xxyy
; exit> 	de = xxyy/2
;		Cy = set/reset
divDEby2:
	srlr	d	; 00 -> b7, b0 -> Cy
	rarr	e	; Cy -> b7, b0 -> Cy
	ret
;
;-------
; entry>	hl = xxyy
; exit> 	hl = xxyy/2
;		Cy = set/reset
divHLby2:
	srlr	h	; 00 -> b7, b0 -> Cy
	rarr	l	; Cy -> b7, b0 -> Cy
	ret
;
;-------
; entry>	none
; exit> 	a = status
xInStatus:
	out	toggle
	in	Dat$CmdPort
	out	toggle
	ret
;
;-------
; entry>	none
; exit> 	none
xSelect:
	call	wBusyFalse
	mvi	A,xSelCont
	call	xOutStatus
	jmpr	wBusyTrue
;
;-------
; entry>	none
; exit> 	none
deSelect:
	call	wBusyTrue
	mvi	A,xdeSelCont
;				; fall into xOutStatus
;-------
; entry>	a = new status
; exit> 	none
xOutStatus:
	out	toggle
	out	Dat$CmdPort
	out	toggle
	ret
;
;-------
; entry>	none
; exit> 	none
xWaitReq:
	in	PIOAD
	bit	xReqXfer,A	; (4)
	jrz	xWaitReq
	ret
;
;-------
; entry>	none
; exit> 	none
wBusyFalse:
	call	xInStatus
	bit	xBusy,A
	jrnz	wBusyFalse	; wait till not busy
	ret
;
;-------
; entry>	none
; exit> 	none
wBusyTrue:
	call	xInStatus
	bit	xBusy,A
	jrz	wBusyTrue	; wait till busy
	ret
;
;-------
; entry>	none
; exit> 	a = Sasi status
SasiStat:
	call	xWaitReq
	call	xInStatus	; get bus status
	ani	0fh
	ret
;
;-------
; entry>	hl = .command string
;		 b = command length
; exit> 	none
xCmdSend:
	call	xWaitReq
	mov	A,M
	out	Dat$CmdPort
	inx	H
	djnz	xCmdSend
	ret
;
;-------
; entry>	a  =	command code
; exit> 	none
CmdHard5:
	push	H
	lxi	h,xOPcode
	mov	M,A
	call	xSelect
	call	SasiStat
	cpi	CmdMode
	jrz	..sendCmd
;
	call	xHaveErr	; not in command mode
	lda	xOPcode 	; retrieve command code
	pop	h		; clean up stack
	jmpr	CmdHard5
;
..sendCmd:
	call	deSelect
	mvi	B,LenXebCmd	; (6)
	call	xCmdSend
	pop	H
	ret
;
;-------
; This version treats b = page count and c = byte count
; thus bc = 0006 will transfer (64k +6 bytes) !
; This code is optimized for skew of 6
; entry>	hl =	buffer adr
;		bc =	block count
; exit> 	none
xRcvData:
	mov	d,b		; page count in D
	mov	b,c		; byte count in B
	mvi	c,Dat$CmdPort	; port# in C
;
..xread:
	call	SasiStat	; get the bus status,
	cpi	RdDataMode	; leave if not in
	rnz			; read data mode
;
..rloop:
	in	PIOAD		; check for data ready
	bit	xReqXfer,A	; (4)
	jz	..rloop 	; inline for speed
;
; the timing charts say that once data is available we
; shouldn't need to check status until the next sector

	inir			; move 256 bytes to mem
	dcr	d		; do for D times
	jrnz	..xread
	ret
;
;-------
; This version treats b = page count and c = byte count
; thus bc = 0006 will transfer (64k +6 bytes) !
; This code is optimized for skew of 6
; entry>	hl =	buffer adr
;		bc =	block count
; exit> 	none
xSendData:
	mov	d,b		; page count in D
	mov	b,c		; byte count in B
	mvi	c,Dat$CmdPort	; port# in C
;
..xwrite:
	call	SasiStat	; get the bus status,
	cpi	WrDataMode	; leave if not in
	rnz			; write data mode
;
..wloop:
	in	PIOAD		; check for data ready
	bit	xReqXfer,A	; (4)
	jz	..wloop 	; inline for speed
;
; the timing charts say that once data is available we
; shouldn't need to check status until the next sector

	outir			; wr 256 bytes to disk
	dcr	d		; do for D times
	jrnz	..xwrite
	ret
;
;-------
; entry>	none
; exit> 	Z set for success
xGetRetStatus:
	call	SasiStat
	cpi	RetStatMode
	jrnz	xHaveFatal	; not in result mode!
;
	in	Dat$CmdPort
	push	psw		; save the status byte
	call	xWaitReq
	in	Dat$CmdPort	; this byte's always 0
	pop	psw		; a = the status byte
	ani	0dfh		; mask off volume#
	ret			; a = 0 means no error
;
;-------
; entry>	none
; exit> 	none
xInErrBytes:
	mvi	A,xSENSE
	call	CmdHard5
	lxi	H,xErrBuf
	lxi	b,4 <8 +Dat$CmdPort
..inErr:
	call	xWaitReq	; get the 4 error bytes
	ini
	jrnz	..inErr
	ret
;
;-------
; entry>	stack = .1st caller, .2nd caller
; exit> 	stack = .1st caller, .2nd caller
xHaveErr:
	call	xInErrBytes	; get the error bytes
	call	xGetRetStatus	; check for 2nd error
	jrnz	xHaveFatal	; exit if fatal error
;
	lda	xErrBuf 	; see if last operation
	ani	03fh		; gave a corrected Crc
	cpi	FixedData	; error - caller will
	rz			; recover if so
;
	lxi	h,xNotFatalErr	; print '***'
	jmpr	xRetryErr
;
;-------
; entry>	none
; exit> 	hl = .string
xHaveFatal:
	lxi	h,xFatalErr	; print '*** Fatal'
;				; fall into xRetryErr
;-------
; entry>	stack = adr1, adr2
;		hl    = .string
; exit> 	stack = adr1, adr2
xRetryErr:
	call	PrtMsg

; hl>		don't care
; stack>	adr1, adr2
	lxi	h,xRestofErr	; print
	call	PrtMsg		; '*** Hard5 error at '
	pop	h

; hl>		adr2	(.ret of last caller)
; stack>	adr1	(.ret of first caller)
	xthl

; hl>		adr1	(.ret of caller of err caller)
; stack>	adr2	(.ret of error caller)
	call	PrtCallAdr	; print first caller
	xthl

; hl>		adr2	(.ret of last caller)
; stack>	adr1	(.ret of first caller)
	push	h

; hl>		don't care
; stack>	adr1, adr2
	call	xDumpErrBufs	; display buffers

  .ife	Master,[jmp	WaitMaster]
  .ifn	Master,[jmp	waitUser]

;
;-------
; entry>	none
; exit> 	none
xDumpErrBufs:
	lxi	H,xCmdMsg	; print 'command> '
	call	PrtMsg
	lxi	H,xOPcode
	mvi	B,LenXebCmd	; (6)
	call	PrtBuf
	lxi	H,xStatusMsg	; prt 'status> '
	call	PrtMsg		; and error buf
	lxi	H,xErrBuf
	mvi	B,4		; 4 error bytes
	jmp	PrtBuf

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	end of 5 inch hard disk core drivers	+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++
++++++
; +						+
; +	end of 5 inch hard disk core drivers	+
; +						+
; ++++++++++++++++++++++++++++