


  .page
  .sbttl	'Automatic Assembly Options (b83cnfg.asm)'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Automatic Assembly Option Selections	+
; +						+
; +	last modified>	25apr84 msh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Manual Assembly Option Selection +
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
; flag to ask user for standard config options
cnfgask	==	1	; 0 = don't ask user
			; 1 = ask user

; if cnfgask = 0, must set config = something 
;
; When config = 0, the user will be prompted for
; all assembly options.  
; When config = anything else, a set of equates
; are selected below.
;
  .ife cnfgask,[ config == 0 ]  ; interactive mode

  .ifn cnfgask,[
config	=\	'      0 => Interactive option selection
      1 => Standard 5" master
      2 => Standard 8" master
      3 => Standard no local storage station
      4 => Standard 8" local hard/flop station
      5 => Standard 5" local hard/flop station
      6 => Standard 5" FOX local flop station
      7 => Standard 8" local floppy station	
      8 => Standard 5" Floppy only Stand-alone
      9 => Standard 8" Floppy only Stand-alone
choice  => '
	] ; end 'cnfgask'

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		5" master			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; 5" master.
;
  .ife 		config-1,[
Select	==	2	; network master
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos 
HardMast ==	0	; Select hard disk master
Hard5opt ==	0	; 5" hard disks
Flop5opt ==	0	; 5" floppy disks
numusr	==	32	; number of users max
numlock	==	64	; number of lockstrings
FoxOpt	==	0	; parallel port console
WriteModes ==	0	; enable write modes
.title	'DMS 15 MASTER LISTING'
	] ; end config = 1

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		8" master			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; 8" master.
;
  .ife 		config-2,[
Select	==	2	; network master
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos 
HardMast ==	0	; Select hard disk master
Hard5opt ==	1	; 8" hard disks
Flop5opt ==	1	; 8" floppy disks
numusr	==	64	; number of users max
numlock	==	128	; number of lockstrings
FoxOpt	==	1	; serial console
WriteModes ==	0	; enable write modes
.title	'DMS 3/10X MASTER LISTING'
	] ; end config = 2

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		No Local Storage		+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; HiTPA station.
;
  .ife 		config-3,[
Select	==	3	; network station
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos
HaveHard ==	7	; Neither hard disks
HaveFlop ==	7	; Neither floppy disks
FoxOpt	==	1	; serial console
WriteModes ==	0	; enable write modes
AH3opt	==	0	; Port 3 buffered
BuffOpt ==	0	; Net buffer option
.title	'STATION WITH NO LOCAL STORAGE'
	] ; end config = 3

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		8" Station			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; 8" local storage station.
;
  .ife 		config-4,[
Select	==	3	; network station
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos
HaveHard ==	1	; 8" hard disks
HaveFlop ==	1	; 8" floppy disks
FoxOpt	==	1	; serial console
WriteModes ==	0	; enable write modes
AH3opt	==	0	; Port 3 buffered
BuffOpt ==	0	; Net buffer option
.title	'DMS 3/10X STATION'
	] ; end config = 4

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		501 Station			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; 501 station.
;
  .ife 		config-5,[
Select	==	3	; network station
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos
HaveHard ==	0	; 5" hard disks
HaveFlop ==	0	; 5" floppy disks
FoxOpt	==	0	; parallel port console
WriteModes ==	0	; enable write modes
AH3opt	==	0	; Port 3 buffered
BuffOpt ==	0	; Net buffer option
.title	'DMS 15 STATION'
	] ; end config = 5

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		FOX Station			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; FOX station.
;
  .ife 		config-6,[
Select	==	3	; network station
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos
HaveHard ==	7	; no hard disks
HaveFlop ==	0	; 5" floppy disks
FoxOpt	==	0	; parallel port console
WriteModes ==	0	; enable write modes
AH3opt	==	0	; Port 3 buffered
BuffOpt ==	0	; Net buffer option
.title	'DMS FOX STATION'
	] ; end config = 6

;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	Select Auto Assembly Option Selection   +
;+		8" Floppy Station		+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
;
;---------
;
; When config = 0, the user will be prompted for
; assembly options.  This  selects a standard
; 8" floppy local storage station.
;
  .ife 		config-7,[
Select	==	3	; network station
NumDisks ==	4	; 4 CP/M drive letters
HiDosOpt ==	0	; Select HiDos
HaveHard ==	7	; 8" hard disks
HaveFlop ==	1	; 8" floppy disks
FoxOpt	==	1	; serial console
WriteModes ==	0	; enable write modes
AH3opt	==	0	; Port 3 buffered
BuffOpt ==	0	; Net buffer option
.title	'DMS 3 FLOPPY STATION'
	] ; end config = 7

;--------------------------------------------------
;     5" floppy only stand-alone (fox)
;--------------------------------------------------

  .ife		config-8,[
Select		==	1	;Stand-alone
NumDisks	==	2	;2 CPM drives
HiDosOpt	==	0	;select HiDos
eitherHARD	==	1	;no hard disks
Flop5boot	==	0	;5" floppies
FoxOpt		==	0	;polled console
WriteModes	==	1	;no write modes
.title	'DMS FOX STANDALONE'
	] ; end config = 8

;--------------------------------------------------
;     8" floppy only stand-alone (DMS-3)
;--------------------------------------------------

  .ife		config-9,[
Select		==	1	;Stand-alone
NumDisks	==	2	;2 CPM drives
HiDosOpt	==	0	;select HiDos
eitherHARD	==	1	;no hard disks
Flop5boot	==	1	;8" floppies
FoxOpt		==	1	;interrupt console
WriteModes	==	1	;no write modes
.title	'DMS 3 STANDALONE'
	] ; end config = 9

