  .page
  .sbttl	'cold boot code   (b83cboot.asm)'
  .prntx	'
made it to cold boot code'
; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +		Cold Boot Code			+
; +						+
; +	last modified>	 84apr26 (msh)		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

; The cold boot code is stored in one of two places,
; depending upon the boot device:
;
;	If booting a floppy disk system or a floppy
; network master, the cold boot code is loaded into the
; non-initialized memory reserved for the check and
; allocation vector buffers / DirBuf / and RdBuff.

Fbootoff	== lenBoot - lenRdBuf

.ife	BootFlopAny,	    [.loc RdBuff - Fbootoff]
.ife	Master!FlopShare,   [.loc RdBuff - Fbootoff]

; If booting a hard disk system or a network system
; the cold boot code is located below the BIOS.

.ife	NetBoot&BootHardAny,[.loc Bios - lenBoot]

	prodtype == 10c6h ; product address in 
			  ; BP2/Z80
;----------
; Prepare for interrupts
CBOOT:
	di
	lxi	SP,80h
	mvi	A,(vectors>8)&0FFh
	stai		; setup interrupt register
	im2
;----------
; If floppy and BIOS < 0F000h, move the
; high memory constants to where they belong
  .ife	Flop8boot,[
    .ifg	0F000h-BIOS,[

; ..srce is the addr of the high mem constants

..srce	=	highcon-(0F000h-BIOS)
	lxi	H,..srce
	lxi	D,highcon
	lxi	B,0ffffh-highcon+1 ; # bytes to move
	ldir
	]		; end ' move constants '
	]		; end ' Flop8boot '
;----------
; Initialize serial no, IOBYTE, drive, error count
	sixd	serial	; store serial number
	siyd	serial+2
	lda	IOBYTE
	sta	3	; initialize IOBYTE
	sub	A
	sta	4	; active drive = 0
	sta	errNET
	sta	errFLOP ; init err cnts to 0
	lda	DEFmode 
	sta	Mode	; default mode bits
	lda	hertz
	sta	ticsec	; ticks per second
;----------
; Initialize timer and network user number
  .ife	BootFlopAny&BootHardAny&master,[
	lxi	H,ticks
	mvi	B,7
init0:
	mvi	M,0	; set to zero
	inx	H
	djnz	init0
;
	mvi	A,0FFh	; default network user number
	sta	NETusr
	]	; end ' non station boot '

  .ife	Station,[
	lda	BOOTnum
	sta	NETusr
	lda	IOBdef
	sta	3	; get iobyte from bp2/z80
	lxi	H,BOOTclk
	lxi	D,ticks
	lxi	B,7
	ldir
	lda	prodtype
	sta	prodval
	]	; end 'station boot'

;----------
; Initialize port 1
	lxi	H,baud1
	lxi	B,2<8+CTC1
	outir		; set baud rate for port 1
	lda	baud1+1
	cpi	2	; if 500Khz, then RS-422
	jrz	..port2 ; so don't initialize RS-232
;
	lxi	H,rs232
	lxi	B,rs232$<8+SIO1BC
	outir		; program SIO for port 1
;----------
; Initialize port 2
..port2:
	lxi	H,baud23
	lxi	B,2<8+CTC2
	outir		; set baud rates for ports 2,3
	lxi	H,rs232
	lxi	B,rs232$<8+SIO2AC
	outir		; program SIO for port 2
;----------
; Initialize port 3
	lxi	H,rs232
	lxi	B,rs232$<8+SIO2BC
	outir		; program SIO for port 3
;----------
; Initialize SIO interrupt vectors
	mvi	A,2
	out	SIO1BC
	mvi	A,SIO1vect&0FFh
	out	SIO1BC	; setup SIO-1 vectors
	mvi	A,2
	out	SIO2BC
	mvi	A,SIO2vect&0FFh
	out	SIO2BC	; setup SIO-2 vectors
;----------
; Specify floppy seek rate
  .ife	OptFlopAny,[
	in	FLOPSR
	cpi	80h	; check whether floppy exists
	jrnz	..noflop; skip specify if no floppy
;
	lda	FLOPmdl
	ora	A	; seek rate 8ms for Shugart 800
	jrz	..specify
;
	mvi	A,stp8DS; seek rate 3ms for Shugart 850
	sta	specFLOP+1

    .ife	Flop8opt,[
	sta	DS8flag ; for SelDsk specifying
	]		; end ' Flop8opt '

..specify:
	lxi	H,specFLOP
	call	COMMAND ; specify floppy facts
..noflop:
	]		; end ' either floppy '

;----------
; If timer-option has been selected, enable
; real-time interrupts
  .ife	TIMERopt,[
	lda	hertz
	cpi	62
	jrz	..62hz
;
; External user-selectable hertz rate
	mvi	A,0C5h	; enable real-time interrupts
	out	CTC3
	mvi	A,1	; interrupt at power hertz rate
	out	CTC3
	jmpr	..ok
;
; Internal fixed hertz rate (62 hertz)
..62hz:
	mvi	A,0A5h	; enable real-time interrupts
	out	CTC3
	mvi	A,252	; interrupt at 4Mhz/(256*252)
	out	CTC3
..ok:	mvi	A,CTCvect&0FFh ; interrupt vector
	out	CTC0	; must send to channel zero
	]		; end ' timer int '

;----------
; If front-panel option has been selected, enable
; front-panel interrupts
  .ife	FRONTopt,[
	mvi	A,PIOvect&0FFh ; interrupt vector
	out	PIOAC
	mvi	A,10110111b ; enable interrupts
	out	PIOAC
	mvi	A,01111111b ; front-panel/HLT
	out	PIOAC
	]		; end ' FRONTopt '

;----------
; If type-ahead option selected, enable receiver ints
  .ife	AHEADopt,[
			; initialize port 0
	mvi	A,11h	; write SIO register 1
	out	SIO1AC

  .ife	MASTopt,[mvi	a,0]	; no receiver ints
		[mvi	a,18h]	; enable rcver ints

	out	SIO1AC
;
; Initialize port 1
	mvi	A,11h	; write to channel B
	out	SIO1BC
	mvi	A,00000100b ; status affects vector
	out	SIO1BC
	]		; end ' AHEADopt '
;
; Initialize port 3 for type-ahead
  .ife	AH3opt,[
	mvi	A,11h	; write SIO register 1
	out	SIO2BC
	mvi	A,00011100b ; enable Rx interrupt
			    ; no Tx interrupt
	out	SIO2BC
	]		; end '  ahead3 opt '
;
;----------
; Print CP/M message
  .ifn	station,[
	lxi	H,CPMmsg
	call	PRTMSG
	]
	ei		; interrupts OK now
  .page
;
;-----------------------------------------------------
;  M A S T E R	 I N I T I A L I Z A T I O N
;-----------------------------------------------------
; If master option has been selected, clear various
; tables, then wait for local user to login

  .ife	MastOpt,[
; Restart master if front-panel int during cold boot
	mvi	A,0C3h
	sta	30h	; setup jump to goMAST
	lxi	H,goMAST
	shld	31h
;
; init master stack (aids debugging)
	lxi	H,EndMastStack
	lxi	B,MastStack-EndMastStack	
..vFill:
	mvi	M,'v'	; fill memory from f500
	inx	H	; down thru end of 
	dcx	B	; the master's stack
	mov	A,B	; with known value
	ora	C
	jrnz	..vFill
;
; init slowTBL with pollSKIP value
	lxi	H,slowTBL
	mvi	B,numusr
..pfill:
	mvi	M,pollSKIP
	inx	H
	djnz	..pfill	
;
; Clear user name list
	lxi	D,USERlist
	mvi	B,numusr
..init:
	push	B
	lxi	H,inituser
	lxi	B,16
	ldir
	pop	B
	djnz	..init
;
	sub	A	
	sta	userlist; dont touch local user
	sta	NETusr
;
; Clear lock list
  .ife	HARDshar,[
	lxi	H,locklist
	mvi	M,0FFh
	lxi	D,locklist+1
	lxi	B,16*numlock-1
	ldir
;
; Clear spool list
	lxi	H,SPOOLlist
	mvi	M,0E5h
	lxi	D,SPOOLlist+1
	lxi	B,16*lenSPOOL
	ldir
;
    .ife	Hard5opt,[

; init offset table for alloc table
	mvi	a,HighAlloc
	sta	HighAdr
	lxi	h,MidAlloc <8 +LowAlloc
	shld	ReqLogAdr	; point to alloc table
	xra	a
	sta	ActVol		; set volume 0
	call	Phys1kRead	; read the alloc table
	call	BldOffTable
	]		; end ' Hard5opt '

;
; init user read history table
	lxi	h,SeqList
	lxi	d,SeqList+1

  .ife	Hard5opt,[lxi	b,(NumUsr*2)-1]
  .ife	Hard8opt,[lxi	b,(NumUsr*5)-1]

	mvi	m,0ffh
	ldir
;
; init user preRead table
	lxi	H,PreDesc
	lxi	D,PreDesc+1
	lxi	B,lenNewDesc
	mvi	M,0FFh
	ldir
;
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; ~	- alloc control byte bit map -		~
; ~						~
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;
;  7   6   5   4   3   2   1   0
; --- --- --- --- --- --- --- ---
;  |   |  | Dsk |  |  | Op. Sys |
;  |   |  -------  |  ----------- 
;  |   |     |	   |	    |	 |_ 000  ->  cp/m -80
;  |   |     |	   |	    |	 |_ 001  ->  msdos
;  |   |     |	   |	    |____|_ 010  ->  ccp/m -86
;  |   |     |	   |		 |_ 011  \
;  |   |     |	   |		 |_ ---   >  reserved
;  |   |     |	   |		 |_ 111  /
;  |   |     |	   |
;  |   |     |	   |_______________   x      reserved
;  |   |     |
;  |   |     |			  
;  |   |     |			 |_  00  ->  read/write
;  |   |     |___________________|_  01  ->  read/only
;  |   |			 |_  10  ->  ownable
;  |   |			 |_  11  ->  reserved
;  |   |
;  |   |___________________________   1  ->  Shared
;  |
;  |_______________________________   1  ->  TapeBackUp
;

  .ife	WriteModes,[

; init WrMode.Table (Write_Mode_Control_Table)
	call	Init2err	; init to GenericErr

; modify WrMode.Table by the alloc tables
	call	InitVolsPresent

; modify WrMode.Table by the Ownership table
	call	InitOwnedMode
	]		; end ' WriteModes '

;
; assign unit0 to drive 'a'
	mvi	C,0
	lxi	h,Unit0Name
	call	AssDef
;
; Check whether another master is already on the net
ckmast:
	mvi	A,11111001b ; receive anyone's message
	sta	RECable
	lxi	H,1000h ; throw away net junk
	lxi	B,1000h ; of course, its never this big
	lxi	D,$1sec
	call	RECNET
	bit	timeout,A	; test timeout bit
	mvi	A,11111101b ; restore receiver control
	sta	RECable
	jz	goSPOOL ; jump if net is idle
;
; init user name to 'Mimicker'
	xra	a
	sta	MastUsr ; we are the master user
	call	CurUsr	; adr of name field
	inx	h	; hl = .usrTbl(name)
	lxi	d,MimicName
	xchg
	lxi	b,8
	ldir
;
; Ask whether mimic mode should be entered
	lxi	H,BUSYmsg
	call	PRTMSG	; first tell user net is busy
..ask:
	lxi	H,MIMask
	call	PRTMSG	; ask for mimic mode
	lxi	H,BOOTnam
	mvi	E,1
	call	INMSG
	lda	BOOTnam
	cpi	'M'	; type 'M' to start mimicking
	jrnz	..ask
;
WaitMime:
	lxi	h,CrLf
	call	PrtMsg
;
; Wait for a poll or a write request
mimicry:
	lxi	H,MASTcom
	lxi	B,lencom
	lxi	D,$4sec
	mvi	A,MIMICusr
	call	RECNET
	bit	timeout,A
	cz	MIMerr	; timeout
;
	ani	crc$ovr ; crc or ovrun err
	cnz	MIMerr
;
	lda	MASTcom
	cpi	poll	; check for poll
	jrz	..ack
;
	cpi	writeNET; check for write request
	jrz	..write
;
	cpi	spoolNET; check for spool request
	jrz	..write
;
	call	MIMerr	; bad message

; Answer a poll
..ack:
	mvi	A,pollack
	mvi	E,$halfms
	call	SENDMSG ; acknowledge the poll
	mvi	C,'M'	; print 'M' so that everyone
	call	ConOut	; knows that we're mimicking

  .ife	Hard5opt,[
	lda	Hd5busy
	ora	a
	jrnz	mimicry	; disk is busy
;
	push	x	; flush a disk buffer
	call	LruFlush
	pop	x
	]			; end ' Hard5opt '

	jmpr	mimicry
;
; Process a write request
..write:
	mvi	A,mesack
	mvi	E,$halfms
	call	SENDMSG ; acknowledge message receipt
	lxi	H,MASTbuf
	lxi	B,128
	lxi	D,$16ms
	mvi	A,MIMICusr
	call	RECNET	; get sector to be written
	call	ckRECstat
	jrnc	..0good

..fail:
	mvi	e,$halfms ; 1/2 ms delay
	mvi	a,nack	; let master know that
	call	sendmsg ; something went wrong
	call	MIMerr

..0good:
	call	qDMAlen ; rcv'd data len error
	jrnz	..fail
;
	lxi	H,MASTbuf
	call	MMwrite ; write data to disk
	mvi	A,datack
	mvi	E,0	; no delay
	call	SENDMSG ; acknowledge that data is OK
	jmp	mimicry
;
; Handle a mimicry error (print message and address)
MIMerr:
	lxi	H,MIMmsg
	call	PRTMSG	; print message
	pop	h	; get caller's adr
	call	PrtCallAdr; compute caller's adr
	call	NetErr	; show error buf

; don't restore return adr, just jump back to mimicry
; this code not implemented yet because it requires
; net protocol changes
;	mvi	E,$halfms ; 1/2 ms delay
;	mvi	A,nack	; let master know that
;	call	sendmsg ; something went wrong
	jmp	WaitMime
	]		; end ' HARDshare '
;
;----------
; Open SPOOL partition
goSPOOL:
  .ife	SPOOLopt,[
	lxi	H,SpoolUnit
	call	ASSIGN
	cpi	0FFh	; unit number in A
	jrz	goMAST	; jump if no spool partition
			; SPLsiz is initially 0
;
	sta	SPLdsk	; spool partition number
	mov	A,D
	sta	SPLvol	; HD drive (volume) number
	mov	B,C	; size byte (1-5)
	sub	A
	stc
..rot:
	ral		; convert (1-5) to (1-8)
	djnz	..rot
;
	ani	1fh	; 256K-4M only
	sta	SPLsiz
	jz	SPOLerr ; any other is invalid
;
; Read initial spool job table from spool partition

	lda	3	; get IObyte
	ori	0e0h	; assign spooler
	sta	3
	lda	SPLvol
	mov	B,A	; B is volume number
	lda	SPLdsk	; partition (unit) number
	lxi	D,0	; track
	mvi	C,1	; sector
	lxi	H,SPOOLlist
	call	HARDr
;
	lda	SPLvol	; HD drive (volume) number
	mov	B,A	; B has volume no. for HARDr
	lda	SPLdsk	; partition (unit) number
	lxi	D,0	; track
	mvi	C,2	; sector
	lxi	H,SPOOLlist+128
	call	HARDr
;
; If master started spooling, kill spool job
	lxi	D,(0<8)!SPLstart
	call	JOBmatch
	jrnz	..1
;
; If master was spooling, kill spool job
	lxi	D,(0<8)!SPLspool
	call	JOBmatch
	jrz	..2

..1:	mvi	M,SPLabort ; kill spool job

; If any spool job was printing, set to waiting
..2:
	lxi	D,(0FFh<8)!SPLprint
	call	JOBmatch
	jrz	..3
;
	mvi	M,SPLready; set status to "ready"
;
;	Enable serial printer interrupts
..3:
	mvi	A,11h
	out	SIO2AC
	mvi	A,00000011b; enable transmitter int
	out	SIO2AC
;
;	Enable parallel printer interrupts
;	- no parallel printer on DMS-15

  .ife	Hard8opt,[
	mvi	A,PIOvect&0FFh
	out	PIOAC
	mvi	A,00010111b
	out	PIOAC	; allow int on PIO-A bit 6 low
	mvi	A,10111111b
	out	PIOAC
	]		; end ' Hard8opt '
	]		; end ' SPOOLopt '
;-----------
; It's OK to wake the master now
goMAST:
	lxi	SP,80h
	mvi	A,wakeupMAST
	sta	timeMAST
	sub	A
	sta	upMAST
;
; Ask for date
  .ife	HARDshar,[
..daterr:
	lxi	H,DATEmsg
	call	PRTMSG
	lxi	H,BOOTdate
	mvi	M,cr
	mvi	E,1	; echo string
	call	INMSG
	mvi	M,cr
	lxi	H,BOOTdate
	mov	A,M
	cpi	cr	; abort if RETURN
	jz	ASKlog
;
	call	getnum	; get month
	cpi	1
	jrc	..daterr
;
	cpi	13
	jrnc	..daterr
;
	sta	BOOTdate+month
	mov	A,M	; check delimiter
	cpi	'/'
	jrnz	..daterr
;
	inx	H	
	call	getnum	; get day
	cpi	1
	jrc	..daterr
;
	cpi	32
	jrnc	..daterr
;
	sta	BOOTdate+day
	mov	A,M	; check delimiter
	cpi	'/'
	jrnz	..daterr
;
	inx	H	
	call	getnum	; get year
	cpi	80
	jrc	..daterr
;
	cpi	100
	jrnc	..daterr
;
	sta	BOOTdate+year
	mov	A,M	; check for RETURN at end
	cpi	cr
	jrnz	..daterr
;
; Ask for time
..timerr:
	lxi	H,TIMEmsg
	call	PRTMSG
	lxi	H,BOOTdate
	mvi	M,cr
	mvi	E,1
	call	INMSG
	mvi	M,cr
	lxi	H,BOOTdate
	call	getnum	; get hours
	cpi	24
	jrnc	..timerr
;
	sta	BOOTdate+hrs
	mov	A,M	; check delimiter
	cpi	':'
	jrnz	..timerr
;
	inx	H
	call	getnum	; get minutes
	cpi	60
	jrnc	..timerr
;
	sta	BOOTdate+mins
	mov	A,M	; check for RETURN at end
	cpi	cr
	jrnz	..timerr
;
	sub	A
	sta	BOOTdate+secs
	di
	lxi	H,BOOTdate+secs
	lxi	D,secs
	lxi	B,6
	ldir		; set time
	ei
;
; Ask master user for his login name
ASKlog:
	lxi	H,LOGmsg
	call	PRTMSG
..askname:
	call	askname
	mvi	A,loginNET
	sta	NETcom
	call	NETreq
	lda	NETassn
	ora	A	; A = 0 if login accepted
	jrz	..logged
;
	mvi	C,bell	; ring bell if login denied
	call	conout
	jmpr	..askname

..logged:
	]		; end ' HARDshare '
	]		; end ' MastOpt '
  .page
;----------
; Initialize type-ahead buffer
  .ife	HardShare!(AheadOpt&Station),[
	di
	lda	INLENdef
	ani	typeahead
	sta	nxtin	; number of chars
	mvi	A,typeahead
	sta	nxtout
	lxi	H,INBUFdef
	lxi	D,PORT0buf
	lxi	B,typeahead
	ldir		; type-ahead chars
	ei
	]	; end 'HardShare and (Ahead | Station)'

;-------
; Init Hard5 disk tables if flopBoot with Hard5opt
   .ife BootFlopAny ! Hard5opt,[
	call	Init5hard
	]		; end ' FlopBoot w/Hard5opt '
;
;----------
; Assign default disks on hard disk network

    .ife	station!Hard5opt,[
	lda	3		; default IOBYTE
	bit	qHrd5,a 	; iobyte bit 3 = 1
	cnz	Init5hard	; if hard5 present
	]		; end ' Hard5 station '

  .ife	HARDshar,[

..dfltDrvs:
	lxi	H,DSK0def
	mvi	C,0
	call	ASSdef	; CP/M 'A' drive
	lxi	H,DSK0def+8
	mvi	C,1
	call	ASSdef	; CP/M 'B' drive
	lxi	H,DSK0def+16
	mvi	C,2
	call	ASSdef	; CP/M 'C' drive
	lxi	H,DSK0def+24
	mvi	C,3
	call	ASSdef	; CP/M 'D' drive

  .ife	WriteModes,[
; build the write permission table
; - init it to generic error status
	lxi	h,ModeTable
	mvi	b,NumDisks	; init drives to error
..errFill:
	mvi	m,GenericErr
	inx	h
	djnz	..errFill
;
; now init first 4 drives to actual status
	lxi	h,ModeTable

  .ifg	NumDisks -4,[mvi   b,4]
  .ifle NumDisks -4,[mvi   b,NumDisks]

	mvi	c,0
..makeMode:
	push	b
	push	h
	call	SelDsk	; rets de = .dpb(unit)
	lxi	h,dpbCtlDisp
	dad	d	; hl = .dpb(control)
	mov	a,m
	call	WrControl	; rets type in B
	pop	h
	mov	m,b	; save current Wr_Mode_Status
	inx	h
	pop	b
	inr	c
	djnz	..makeMode
;
; request write status on drives if relevant

  .ifg	NumDisks -4,[mvi   b,4]
  .ifle NumDisks -4,[mvi   b,NumDisks]

	mvi	c,0
	lxi	h,Dsk0def
..writeGrant:
	push	b
	push	h
	call	autoGrant	; maybe request writing
	pop	h
	lxi	b,8
	dad	b		; hl = .Dsk(i)def
	pop	b		; b = count, c = drive#
	inr	c		; next drive
	djnz	..writeGrant
	]		; end ' WriteModes '
	]		; end ' HARDshare '
;
;----------
; Assign default disks on hard disk stand-alone system
  .ife	BootHardAny,[
	mvi	C,0FFh
	call	SELDSK

    .ife	Hard5boot,[
	call	Init5hard	; init hard5 tables
	lxi	H,actBUF	; copy first 4 alloc
	lxi	D,DSK0def	; table entries for
	lxi	B,64		; default assignments
	ldir
	]		; end ' Hard5boot '

    .ifn	Hard5boot,[
	call	HOME
	lxi	B,0
	call	SETTRK
	mvi	C,121	; first sector of alloc table
	call	SETSEC
	lxi	B,DSK0def
	call	SETDMA
	call	READ	; read beginning of alloc table
	]		; end ' not Hard5boot '

	lxi	H,DSK0def+17
	mvi	C,0
	call	ASSdef	; CP/M 'A' drive
	lxi	H,DSK0def+33
	mvi	C,1
	call	ASSdef	; CP/M 'B' drive
	lxi	H,DSK0def+49
	mvi	C,2
	call	ASSdef	; CP/M 'C' drive
; 
  .ife	DriveDopt!BootHardAny,[
	lxi	H,DSK0def+65	; skip past size byte
	mvi	B,14
..blNAME:
	mvi	M,' '	; blank fill name & password
	inx	H
	djnz	..blNAME
;
	lxi	H,DSK0def+65

    .ife	Hard5boot,[mvi	M,'M']	; default drive
    .ife	Hard8boot,[mvi	M,'D']	; 'D' to floppy

	inx	H	; to minifloppy 0
	mvi	M,'0'
	dcx	H	; adr of name in alloc table
	mvi	C,3
	call	ASSdef	; CP/M 'D' drive
	]		; end ' DriveDopt Hard5boot '
;
  .ifn	DriveDopt!Hard5boot,[
	lxi	H,DSK0def+65
	mvi	C,3
	call	ASSdef
	]	; end ' not Hard5boot and DriveDopt '
	]	; end ' BootHardAny '

  .ife (BootHardAny & Master),[
;-----------------------------------------------
; locate appropriate CP/M kernel by looking it up
; in System Directory.	Put relevant parameters into
; warm-boot area so we can warm-boot.

	call	DIRsetup	; get set to read dir
	mvi	B,128	; max entries in sys dir
..ent:	push	B
	mvi	B,24	; length of an entry
	lxi	H,..buf
..chr:	push	B
	call	getc	; get a character
	mov	M,A
	inx	H
	pop	B
	djnz	..chr	; get until 24 are got

	lxi	H,..buf ; see if name is right!
	lxi	D,kernel
	mvi	B,8	; length of name
..cmp:	ldax	D
	cmp	M
	inx	H
	inx	D
	jrnz	..no
	djnz	..cmp
;
..yes:	lhld	..buf+10	; track
	shld	yWarmTrack

	lda	..buf+12	; sector
	sta	yWarmRecord

	lda	..buf+13	; low byte of length
	sta	yNumCPMRecs

	lhld	..buf+15	; low word of load addr
	shld	yCPMbase

	jmp	gWARM 
;
;------- 
..no:	pop	B
	djnz	..ent	; try again
	lxi	H,muckup
	call	PRTMSG
	rst	7	; go off to die

..buf:	.blkb	24

muckup: .ascii	[cr][lf]"Cannot find system file "

zOS.hi	=	((bios>12) & 0Fh) + '0'
zOS.low =	((bios>8)  & 0Fh) + '0'

  .ifg	zOS.hi -'9', [
		zOS.hi	= zOS.hi  + 'A' - ('9' +1)]

  .ifg	zOS.low -'9',[
		zOS.low = zOS.low + 'A' - ('9' +1)]

kernel:
.ife Hard5opt, [.byte '5']	      ; Hard Disk
	       [.byte '8']
.ife Flop5opt, [.byte '5']	      ; Flop Disk
	       [.byte '8']
.ife HiDosOpt, [.byte 'H']	      ; HMBDOS for HiDos
	       [.byte 'C']	      ; DCBDOS for CP/M
	.ascii	"MBDOS"
	.byte	0
DIRsec: .byte	0		      ; hard disk sector
DIRcnt: .byte	0		      ; chars remaining

	] ; end "hard boot or master "

  .ife Station, [
; Get DPM vital statistics from the Boot Phase 2 load list
; (they were thoughtfully put there for us by the Master)

	lhld	WBdef+2        ;"track" field of the 2nd
	shld	yWarmTrack     ; item in the load list

	lda	WBdef+4        ; sector
	sta	yWarmRecord

	lda	WBdef+5        ; low byte of length
	sta	yNumCPMRecs

	lhld	WBdef+7        ; load address
	shld	yCPMbase

	]	; end "station"

gWARM:
;-------
; Jump to the warm-boot entry point

	lxi	H,WBOOT
	push	H
	reti		; clear mysterious interrupt

;
;-------
; +++		Cold Boot Utilities
;		---- ---- ---------
;		    

    .ife (BootHardAny & MASTopt),[
;----------
; Set up to read the System Directory, buffered-style.
DIRsetup:
	mvi	A,9	; sector 9
	sta	DIRsec
	ret
;----------
; Read a record's worth of system directory.
diread:
	mvi	C,0FFh	; select boot drive
	call	SELDSK
	call	HOME
	lxi	B,2	; sys dir is on track 2
	call	SETTRK
	lxi	h,DirSec
	mov	c,m	; current dir record
	inr	m
	call	SETSEC
	lxi	B,SDIRbuf
	call	SETDMA
	call	READ
	mvi	A,128
	sta	DIRcnt	; this surely is not needed
	ret

;-------------------------
; Get a character from the (sysdir) buffer.
; Regs in:   none
; Regs out:  a = character
; Trashed:   all except HL
getc:
	push	H
	lda	DIRcnt
	ora	A
	cz	diread
;
	mov	C,A
	dcr	A
	sta	DIRcnt	; how many will remain
	mvi	B,0
	lxi	h,SDirBuf +128
	xra	a	; clear carry
	dsbc	B	; point H at char
	mov	A,M
	pop	H
	ret
	]	; end ' Separated HardAlone or Master '

  .ifn	Master,[
    .ife	Hard5opt,[
;------
; read the alloc table, create offset and max tables
; entry>	none
; exit> 	hard5 tables initialized
Init5hard:
	lxi	h,HighAdr
	mvi	m,HighAlloc
	inx	h
	mvi	m,MidAlloc
	inx	h
	mvi	m,LowAlloc
	call	xPreRead	; need whole alloc tbl
	call	BldOffTable
	ret
	]	; end ' Hard5opt '
	]	; end ' not Master '
;
;----------
; Assign default disk partitions
;
; Regs in:   HL = pointer to partition name
;	     C	= unit number
; Regs out:  none
; Destroyed: A, BC, DE, HL
  .ife	HARDshar&BootHardAny,[

ASSdef:
	push	B	; unit number
	push	H	; adr of unit name
	call	SELDSK	; needed for calling CPMMAP
	pop	h	; get name adr in alloc table
	push	H	; save name adr in alloc table
	lxi	D,AssnStr
	lxi	B,8	; len of name
	ldir		; copy it for future reference
; 
;

	lxi	H,AssnStr
	call	ASSIGN	; ret's unit in B, size in C
	cpi	0FFh	; vol in D, control in E
	jrnz	..assign ; jump if assign successful
;
; Check for floppy assignment

..ckFLOP:

  .ife	HARDshar&(Hard5boot!DriveDopt),[
	lda	AssnStr ; density indicator

;Convert Fn to Mn or Dn based on assembly options
	cpi	'F'	; generic floppy?
	jrnz	..nosubst ; no, don't substitute
    .ife flop5opt,[ mvi a,'M' ]
    .ife flop8opt,[ mvi a,'D' ] ; selects D if both
..nosubst:
	cpi	'S'	; single density
	mvi	C,SDtab
	jrz	..flop
;
	cpi	'D'	; double density
	mvi	C,DDtab
	jrz	..flop
;
	cpi	'M'	; mini floppy, double sided
	mvi	C,Mtab
	jrnz	..ret

..flop:
	lda	AssnStr+1; unit number (0-7)
	sui	'0'
	jrc	..ret
;
	cpi	8
	jrnc	..ret	; A is unit #
;
	mov	B,A	; save unit # in B
	mvi	E,0	; force control => 0
	]	; end 'HARDshare&(Hard5boot!DriveDopt)'
;
  .ifn	HARDshar&Hard5boot,[
	jmpr	..ret	; if non DMS-15 boot
	]

; Process network, hard disk, or floppy assignment
..assign:	; first check if valid type
	mov	A,E	; get control byte
	ani	7	
	jrnz	..ret
;
	mov	A,D
	sta	VOLUME	; save the HD volume #
	mov	A,E
	sta	CONTROL ; save the alloc ctl byte
	call	CPMMAP	; get pointer to unit #
	push	H	; save addr of unit #
	mov	M,B	; overwrite unit #
	dcx	H	; point at media type
;
; Check if 8 inch single density
	mvi	A,SDtab
	cmp	C
	jrnz	..med1
;
	mvi	M,SD
	jmpr	..DPB
;
; Check if 8 inch double density
..med1:
	mvi	A,DDtab
	cmp	C
	jrnz	..med2
;
	mvi	M,DD
	jmpr	..DPB
;
; Check if 2-sided mini
..med2:
	mvi	A,Mtab
	cmp	C
	jrnz	..med3
;
	mvi	M,MINI2
	jmpr	..DPB
;
..med3:
			; code for 1-sided mini here
;
; Get media type and HD volume # from
; last ASSIGN if not floppy
	lda	MEDIUM
	mov	M,A	; store in media type byte
	dcx	H	; point at volume number
	lda	VOLUME
	mov	M,A	; store in volume # byte
	inx	H	; point at media type
;
; Compute DPB addr and put it in DE
..DPB:
	inx	H	; point at unit #
	inx	H	; point at DPB base
	xchg		; DE = address of DPB
;
; Compute offset into tbl of ASSIGNable devices

  .ife	HiDosOpt,[

;	c = index into Assign table (1-0ah)
;	    - allows 32 MegByte Unit size
;	Table entries are 19 bytes each
;	Exit with bc = (c * 19)

	dcr	C
	mov	A,C	; A = 0 - 9
	rlc
	rlc
	rlc
	rlc		; a = c*16
	add	c
	add	c
	add	c	; a = (c*16) + (c*3)
	mov	C,A	; C = 0,19,38,57,76,95,114,143
	mvi	B,0
;
; Compute tbl addr and overwrite the DPB
	lxi	H,DSKtab
	dad	B	; compute disk table address
	lxi	b,19
	ldir		; overwrite disk map
	]		; end ' HiDosOpt '

  .ifn	HiDosOpt,[

;	c = index into Assign table (1-8)
;	    - allows 8 MegByte Unit size
;	Table entries are 15 bytes each
;	Exit with bc = (c * 15)

	dcr	C
	mov	A,C	; A = 0,1,2,3,4,5,6,or 7
	rlc
	rlc
	rlc
	rlc		; a = (c*16)
	sub	C	; a = (c*15)
	mov	C,A	; C = 0,15,30,45,60,75,90,105
	mvi	B,0
;
; Compute tbl addr and overwrite the DPB
	lxi	H,DSKtab
	dad	B	; compute disk table address
	lxi	b,15
	ldir		; overwrite disk map
	]		; end ' not HiDosOpt '
;
; Move partition name into BIOS
	pop	H	; HL = addr of DPB-1
	lxi	d,15	; compute adr of the
	ora	a	; control byte in the
	dsbc	d	; DPB and store the alloc
	lda	CONTROL ; table control value
	mov	m,a	; there
	lxi	d,5	; offset to name field
	dad	d	; calc adr of drv name in dpb
	pop	D	; get source of name
	pop	B	; throw away unit number
	xchg
	lxi	B,8	; the name is 8 bytes long
	push	d	; save .dpb(name)
	ldir		; move the name to the dpb
	pop	h	; hl = .dpb(name,0)
	res	7,m	; clear possible autoGrant bit
	ret
;
; Can't assign, so set map byte to "unassigned"
; by setting media type and unit no. to 0FFh.
..ret:
	pop	H
	pop	B
	call	CPMMAP
	mvi	M,0FFh	; unit number marked
	dcx	H
	mvi	M,0FFh	; media type marked
	ret
  .page
  .sbttl	'assign a hard disk partition (b83cboot.asm)'
;
;----------
; ASSIGN a hard disk partition
;  entry>	HL = address of partition name
;  exit>	B = unit number
;		C = size
;		D = volume no
;		E = control byte
;		A = same as B
;
ASSIGN:

  .ife	WriteModes,[
	res	7,m	; reset autoGrant flag
	]		; end ' WriteModes '

  .ife	MastOpt,[

	lda	upMAST
	ora	A	; if master not up yet,
	jrnz	..hdass ;  then assign directly
;
; If master is awake then let the BIOS handle it
;
	lxi	D,NETnam
	lxi	B,LenAssnStr
	ldir
	mvi	A,assnNET
	sta	NETcom	; set command byte last
	call	NETreq	; wait for master to wakeup
	lbcd	NETassn ; B = unitno, C = size
	lded	NETassn + 2; D = volume,E = control
	mov	A,B	; unitno in A as well
	push	H
	lxi	H,MEDIUM; point at media type
	mvi	M,NET	; Net partition assignment
	pop	H
	ret
	]		; end ' MASTopt '
;----------
; If network station, then assign thru network
  .ife	station!NETboot,[

	lda	BOOTnum ; this may have been trashed
	sta	NETusr	; by something before now
;
; Move partition name to net command area
..request:
	lxi	D,BOOTnam; setup command in boot area
	lxi	B,LenAssnStr
	ldir

; Wait for the master to poll
	mvi	A,assnNET
	sta	BOOTcom
..poll: lxi	H,BOOTmsg
	lxi	B,1
	lda	NETusr
	call	RECNET
	bit	timeout,a
	jrz	..poll
;
	bit	pollRCV,a
	jrz	..poll	; wait for valid poll
;
	ani	crc$ovr ; crc or ovrun err
	jrnz	..poll

; Send assign request
	lxi	H,BOOTcom; send assign request
	lxi	B,lenCom
	sub	A
	call	SENDNET
;
; Get response from master
..getresp:
	lxi	H,BOOTassn
	lxi	B,4
	lda	NETusr
	call	RECNET
	bit	timeout,a
	jrz	..retry
;
	ani	crc$ovr ; crc or ovrun err
	jrz	..success

..retry:
	lxi	h,AssnStr
	jmpr	..request

..success:
	lbcd	BOOTassn    ; B = unitno, C = size
	lded	BOOTassn + 2; D = volume, E = control
;
; Store the mass storage media type in RAM
	mvi	A,NET
	sta	MEDIUM
;
; Put the unit number in Acc
	mov	A,B
	ret
	]		; end ' STATION '

;----------
; If booting from non DMS-15 hard disk assign directly
  .ifn	Hard5opt,[
    .ife	Hard8boot&MASTopt,[
..hdass:
	push	H
	mvi	A,assnHARD
	call	CMDHARD ; send assign command to disk
	pop	H
	lxi	B,LenAssnStr
	call	SENDHARD; send partition name and psw
	call	RESHARD ; get unit number and size
	lbcd	HARDstat
	lded	HARDstat + 2 ;D=volume, E = control
	mvi	A,HARD
	sta	MEDIUM	; mark this ASSIGN as HARD
	mov	A,B
	ret
	]	; end ' Hard8boot or MASTopt '
	]	; end ' not DMS-15 hard boot '
;
;
  .ife	Hard5opt,[
;-------
; if booting from XEBEC controller assign directly
; entry>	hl = adr of partition name and psw
; exit> 	b  = unit#
;		c  = size
;		d  = volume
;		e  = control
..hdass:

;    call subroutine 'cause master needs assign
;    code for cold boot and in running system

    .ife	master,[
	call	do5assign
	mvi	a,fHARD
	sta	MEDIUM
	mov	a,b	; a  = unit no. also
	ret
	]		; end ' hard5 master '

;    code in-line here 'cause stand alone only
;    needs this stuff at cold boot time

    .ife	alone,[
	lxi	d,actBUF+1
	xchg		; de = .assign name
			; hl = .alloc name
	mvi	b,MaxAllocEntry
..testASN:
	push	h	; alloc name adr
	push	d	; asn string adr
	call	testNAME
	pop	d	; restore string adr
	pop	h	; restore alloc adr
	jrz	..match
;
	push	d
	lxi	d,LenAllocEntry
	dad	d	; hl = new alloc adr
	pop	d
	djnz	..testASN	; test 64 entries
;
..fail:
	lxi	b,0ffffh	; return failure
	lxi	d,0ffffh
	mov	a,e
	sbcd	HARDstat
	sded	HARDstat+2
	ret
;
..match:
	mvi	a,MaxAllocEntry
	sub	b
	mov	b,a	; b  = unit number
	dcx	h	; hl = adr of size
	mov	c,m	; c  = size byte
	lxi	d,LenAllocEntry-1
	dad	d	; adr of control
	mov	e,m	; e  = control byte
	xra	a
	mov	d,a	; d  = volume
	sbcd	HARDstat
	sded	HARDstat+2
	mvi	a,fHARD
	sta	MEDIUM
	mov	a,b	; a  = unit no. also
	ret
;
;-------
; entry>	hl = alloc string adr
;		de = assign string adr
; exit> 	 z = set if match
testNAME:
	mvi	c,LenAssnStr
..test:
	ldax	d
	cmp	m	; do chars match
	jrz	..next
;
	mov	a,c	  ; no match> so is it
	cpi	LenAssnStr; first char of string
	jrz	..fail
;
	ldax	d	; not first char so
	ora	a	; match if byte is zero
	jrz	..next
;
..fail:
	ori	0ffh
	ret
;
..next:
	inx	h	; check rest of string
	inx	d
	dcr	c
	jrnz	..test
	ret
	]	; end ' stand alone '
	]	; end ' Hard5opt '
	]	; end ' HardShare or BootHardAny '
;
  .ife	Hard5opt,[
;
;-------
; entry>	none
; exit> 	builds size table
; used> 	all
BldOffTable:
	lxi	h,TrkOffTable
	shld	curPTR	; init curPTR
;
;  zero the offset table - note that the first
;  entry (unit0) of the offset table will always
;  have an offset of zero

	mvi	M,0
	lxi	D,TrkOffTable+1
	lxi	B,127
	ldir
;
	lxi	H,MaxTable
	shld	BldMaxPtr; init MaxPtr
;
; zero the MaxTrk table
	mvi	M,0
	lxi	D,MaxTable+1
	lxi	B,127
	ldir
;
  .ife	master,[lxi  H,Rd1kBuf]
	       [lxi  H,actBUF]	; alloc tbl still here

	shld	SizeAdr ; adr of first size byte
..size:
	call	getSIZE ; rets a = (size byte-1)
	rnc		; carry reset when done
;
	lxi	H,16	; a = log base 2
	ora	A	; don't multiply if
	jrz	..build ; size = 256k (16 tracks)
;
	mov	B,A
..mult: dad	H
	djnz	..mult
;
..build:
	call	bldTABLE; hl=incr for bldTABLE
	jmpr	..size
;
;------
; entry>	none
; exit> 	a  =	size of part - 1
;		c  reset if all done
; used> 	b,hl,a
getSIZE:
	xra	a	; clear carry
	lhld	SizeAdr
	mov	A,M	; size of zero means
	dcr	A	; end of alloc table
	rm		; -- carry reset
;
	lxi	B,LastReadAdr
	dsbc	B
	rnc		; -- carry reset
;
	lhld	SizeAdr
	lxi	B,LenAllocEntry
	dad	B
	shld	SizeAdr ; set for next time
	stc		; carry set if not end
	ret
;
;-------
; entry>	hl = amount to add
; exit> 	curPTR incr, new total stored
; used> 	bc,de,hl
bldTABLE:
	push	H	; save incr
	lhld	curPTR	; prev table entry
	mov	E,M
	inx	H
	mov	D,M
	inx	H
	shld	curPTR	; new table entry
	xchg		; de = new entry adr
			; hl = last total
	pop	B	; bc = new incr
	dad	B	; hl = new total
	xchg		; hl = new entry adr
			; de = new total
	mov	M,E
	inx	H
	mov	M,D	; store new total
;
	lhld	BldMaxPtr; new table entry
	mov	M,E	; set MaxTrk
	inx	H
	mov	M,D
	inx	H	; set next MaxPtr
	shld	BldMaxPtr
	ret
	]		; end ' Hard5opt '
  .page
  .ife	WriteModes,[
;
;-------
; entry>	hl = .unit name
;		 c = drive#
; exit>		none
autoGrant:
; check for auto_Wr_Mode_Grant request
	bit	7,m
	rz
;
	call	SelDsk
	call	cpmMap
	lxi	d,autoUnit
	stax	d
	dcx	h
	dcx	h
	mov	a,m
	dcx	d
	stax	d	; de = .autoVolume
	lda	NetUsr
	inx	d
	inx	d
	stax	d	; de = .autoValue
	inx	d
	stax	d	; de = .autoUser
	lda	cpmDsk
	inx	d
	stax	d	; de = .autoDrive
	mvi	a,WrGrant
	sta	autoRequest
..tryAgain:
	lxi	h,autoRequest
	lxi	d,autoAnswer
	call	MakeModeRequest
	lxi	h,autoAnswer
	mov	a,m
	cpi	MesAck
	jrnz	..tryAgain
;
	ret
;
;-------
; entry>	a = alloc control byte
; exit> 	b = Write_Mode_Type
WrControl:
	rlc
	rlc		; check the Shared bit
	mvi	b,Shared.Unit
	rc
;
	rlc
	rlc
	ani	3	; a = unit type
	push	h
	lxi	h,TypeTable
	mvi	b,0
	mov	c,a
	dad	b
	mov	b,m
	pop	h
	ret

    .ife	Master,[
;
;-------
; entry>	none
; exit> 	none
Init2err:
	lxi	h,WrMode.Table
	mvi	b,0		; 256 units
..errFill:
	mvi	m,GenericErr
	inx	h
	djnz	..errFill
	ret
;
;-------
; entry>	none
; exit> 	none
InitVolsPresent:
	lxi	b,PreRdBuf	; its out of the way
	call	MmHdStat
	lda	PreRdBuf +7
	ora	a
	jrz	..doVols	; should always be zero
;
	lxi	h,DeadCityMsg
	jmp	PrtMsg	
;
..doVols:
	lda	PreRdBuf +8	; vol0 marker
	ora	a
	cnz	..0volInit
;
	lda	PreRdBuf +40	; vol1 marker
	ora	a
	cnz	..1volInit
;
	lda	PreRdBuf +72	; vol2 marker
	ora	a
	cnz	..2volInit
;
	lda	PreRdBuf +104	; vol3 marker
	ora	a
	cnz	..3volInit
;
	ret
;
;-------
;
..0volInit:
	xra	a		; select vol# 0
	lxi	d,WrMode.Table +(0 * 64)
	jmpr	VolModeInit
;
..1volInit:
	mvi	a,1		; select vol# 1
	lxi	d,WrMode.Table +(1 * 64)
	jmpr	VolModeInit
;
..2volInit:
	mvi	a,2		; select vol# 2
	lxi	d,WrMode.Table +(2 * 64)
	jmpr	VolModeInit
;
..3volInit:
	mvi	a,3		; select vol# 3
	lxi	d,WrMode.Table +(3 * 64)
;
;		- fall into VolModeInit
;-------
; entry>	de = .WrModeTable(volume)
;		 a = volume#
; exit> 	none
VolModeInit:
	push	d
	call	ReadAlloc
	pop	d
;
;		- fall into InitAllocMode
;-------
; entry>	hl = .allocTable(size)
;		de = .WrMode.Table(volume)
; exit> 	none
InitAllocMode:
	dcx	h		; NextControl will incr
..build:
	call	NextControl	; ret hl = .alloc(ctl)
	rc			;     Cy set if done
;
	mov	a,m
	call	WrControl	; rets b = Write_Status
	mov	a,b
	stax	d
	inx	d		; de = .WrMode.Table(i)
	jmpr	..build
;
;-------
; read the alloc table into the MastBuf
; entry>	 a = volume# (0 - 3)
; exit> 	hl = MastBuf
ReadAlloc:
	sta	MastVol ; select volume
	xra	a
	sta	MastDsk ; unit 0
	lxi	h,0
	shld	MastTrk ; track 0
	mvi	a,79h
	sta	MastSec ; sector 79h
	lxi	h,MastBuf
	call	MMrd1
	lxi	h,MastBuf
	ret
;
;-------
; entry>	hl = adr of current control byte
; exit> 	hl = adr of next control byte
;		Cy set if done
NextControl:
	inx	h	; hl = .alloc(current,size)
	mov	a,m
	ora	a	; size = 0, then done
	stc		; Cy set means done
	rz
;
	push	d
	lxi	d,15	; de = length of alloc entry -1
	dad	d
	xchg
	lxi	h,MastBuf +3ffh
	xra	a	; clear carry
	dsbc	d	; Cy set if past end of table
	xchg		; hl = .allocTble(next control)
	pop	d
	ret
;
;-------
; entry>
; exit>
InitOwnedMode:
	call	ReadDiskMode	; Wr_Mode_Stat from dsk
	lxi	h,WrMode.Table
	mvi	c,0
..check:
	mvi	a,Not.Owned.Unit
	cmp	m
	jrnz	..more
;
	call	GetDiskMode
	mov	m,a
..more:
	inx	h
	inr	c
	jrnz	..check
	ret
;
;-------
; entry>	none
; exit> 	none
ReadDiskMode:
	xra	a
	sta	MastVol ; vol 0
	sta	MastDsk ; unit 0
	lxi	h,WModTrk ; 
	shld	MastTrk ; track 1
	mvi	a,WModSec ; 
	sta	MastSec ; record 15
	lxi	h,MastBuf
	call	MMread	; read first 128 bytes
	mvi	a,WModSec+1
	sta	MastSec ; record 16
	lxi	h,MastBuf +128
	jmp	MMread	; read next 128 bytes
;
;-------
; entry>	c = table offset
; exit> 	a = Wr_Mode from disk
GetDiskMode:
	push	h
	lxi	h,MastBuf
	mvi	b,0
	dad	b
	mov	a,m
	pop	h
	ret
	]		; end ' Master '
	]		; end ' WriteModes '
  .page
;
;--------
  .ife	HardShare & BootHardAny,[
    .ife	MASTopt,[

; Burn.Sp is the initial user stack pointer for no
; particularly good reason that I can see.

; Twiddle thumb(s) while waiting for hard disk int
BURN.SP:	.word	0
		.word	BURNcpu
BURNcpu:
	jmpr	.
;
;----------
; Get 2 digit number from input buffer
;  Regs in:  HL = address of input buffer
getnum:
	call	getdig	; get first digit
	cpi	0FFh
	rz		; return if illegal digit
;
	rlc
	mov	B,A
	rlc
	rlc
	add	B	; muliply first digit by 10
	mov	B,A
	call	getdig
	cpi	0FFh
	rz		; return if illegal digit
;
	add	B
	ret

;----------
; Get 1 digit from input buffer
getdig:
	mov	A,M
	inx	H
	sui	'0'
	jrc	..numerr
;
	cpi	10
	rc

..numerr:
	mvi	A,0FFh
	ret
	]		; end ' Master '
  .page
  .sbttl	'disk parameter tables (b83cboot.asm)'
;----------
; CP/M 2.2 disk parameter table

DSKtab:

CurDPB	=	1
; 256K
	.word	128	; sectors per track
	.byte	3,7,0	; blk shift, blk and ext mask
	.word	255	; number of blocks - 1
	.word	63	; maximum directory number
	.byte	0C0h,0	; bits indicate directory blks
	.word	16	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	16	; 1st sec of shared alloc vec
	.word	0	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
; 512K
	.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	255	; number of blocks - 1
	.word	127	; maximum directory number
	.byte	0C0h,0	; bits indicate directory blks
	.word	32	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	32	; 1st sec of shared alloc vec
	.word	0	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
; 1M
	.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	511	; number of blocks - 1
	.word	255	; maximum directory number
	.byte	0F0h,0	; bits indicate directory blks
	.word	64	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	64	; 1st sec of shared alloc vec
	.word	0	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
; 2M
	.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	1023	; number of blocks - 1
	.word	511	; maximum directory number
	.byte	0FFh,0	; bits indicate directory blks
	.word	128	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	0	; 1st sec of shared alloc vec
	.word	1	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
; 4M
	.word	128	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory number
	.word	0FFFFh	; bits indicate directory blks
	.word	256	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	0	; 1st sec of shared alloc vec
	.word	2	; 1st trk of shared alloc vec
	.byte	2	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
; 8M
	.word	128	; sectors per track
	.byte	5,31,1	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory number
	.byte	0FFh,0	; bits indicate directory blks
	.word	256	; check vector size
	.word	0	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	0	; 1st sec of shared alloc vec
	.word	2	; 1st trk of shared alloc vec
	.byte	2	; size of alloc vec in records
	]		; end '  HiDosOpt '

  .ife	HiDosOpt,[

CurDPB	=	CurDPB+1
; 16M
	.word	128	; sectors per track
	.byte	6,63,3	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory number
	.byte	0F0h,0	; bits indicate directory blks
	.word	256	; check vector size
	.word	0	; number of op sys tracks
	.byte	0	; 1st sec of shared alloc vec
	.word	2	; 1st trk of shared alloc vec
	.byte	2	; size of alloc vec in records

CurDPB	=	CurDPB+1
; 32M
	.word	128	; sectors per track
	.byte	7,127,7	; blk shift, blk and ext mask
	.word	2047	; number of blocks - 1
	.word	1023	; maximum directory number
	.byte	0C0h,0	; bits indicate directory blks
	.word	256	; check vector size
	.word	0	; number of op sys tracks
	.byte	0	; 1st sec of shared alloc vec
	.word	2	; 1st trk of shared alloc vec
	.byte	2	; size of alloc vec in records
	]		; end '  HiDosOpt '

CurDPB	=	CurDPB+1
SDtab	==	CurDPB

	.word	26	; sectors per track
	.byte	3,7,0	; blk shift, blk and ext mask
	.word	242	; number of blocks - 1
	.word	63	; maximum directory number
	.byte	0C0h,0	; bits indicate directory blks
	.word	16	; check vector size
	.word	2	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	16	; 1st sec of shared alloc vec
	.word	0	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '
;
CurDPB	=	CurDPB+1
DDtab	==	CurDPB

	.word	52	; sectors per track
	.byte	4,15,0	; blk shift, blk and ext mask
	.word	242	; number of blocks - 1
	.word	127	; maximum directory number
	.byte	0C0h,0	; bits indicate directory blks
	.word	32	; check vector size
	.word	2	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	32	; 1st sec of shared alloc vec
	.word	0	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end '  HiDosOpt '
;
CurDPB	=	CurDPB+1
Mtab	==	CurDPB

	.word	32	; sectors per track
	.byte	5,31,0	; blk shift, blk and ext mask
	.word	156	; number of blocks - 1
	.word	127	; maximum directory number
	.byte	080h,0	; bits indicate directory blks
	.word	32	; check vector size
	.word	3	; number of op sys tracks

  .ife	HiDosOpt,[
	.byte	0	; 1st sec of shared alloc vec
	.word	1	; 1st trk of shared alloc vec
	.byte	1	; size of alloc vec in records
	]		; end ' HiDosOpt '
	]	; end ' HardShare | Hard8 | Hard5 boot'
  .page
  .sbttl	'cold boot messages, SIO commands, data storage (b83cboot.asm)'
;----------
; CP/M cold-boot message
CPMmsg:
  .ife	Master,  [
  .ife	HiDosOpt,[.ascii   [cr][lf]'HiDos Network ']
		  .ascii   [cr][lf]'HiNet Master  '
	]		; end ' Master '

  .ife	Alone,	 [.ascii [cr][lf]'CP/M  ']

  .ifn	Station, [
	.byte	version+'0','.',revision/100+'0'
	.byte	(revision@100)/10+'0'
	.byte	(revision@100)@10+'0'
	.word	(((mod+'0') & 0ffh) <8) + patch
	]		; end ' not Station '

.ife	MASTopt,[
crlf:	.ascii	[cr][lf]
	]

	.byte	0	; end main signon message

  .ife	Master!HardShare,[
DATEmsg:.asciz	[cr][lf]'Enter Date  MM/DD/YY - '
TIMEmsg:.asciz	[cr][lf]'Enter Time  HH:MM - '
LOGmsg: .asciz	[cr][lf][lf]'Login please ... '
	]		; end ' HardMaster '

  .ife	HardShare ! Master,[

;		Mimicry messages
;		----------------

BUSYmsg:
	.ascii	[cr][lf]'Another HiNet Master '
	.asciz	'is active -'
MIMask:
	.asciz	[cr][lf]'Enter "M" <CR> to mimic - '
MIMmsg:
	.asciz	[bell][cr][lf]'*** MIMIC error at '

MimicName:
	.ascii	'Mimicker'

SpoolUnit:
	.ascii	"PRTSPOOL"	; spool partition name
	.byte	0,0,0,0,0,0	; no password
	]		; end ' HardShare and Master '

    .ife	master,[
inituser:.ascii [0]'Unknown        '
Unit0Name:			; boot partition name
	.word	0,0,0,0,0,0,0	; string is all zeros

      .ife	WriteModes,[
DeadCityMsg:
	.asciz	[cr][lf]'*** Wr_Mode Init error'
	]		; end ' WriteModes '
	]		; end ' Master '

    .ifn	BootFlopAny,[
AssnStr:
	.word	0,0,0,0,0,0,0	; storage for assign name

UpMast: .byte	0FFh	; 0 if master is active

Medium: .byte	0	; mass storage medium last
			; ASSIGNed = NET, Hard8, Hard5
			;	   SD, DD, MINI1, MINI2
Volume: .byte	0	; If Medium = Net or eitherHard
			; then Volume = the HD volume #
Control:.byte	0	; control byte for dpb
	]		; end 'not floppy boot'

  .ife	Hard5opt,[
curPTR: 	.word	TrkOffTable
BldMaxPtr:	.word	MaxTable
SizeAdr:
     .ife	Master, [.word	Rd1kbuf+16]
			[.word	ActBuf+16]
	]			; end ' Hard5opt '
  .page
;----------
; SIO command strings
rs232:	
	.byte		  18h; channel reset
	.byte	14h,01001100b; x16 clock, 2 stop bits
	.byte	 3h,11100001b; receiver & auto enable
	.byte	 5h,11101010b; xmitter,dtr,rts enable
	.byte	11h,00000100b; no interrupts
rs232$	==	.-rs232

;
;----------
; Floppy specify command - cold boot only

  .ife	OptFlopAny,[
specFLOP:
	.byte	3	; specify command

    .ife	Flop8opt,[
	.byte	stp8	; step rate is 3 or 8 mSec
	]		; end ' Flop8opt '

    .ifn	Flop8opt,[
	.byte	stp5	; step rate is 6 mSec
	]		; end ' Flop5opt only '
	
	.byte	02h	; use dma
	.byte	endcom
	]		; end ' either floppy '

  .ife	WriteModes,[
;
;-------
TypeTable:
	.byte	Rd.Wr.Unit
	.byte	Rd.Only.Unit
	.byte	Not.Owned.Unit
	.byte	Not.Owned.Unit	; currently not used
	]		; end ' WriteModes '

;-------
; actual length of cold boot code
lenCold =	. - CBoot
  .if2,[
    .ifg (lenCold-lenBoot),[
	 .prntx "Cold boot code is TOO LONG"]
	[.prntx "cold boot code fits"]
	]		; end ' phase 2 '
;
;----------
; Scratch areas
DSK0def  ==	1004h	; == DSKSdef for consistency,
			; and to save PROM for tests
IOBdef	 ==	DSK0def+32  ; default IOBYTE
INLENdef ==	DSK0def+33  ; length of type-ahead buf
INBUFdef ==	DSK0def+34  ; default type-ahead buffer
WBdef	 ==	DSK0def+66+16  ; 2nd item in load list
SDIRbuf  ==	CBOOT-128   ; scratch for disk I/O

;
;----------
; Network login command goes here
BOOTcom ==	7000h	; so PROM doesn't cream it
BOOTnam ==	BOOTcom+1
BOOTpsw ==	BOOTnam+8
BOOTprom==	BOOTpsw+6
BOOTmsg ==	BOOTprom
BOOTassn==	BOOTnam
BOOTdate==	BOOTcom

BOOTresp==	BOOTcom+32
BOOTnum ==	BOOTresp+1
BOOTclk ==	BOOTnum+1
BOOTver ==	BOOTclk+7 

;
;-----
;
  .ife	WriteModes,[
autoRequest	==	4000h
autoUnit	==	4002h
autoAnswer	==	4006h
	]		; end ' WriteModes '
