  .page
  .sbttl	'conin,conout,const,list,reader,punch (b83bytio.asm)'
  .prntx	'made it to character i/o'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +		Character I/O			+
; +						+
; +	last modified>	13apr84 kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;
;----------
;
; IOBYTE implementation:
;
;    default values>	54  =	serial console
;			56  =	parallel console
;			5C  =	serial, Hard5 present
;			5E  =	parallel, Hard5 present
;	mapping:
;	       list   punch   qHrd5   reader  console
;	    -----------------------------------------
;	    |  010  |	1   |	0   |	1   |  00   |
;	    -----------------------------------------
;	     msb				 lsb

;----------
; Console status
CONST:
	call	doCONIO
	.word	PORT0st 	; TTY: (default ser)
	.word	PORT2st 	; CRT:
	.word	PAR1st		; BAT: (default par)
				; UC1:
  .ife	port3debug,[.word	pt3status]
		   [.word	prt3st]
	
;----------
; Console input
CONIN:
	call	doCONIO
	.word	PORT0in 	; TTY: (default ser)
	.word	PORT2in 	; CRT:
	.word	PAR1in		; BAT: (default par)
				; UC1:
  .ife	port3debug,[.word	pt3in]
		   [.word	prt3in]

;----------
; Console output
CONOUT:

  .ife	MASTopt,[call	WAITspool]
			; wait for spool message
	call	doCONIO
	.word	PORT0out	; TTY: (default ser)
	.word	PORT2out	; CRT:
	.word	PAR1out 	; BAT: (default par)
				; UC1:
  .ife	port3debug,[.word	pt3out]
		   [.word	prt3out]

;----------
; List output
LIST:
	lda	3
	rlc
	rlc
	rlc
	ani	7	; allow 8 LST: assignments
	call	DISPATCH

  .ife	ADDSopt,[.word PORTAout]
		[.word PORT0out]

	.word	PRT3out
	.word	PORT2out; CRT:	(default)
	.word	PORT1out
	.word	PORTPout; LPT:

  .ifn	master&Hard5opt,[.word par1fox]
			[.word CALLerr]

	.word	PORTUout; UL1:

  .ife	SPOOLopt,[.word PORTNout]
		 [.word CALLerr]
;----------
; List status
LISTST:
	sub	A	; indicates not ready
	ret

;----------
; Punch output
PUNCH:
	lda	3
	rrc
	rrc
	rrc
	rrc
	ani	1	; allow 2 PUN: assignments
	call	DISPATCH
	.word	PORT0out; TTY:
	.word	PRT3out; PTP:	(default)

;----------
; Reader input
READER:
	lda	3
	rrc
	rrc
	ani	1	; allow 2 RDR: assignments
	call	DISPATCH
	.word	PORT0in ; TTY:
	.word	PRT3in	; PTR:	(default)

;----------
; I/O dispatch routines
doCONIO:
	lda	3
	ani	3	; allow 4 CON: assignments
DISPATCH:
	rlc
	xthl
	mov	E,A
	mvi	D,0
	dad	D	
	mov	A,M	; get jump vector
	inx	H
	mov	H,M
	mov	L,A
	xthl
	ret		; go to appropriate routine
  .page
  .sbttl	'type ahead code for various ports'

  .ife	AHEADopt,[
OPTM0	=	OPTM0 + (1<P0AHEAD) ; set opt map bit

	; master console now polled in timer int
	; this avoids conflict w/net xmissions
  .ifn	master,[
;----------
; Port 0 interrupt
PORT.SP:.word	0	; user's SP
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
PORTstack:

PORTint:
	push	PSW
	ei
..saveregs:
	sspd	PORT.SP ; save user registers
	lxi	SP,PORTstack
	push	H
	push	D
	push	B
	call	getCHAR
	jrz	..full	; if z set buffer is full
;
	call	plusBUF ; store char and inc ptr
	jmpr	..ret

..full:
	di		; this might take a while
	mvi	C,bell	; ring bell if buffer full
	call	conout
..ret:
	pop	B
	pop	D
	pop	H
	lspd	PORT.SP
	pop	PSW
	ei
	reti
	]		; end ' not master '

  ; common routines
getCHAR:
	in	SIO1AD	; get the character
	ani	7Fh	; mask out parity bit
	mov	C,A
	lhld	nxtin	; L = nxtin, H = nxtout
	mov	A,L
	cmp	H	; check for buf full
	ret

plusBUF:
	mvi	H,0
	lxi	D,PORT0buf
	dad	D	; point to next spot in buffer
	mov	M,C	; store char in buffer
	inr	A	; increment nxtin
	ani	typeahead ; use modulo arithmetic
	sta	nxtin	; save new value of nxtin
	ret
;
;----------
; Port 0 status - type ahead option
PORT0st:
	ei		; make sure interrupts enabled
	lhld	nxtin	; L = nxtin, H = nxtout
	]		; end ' AheadOpt '
			; fall into IntBufStatus
  .ife	AheadOpt & AH3opt,[
;
;------
; entry>	hl = .buffer
; exit> 	 a = 0ffh,  Z reset if char available
;		 a = 0, Z set if no data is available
IntBufStatus:

  .ife	Master,[
	call	WaitSpool
	]		; wait for spool response

  .ife	Station,[
	call	MaybeForceAck
	]		; maybe call AckPoll

	mov	A,H
	inr	A	; increment nxtout
	ani	typeahead ; use modulo arithmetic
	mov	B,A	; save nxtout+1 for CONIN
	sub	L	; zero if nxtout+1=nxtin
	rz		; return if no char available
;
	mvi	A,0FFh	; CP/M wants A = 0FFh if yes
	ret
	]		; end ' AheadOpt or AH3opt '
;
  .ife	AheadOpt,[
;
;----------
; Port 0 input - type-ahead option
PORT0in:
	call	Port0st ; wait for character
	jrz	PORT0in
;
	mov	L,B	; add nxtout+1 to PORT0buf
	mvi	H,0
	lxi	D,PORT0buf
	dad	D	; point to char in buffer
	mov	A,M	; get the character
	lxi	H,nxtout
	mov	M,B	; update the nxtout pointer
	ret
	]		; end ' AHEADopt '

  .ifn	AHEADopt,[
OPTM0	=	OPTM0 + (1<P0poll)  ; set opt map bit
;----------
; Console status
PORT0st:

    .ife	Master,[
	call	WaitSpool
	]		; wait for spool response

    .ife	Station,[
	call	MaybeForceAck	; might call AckPoll
	call	pt0status	; check default buf
	jrnz	..present	; jmp if buf <> empty
	]			; end ' station '

	in	SIO1AC	; check port 0 status
	ani	1<RxRDY ; check for receiver ready
	rz
;
..present:
	mvi	A,0FFh	; CP/M wants A = 0FFh if yes
	ret

;----------
; Console input
PORT0in:

    .ife	Station,[
	call	pt0status	; check default buf
	jnz	pt0input	; use if char avail
	]			; end ' station '

	call	PORT0st
	jrz	PORT0in
;
	in	SIO1AD	; read the character
	ani	7Fh	; mask out the parity bit
	ret
	]		; end ' not AHEADopt '
;
;----------
; Port 0 output
PORT0out:
	in	SIO1AC
	ani	1<TxRDY
	jrz	Port0out
;
	mov	A,C
	out	SIO1AD
	ret

    .ifn	NETopt,[
;-------
; Port 1 status
PORT1st:
	in	SIO1BC
	ani	1<RxRDY
	rz
;
	mvi	A,0FFh
	ret

;----------
; Port 1 input
PORT1in:
	call	PORT1st
	jrz	PORT1in
;
	in	SIO1BD
	ani	7Fh
	ret

;----------
; Port 1 output
PORT1out:
	in	SIO1BC
	ani	1<TxRDY
	jrz	PORT1out
;
	mov	A,C
	out	SIO1BD
	ret
	]		; end ' not NETopt '

    .ife	NETopt,[
;----------
; Port 1 not available on network station
PORT1st:
PORT1in:
PORT1out:
	jmp	CALLerr
	]		; end ' NetOpt '

;----------
OPTM8	=	OPTM8 + (1<(P2poll-8)) ; set opt map bit
; Port 2 status
PORT2st:

    .ife	Master,[
	call	WaitSpool
	]		; wait for spool response

  .ife	Station,[
	call	MaybeForceAck
	]		; maybe call AckPoll

	in	SIO2AC
	ani	1<RxRDY
	rz
;
	mvi	A,0FFh
	ret

;----------
; Port 2 input
PORT2in:
	call	PORT2st
	jrz	PORT2in
;
	in	SIO2AD
	ani	7Fh
	ret

;----------
; Port 2 output   --	uses xon/off protocol
PORT2out:
  .ife	MASTopt,[
	lda	SPLdsk	; if spooler is active, then
	ora	A	; don't allow direct printing
	jnz	CALLerr
	]

  .ife	alone!Flop5boot,[
	lxi	h,..xonflag
..tryOUT:
	in	SIO2AC	; is port2 device xmitting
	ani	1<RxRDY ; if not, then check our
	jrz	..ckXMITer	; xmitter status
;
	in	SIO2AD	; get char from port2 dev
	ani	7fh	; if it's not an xon
	cpi	cntlQ	; then see if 
	jrnz	..ckXOFF; it's an xoff
;
	mvi	m,0ffh	; it's xon so set xonflag
..ckXOFF:
	cpi	cntlS
	jrnz	..ckXMITer
;
	mvi	m,0	; it's xoff so reset flag
..ckXMITer:
	in	SIO2AC	; print only if our xmitter
	ani	1<TxRDY ; is ready and the flag
	ana	m	; is true (set)
	jrz	..tryOUT
;
	mov	a,c
	out	SIO2AD
	ret

..xonflag:	.byte	0ffh	; init to ok to send
	]		; end ' Flop5boot '

  .ifn	alone!Flop5boot,[

	in	SIO2AC
	ani	1<TxRDY
	jrz	PORT2out
;
	mov	A,C
	out	SIO2AD
	ret
	]		; end ' not Flop5boot '


    .ife	port3Debug,[

;-------
;	Assigning the console to port3 and setting the
; mode byte to DEBUG sets the console i/o to both port3
; and the normal console device. Assigning the console
; to port3 and setting the mode byte to NORMAL sets the
; console i/o to port3 only.
;	The normal console device is selected by the
; qHrd5 bit (bit 3) of the iobyte ->
;		reset to 0 = serial console
;		set   to 1 = parallel console.
; This bit is also used at cold boot time to decide
; if this is a DMS-15 or not. It should be set or reset
; at debug start time to pick the console type.
;
;	This Debug mode allows the service rep to call
; up a remote system and function as a psuedo user
; while still allowing the local user to function
; normally.
;	If both the remote and local users key at the
; same time the remote user will be given precedence,
; however their input will probably get intertwined.

;-------
; entry>	none
; exit> 	a = ff	-char available
;		    00	-no char available
;		b = ff	-port3 has char available
;		    fe	-par1  has char available
;		    fd	-port0 has char available
;		    00	-no char available
pt3status:
	call	prt3st		; check port3 first
	mvi	b,0ffh		; 'ff' = pt3 char
	rnz
;
	inr	b		; clear port# flag
	lda	Mode		; if not debugging
	ani	DebugMask	; then we are done
	rz			; '00' = no char
;
	lda	0003		; ck the usual console
	bit	3,a		; bit set => parallel
	jrz	..ckSerial
;
	call	par1st		; get parallel status
	rz			; '00' = no char avail
;
	mvi	b,0feh		; 'fe' = par1 char
	ret
;
..ckSerial:
	call	port0st 	; get serial status
	rz			; '00' = no char avail
;
	mvi	b,0fdh		; 'fd' = port0 char
	ret
;
;------
; entry>	none
; exit> 	a = char
pt3in:
	lda	Mode
	bit	ModeDebug,a	; if not debugging then
	jrz	prt3in		; wait for port3 char
;
	call	pt3status	; b = ff, fe, fd, 00
;
	inr	b		; b = 00, ff, fe, 01
	jrz	prt3in		; port3 has char
;
	inr	b		; b = 00, ff, 02
	jz	par1in		; parallel port has char
;
	inr	b		; b = 00, 03
	jz	port0in 	; port0 has char
;
	jmpr	pt3in		; nobody has char
;
;-------
; entry>	c = data char
; exit> 	none
pt3out:
	push	b		; save the char
	call	prt3out 	; output to modem
	pop	b		; restore char

	lda	Mode
	bit	ModeDebug,a	; if not debugging
	rz			; then we are done
;
	lda	3		; check the iobyte
	bit	3,a
	jz	port0out	; serial   = 0
;
	jmp	par1out 	; parallel = 1
	]			; end ' port3debug '

    .ife	AH3opt,[
OPTM8	=	OPTM8 + (1<(P3ahead-8)) ; set opt map bit
;----------
; Port 3 interrupt
;p3disable:
;	.byte	0	; p3 rcv ints disabled flag

PRT3.sp:
	.word	0	; user's SP
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
P3stack:		; Interrupt stack pointer

P3int:
	push	PSW

  .ife	MASTopt,[
	lda	LOCALflag
	ora	A
	jrz	..saveregs
	]
;
	ei
..saveregs:
	sspd	PRT3.SP ; save user registers
	lxi	SP,P3stack
	push	H
	push	D
	push	B
;
	lhld	nxt3in	; L = nxtin, H = nxtout
	mov	A,L
	cmp	H	; check for nxtin=nxtout
	jrz	..full	; if yes, buffer is full
;
	inr	A	; increment nxtin
	ani	typeahead ; use modulo arithmetic
	sta	nxt3in	; save new value of nxtin
	mvi	H,0
	lxi	D,PRT3buf
	dad	D	; point to next spot in buffer
	in	SIO2BD	; get the character
	mov	m,a	; store char in buffer
	jmpr	..ret

..full:
	mvi	C,bell	; ring bell if buffer full
	call	conout
;	call	dis3rcv ; disable rcv ints, drop rts
;	mvi	a,0ffh
;	sta	p3disable	; flag for prt3st
..ret:
	pop	B
	pop	D
	pop	H
	lspd	PRT3.SP
	pop	PSW
	ei
	reti

;----------
; Port 3 status - type-ahead option
PRT3st:
	ei		; make sure interrupts enabled
	lhld	nxt3in	; L = nxtin, H = nxtout
	jmp	IntBufStatus
;
; This code (and relevant SIO controls)
; deleted for space considerations.
;
;	jrnz	..end	; return 0ffh if buf not empty
;
;	lda	p3disable
;	ora	a	; ret if p3 rcv ints active
;	rz
;
;	xra	a
;	sta	p3disable
;	call	ena3rcv ; re-enable rcv ints & rts
;	in	SIO2BC	; is char in sio
;	ani	1<RxRDY
;	rz		; return if no char available
;
;	lhld	nxt3in	; set new nxtin value
;	mov	a,l
;	inr	A	; increment nxtin
;	ani	typeahead ; use modulo arithmetic
;	sta	nxt3in	; save new value of nxtin
;	in	SIO2BD	; get the char left in the SIO
;	mvi	h,0
;	lxi	d,Prt3buf
;	dad	d
;	mov	m,a	; and store it in the buf
;	
;..end: mvi	A,0FFh	; CP/M wants A = 0FFh if yes
;	ret
;
;----------
; Port 3 input - type-ahead option
PRT3in:
	call	PRT3st	; wait for character
	jrz	PRT3in
;
	mov	L,B	; add nxt3out+1 to PRT3buf
	mvi	H,0
	lxi	D,PRT3buf
	dad	D	; point to char in buffer
	mov	A,M	; get the character
	lxi	H,nxt3out
	mov	M,B	; update the nxt3out pointer
	ret
;
;---------------
;dis3rcv:
;	lxi	h,disRCV
;	lxi	b,lenDIS<8+SIO2AC
;	outir
;	ret
;
;-----------------------
;ena3rcv:
;	lxi	h,enaRCV
;	lxi	b,lenENA<8+SIO2AC
;	outir
;	ret
;
;--------------
;	-- more SIO command strings --
;disRCV:
;	.byte	5,0e8h	; drop RTS
;	.byte	1,4	; disable rcv ints
;lenDIS ==	.-disRCV

;enaRCV:
;	.byte	5,0eah	; raise RTS
;	.byte	1,1ch	; enable rcv ints
;lenENA ==	.-enaRCV
	]		; end ' AH3opt '

  .ifn	AH3opt,[
OPTM8	=	OPTM8 + (1<(P3poll-8)) ; set opt map bit
;----------
; Port 3 status
PRT3st:

  .ife	Master,[
	call	WaitSpool
	]		; wait for spool response

  .ife	Station,[
	call	MaybeForceAck
	]		; maybe call AckPoll

	in	SIO2BC
	ani	1<RxRDY
	rz
;
	mvi	A,0FFh
	ret

;----------
; Port 3 input
PRT3in:
	call	PRT3st
	jrz	PRT3in
;
	in	SIO2BD
	ret
	]		; end ' not AH3opt '
;
;----------
; Port 3 output
PRT3out:
	in	SIO2BC
	ani	1<TxRDY
	jrz	PRT3out
;
	mov	A,C
	out	SIO2BD
	ret
;
;-------
; stations w/o AheadOpt still need a default buffer
; for cold boot commands.
; They will use Pt0status and Pt0input, allowing
; normal unbuffered port0 input as well.
; entry>	none
; exit> 	Z set if no char

  .ife	Station!(1-AheadOpt),[
Pt0status:
	lhld	NxtIn	; L = nxtin, H = nxtout
	mov	A,H
	inr	A	; increment nxtout
	ani	typeahead ; use modulo arithmetic
	mov	B,A	; save nxtout+1 for CONIN
	sub	L	; zero if nxtout+1=nxtin
	ret
;
;-------
; entry>	none
; exit> 	 a = char
Pt0input:
	call	Pt0status
	jrz	Pt0input
;
; entry>	 a = char ready flag
;		 b = new NxtOut

	mov	l,b	; add nxtout+1 to Port0buf
	mvi	h,0
	lxi	d,Port0buf
	dad	d	; hl = .buf(cur)
	mov	a,m
	lxi	h,NxtOut
	mov	m,b
	ret
	]		; end ' Station w/o AheadOpt '
;
;----------
; Parallel Port 1 status
; DMS-15 master and stations now checks the port0buf
; before the CRT buf (provides cold boot buf init)
OPTM8	=	OPTM8 + (1<(Par1con-8)) ; set opt map bit

PAR1st:
  .ife	Station,[
	call	MaybeForceAck
	]		; maybe call AckPoll

    .ife	master&station,[
      .ife	AheadOpt,[call	port0st]
			 [call	Pt0status]
	jrnz	..avail
	]		; end ' not Stand Alone '

	in	PIOAD
	ani	40h	; Rx data rdy bit
	rz
;
..avail:
	ori	0FFh
	ret
;
;----------
; Parallel Port 1 input
; DMS-15 master and stations now use the
; port0buf if it has characters available
Par1in:
    .ife	master&station,[
      .ife	AheadOpt,[
		call	port0st
		jnz	port0in]

      .ifn	AheadOpt,[
		call	Pt0status
		jrnz	Pt0input]
	]		; end ' not Stand Alone '

;
; serial port0 has no char, see if parallel port 1 does

	in	PIOAD	; Check Rx status
	ani	40h	; mask for receive data ready
	jrz	Par1In	; Loop until someone has a char
;
..ckOut:
	in	PIOAD	; crt controller must
	ani	20h	; take outCHAR before
	jrnz	..ckOut ; bios will take inCHAR
;
	in	OFFPROM ; Same as DSC/3 PROM-OFF port
	ret
;
;----------
; Parallel Port 1 output
PAR1out:
	in	PIOAD
	ani	20h	; Check Tx status
	jrnz	PAR1out ; Loop if busy
;
	mov	A,C	; Put the char in the Acc
	out	OFFPROM ; Output the char
	ret
;
;----------
; List output on Centronix printer
OPTM8	=	OPTM8 + (1<(Par1prt-8)) ; set opt map bit

PORTPout:
  .ife	MASTopt,[
	lda	SPLdsk	; if spooler is active, then
	ora	A	; don't allow direct printing
	jnz	CALLerr
	]

	lda	3	; get iobyte
	ani	3	; mask all but console
	cpi	2	; Fox and 5000 should use the
	jrz	Par1out ; crt driver for portp out
;
	in	PIOAD
	bit	6,A
	jrnz	PORTPout
;
	mov	A,C
	out	CENTP
	in	PPSTROBE
	ret

;-----------------------------
; List output on DMS-15 hard disk parallel port
; no local Hard5opt allowed for this option.
;
.ifn	master&Hard5opt,[
OPTM8	=	OPTM8 + (1<(Par2prt-8)) ; set opt map bit
par1fox:
	in	PIOAD	; bit 3 set = data buffer full
	ani	18h	; bit 4 set = printer busy
	jrnz	par1fox
;
	mov	a,c
	out	HARDP
	out	PPSTROBE; data valid strobe	
	ret
	]	; end ' not master or Hard5opt '

;----------
; List output on ADDS printer
  .ife	ADDSopt,[
OPTM8	=	OPTM8 + (1<(PrtMux-8)) ; set opt map bit

PORTAout:
	push	b	; save output char
	lded	AuxEna	; get enable seq
	call	..sendControl
;
	pop	b	; get output char
	call	..Alist ; and send it
;
	lded	AuxDis	; get disable seq
;
..sendControl:
	mov	c,d	; first char of
	call	..Alist ; control sequence
;
	mov	c,e	; last char of
			; control sequence
..Alist:
	lda	3	; look at console assign
	ani	3	; mask all but console
	cpi	2	; Con: field = 2
	jrz	Par1out ; means parallel console
;
..Slist:
	mvi	a,rstInt
	out	sio1ac	; reset Interrupt status latch
;
	in	sio1ac	; get new status
	bit	CTS,a	; wait for CTS true
	jrz	..Slist
;
	ani	1<TxRdy ; and xmit buf clear
	jrz	..Slist
;
	mov	a,c	; then output char
	out	sio1ad
	ret
;
;------
; entry>
;	H = first char of enable sequence
;	L = second char of enable sequence
;	D = first char of disable sequence
;	E = second char of disable sequence
; exit> 	none
SetListType:
	shld	AuxEna
	sded	AuxDis
	ret
	]		; end ' ADDSopt '
;
;-------
; LookUp table for Adds List Output driver -
;  Table is not used now but does show the
;  control sequences for these 5 terminals.
;
;    first  entry>	Freedom 100
;    second entry>	TeleVideo 910
;    third  entry>	Hazeltine 1420
;    forth  entry>	Adds 25
;    fifth  entry>	Adm 3/5
;
;	Each entry consists of 2 bytes to enter
; transparent print mode, then 2 bytes to exit.
;
;	.byte	Esc,"'" 	; Fredom 100
;	.byte	Esc,'a'
;	.byte	null,ctlR	; TeleVideo 910
;	.byte	null,ctlT
;	.byte	Esc,'*' 	; Hazeltine 1420
;	.byte	Esc,'/'
;	.byte	Esc,'3' 	; Adds 25
;	.byte	Esc,'4'
;	.byte	Esc,'@' 	; Adm 3/5
;	.byte	Esc,'A'
;
;-------
; (Custom) Diablo printer driver
; (compatible with any printer using XON/XOFF protocol)
PORTUout:
  .ife	master&station, [
	lxi	H,..flag
	in	SIO2AC	; see if printer trying to
	ani	1<RxRDY ;  tell us something
	jrz	..chkstat
;
	in	SIO2AD	; should be cntlS or cntlQ
	ani	7Fh
	cpi	cntlQ
	jrnz	..chkcntl
;
	mvi	M,0FFh	; its OK to send
..chkcntl:
	cpi	cntlS
	jrnz	..chkstat
;
	mvi	M,0	; its not OK to send
..chkstat:
	in	SIO2AC
	ani	1<TxRDY ; see if transmitter ready
	ana	M	;  and also cntlQ active
	jrz	PORTUout; retry if not
;
	mov	A,C
	out	SIO2AD	; print char
	]		; end ' MAST or STAT '
	ret
;
  .ife	master&station, [
..flag: .byte	0FFh	; initially OK to send
	]		; end ' MAST or STAT '

  .ife	SPOOLopt,[
OPTM8	=	OPTM8 + (1<(Spooler-8)) ; set opt map bit
;----------
; Print using HiNet spooler
PORTNout:
	lda	SPOOLdsk
	ora	A	; check if already spooling
	jrnz	..ok	; jump if yes
;
; Start a new spool job
	call	newjob

; Spool character
..ok:	lxi	H,SPOOLbuf
	lda	nxtNin
	mvi	D,0
	mov	E,A
	dad	D	;hl=address in buffer
	mov	M,C	; stuff char in buffer
	mov	A,C
	cpi	cntlz	; end of job?
	jrz	..termjob	; yes
;
	lda	nxtNin
	inr	A
	cpi	lenNbuf	; end of buffer?
	sta	nxtNin	; store it anyway
	rnz
;
	xra	A
	sta	nxtNin	; reset buffer pointer
;
..retry:	; retry entry point
	call	NETspool	; flush the buffer
	rz			; 0=success
;
	call	NETstop	; stop the block
	lxi	H,SPLid
	call	blkidinc	; inc block id
	mov	M,A
	call	newjob	; start next block
	jmpr	..retry ; now flush
;
..termjob:	; flush and terminate
	call	..retry
	call	NETstop
	sub	A
	sta	nxtNin	; reset buffer pointer
	sta	SPOOLdsk ;stop spooling
	lxi	H,SPLid
	mov	A,M
	ani	0f0h
	adi	10h
	mov	M,A	; increment job id
	ret	 
;
; Main entry is newjob, joberr is for recovery
joberr:	push	B
	call	SPOLerr
	jmpr	newjb1
newjob:	push	B
newjb1:	call	netstart	;start new job
	pop	B
	xra	A
	sta	trkspl
	lda	SPOOLdsk
	ora	A	; if zero then no room
	jrz	joberr
	ret

;
; Increment Block ID by 1 for next spool buffer
;  Entered with HL pointing to id byte
;  Exits with incremented value in A	
blkidinc:
	mov	A,M
	inr	A
	ani	0fh	; mask off low nibble
	mov	B,A
	mov	A,M
	ani	0f0h	; ask off high nibble
	ora	B
	ret	

;----------
; Spool buffer

lenNbuf ==	128	; length of spool buffer

SPLmsg:
	.asciz	[cr][lf]"Spooled"

SPLid:	.byte	0	; job and block id
trkspl: .byte	0	; spool track counter
SPOOLbuf:
	.blkb	lenNbuf ; spool buffer

nxtNin: .byte	0	; spool buffer pointer
	]		; end ' SPOOLopt '

;
;-------
; When stations program the SIO to auto answer polls,
; sometimes it doesn't work right. Therefore, if there
; are 256 calls to ConStat without a call to PollAck
; and if the station isn't busy with a data block or
; a pollPrime data block then call PollAck from here.

  .ife	Station,[
;------
; entry>	none
; exit> 	none
MaybeForceAck:
	push	h
	push	b
	lxi	h,failed2ack
	inr	m
	cz	ForceAcking
;
	pop	b
	pop	h
	ret
;
;-------
; reProgram the SIO to answer polls if we're not using
; the network - this circumvents an SIO bug
; entry>	none
; exit> 	none
ForceAcking:
	lhld	PPAadr
	mov	a,m	; see if we're in a poll prime
	cpi	2	; data block transfer
	rz		; - leave SIO alone if so
;
	lda	AckFlag
	ora	a	; see if we're using the net
	cz	AckPoll
	ret
	]		; end ' Station '
