	PROGRAM DK_FORMAT
C
C	GET SYSTEM PARAMETERS
C
	INCLUDE	'($SSDEF)/NOLIST'
	INCLUDE	'($IODEF)/NOLIST'
C
C	SET UP LOCAL STORAGE
C
	INTEGER*2 IOERR

	INTEGER*4 SYS$ASSIGN,SYS$ALLOC,SYS$QIOW
	INTEGER*4 SYS$DALLOC,SYS$DASSGN
	INTEGER*4 ISTAT,CHAN,P3,IOSB(2),RETRY_1,RETRY_2,RETRY_3
	INTEGER*4 NAME_SIZE,MESSAGE_VECTOR(2)

	CHARACTER*6 DEVICE,NAMEBUF*30

	BYTE BUFFER(24576)

	EQUIVALENCE (IOERR,IOSB)

	DATA BUFFER/24576*0/
	DATA DEVICE/'_DKA0:'/
	DATA MESSAGE_VECTOR/'F0002'X,0/
C
C	GET THE DEVICE NAME
C
	WRITE(6,50)
50	FORMAT('$WHAT CONTROLLER (A..Z) ? ')
	READ(5,51)DEVICE(4:4)
51	FORMAT(A1)
	WRITE(6,52)
52	FORMAT('$WHAT UNIT NUMBER (0-7) ? ')
	READ(5,51)DEVICE(5:5)
	WRITE(6,53)DEVICE
53	FORMAT(' STARTING DEVICE ',A6)
C
C	ALLOCATE THE DEVICE
C
	WRITE(6,102)
102	FORMAT(' ALLOCATEING DEVICE')
	ISTAT=SYS$ALLOC(DEVICE,NAME_SIZE,NAMEBUF,%VAL(PSL$C_USER))
	IF(ISTAT.EQ.SS$_NORMAL)THEN
		WRITE(6,103)
103		FORMAT(' DEVICE ALLOCATED')
	ELSEIF(ISTAT.EQ.SS$_DEVALRALLOC)THEN
		WRITE(6,104)
104		FORMAT(' DEVICE ALREADY ALLOCATED TO TASK')
	ELSE
		CALL SYS$EXIT(%VAL(ISTAT))
	ENDIF
C
C	ASSIGN LUN
C
	WRITE(6,200)
200	FORMAT(' ASSIGNING LUN ')
	ISTAT=SYS$ASSIGN(DEVICE,CHAN,%VAL(PSL$C_USER),)
	IF(ISTAT.EQ.SS$_NORMAL)THEN
		WRITE(6,201)
201		FORMAT(' UNIT NUMBER ASSIGNED')
	ELSE
		CALL SYS$EXIT(%VAL(ISTAT))
	ENDIF
C
C	FORMAT THE RK05
C
	WRITE(6,308)
308	FORMAT(' STARTING DISK FORMATTING')
	DO 400 I=1,100		!IN CHUNKS OF 48 BLOCKS(2 TRACKS BOTH SURFACES)
		P3=((I-1))*2*'10000'X
		ISTAT=SYS$QIOW(,%VAL(CHAN),%VAL(IO$_WRITEHEAD),IOSB,
	1	 ,,BUFFER,%VAL(24576),%VAL(P3),%VAL(0),%VAL(0),%VAL(0))
		IF(ISTAT.NE.SS$_NORMAL)THEN
			MESSAGE_VECTOR(2)=ISTAT
			CALL SYS$PUTMSG(MESSAGE_VECTOR)
			GOTO 500
		ELSEIF(IOERR.NE.SS$_NORMAL)THEN
			ISTAT=IOERR
			MESSAGE_VECTOR(2)=IAND(ISTAT,'0000FFFF'X)
			CALL SYS$PUTMSG(MESSAGE_VECTOR)
			IF((IOERR.EQ.SS$_FORMAT).OR.(IOERR.EQ.SS$_DATACHECK)
	1		 .OR.(IOERR.EQ.SS$_RDDELDATA).OR.(IOERR.EQ.SS$_TIMEOUT)
	1		 .OR.(IOERR.EQ.SS$_DATAOVERUN).OR.(IOERR.EQ.SS$_WASECC)
	1		 .OR.(IOERR.EQ.SS$_OPINCOMPL).OR.(IOERR.EQ.SS$_CTRLERR)
	1		 .OR.(IOERR.EQ.SS$_DRVERR).OR.(IOERR.EQ.SS$_PARITY)
	1		 )THEN
				GO TO 480
			ELSE
				GOTO 500
			ENDIF
		ENDIF
	GOTO 400
480	CONTINUE
C
C	TRY TO RECOVER FROM FORMAT ERROR
C
	WRITE(6,481)
481	FORMAT(' ATTEMPTING TO RECOVER FROM FORMAT ERROR')
	DO 482 RETRY_1=0,1
		DO 483 RETRY_2=0,1
			DO 484 RETRY_3=0,11
				P3=((I-1))*2*'10000'X+RETRY_1*'10000'X+
	1			  RETRY_2*'100'X+RETRY_3
				ISTAT=SYS$QIOW(,%VAL(CHAN),
	1			  %VAL(IO$_WRITEHEAD),IOSB,
	1			  ,,BUFFER,%VAL(512),%VAL(RETRY),
	1			  %VAL(0),%VAL(0),%VAL(0))
				IF(ISTAT.NE.SS$_NORMAL)THEN
					MESSAGE_VECTOR(2)=ISTAT
					WRITE(6,485)I+RETRY_1,RETRY_2,RETRY_3
485					FORMAT(' Error formatting block ',
	1				 ' Track ',I3,' Surface ',I1,
	1				 ' Sector ',I2)
					CALL SYS$PUTMSG(MESSAGE_VECTOR)
				ELSEIF(IOERR.NE.SS$_NORMAL)THEN
					ISTAT=IOERR
					MESSAGE_VECTOR(2)=IAND(ISTAT,
	1					'0000FFFF'X)
					WRITE(6,485)I+RETRY_1,RETRY_2,RETRY_3
					CALL SYS$PUTMSG(MESSAGE_VECTOR)
				ENDIF
484			CONTINUE
483		CONTINUE
482	CONTINUE
400	CONTINUE
C
C	CLOSE DOWN DRIVE 
C
500	CONTINUE
	WRITE(6,504)
504	FORMAT(' FORMAT COMPLETE STARTING DEASSIGN')
	ISTAT=SYS$DASSGN(%VAL(CHAN))
	IF(ISTAT.EQ.SS$_NORMAL)THEN
		WRITE(6,505)
505		FORMAT(' DEASSIGN COMPLETE')
	ELSE
		MESSAGE_VECTOR(2)=ISTAT
		CALL SYS$PUTMSG(MESSAGE_VECTOR)
	ENDIF
	WRITE(6,507)
507	FORMAT(' STARTING DEALLOCATE')
	ISTAT=SYS$DALLOC(DEVICE,%VAL(PSL$C_USER))
	IF(ISTAT.EQ.SS$_NORMAL)THEN
		WRITE(6,508)
508		FORMAT(' DEALLOCATE COMPLETE')
	ELSE
		MESSAGE_VECTOR(2)=ISTAT
		CALL SYS$PUTMSG(MESSAGE_VECTOR)
	ENDIF
	STOP
	END	
