/*
 * @DEC_COPYRIGHT@
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * HISTORY
 * $Log:	math-hdr,v $
 * Revision 4.1.2.8  92/04/23  15:39:36  William_Burns
 * 	Backed out 326-dve again
 * 	[92/04/23  15:25:59  William_Burns]
 * 
 * Revision 4.1.2.6  92/04/08  10:52:39  William_Burns
 * 	Restored submit 326-dve
 * 	[92/04/08  10:38:11  William_Burns]
 * 
 * Revision 4.1.2.4  92/04/06  09:33:16  Daniel_Eskenazi
 * 	Merge with BL5
 * 	[92/04/03  10:40:33  Daniel_Eskenazi]
 * 
 * 	Added remainder() declaration
 * 	[92/03/20  10:21:02  Daniel_Eskenazi]
 * 
 * 	Daniel Eskenazi- Added nextafter() declaration
 * 	[92/03/09  10:43:58  Daniel_Eskenazi]
 * 
 * Revision 4.1.2.3  92/03/27  15:26:59  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:59:48  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:52:48  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  16:20:02  Craig_Horman]
 * 
 * Revision 4.1.2.2  91/12/05  14:14:48  Jim_McHale
 * 	Merge with 3.0
 * 
 * Revision 4.1.1.2  91/11/22  17:45:46  Jim_McHale
 * 	Merge with 3.0
 * 
 * $EndLog$
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * math-hdr
 *
 *	Modification History:
 *
 * 01-Apr-91	Fred Canter
 *	MIPS C 2.20+, changes for -std
 *
 */
/* @(#)math.h   1.25  com/inc,3.1,9013 3/13/90 11:37:37 */
/*
 * COMPONENT_NAME: (math.h) math header file
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1988, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef  _MATH_H_
#define  _MATH_H_
#include <standards.h>

/*
 *      The ANSI standard requires that certain values be in math.h.
 *      It also requires that if _ANSI_C_SOURCE is defined then ONLY these
 *      values are present.
 *
 *      This header includes all the ANSI required entries. In addition
 *      other entries for the XIX system are included.
 *
 */

/*
 *      ANSI required entries in math.h
 *
 */
#ifdef _ANSI_C_SOURCE

#ifdef _NO_PROTO

  double acos();
  double asin();
  double atan();
  double atan2();
  double ceil();
  double cos();
  double cosh();
  double exp();
  double fabs();
  double floor();
  double fmod();
  double frexp();
  double ldexp();
  double log();
  double log10();
  double modf();
  double pow();
  double sin();
  double sinh();
  double sqrt();
  double tan();
  double tanh();

#else  /*_NO_PROTO */			/* Use ANSI C required prototyping */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif

  double acos(double );
  double asin(double );
  double atan(double );
  double atan2(double ,double );
  double ceil(double );
  double cos(double );
  double cosh(double );
  double exp(double );
  double fabs(double );
  double floor(double );
  double fmod(double , double );
  double frexp(double , int *);
  double ldexp(double , int );
  double log(double );
  double log10(double );
  double modf(double , double *);
  double pow(double , double );
  double sin(double );
  double sinh(double );
  double sqrt(double );
  double tan(double );
  double tanh(double );

#if defined(__cplusplus)
}
#endif
#endif
#endif /*_NO_PROTO */
#endif /*_ANSI_C_SOURCE */

/*
 *
 * The following function prototypes define functions available in the
 * XIX system but not required by the ANSI standard. They will not be
 * included in _ANSI_C_SOURCE is defined (strict ANSI conformance).
 *
 */

#ifdef _XOPEN_SOURCE

extern int signgam;


#ifdef _NO_PROTO
     double   erf();
     double   erfc();
     double   gamma();
     double   hypot();
     int      isnan();
     double   j0();
     double   j1();
     double   jn();
     double   lgamma();
     double   y0();
     double   y1();
     double   yn();

#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
     double   erf(double );
     double   erfc(double );
     double   gamma(double );
     double   hypot(double ,double );
     int      isnan(volatile double );
     double   j0(double );
     double   j1(double );
     double   jn(int n, double );
     double   lgamma(double );
     double   y0(double );
     double   y1(double );
     double   yn(int , double );

#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

#include <stdlib.h>

typedef struct { double r, i; } complex;

#ifdef _NO_PROTO

     double   acosh();
     double   asinh();
     double   atanh();
     double   cabs();
     double   cbrt();
     double   copysign ();
     double   drem();
     double   expm1();
     double   log1p();
     double   logb();
     double   nextafter();
     double   remainder();
     double   rint();
     double   scalb();
     int      finite();

#else /* _NO_PROTO */			/* Use ANSI C required prototyping */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif


     double   acosh(double );
     double   asinh(double );
     double   atanh(double );
     double   cabs(complex);
     double   cbrt(double );
     double   copysign (double , double );
     double   drem(double , double );
     double   expm1(double );
     double   log1p(double );
     double   logb();
     double   nextafter(double, double );
     double   remainder(double, double );
     double   rint(double );
     double   scalb(double , int );
     int      finite();


#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */

#define _ABS(x) ((x) < 0 ? -(x) : (x))
#define _REDUCE(TYPE, X, XN, C1, C2)    { \
        double x1 = (double)(TYPE)X, x2 = X - x1; \
        X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }
#define _POLY1(x, c)    ((c)[0] * (x) + (c)[1])
#define _POLY2(x, c)    (_POLY1((x), (c)) * (x) + (c)[2])
#define _POLY3(x, c)    (_POLY2((x), (c)) * (x) + (c)[3])
#define _POLY4(x, c)    (_POLY3((x), (c)) * (x) + (c)[4])
#define _POLY5(x, c)    (_POLY4((x), (c)) * (x) + (c)[5])
#define _POLY6(x, c)    (_POLY5((x), (c)) * (x) + (c)[6])
#define _POLY7(x, c)    (_POLY6((x), (c)) * (x) + (c)[7])
#define _POLY8(x, c)    (_POLY7((x), (c)) * (x) + (c)[8])
#define _POLY9(x, c)    (_POLY8((x), (c)) * (x) + (c)[9])


struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};

#define 	DOMAIN		01
#define		SING		02
#define		OVERFLOW	03
#define		UNDERFLOW	04
#define		TLOSS		05
#define		PLOSS		06

#endif /* _OSF_SOURCE */

/* N.B.  This FILE must be catenated with a machine-dependent file  ${MACHINE}/math.h
   with ends with #endif for _MATH_H_ feature-test
*/

/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	math.h,v $
 * Revision 4.2.3.4  92/04/08  12:06:23  David_Metsky
 * 	use _MAXFLOAT to test for MAXFLOAT as in values.h
 * 	[92/03/31  18:26:01  David_Metsky]
 * 
 * Revision 4.2.3.3  92/01/16  13:49:57  Jim_McHale
 * 	"SR#32 - DE tin bl7/8 mods"
 * 
 * Revision 4.2.2.3  92/01/16  13:27:58  Jim_McHale
 * 	Merge DE tin bl7/8/ mods with AG
 * 
 * Revision 4.2.3.2  91/12/20  13:14:43  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 91/11/19 13:47:18;  author: devrcs;  state: Exp;  lines added/del: 15/9
 * 	sccs rev: 3.2;  orig date: 91/11/07 13:22:30;  orig author: iannelli
 * 	1079-iannelli-942 - QAR 1108 (tin)
 * 	Fix conflict with math.h
 * 	Fix errors in math constants
 * 	[91/12/20  12:06:54  William_Burns]
 * 
 * Revision 4.2.2.2  91/12/20  12:39:15  Jim_McHale
 * 	Merge TIN bl7/bl8 changes
 * 
 * Revision 4.2  91/09/20  05:06:54  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: math.h,v $ $Revision: 4.2.3.4 $ (DEC) $Date: 92/04/08 12:06:23 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * COMPONENT_NAME: (math.h) math header file
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1988, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/*
 *      ANSI required entries in math.h
 *
 */
#ifdef _ANSI_C_SOURCE

#define HUGE_VAL 1.8e308

#endif /*_ANSI_C_SOURCE */

/*
 *
 * The following function prototypes define functions available in the
 * XIX system but not required by the ANSI standard. They will not be
 * included in _ANSI_C_SOURCE is defined (strict ANSI conformance).
 *
 */

#ifdef _XOPEN_SOURCE

/*
 *      Useful mathmatical constants:
 *
 * M_E          - e
 * M_LOG2E      - log2(e)
 * M_LOG10E     - log10(e)
 * M_LN2        - ln(2)
 * M_PI         - pi
 * M_PI_2       - pi/2
 * M_PI_4       - pi/4
 * M_1_PI       - 1/pi
 * M_2_PI       - 2/pi
 * M_2_SQRTPI   - 2/(sqrt(pi)
 * M_SQRT2      - sqrt(2)
 * M_SQRT_2     - 1/sqrt(2)
*/

#define M_E        2.7182818284590452354E0  /*Hex  2^ 0 * 1.5bf0a8b145769 */
#define M_LOG2E    1.4426950408889634074E0  /*Hex  2^ 0 * 1.71547652B82FE */
#define M_LOG10E   4.3429448190325182765E-1 /*Hex  2^-2 * 1.BCB7B1526E50E */
#ifndef M_LN2
#define M_LN2      6.9314718055994530942E-1 /*Hex  2^-1 * 1.62E42FEFA39EF */
#endif
#define M_LN10     2.3025850929940456840E0  /*Hex  2^ 1 * 1.26bb1bbb55516 */
#ifndef M_PI
#define M_PI       3.1415926535897932846E0  /*Hex  2^ 1 * 1.921FB54442D18 */
#endif
#define M_PI_2     1.57079632679489661923E0  /*Hex  2^ 0 * 1.921FB54442D18 */
#define M_PI_4     7.8539816339744820962E-1 /*Hex  2^-1 * 1.921FB54442D18 */
#define M_1_PI     3.1830988618379067154E-1 /*Hex  2^-2 * 1.45f306dc9c883 */
#define M_2_PI     6.3661977236758134308E-1 /*Hex  2^-1 * 1.45f306dc9c883 */
#define M_2_SQRTPI 1.1283791670955125739E0  /*Hex  2^ 0 * 1.20dd750429b6d */
#ifndef M_SQRT2
#define M_SQRT2    1.4142135623730950488E0  /*Hex  2^ 0 * 1.6A09E667F3BCD */
#endif
#define M_SQRT1_2  7.0710678118654752440E-1 /*Hex  2^-1 * 1.6a09e667f3bcd */


#ifndef _MAXFLOAT
#define _MAXFLOAT
#define MAXFLOAT            ((float)3.40282346638528860e+38)
#endif

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

/*
 *      Useful mathmatical constants:
 *
 * HUGE         - +infinity
 * M_2PI        - 2*pi
 *
 */
#define HUGE       HUGE_VAL
#define M_2PI      6.28318530717958647692E0  /*Hex  2^ 2 * 1.921FB54442D18 */

/* This is the nearest number to the cube root of MAXDOUBLE that   */
/*      doesn't cause the cube of it to overflow.                  */
/* In double precision hex this constant is: 554428a2 f98d728a     */
#define CUBRTHUGE      5.6438030941223618e102
#define INV_CUBRTHUGE  1.7718548704178434e-103

#endif /* _OSF_SOURCE */
#endif /* _MATH_H_ */

