/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ChfDef.h,v $
 * Revision 1.1.2.2  92/03/12  17:30:21  Ray_Giroux
 * 	Initial creation
 * 	[92/03/12  17:23:51  Ray_Giroux]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: ChfDef.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/03/12 17:30:21 $
 */
/*
**  Structure definitions and typedefs
*/
typedef int (*ChfCondHandPtr)();

/*
** Portable condition handling structures
*/

typedef struct _ChfSigVec
  {
    int           args;         /* Number of longwords (VARIABLE) */
    int           name;         /* Name of condition */
    int           arg1;         /* 1st signal specific arg. (if it exists) */
  } ChfSigVec, *ChfSigVecPtr;
  
typedef struct _ChfMchArgs {
  int	          args;		/* Number of longwords (always 4)	    */
  int             frame;	/* Frame of establisher			    */
  int	          depth;	/* Depth of establisher			    */
  int	          save_R0;	/* Saved R0				    */
  int	          save_R1;	/* Saved R1				    */
} ChfMchArgs, *ChfMchArgsPtr;

typedef struct _ChfArgList
  {
    ChfSigVecPtr  signal_vector;
    ChfMchArgsPtr mech_array;
  } ChfArgList, *ChfArgListPtr;

/*
**  Condition value structure
**
**	Condition values are 32-bit values that uniquely define a message. The
**	condition value, which is created from information defined in a message
**	source file, consists of:
**
**	o The severity level defined in the severity directive or message
**	  definition.
**
**      o The message number assigned automagically by a message definition or
**	  specified with the base message number directive.
**
**	o The facility number defined in the facility directive.
**
**	o Internal control flags
**
**      3        2 2               1 1
**	1        8 7               6 5              3 2    0
**	+---------+-----------------+----------------+-----+
**	| control | facility number | message number | sev |
**	+---------+-----------------+----------------+-----+
**	
*/
struct	_ChfR_CondValue
{
    unsigned    severity : 3;
#define ChfK_SevError      2
#define ChfK_SevInfo       3
#define ChfK_SevSevere     4
#define ChfK_SevSuccess    1
#define ChfK_SevWarning    0
    unsigned	code : 13;
    unsigned	facility : 12;
    unsigned	control : 4;
};

typedef struct _ChfR_CondValue ChfR_CondValue;

/*
**  MACRO definitions
*/
#define ChfInitialize()

/*
**  Equated Symbols
*/
#define Chf_Continue	1
#define Chf_Resignal	2328
#define Chf_Unwind	2336

#define Chf_Normal	1
#define Chf_InsFrm	300
#define Chf_NoSignal	2304
#define Chf_Unwinding	2344

/*
**  Chf Entry Points
*/
extern void		ChfSignal();
extern unsigned long    ChfSigToRet();
extern void		ChfStop();
extern ChfCondHandPtr	ChfEstablish();
extern unsigned long	ChfFao();
extern unsigned long	ChfFaoL();
extern unsigned long	ChfGetMsg();
extern unsigned long    ChfMatchCondition();
extern unsigned long	ChfPutMsg();
extern ChfCondHandPtr   ChfRevert();
extern unsigned long	ChfUnwind();
extern int              ChfDefaultHandler();
