/*  DEC/CMS REPLACEMENT HISTORY, Element XTOS.H */
/*  *3     2-JAN-1991 11:16:57 BMATTHEWS "add vms allocate_local and deallocate_local macros" */
/*  *2    17-APR-1990 14:01:49 JVANGILDER "1.1 vg-alpha" */
/*  *1    29-MAR-1990 15:41:29 JVANGILDER "V3 BL1 checkin" */
/*  DEC/CMS REPLACEMENT HISTORY, Element XTOS.H */
/*
* $XConsortium: Xtos.h,v 1.6 89/12/19 08:23:59 swick Exp $
*/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _Xtos_h
#define _Xtos_h

#ifdef INCLUDE_ALLOCA_H
#include <alloca.h>
#endif

#ifdef CRAY
#define WORD64
#define MAXPATHLEN PATH_MAX
#endif

#ifdef __HIGHC__
# ifdef MissingStdargH
#  if MissingStdargH
#   define MISSING_STDARG_H
#  endif
# else
#  define MISSING_STDARG_H
# endif

# ifdef MISSING_STDARG_H

#ifndef _STDARG_H
#define _STDARG_H

typedef char *va_list;

/* Amount of space required in an argument list for an arg of type TYPE.
   TYPE may alternatively be an expression whose type is used.  */

#define __va_rounded_size(TYPE)  \
  (((sizeof (TYPE) + sizeof (int) - 1) / sizeof (int)) * sizeof (int))

#define va_start(AP, LASTARG)                                           \
 (AP = ((char *) &(LASTARG) + __va_rounded_size (LASTARG)))

#define va_end(AP)

#define va_arg(AP, TYPE)                                                \
 (AP += __va_rounded_size (TYPE),                                       \
  *((TYPE *) (AP - __va_rounded_size (TYPE))))

#endif /* _STDARG_H */

# endif /* MissingStdargH */
#endif /* __HIGHC__ */


/* stolen from server/include/os.h */
#ifdef VMS
/*
* define allocate_local and deallocate_local as macros for small allocations
* using and reusing a single static per thread data area. If the toolkit
* is made multithread someday then either these statics should be in per
* thread space or the _XtAllocBusy flag use must be made thread safe.
*/
#define _XTALLOC_STACK_SIZE 512
#ifdef INTRINSIC_C
_align(QUADWORD) char _XtAllocLocalArray[_XTALLOC_STACK_SIZE];
long _XtAllocBusy = 0;
#else
extern char _XtAllocLocalArray[_XTALLOC_STACK_SIZE];
extern long _XtAllocBusy;
#endif
#define ALLOCATE_LOCAL(size) \
    ((((size) <= _XTALLOC_STACK_SIZE) && (_XtAllocBusy == 0)) ? \
		(_XtAllocBusy = 1, (char *) &_XtAllocLocalArray) : \
		((char *) XtMalloc(size)))

#define DEALLOCATE_LOCAL(ptr) \
    if ((ptr) == &_XtAllocLocalArray) {_XtAllocBusy = 0;} else {XtFree(ptr);}
#define NO_ALLOCA
#endif

#ifndef NO_ALLOCA
/*
 * os-dependent definition of local allocation and deallocation
 * If you want something other than XtMalloc/XtFree for ALLOCATE/DEALLOCATE
 * LOCAL then you add that in here.
 */
#if defined(__HIGHC__)

extern char *alloca();

#if HCVERSION < 21003
#define ALLOCATE_LOCAL(size)	alloca((int)(size))
pragma on(alloca);
#else /* HCVERSION >= 21003 */
#define	ALLOCATE_LOCAL(size)	_Alloca((int)(size))
#endif /* HCVERSION < 21003 */

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* defined(__HIGHC__) */


#ifdef __GNUC__
#define alloca __builtin_alloca
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
/*
 * warning: mips alloca is unsuitable in the server, do not use.
 */
#if defined(vax) || defined(sun) || defined(__DECC)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix it here.
 */
char *alloca();
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* vax or sun or __DECC */
#endif /* __GNUC__ */

#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) XtMalloc((unsigned long)(size))
#define DEALLOCATE_LOCAL(ptr) XtFree((XtPointer)(ptr))
#endif /* ALLOCATE_LOCAL */

#endif /* _Xtos_h */
/* DON'T ADD STUFF AFTER THIS #endif */
