/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	X10.h,v $
 * Revision 1.2  91/12/30  12:48:20  devbld
 * Initial load of project
 * 
 * $EndLog$
 */
/* $Header: /usr/sde/uws/rcs/uws3.0/src/./dec/lib/X/X10.h,v 1.2 91/12/30 12:48:20 devbld Exp $
******************************************************************************
* Copyright (c) Digital Equipment Corporation, 1990 All Rights Reserved.     *
* Unpublished rights reserved under the copyright laws of the United States. *
*                                                                            *
* The software contained on this media is proprietary to and embodies the    *
* confidential technology of Digital Equipment Corporation.  Possession, use,*
* duplication or dissemination of the software and media is authorized only  *
* pursuant to a valid written license from Digital Equipment Corporation.    *
*                                                                            *
* RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the          *
* U.S. Government is subject to restrictions as set forth in Subparagraph    *
* (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.      *
******************************************************************************
*/
/*
 *	X10.h - Header definition and support file for the C subroutine
 *	interface library for V10 support routines.
 */
#ifndef _X10_H_
#define _X10_H_

/* Used in XDraw and XDrawFilled */

typedef struct {
	short x, y;
	unsigned short flags;
} Vertex;

/* The meanings of the flag bits.  If the bit is 1 the predicate is true */

#define VertexRelative		0x0001		/* else absolute */
#define VertexDontDraw		0x0002		/* else draw */
#define VertexCurved		0x0004		/* else straight */
#define VertexStartClosed	0x0008		/* else not */
#define VertexEndClosed		0x0010		/* else not */
/*#define VertexDrawLastPoint	0x0020 	*/      /* else don't */	

/*
The VertexDrawLastPoint option has not been implemented in XDraw and 
XDrawFilled so it shouldn't be defined. 
*/

/*
 * XAssoc - Associations used in the XAssocTable data structure.  The 
 * associations are used as circular queue entries in the association table
 * which is contains an array of circular queues (buckets).
 */
typedef struct _XAssoc {
	struct _XAssoc *next;	/* Next object in this bucket. */
	struct _XAssoc *prev;	/* Previous obejct in this bucket. */
	Display *display;	/* Display which ownes the id. */
	XID x_id;		/* X Window System id. */
	char *data;		/* Pointer to untyped memory. */
} XAssoc;

/* 
 * XAssocTable - X Window System id to data structure pointer association
 * table.  An XAssocTable is a hash table whose buckets are circular
 * queues of XAssoc's.  The XAssocTable is constructed from an array of
 * XAssoc's which are the circular queue headers (bucket headers).  
 * An XAssocTable consists an XAssoc pointer that points to the first
 * bucket in the bucket array and an integer that indicates the number
 * of buckets in the array.
 */
typedef struct {
    XAssoc *buckets;		/* Pointer to first bucket in bucket array.*/
    int size;			/* Table size (number of buckets). */
} XAssocTable;

XAssocTable *XCreateAssocTable();
char *XLookUpAssoc();

#endif /* _X10_H_ */
