/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cma_config.h,v $
 * Revision 4.2.2.2  92/02/12  15:53:42  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 92/02/05 13:55:58;  author: devrcs;  state: Exp;  lines added/del: 22/28
 * 	sccs rev: 3.2;  orig date: 92/01/20 16:22:39;  orig author: scales
 * 	Bugfixes for MUP
 * 	[92/02/11  12:26:50  William_Burns]
 * 
 * Revision 4.2  91/09/20  04:56:08  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: cma_config.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/02/12 15:53:42 $
 */
/*
 *  FACILITY:
 *
 *	CMA services
 *
 *  ABSTRACT:
 *
 *	Configuration header file to set up control symbols.
 *
 *  AUTHORS:
 *
 *	Dave Butenhof
 *
 *  CREATION DATE:
 *
 *	26 January 1990
 *
 *  MODIFICATION HISTORY:
 *
 *	001	Dave Butenhof	9 February 1990
 *		Add _CMA_UPSTACK_ conditional to specify that machine's
 *		stacks grow towards higher addresses.
 *	002	Dave Butenhof	2 March 1990
 *		Add support for Apollo M68000
 *	003	Dave Butenhof	10 April 1990
 *		Integrate Kevin Ackley's changes to M68000 support.
 *	004	Webb Scales	27 April 1990
 *		Integrate Kevin Ackley's changes for BL2.
 *	005	Dave Butenhof	23 May 1990
 *		Make selection for Apollo prototype support more specific
 *		than simply "M68K UNIX" platform.
 *	006	Dave Butenhof	20 June 1990
 *		Add config. symbol for multiprocessor spinlock count.
 *	007	Paul Curtin	22 June 1990
 *		Changed logic on _cma_protect_memory_ now on for vms/unix
 *	008	Paul Curtin	17 July 1990
 *		Removed elif's, set _cma_protect_memory_ 0 on unknown systems
 *	009	Webb Scales	15 August 1990
 *		Added HPPA and SUN-m68K platforms
 *	010	Webb Scales	31 August 1990
 *		Added severity argument to CMA_STATUS macro
 *	011	Bob Conti	8 October 1990
 *		Restored use of "high" E-values on U*IX to help ensure
 *		uniqueness of CMA errors with respect to system errors.
 *	012	Dave Butenhof	9 October 1990
 *		Invent new config symbols, _CMA_IMPORT_ and _CMA_EXPORT_, so
 *		we can go back to using VAX C's hacky globalref/globaldef
 *		(for better VAX/VMS integration) without confusing code (too
 *		much) for other platforms.
 *	013	Dave Butenhof	12 November 1990
 *		Improve Apollo support by checking for _ISP__M68K
 *	014	Dave Butenhof	27 November 1990
 *		Add IBM RIOS support provided by Dave Mehaffy.
 *	015	Dave Butenhof	14 February 1991
 *		Use prototypes and "void *" regardless of platform if using
 *		VAX C or DEC C, and support Glockenspiel C++. Changes mostly
 *		courtesy of Aron Insinga.
 *	016	Paul Curtin	15 February 1991
 *		Fixed a typo
 *	017	Dave Butenhof	19 February 1991
 *		Additional C++ changes.
 *	018	Dave Butenhof	25 February 1991
 *		Look for _AIX in OS check, since AIX CC doesn't define "unix"
 *		by default (and we treat it as generic U*IX).
 *	019	Dave Butenhof	26 March 1991
 *		Move _CMA_STATUS_ macro to exc_handling.h (since that's the
 *		only place it's used).
 *	020	Dave Butenhof	01 April 1991
 *		Support generic OSF/1 platform
 *	021	Dave Butenhof	03 April 1991
 *		Support for Mach threads.
 *	022	Paul Curtin	23 April 1991
 *		fixed a typo.
 *	023	Dave Butenhof	25 April 1991
 *		Alter OSF/1 support to handle ULTRIX/OSF BL3 symbols.
 *	024-A1	Webb Scales	9 January 1991
 *		Add support for void* on DEC OSF/1.
 */

#ifndef CMA_CONFIG
#define CMA_CONFIG

/*
 *  INCLUDE FILES
 */

/*
 * CONSTANTS AND MACROS
 */

/*
 * NOTE: all configuration symbols are set up such that they can be
 * overridden by a -D switch on the command line if desired.
 */

/*
 * Name of the platform C compiler
 */
#define _CMA__CC	1
#define _CMA__VAXC	2
#define _CMA__DECC	3
#define _CMA__CFRONT	4
#define _CMA__GCC	5

/*
 * Test for C++ compilers before C compilers because Glockenspiel C++ also
 * defines symbols for the VAX C compiler and this could be the case for
 * other C++/C compiler combinations
 */
#ifndef _CMA_COMPILER_
# if defined(__cplusplus)		/* test for other C++ compilers first */
#  define _CMA_COMPILER_	_CMA__CFRONT
# elif defined(vaxc) || defined(VAXC) || defined(__vaxc) || defined(__VAXC)
#  define _CMA_COMPILER_	_CMA__VAXC
# elif defined(__decc) || defined(__DECC)
#  define _CMA_COMPILER_	_CMA__DECC
# elif defined(__GNUC__)
#  define _CMA_COMPILER_	_CMA__GCC
# else
#  define _CMA_COMPILER_	_CMA__CC
# endif
#endif

/*
 * Name of the hardware platform
 */
#define	_CMA__MIPS	1
#define	_CMA__VAX	2
#define _CMA__M68K	3
#define _CMA__HPPA	4
#define _CMA__IBMR2     5

#ifndef	_CMA_HARDWARE_
# if defined(vax) || defined (VAX) || defined(__vax) || defined(__VAX)
#  define	_CMA_HARDWARE_	_CMA__VAX
# endif
# if defined(mips) || defined(MIPS) || defined(__mips) || defined(__MIPS) || defined(__MIPSEL__) || defined(__mips__)
#  define	_CMA_HARDWARE_	_CMA__MIPS
# endif
# if defined(m68k) || defined(m68000) || defined(_ISP__M68K) || defined(M68000) || defined(mc68000) 
#  define	_CMA_HARDWARE_	_CMA__M68K
# endif
# if defined(hp9000s300) || defined(__hp9000s300)
#  define	_CMA_HARDWARE_	_CMA__M68K
# endif
# if defined(__hppa0)
#  define	_CMA_HARDWARE_	_CMA__HPPA
# endif
# if defined(_IBMR2)
#  define _CMA_HARDWARE_ _CMA__IBMR2
# endif
# ifndef _CMA_HARDWARE_
   !!!Error: _CMA_HARDWARE_ not set
# endif
#endif

/*
 * Name of the software platform
 */
#define	_CMA__UNIX	1
#define	_CMA__VMS	2

#ifndef	_CMA_OS_
# if defined(unix) || defined(__unix) || defined(__unix__) || defined(_AIX) || defined(__OSF__) || defined(__osf__)
#  define	_CMA_OS_	_CMA__UNIX
# endif
# if defined(vms) || defined(__vms) || defined(VMS) || defined(__VMS) || defined(__vms__)
#  define	_CMA_OS_	_CMA__VMS
# endif
# ifndef _CMA_OS_
   !!!Error: _CMA_OS_ not set
# endif
#endif

/*
 * Name of the software vendor
 */
#define _CMA__APOLLO	1
#define _CMA__DIGITAL	2
#define _CMA__HP        3
#define _CMA__IBM       4
#define _CMA__OSF	5
#define _CMA__SUN       6

#ifndef _CMA_VENDOR_
# ifdef apollo
#  define	_CMA_VENDOR_	_CMA__APOLLO
# endif
# if _CMA_OS_ == _CMA__VMS
#  define	_CMA_VENDOR_	_CMA__DIGITAL
# endif
# if defined(ultrix) || defined(__ULTRIX) || defined (__ultrix__)
#  define	_CMA_VENDOR_	_CMA__DIGITAL
# endif
# if defined(__osf__) && !defined(__OSF__) && (_CMA_HARDWARE_ == _CMA__MIPS)
#  define	_CMA_VENDOR_	_CMA__DIGITAL
# endif
# if defined(hpux) || defined(__hpux)
#  define	_CMA_VENDOR_	_CMA__HP
# endif
# ifdef _IBMR2
#  define 	_CMA_VENDOR_	_CMA__IBM
# endif
# ifdef sun
#  define	_CMA_VENDOR_	_CMA__SUN
# endif
# if defined (__OSF__) && !defined (_CMA_VENDOR_)
#  define	_CMA_VENDOR_	_CMA__OSF
# endif
# ifndef _CMA_VENDOR_
   !!!Error: _CMA_VENDOR_ not set
# endif
#endif

/*
 * Combined platform (OS + hardware)
 */
#define	_CMA__MIPS_UNIX	1
#define	_CMA__VAX_VMS	2
#define _CMA__VAX_UNIX	3
#define _CMA__M68K_UNIX	4
#define _CMA__HPPA_UNIX	5
#define _CMA__IBMR2_UNIX 6

#ifndef	_CMA_PLATFORM_
# if _CMA_OS_ == _CMA__UNIX
#  if _CMA_HARDWARE_ == _CMA__MIPS
#   define _CMA_PLATFORM_	_CMA__MIPS_UNIX
#  endif
#  if _CMA_HARDWARE_ == _CMA__VAX
#   define _CMA_PLATFORM_	_CMA__VAX_UNIX
#  endif
#  if _CMA_HARDWARE_ == _CMA__M68K
#   define _CMA_PLATFORM_	_CMA__M68K_UNIX
#  endif
#  if _CMA_HARDWARE_ == _CMA__HPPA
#   define _CMA_PLATFORM_	_CMA__HPPA_UNIX
#  endif
#  if _CMA_HARDWARE_ == _CMA__IBMR2
#   define _CMA_PLATFORM_	_CMA__IBMR2_UNIX
#  endif
# endif
# if (_CMA_OS_ == _CMA__VMS) && (_CMA_HARDWARE_ == _CMA__VAX)
#  define _CMA_PLATFORM_	_CMA__VAX_VMS
# endif
# ifndef _CMA_PLATFORM_
   !!!Error: _CMA_PLATFORM_ not set
# endif
#endif

/*
 * Set to 1 if system supports setting memory page protection (see
 * cma_stack.c for use of page protection routines; "cma_vmprot.h" defines
 * interface to generic jacket routines "cma__set_noaccess" and
 * "cma__set_access").
 */
#ifndef _CMA_PROTECT_MEMORY_
# if _CMA_PLATFORM_ == _CMA__VAX_VMS
#  define _CMA_PROTECT_MEMORY_	1
# endif
# if _CMA_PLATFORM_ == _CMA__MIPS_UNIX
#  define _CMA_PROTECT_MEMORY_  1
# endif
# if _CMA_PLATFORM_ == _CMA__VAX_UNIX
#  define _CMA_PROTECT_MEMORY_  1
# endif
#endif

/*
 * This controls whether ANSI C function prototypes are used for CMA
 * interfaces.
 */
#ifndef	_CMA_PROTO_
# ifdef __STDC__
#  define _CMA_PROTO_		1
# endif
# if _CMA_COMPILER_ == _CMA__DECC
#  define _CMA_PROTO_		1
# endif
# if _CMA_COMPILER_ == _CMA__GCC
#  define _CMA_PROTO_		1
# endif
# if _CMA_COMPILER_ == _CMA__CFRONT
#  define _CMA_PROTO_		1
# endif
# if _CMA_COMPILER_ == _CMA__VAXC
#  define _CMA_PROTO_		1
# endif
# if _CMA_PLATFORM_ == _CMA__MIPS_UNIX
#  define _CMA_PROTO_		1
# endif
# if _CMA_VENDOR_ == _CMA__APOLLO
#  define _CMA_PROTO_		1
# endif
# if (_CMA_VENDOR_ == _CMA__HP) && (_CMA_HARDWARE_ == _CMA__HPPA)
#  define _CMA_PROTO_		1
# endif
# if _CMA_PLATFORM_ == _CMA__IBMR2_UNIX
#  define _CMA_PROTO_		1
# endif
/* Otherwise, _CMA_PROTO_ is undefined, which means do not use prototypes. */
#endif

#define _CMA__OS_AIX	1
#define _CMA__OS_OSF	2
#define _CMA__OS_BSD	3
#define _CMA__OS_SYSV	4

/*
 * MIPS C on DEC OSF/1 sets __osf__ but not __OSF__; but gcc on "raw" OSF/1
 * sets __OSF__ but not __osf__. This little ditty provides a bridge.
 */
#if defined (__OSF__) && !defined (__osf__)
# define __osf__
#endif

#ifndef _CMA_OSIMPL_
# if defined (__osf__)
#  define _CMA_OSIMPL_		_CMA__OS_OSF
# else
#  if _CMA_VENDOR_ == _CMA__IBM
#   define _CMA_OSIMPL_		_CMA__OS_AIX
#  else
#   if _CMA_VENDOR_ == _CMA__SUN
#    define _CMA_OSIMPL_	_CMA__OS_SYSV
#   else
#    define _CMA_OSIMPL_	_CMA__OS_BSD
#   endif
#  endif
# endif
#endif

/*
 * The stack manager module (cma_stack.c) can printf messages which can be
 * useful for debugging (if changes are made to stack management for a
 * platform).
 */
#ifndef _CMA_STACK_TRACE_
# define _CMA_STACK_TRACE_	0	/* DEBUG (report stack management) */
#endif

/*
 * Define whether to use "void *" or "char *" pointers, based on whether the
 * compiler can support them.
 */
#ifndef	_CMA_VOID_
# ifdef __STDC__
#  if (_CMA_PLATFORM_ != _CMA__MIPS_UNIX) || (_CMA_OSIMPL_ != _CMA__OS_BSD)
#   define _CMA_VOID_		1
#  endif
# endif
# if _CMA_OSIMPL_ == _CMA__OS_OSF
#  define _CMA_VOID_		1
# endif
# if _CMA_COMPILER_ == _CMA__VAXC 
#  define _CMA_VOID_	        1
# endif
# if _CMA_COMPILER_ == _CMA__CFRONT
#  define _CMA_VOID_		1
# endif
# if _CMA_COMPILER_ == _CMA__DECC
#  define _CMA_VOID_		1
# endif
# if _CMA_VENDOR_ == _CMA__APOLLO 
#  define _CMA_VOID_	        1
# endif
# if _CMA_VENDOR_ == _CMA__SUN
#  define _CMA_VOID_            1
# endif
# if _CMA_VENDOR_ == _CMA__HP
#  define _CMA_VOID_            1
# endif
# ifndef _CMA_VOID_
#  define _CMA_VOID_		0
# endif
#endif

/*
 * Certain structures within CMA (especially in exception handling) should be
 * marked "volatile", however some C compilers do not support "volatile" on
 * structures.  Set this to "volatile" unless using such a deficient
 * compiler, in which case it should be "".
 */
#ifndef	_CMA_VOLATILE_
# if _CMA_PLATFORM_ == _CMA__VAX_UNIX
#  if _CMA_COMPILER_ == _CMA__CC
#   define _CMA_VOLATILE_
#   define _CMA_VOLATILE_FLAG_		0
#  endif
# endif
# if _CMA_VENDOR_ == _CMA__SUN
#  define _CMA_VOLATILE_
#  define _CMA_VOLATILE_FLAG_		0
# endif
#ifndef	_CMA_VOLATILE_
#  define _CMA_VOLATILE_  		volatile
#  define _CMA_VOLATILE_FLAG_		1
# endif
#endif

/*
 * This symbol defines whether stacks grow towards lower addresses or higher
 * addresses (_CMA_UPSTACK_ is defined if the stack grows up).
 */
#ifndef _CMA_UPSTACK_
# if _CMA_HARDWARE_ == _CMA__HPPA
#  define _CMA_UPSTACK_ 1
# endif
#endif

/*
 * If the platform supports kernel threads, then the DECthreads VP layer can
 * provide parallel computation. This symbol defines the variety of kernel
 * threads supported by the platform.
 */
#define _CMA__NONE	0
#define _CMA__MACH	1

#ifndef _CMA_KTHREADS_
# if _CMA_OSIMPL_ == _CMA__OS_OSF
#  define _CMA_KTHREADS_	_CMA__MACH
# else
#  define _CMA_KTHREADS_	_CMA__NONE
# endif
#endif

/*
 * This symbol, if defined, provides for some shortcuts that can be made when
 * only uniprocessor hardware is supported (for example, using a fixed entry
 * for "current thread" instead of search stack clusters).
 */
#ifndef _CMA_UNIPROCESSOR_
# if _CMA_KTHREADS_ == _CMA__NONE
#  define _CMA_UNIPROCESSOR_	1
# else
#  define _CMA_UNIPROCESSOR_	0
# endif
#endif

/*
 * Specify whether this implementation will multiplex on top of VPs
 */
#ifndef _CMA_MULTIPLEX_
# if !_CMA_UNIPROCESSOR_
#  define _CMA_MULTIPLEX_	0	/* No support yet! */
# endif
# ifndef _CMA_MULTIPLEX_
#  define _CMA_MULTIPLEX_	0
# endif
#endif

/*
 * The expression "if _CMA_MULTIPLEX_ || (_CMA_KTHREADS_ == _CMA__NONE)" is
 * used so frequently that it's worth having a simpler way to detect whether
 * kernel thread mapping is one-to-one or some form of multiplexing (on
 * kernel threads or a single process) is going on.
 */
#ifndef _CMA_THREAD_IS_VP_
# if _CMA_MULTIPLEX_ || (_CMA_KTHREADS_ == _CMA__NONE)
#  define _CMA_THREAD_IS_VP_	0
# else
#  define _CMA_THREAD_IS_VP_	1
# endif
#endif

/*
 * This symbol controls the number of times a thread will spin (in a tight
 * loop) attempting to lock a mutex before it gives up and blocks itself.
 *
 * On a uniprocessor configuration, this symbol should be defined to zero;
 * spinning won't accomplish anything but to waste the rest of the thread's
 * timeslice.
 */
#ifndef _CMA_SPINLOOP_
# if _CMA_UNIPROCESSOR_
#  define	_CMA_SPINLOOP_		0
# else
#  define	_CMA_SPINLOOP_		100
# endif
#endif

/*
 * Some UNIX vendors don't yet provide POSIX compatible sigaction().
 * In this case, use sigvec() instead.
 */
#ifndef _CMA_NO_POSIX_SIGNAL_
# if _CMA_VENDOR_ == _CMA__SUN
#  define _CMA_NO_POSIX_SIGNAL_         1
# endif
#endif

/*
 * Use ANSI varargs method for functions with variable number of
 * arguments.  Not same as _CMA_PROTO_ or __STDC__, because some
 * compilers support varargs without prototypes or full __STDC__
 * compatibility.
 */
#ifndef _CMA_VARARGS_
# ifdef __STDC__
#  define _CMA_VARARGS_		1
# endif
# if _CMA_COMPILER_ == _CMA__VAXC
#  define _CMA_VARARGS_		1
# endif
# if _CMA_PLATFORM_ == _CMA__MIPS_UNIX
#  define _CMA_VARARGS_		1
# endif
# if _CMA_VENDOR_ == _CMA__APOLLO
#  define _CMA_VARARGS_		1
# endif
# if _CMA_VENDOR_ == _CMA__SUN
#  define _CMA_VARARGS_		1
# endif
# if _CMA_VENDOR_ == _CMA__HP
#  define _CMA_VARARGS_		1
# endif
# if _CMA_PLATFORM_ == _CMA__IBMR2_UNIX
#  define _CMA_VARARGS_		1
# endif
#endif

/*
 * Define the symbols used to "import" and "export" symbols for the client
 * interface.  Note that these shouldn't be used for symbols shared only
 * between CMA modules; it's for those symbols which are "imported" in the
 * cma.h (or pthread.h) header files, such as cma_c_null,
 * pthread_attr_default, and the exception names.
 *
 * On most platforms (with well-integrated C compilers), "import" should be
 * "extern", and "export" should be "".
 */
#if _CMA_PLATFORM_ == _CMA__VAX_VMS
# define _CMA_IMPORT_ globalref
# define _CMA_EXPORT_ globaldef
#else
# define _CMA_IMPORT_ extern
# define _CMA_EXPORT_
#endif

/*
 * TYPEDEFS
 */

/*
 *  GLOBAL DATA
 */

/*
 * INTERNAL INTERFACES
 */

#endif
