/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cma.h,v $
 * Revision 4.2  91/09/20  04:55:32  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: cma.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/20 04:55:32 $
 */
/*
 *  Copyright (c) 1989, 1991 by
 *  Digital Equipment Corporation, Maynard Massachusetts.
 *  All rights reserved.
 *
 *  This software is furnished under a license and may be used and  copied
 *  only  in  accordance  with  the  terms  of  such  license and with the
 *  inclusion of the above copyright notice.  This software or  any  other
 *  copies  thereof may not be provided or otherwise made available to any
 *  other person.  No title to and ownership of  the  software  is  hereby
 *  transferred.
 *
 *  The information in this software is subject to change  without  notice
 *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment
 *  Corporation.
 *
 *  DIGITAL assumes no responsibility for the use or  reliability  of  its
 *  software on equipment which is not supplied by DIGITAL.
 */

/*
 *  FACILITY:
 *
 *	Digital's Proprietary Interface to DECthreads (CMA)
 *
 *  ABSTRACT:
 *
 *	External definitions for CMA services
 *
 *  AUTHORS:
 *
 *	Dave Butenhof
 *
 *  CREATION DATE:
 * 
 *	2 November 1988
 *
 *  MODIFICATION HISTORY:
 * 
 *	001	Robert A. Conti	3 November 1988
 *		Merge comments from Ada version
 *	002	Dave Butenhof	7 November 1988
 *		Clean up code and typedefs
 *	003	Dave Butenhof	9 February 1989
 *		Bring up to latest arch. spec
 *	004	Dave Butenhof	2 March 1989
 *		IN Handles by value, fix routine types
 *	005	Dave Butenhof	20 July 1989
 *		Update to latest APA conventions, CMA style
 *	006	Dave Butenhof	2 August 1989
 *		Add MBZ field to once block for revision control.
 *	007	Dave Butenhof	16 August 1989
 *		More APA changes (argument passing)
 *	008	Dave Butenhof	16 August 1989
 *		Add some constants for boolean and address types
 *	009	Dave Butenhof	25 August 1989
 *		Fix handle (embed array in a structure to make argument
 *		passing more consistent).
 *	010	Dave Butenhof	25 August 1989
 *		Define stack operations (these are all suffixed with _np,
 *		since they're not architecturally defined).
 *	011	Dave Butenhof	30 August 1989
 *		Change cma_c_true to "!cma_c_false" (conform to C convention
 *		more explicitly).
 *	012	Dave Butenhof	31 August 1989
 *		Change back to match architecture: take input handles by
 *		value, not by reference.
 *	013	Dave Butenhof	12 September 1989
 *		Change cma_c_null (for VMS) to be globaldef.
 *	014	Dave Butenhof	14 September 1989
 *		Change "state" field of cma_t_alert_state to be boolean.
 *	015	Dave Butenhof	27 September 1989
 *		Make cma_t_boolean an unsigned int (not a char) to improve
 *		data structure alignment.
 *	016	Hans Oser	03 October 1989
 *		cma_c_null_thread added in cma_t_exit_status for null thread
 *	017	Bob Conti 	05 October 1989
 *	        Add type cma_t_status and provide octal status values
 *              for architecture-defined errors. Add exception for thread exit.
 *	018	Dave Butenhof	12 October 1989
 *		Modify cma_t_once structure to follow internal definition.
 *	020	Dave Butenhof	16 October 1989
 *		cma_dcl_once incorrectly declares a "cma_once_block" instead
 *		of a "cma_t_once_block".
 *	021     Webb Scales     17 October 1989
 *		MIPS/Ultrix integration:  removed argument prototypes from
 *		routine-typedef declarations, and redefined cma_t_address for
 *		MIPS platforms
 *	022	Dave Butenhof	20 October 1989
 *		Change conditional on cma_c_null definition: "globalref" on
 *		vms (not on vaxc) and "extern" otherwise (even on VAX/ULTRIX
 *		vcc).
 *	023	Dave Butenhof	24 October 1989
 *		Make cma_t_date_time fields unsigned to correspond to internal
 *		tick time.
 *	024	Webb Scales	26 October 1989
 *		Add include of types.h for timeb.h
 *	025	Dave Butenhof	27 November 1989
 *		Add cma_allocate_stack_np routine.
 *	026	Dave Butenhof	30 November 1989
 *		Name and argument order changes to track changes made to CMA
 *		interface by POSIX 1003.4 threads working group.
 *	027	Dave Butenhof	5 December 1989
 *		Make some consistency changes to function names.
 *	028	Bob Conti	8 December 1989
 *		Add status codes corresponding to new conditions for
 *		raising CMA exceptions.
 *	029	Dave Butenhof	8 December 1989
 *		Add cma_s_unimp status code.
 *	030	Webb Scales	8 December 1989
 *		MIPS/Ultrix integration:  made "EXCEPTION.match_value" into a
 *		union of "match.addr" and "match.value".
 *	031	Bob Conti	9 December 1989
 *		Added INCLUDE for CMA_EXCEPTIONS and moved the 
 *		typedefs for exceptions into that package. 
 *		Removed definitions for statuses that are never exceptions and
 *		exception cma_e_uninitexc.
 *	032	Bob Conti	10 December 1989
 *		Restored cma_e_uninitexc to this interface.  
 *		(It can't hurt to be here *and* in CMA_EXCEPTION.h)
 *	033	Bob Conti	11 December 1989
 *		Added cma_s_errimprep status code.
 *	034	Bob Conti	11 December 1989
 *		Remove cma_s_errimprep status code.
 *		Add status code cma_s_inialrpro, for attempting to call 
 *		cma_init while an initialization is in progress.
 *	035	Dave Butenhof	23 January 1990
 *		Add support for conditional use of function prototypes.
 *	036	Dave Butenhof	26 January 1990
 *		Use new cma_config.h to define configuration symbols.
 *	037	Dave Butenhof	8 February 1990
 *		Recognize that (for now) cma_debug is a legitimate part of
 *		the CMA reference implementation, and define it in the
 *		interface.
 *	038	Dave Butenhof	15 February 1990
 *		Correct oversight; add priority argument to
 *		cma_thread_set_sched to conform to POSIX pthreads.
 *	039	Dave Butenhof	27 February 1990
 *		Add priority argument to cma_attr_set_sched, since setting
 *		policy and priority separately on an attributes object really
 *		makes no more sense than setting them separately on a running
 *		thread.  Also, "implement" the new symbols for scheduling
 *		policies and priorities.
 *	040	Dave Butenhof	28 February 1990
 *		Ooops--we've got two "cma_c_sched_default" symbols.  Change
 *		the inherit-sched one to "cma_c_sched_use_default".
 *	041	Webb Scales	20 March 1990
 *		Added exceptions to support U*ix signal-to-exception mapping.
 *	042	Webb Scales	16 April 1990
 *		Added notcmastack exception
 *	043	Dave Butenhof	18 April 1990
 *		Remove conditionals around cma_c_null (now extern even on
 *		VAX/VMS).
 *	044	Webb Scales	2 May 1990
 *		Changed the value of cma_c_true to a constant instead of an
 *		expression, to accomodate the old (V1.3) MIPS/Ultrix compiler.
 *	045	Webb Scales	4 June 1990
 *		Added more exceptions.
 *	046	Dave Butenhof	13 June 1990
 *		During initial MIPS ULTRIX migration, prototypes for the
 *		"callback" routines (main thread, destructor, init) were
 *		removed because they wouldn't compile.  They should have been
 *		restored when conditional prototypes were implemented; do so
 *		now.
 *	047	Webb Scales	15 June 1990
 *		Added scheduling policies for "Ada low" and "idle".
 *	048	Dave Butenhof	26 June 1990
 *		Add constants and functions for controlling whether mutex
 *		locks can nest within a thread ("friendly mutexes").
 *	049	Dave Butenhof and Webb Scales	03 August 1990
 *		Add prototype for cma_cond_signal_interrupt.
 *	050	Webb Scales	15 August 1990
 *		Made status code definitions platform-generic.
 *	051	Dave Butenhof	27 August 1990
 *		Change name of Webb's "interrupt level signal" to
 *		cma_cond_signal_int rather than more awkward
 *		cma_cond_signal_interrupt (since he put the shorter form into
 *		the transfer vector, and has used it in cmalib).
 *	052	Dave Butenhof	27 August 1990
 *		Change interfaces to pass handles & structures by reference.
 *	053	Webb Scales	31 August 1990
 *		Added severity argument to CMA_STATUS macro
 *	054	Paul Curtin	17 September 1990
 *		Added errno function
 *	055	Webb Scales	17 September 1990
 *		Added errno macro that sets up wrapper function.
 *	056	Bob Conti	1 October 1990
 *		Delete cma_c_null_thread from exit_status
 *	057	Dave Butenhof	9 October 1990
 *		Add argument to cma_t_init_routine and cma_once prototypes,
 *		to accomodate enhancement to one-time initialization.
 *	058	Dave Butenhof	9 October 1990
 *		Use new _CMA_IMPORT_ config symbol for the exception and
 *		cma_c_null definitions.
 *	059	Dave Butenhof	11 October 1990
 *		Move errno stuff to it's own file, cma_errno.h.
 *	060	Webb Scales	15 October 1990
 *		Removed "idle" scheduling policy.
 *	061	Dave Butenhof	27 December 1990
 *		Rearrange and rename some exceptions.
 *	062	Dave Butenhof & Webb Scales	21 January 1991
 *		Figure out new exception prefixes (change low-level
 *		exceptions to "exc" prefix).
 *	063	Paul Curtin	31 January 1991
 *		Added user header files; conditionally removed
 *		on defining _CMA_NOWRAPPERS_  (for CMA build, ...)
 *	064	Dave Butenhof	7 February 1991
 *		New alert control scoping primitives.
 *	065	Dave Butenhof	12 February 1991
 *		Change "friendly" mutex to "recursive"
 *	066	Dave Butenhof	14 February 1991
 *		Integrate Aron Insinga's changes to improve compatibility
 *		with non-default C/C++ compilers.
 *	067	Webb Scales	19 February 1991
 *		Added symbol which users can test to see if the threading
 *		package is us (especially important for the pthreads interface)
 *	068	Dave Butenhof	18 March 1991
 *		Add an external variable cma_g_debug which points to the
 *		debugger code, so that users can always call through it (this
 *		is mostly necessary under the VAX/VMS Debugger, which refuses
 *		to look at function names from a shareable image).
 *	069	Dave Butenhof	25 March 1991
 *		Include exc_handling.h rather than cma_exception.h, and move
 *		all the exception definitions into exc_handling.h.
 *	070	Dave Butenhof	05 April 1991
 *		CFRONT fix from Aron Insinga.
 *	071	Dave Butenhof	12 April 1991
 *		Don't include the DECthreads "hack" support for
 *		thread-synchronous I/O and per-thread errno if this is an
 *		OSF/1 based system, since the standard system versions
 *		provide the necessary support.
 *	072	Dave Butenhof	23 May 1991
 *		Include cma_ux.h and cma_px.h headers on MP system, so we get
 *		a few of the wrappers.
 *	073	Dave Butenhof	05 June 1991
 *		On non-VMS DCE platforms, public header files (except
 *		pthread.h and pthread_exc.h) are in /usr/include/dce.
 *	074	Dave Butenhof	10 June 1991
 *		Create cma_thread_get_unique
 */

#ifndef CMA_INCLUDE
#define CMA_INCLUDE

/*
 * Define a symbol which client code can test to determine whether the 
 * underlying threads package is DECthreads or not.  This is especially
 * important to clients of the Pthreads interface who may want to use
 * certain DECthreads extensions, such as the global lock and non-real-time
 * scheduling policies, on the DECthreads platform while maintaining 
 * portability to a "vanilla" pthreads implementation.
 */
#define _DECTHREADS_	1

/*
 * The implementation makes these basic decisions
 */

#ifdef vms
# include <cma_config.h>		/* configuration symbols */
#else
# include <dce/cma_config.h>		/* configuration symbols */
#endif

#if _CMA_OS_ != _CMA__VMS
# include <sys/types.h>
# include <sys/timeb.h>
#endif

#include <exc_handling.h>		/* Bring in exception services */

#if _CMA_OSIMPL_ == _CMA__OS_OSF
# define _REENTRANT	1		/* Enable reentrant errno.h */
#endif

#ifdef _CMA_PROTO_
# define _CMA_PROTOTYPE_(arg)	arg
#else
# define _CMA_PROTOTYPE_(arg)	()
#endif

/*
 * Sample decisions for the environment types
 */


typedef int			cma_t_integer;

typedef unsigned int		cma_t_boolean;

typedef unsigned int		cma_t_natural;

typedef float			cma_t_interval;

typedef	int			cma_t_key;

typedef int			cma_t_status;

typedef	int			cma_t_priority;

#if _CMA_VOID_
typedef void			*cma_t_address;
#else
typedef char			*cma_t_address;
#endif

#define cma_c_false	(cma_t_boolean)0
#define cma_c_true	(cma_t_boolean)1
#define cma_c_null_ptr	(cma_t_address)0

#define cma_c_prio_fifo_min	16
#define cma_c_prio_fifo_mid	24
#define cma_c_prio_fifo_max	31
#define cma_c_prio_rr_min	16
#define cma_c_prio_rr_mid	24
#define cma_c_prio_rr_max	31
#define cma_c_prio_through_min	8
#define cma_c_prio_through_mid	12
#define cma_c_prio_through_max	15
#define cma_c_prio_back_min	1
#define cma_c_prio_back_mid	4
#define cma_c_prio_back_max	7
#define cma_c_prio_ada_low_min	0
#define cma_c_prio_ada_low_mid	4
#define cma_c_prio_ada_low_max	7

/*
 * The implementation of the cma_t_date_time type should match the "native
 * time" of the platform: that allows clients to use the full set of platform
 * time operations, rather than just "cma_get_expiration", to compute and
 * test timed waits.
 *
 * This section assumes the platform is either "VMS" or "UNIX-ish".  Others
 * will require changes.
 */
#if _CMA_OS_ == _CMA__VMS
typedef struct CMA_T_DATE_TIME {
    unsigned long int	low;
    unsigned long int	high;
    }				cma_t_date_time;
#else
typedef struct timeb		cma_t_date_time;
#endif

/* 
 * Sample decisions for what handles shall be 
 */

typedef struct CMA_T_HANDLE {
    cma_t_address	field1;
    cma_t_address	field2;
    } cma_t_handle;

#define cma_thread_get_unique(handle) \
    (((unsigned int)((cma_t_thread *)handle)->field2) & 0xffff)

#if (_CMA_COMPILER_ == _CMA__CFRONT) && (_CMA_OS_ == _CMA__VMS)
/*
 * The following declaration is a hack to support CFRONT (C++ preprocessor);
 * without an actual instance, the struct definition isn't written out.
 * Creates problems for VAX C when it compiles CFRONT output.
 */
struct CMA_T_HANDLE	cxxl_unused_handle;
#endif

#define cma_c_handle_size sizeof(cma_t_handle)

typedef	cma_t_handle	cma_t_mutex;	/* Needed for CMA_ONCE_BLOCK */

/*
 * Predefined null handle
 */

_CMA_IMPORT_ cma_t_handle	cma_c_null;

/*
 * Sample decision for a one-time initialization control block and its
 * initialization macro.
 *
 * Declare a one time initialization control block as:
 *
 *	static cma_t_once	block = cma_once_init;
 */
typedef struct CMA_T_ONCE {
    cma_t_integer	field1;
    cma_t_integer	field2;
    cma_t_integer	field3;
    }				cma_t_once;

#define cma_once_init	{0, 0, 0}

/* 
 * Sample decision for a variable to save the current alert state.
 */
typedef struct CMA_T_ALERT_STATE {
    cma_t_integer	state1;
    cma_t_integer	state2;
    }				cma_t_alert_state;

/*
 * The following are the portable CMA definitions
 */

/*
 * Operations on Handles
 */

/*
 * The value of a handle can be assigned the value of another handle.	
 */

extern void
cma_handle_assign _CMA_PROTOTYPE_ ((
	cma_t_handle	*handle1,	/* Input handle */
	cma_t_handle	*handle2));	/* Output handle */

/*
 * The value of a handle can be compared to the value of another handle.
 */

extern cma_t_boolean
cma_handle_equal _CMA_PROTOTYPE_ ((
	cma_t_handle	*handle1,
	cma_t_handle	*handle2));

/*
 * Operations on attributes objects
 */

typedef cma_t_handle	cma_t_attr;

/*
 * An attributes object is created to specify the attributes of other CMA
 * objects that will be created.
 */

extern void
cma_attr_create _CMA_PROTOTYPE_ ((
	cma_t_attr	*new_attr,
	cma_t_attr	*attr));

/*
 * An attributes object can be deleted when it is no longer needed.
 */

extern void
cma_attr_delete _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr));

/*
 * Operations on threads
 */

typedef cma_t_handle	cma_t_thread;
typedef cma_t_address	(*cma_t_start_routine) _CMA_PROTOTYPE_ ((
	cma_t_address	arg));

typedef enum CMA_T_EXIT_STATUS {
    cma_c_term_error		= 0,
    cma_c_term_normal		= 1,
    cma_c_term_alert		= 2
    }				cma_t_exit_status;

typedef enum CMA_T_SCHED_INHERIT {
    cma_c_sched_inherit = 0,
    cma_c_sched_use_default = 1
    }				cma_t_sched_inherit;

typedef enum CMA_T_SCHED_POLICY {
    cma_c_sched_fifo = 0,
    cma_c_sched_rr = 1,
    cma_c_sched_throughput = 2,
    cma_c_sched_background = 3,
    cma_c_sched_ada_low = 4
    }				cma_t_sched_policy;

#define cma_c_sched_default	cma_c_sched_throughput
#define cma_c_sched_other	cma_c_sched_default

/*
 * The following procedures can be used to control thread creation,
 * termination and deletion.
 */

/*
 * To create a thread object and runnable thread, a routine must be specified
 * as the new thread's start routine.  An argument may be passed to this
 * routine, as an untyped address; an untyped address may also be returned as
 * the routine's value.  An attributes object may be used to specify details
 * about the kind of thread being created.
 */
extern void
cma_thread_create _CMA_PROTOTYPE_ ((
	cma_t_thread		*new_thread,
	cma_t_attr		*attr,
	cma_t_start_routine	start_routine,
	cma_t_address		arg));

/*
 * A thread object may be "detached" to specify that the return value and
 * completion status will not be requested.
 */
extern void
cma_thread_detach _CMA_PROTOTYPE_ ((
	cma_t_thread	*thread));

/* 
 * A thread may terminate it's own execution.
 */
extern void
cma_thread_exit_error _CMA_PROTOTYPE_ ((void));

extern void
cma_thread_exit_normal _CMA_PROTOTYPE_ ((
	cma_t_address	result));

/* 
 * A thread can await termination of another thread and retrieve the return
 * value and completion status of the thread.
 */
extern void
cma_thread_join _CMA_PROTOTYPE_ ((
	cma_t_thread		*thread,
	cma_t_exit_status	*exit_status,
	cma_t_address		*result));

/*
 * Operations to define thread creation attributes
 */

/*
 * Set or obtain the default thread priority.
 */
extern void
cma_attr_set_priority _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_priority	pri));

extern void
cma_attr_get_priority _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_priority	*pri));

/*
 * Set or obtain the default scheduling algorithm
 */
extern void
cma_attr_set_sched _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_sched_policy	policy,
	cma_t_priority		priority));

extern void
cma_attr_get_sched _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_sched_policy	*policy));

/*
 * Set or obtain whether a thread will use the default scheduling attributes,
 * or inherit them from the creating thread.
 */
extern void
cma_attr_set_inherit_sched _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_sched_inherit	setting));

extern void
cma_attr_get_inherit_sched _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_sched_inherit	*setting));

/*
 * Set or obtain the default stack size
 */
extern void
cma_attr_set_stacksize _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_natural	stacksize));

extern void
cma_attr_get_stacksize _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_natural	*stacksize));

/*
 * Set or obtain the default guard size
 */
extern void
cma_attr_set_guardsize _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_natural	guardsize));

extern void
cma_attr_get_guardsize _CMA_PROTOTYPE_ ((
	cma_t_attr	*attr,
	cma_t_natural	*guardsize));

/*
 * Thread Scheduling Operations
 */

/*
 * The current user_assigned priority of a thread can be changed.
 */
extern void
cma_thread_set_priority _CMA_PROTOTYPE_ ((
	cma_t_thread	*thread,
	cma_t_priority	priority));

/*
 * The current user_assigned scheduler algorithm of a thread can be changed.
 */
extern void
cma_thread_set_sched _CMA_PROTOTYPE_ ((
	cma_t_thread		*thread,
	cma_t_sched_policy	policy,
	cma_t_priority		priority));

/*
 * A thread may tell the scheduler that its processor can be made available.
 */
extern void
cma_yield _CMA_PROTOTYPE_ ((void));

/*
 * A thread may enter a wait state for a speciifed period of time.
 */
extern void
cma_delay _CMA_PROTOTYPE_ ((
	cma_t_interval	interval));

/*
 * Thread Information Operations
 */

/*
 * A thread may obtain a copy of its own thread handle.
 */
extern void
cma_thread_get_self _CMA_PROTOTYPE_ ((
	cma_t_thread	*thread));

/*
 * The current user_assigned priority of a thread can be read.
 */
extern void
cma_thread_get_priority _CMA_PROTOTYPE_ ((
	cma_t_thread	*thread,
	cma_t_priority	*priority));

/*
 * The current user_assigned scheduler algorithm of a thread can be read.
 */
extern void
cma_thread_get_sched _CMA_PROTOTYPE_ ((
	cma_t_thread		*thread,
	cma_t_sched_policy	*policy));

/*
 * Operations on Mutexes
 */

typedef enum CMA_T_MUTEX_KIND {
    cma_c_mutex_fast = 0,
    cma_c_mutex_recursive = 1,
    cma_c_mutex_nonrecursive = 2
    }				cma_t_mutex_kind;

/*
 * Operations to define mutex creation attributes
 */

/*
 * Set or obtain whether mutex locks can nest.
 */
extern void
cma_attr_set_mutex_kind _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_mutex_kind	nest));

extern void
cma_attr_get_mutex_kind _CMA_PROTOTYPE_ ((
	cma_t_attr		*attr,
	cma_t_mutex_kind	*nest));

/* 
 * The following routines create, delete, lock and unlock mutexes.
 */
extern void
cma_mutex_create _CMA_PROTOTYPE_ ((
	cma_t_mutex	*new_mutex,
	cma_t_attr	*attr));

extern void
cma_mutex_delete _CMA_PROTOTYPE_ ((
	cma_t_mutex	*mutex));

extern void
cma_mutex_lock _CMA_PROTOTYPE_ ((
	cma_t_mutex	*mutex));

extern cma_t_boolean
cma_mutex_try_lock _CMA_PROTOTYPE_ ((
	cma_t_mutex	*mutex));

extern void
cma_mutex_unlock _CMA_PROTOTYPE_ ((
	cma_t_mutex	*mutex));

extern void
cma_lock_global _CMA_PROTOTYPE_ ((void));

extern void
cma_unlock_global _CMA_PROTOTYPE_ ((void));

/*
 * Operations on condition variables
 */

typedef cma_t_handle	cma_t_cond;

/*
 * A thread can create and delete condition variables.
 */
extern void
cma_cond_create _CMA_PROTOTYPE_ ((
	cma_t_cond	*new_condition,
	cma_t_attr	*attr));

extern void
cma_cond_delete _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition));

/*
 * A thread can signal to and broadcast on a condition variable.
 */
extern void
cma_cond_broadcast _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition));

extern void
cma_cond_signal _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition));

extern void
cma_cond_signal_int _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition));

/*
 * A thread can wait for a condition variable to be signalled or broadcast.
 */
extern void
cma_cond_wait _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition,
	cma_t_mutex	*mutex));

/*
 * Operations for timed waiting
 */

/*
 * A thread can perform a timed wait on a condition variable.
 */
extern cma_t_status
cma_cond_timed_wait _CMA_PROTOTYPE_ ((
	cma_t_cond	*condition,
	cma_t_mutex	*mutex,
	cma_t_date_time	*expiration));

/*
 * A thread may perform some operations on absolute date-time and intervals.
 */

extern void
cma_time_get_expiration _CMA_PROTOTYPE_ ((
	cma_t_date_time	*expiration,
	cma_t_interval	interval));

/*
 * Operations for CMA and client initialization.
 */

/*
 * Initialize the CMA facility.
 */
extern void
cma_init _CMA_PROTOTYPE_ ((void));

/*
 * A thread can declare a one-time initialization routine.  The address of
 * the init block and routine are passed as parameters.
 */

typedef void		(*cma_t_init_routine) _CMA_PROTOTYPE_ ((
	cma_t_address	arg));

extern void
cma_once _CMA_PROTOTYPE_ ((
	cma_t_once		*init_block,
	cma_t_init_routine	init_routine,
	cma_t_address		arg));

/*
 * Operations for per-thread context
 */

typedef void		(*cma_t_destructor) _CMA_PROTOTYPE_ ((
	cma_t_address	ctx_value));

/*
 * A unique per-thread context key can be obtained for the process
 */
extern void
cma_key_create _CMA_PROTOTYPE_ ((
	cma_t_key		*key,
	cma_t_attr		*attr,
	cma_t_destructor	destructor));

/*
 * A thread can set a per-thread context value identified by a key.
 */
extern void
cma_key_set_context _CMA_PROTOTYPE_ ((
	cma_t_key	key,
	cma_t_address	context_value));

/*
 * A thread can retrieve a per-thread context value identified by a key.
 */
extern void
cma_key_get_context _CMA_PROTOTYPE_ ((
	cma_t_key	key,
	cma_t_address	*context_value));

/*
 * Operations for alerts.
 */

/*
 * The current thread can request that a thread terminate it's execution.
 */

extern void
cma_thread_alert _CMA_PROTOTYPE_ ((
	cma_t_thread	*thread));

/*
 * The current thread can poll for alert delivery.
 */
extern void
cma_alert_test _CMA_PROTOTYPE_ ((void));

/*
 * The current thread can disable asynchronous alert delivery, restore the
 * previous state of asynchronous alert delivery, or enable asynchronous
 * alert delivery.
 */
extern void
cma_alert_disable_asynch _CMA_PROTOTYPE_ ((
	cma_t_alert_state	*prior));

extern void
cma_alert_disable_general _CMA_PROTOTYPE_ ((
	cma_t_alert_state	*prior));

extern void
cma_alert_enable_asynch _CMA_PROTOTYPE_ ((void));

extern void
cma_alert_enable_general _CMA_PROTOTYPE_ ((
	cma_t_alert_state	*prior));

extern void
cma_alert_restore _CMA_PROTOTYPE_ ((
	cma_t_alert_state	*prior));

/*
 * Operations on stacks
 */

typedef	cma_t_handle	cma_t_stack_np;
typedef void		(*cma_t_call_routine) ();

/*
 * Allocate stack space
 */
extern void
cma_stack_allocate_np _CMA_PROTOTYPE_ ((
	cma_t_integer	size,
	cma_t_address	*new_size));

/*
 * Assign a stack to a thread
 */
extern void
cma_stack_assign_np _CMA_PROTOTYPE_ ((
	cma_t_stack_np	*stack,
	cma_t_thread	*thread));

/*
 * Call a routine on a new stack
 */
extern void
cma_stack_call_routine_np _CMA_PROTOTYPE_ ((
	cma_t_stack_np		*stack,
	cma_t_call_routine	routine,
	cma_t_address		arg,
	cma_t_address		*result));

/*
 * Check stack limit
 */
extern cma_t_boolean
cma_stack_check_limit_np _CMA_PROTOTYPE_ ((
	cma_t_integer	size));

/*
 * Create a new stack
 */
extern void
cma_stack_create_np _CMA_PROTOTYPE_ ((
	cma_t_stack_np	*stack,
	cma_t_attr	*attr));

/*
 * Delete a stack
 */
extern void
cma_stack_delete_np _CMA_PROTOTYPE_ ((
	cma_t_stack_np	*stack));

/*
 * Debug threads
 */
extern void
cma_debug _CMA_PROTOTYPE_ ((void));

extern void
cma_debug_cmd _CMA_PROTOTYPE_ ((char *cmd, ...));

_CMA_IMPORT_ void (*cma_g_debug) _CMA_PROTOTYPE_ ((void));

#ifndef _CMA_NOWRAPPERS_
# if _CMA_UNIPROCESSOR_
#  if _CMA_OS_ == _CMA__VMS
#   include <cma_errno.h>
#   include <cmalib_crtlx.h>
#  else
#   include <dce/cma_errno.h>
#   include <dce/cmalib_crtlx.h>
#  endif
# endif
# if _CMA_OS_ == _CMA__VMS
#  include <cma_px.h>
# else
#  include <dce/cma_px.h>
# endif
# if _CMA_OS_ == _CMA__UNIX
#  include <dce/cma_ux.h>
# endif
# if _CMA_OS_ == _CMA__VMS
#  include <cma_sigwait.h>
# else
#  include <dce/cma_sigwait.h>
# endif
#endif

#endif
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA.H */
/*  *18   10-JUN-1991 19:49:57 SCALES "Convert to stream format for ULTRIX build" */
/*  *17   10-JUN-1991 19:19:45 BUTENHOF "Fix the sccs headers" */
/*  *16   10-JUN-1991 18:16:04 SCALES "Add sccs headers for Ultrix" */
/*  *15   10-JUN-1991 14:12:55 BUTENHOF "Add macro to extract thread sequence #" */
/*  *14    5-JUN-1991 17:30:55 BUTENHOF "On UNIX platforms, most headers are in dce/" */
/*  *13   29-MAY-1991 16:58:42 BUTENHOF "Change cma_debug() prototype" */
/*  *12   12-APR-1991 23:34:36 BUTENHOF "CFRONT fix" */
/*  *11    1-APR-1991 18:08:05 BUTENHOF "QAR 93, exception text" */
/*  *10   21-MAR-1991 09:25:48 BUTENHOF "Make sure that cma_debug is in link" */
/*  *9    19-FEB-1991 22:21:10 SCALES "::" */
/*  *8    14-FEB-1991 23:50:54 BUTENHOF "Improve multiple c-compiler support" */
/*  *7    13-FEB-1991 17:54:13 BUTENHOF "Change mutex attribute name symbols" */
/*  *6    12-FEB-1991 23:09:22 BUTENHOF "Recursive/nonrecursive mutexes" */
/*  *5    12-FEB-1991 01:28:12 BUTENHOF "New alert control primitives" */
/*  *4    31-JAN-1991 16:32:34 CURTIN "added user header files" */
/*  *3    24-JAN-1991 00:34:20 BUTENHOF "Modify exception names again" */
/*  *2    28-DEC-1990 00:04:18 BUTENHOF "Change exception names" */
/*  *1    12-DEC-1990 21:39:46 BUTENHOF "CMA header" */
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA.H */
