//---------------------------------------------------------------------------
//
//    DIGITAL hereby grants any authorized developer using the PATHWORKS SDK 
//    ("Developer"), a royalty-free, non-exclusive license to use any of 
//    DIGITAL's source code supplied with the PATHWORKS SDK to create binaries 
//    which the developer may then copy and merge with the developers software 
//    for distribution to its customers.  DIGITAL is not liable for any 
//    damages caused by any errors in the source code provided with the SDK.
//
//---------------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#define WIN32_LEAN_AND_MEAN TRUE
    /* kick out conflicts between winsock.h & iocb.h */
    /* Could use #define _WINSOCKAPI_ instead.  */
#include <windows.h>
#include <winerror.h>  // WIN32 defined errors
#include <errno.h>

#define IOCB_INCL_LAT        /* include LAT structures */
#define IOCB_INCL_DN         /* include DECnet structures */
#include "iocb_32.h"

VOID lat32(VOID) // validate 32-bit LAT IOCB interface
{
    DWORD rc;
    NIOCB iocb;
    
    iocb.io_seal = IOCB_SEAL;
    iocb.io_fcode = PRU_LOCALINFO;
    iocb.io_flags = MSG_NIOCB | MSG_USRWAIT;
    iocb.io_callback = NULL;
    iocb.io_status = iocb.io_errno = 0;
    iocb.io_psize = sizeof(LOCALINFO_LAT);
    
    if (rc = IocbSubmit(LAT_API,&iocb,0))
    {
        printf("LAT LOCALINFO call failed at WIN32 level, error: %u\n",rc);
        return;
    }
    if (iocb.io_status)
    {
        printf("LAT LOCALINFO call failed at LAT level.");
        if (iocb.io_status == IOCB_ERROR)
            printf("  Errno: %u\n",iocb.io_errno);
        else if (iocb.io_status == IOCB_PENDING)
            printf("  Call is Pending.\n");
        else printf("  Status: %u,  Errno: %u\n",
                    iocb.io_status,iocb.io_errno);
    }
    else
    {
        printf("LAT LOCALINFO:\n");
        printf("   LAT version: %u.%u.%u\n",iocb.plcl_lat.lcl_version[0],
                iocb.plcl_lat.lcl_version[1],iocb.plcl_lat.lcl_version[2]);
        printf("   Station Address: %02X-%02X-%02X-%02X-%02X-%02X\n",
                iocb.plcl_lat.lcl_nodeaddr[0],iocb.plcl_lat.lcl_nodeaddr[1],
                iocb.plcl_lat.lcl_nodeaddr[2],iocb.plcl_lat.lcl_nodeaddr[3],
                iocb.plcl_lat.lcl_nodeaddr[4],iocb.plcl_lat.lcl_nodeaddr[5]);
        printf("   Maximum Slot Size: %u\n",iocb.plcl_lat.lcl_slotsize);
        printf("   Available sockets: %u\n",iocb.plcl_lat.lcl_sockets);
    }
}
