/*
**      NETDB.H
**
**      Copyright (c) 1988, The Regents of the University of California.
**
**      Copyright (c) Hewlett Packard Company, 1989.  All rights reserved.
**      No part of this program may be copied or used without the prior
**      written consent of Hewlett Packard Company.
*/

#include <skdefs.h>

struct hostent {
    char FAR       *h_name;
    char FAR * FAR *h_aliases;
    short             h_addrtype;
    short             h_length;
    struct in_addr FAR * FAR *h_addr_list;  /* address list returned from  */
                                            /* domain name server          */
#define h_addr h_addr_list[0]               /* for backwards compatibility */
};


struct netent {
    char FAR       *n_name;
    char FAR * FAR *n_aliases;
    unsigned long   n_net;
    int             n_addrtype;
};


struct protoent {
    char FAR       *p_name;
    char FAR * FAR *p_aliases;
    int             p_proto;
};


struct servent {
    char FAR       *s_name;
    char FAR * FAR *s_aliases;
    int             s_port;
    char FAR       *s_proto;
};


/*
**   The following errors are not currently returned by the domain name
**   requester.  In Unix systems, these are returned in the extern int
**   variable 'h_errno'.
*/

#define  HOST_NOT_FOUND 1       /*  Authoritative answer not found */
#define  TRY_AGAIN     2        /* Non-authoritative answer not found */
#define  NO_RECOVERY   3        /* Non-recoverable error              */
#define  NO_DATA       4        /* Valid name, no data record for type */
#define  NO_ADDRESS    NO_DATA  /* No address exists */
